/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExpressionTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.ui.LightweightHint;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ShowExpressionTypeHandler
implements CodeInsightActionHandler {
    private final boolean myRequestFocus;

    public ShowExpressionTypeHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, final @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Language language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(project, language2, file2.getViewProvider().getBaseLanguage());
        if (handlers.isEmpty()) {
            return;
        }
        final Map<PsiElement, ExpressionTypeProvider> map2 = ShowExpressionTypeHandler.getExpressions(file2, editor2, handlers);
        Pass<PsiElement> callback2 = new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExpressionTypeProvider provider2 = Objects.requireNonNull((ExpressionTypeProvider)map2.get(expression));
                TextRange range2 = expression.getTextRange();
                editor2.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
                ShowExpressionTypeHandler.this.displayHint(expression, expr -> provider2.getInformationHint(expr), new DisplayedTypeInfo(expression, provider2, editor2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$1", "pass"));
            }
        };
        if (map2.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String errorHint = Objects.requireNonNull((ExpressionTypeProvider)ContainerUtil.getFirstItem((Collection)handlers)).getErrorHint();
                HintManager.getInstance().showErrorHint(editor2, errorHint);
            });
        } else if (map2.size() == 1) {
            ExpressionTypeProvider provider2;
            Map.Entry<PsiElement, ExpressionTypeProvider> entry2 = map2.entrySet().iterator().next();
            PsiElement expression = entry2.getKey();
            DisplayedTypeInfo typeInfo = new DisplayedTypeInfo(expression, provider2 = entry2.getValue(), editor2);
            if (typeInfo.isRepeating() && provider2.hasAdvancedInformation()) {
                this.displayHint(expression, expr -> provider2.getAdvancedInformationHint(expr), typeInfo);
            } else {
                callback2.pass((Object)expression);
            }
        } else {
            IntroduceTargetChooser.showChooser(editor2, new ArrayList<PsiElement>(map2.keySet()), callback2, PsiElement::getText);
        }
    }

    private void displayHint(@NotNull PsiElement expression, @NotNull Function<PsiElement, @Nls String> hintGetter, @NotNull DisplayedTypeInfo typeInfo) {
        if (expression == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(3);
        }
        if (hintGetter == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(4);
        }
        if (typeInfo == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(5);
        }
        Callable<@Nls String> getHintAction = () -> (String)hintGetter.apply(expression);
        ReadAction.nonBlocking(getHintAction).finishOnUiThread(ModalityState.any(), hint -> {
            HintManager.getInstance().setRequestFocusForNextHint(this.myRequestFocus);
            typeInfo.showHint((String)hint);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    public Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(7);
        }
        Language language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)editor2.getCaretModel().getOffset());
        Set<ExpressionTypeProvider> handlers = ShowExpressionTypeHandler.getHandlers(file2.getProject(), language2, file2.getViewProvider().getBaseLanguage());
        return ShowExpressionTypeHandler.getExpressions(file2, editor2, handlers);
    }

    @NotNull
    private static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Set<? extends ExpressionTypeProvider> handlers) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(9);
        }
        if (handlers == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(10);
        }
        return ShowExpressionTypeHandler.getExpressions(file2, EditorUtil.getSelectionInAnyMode(editor2), editor2.getDocument(), handlers);
    }

    @NotNull
    public static Map<PsiElement, ExpressionTypeProvider> getExpressions(@NotNull PsiFile file2, @NotNull TextRange range2, @NotNull Document document, @NotNull Set<? extends ExpressionTypeProvider> handlers) {
        if (file2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(11);
        }
        if (range2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(12);
        }
        if (document == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(13);
        }
        if (handlers == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(14);
        }
        if (handlers.isEmpty()) {
            Map<PsiElement, ExpressionTypeProvider> map2 = Collections.emptyMap();
            if (map2 == null) {
                ShowExpressionTypeHandler.$$$reportNull$$$0(15);
            }
            return map2;
        }
        boolean exactRange = false;
        LinkedHashMap<PsiElement, ExpressionTypeProvider> map3 = new LinkedHashMap<PsiElement, ExpressionTypeProvider>();
        int offset = !range2.isEmpty() ? range2.getStartOffset() : TargetElementUtil.adjustOffset(file2, document, range2.getStartOffset());
        for (int i2 = 0; i2 < 3 && map3.isEmpty() && offset >= i2; ++i2) {
            PsiElement elementAt = file2.findElementAt(offset - i2);
            if (elementAt == null) continue;
            for (ExpressionTypeProvider expressionTypeProvider : handlers) {
                for (PsiElement element2 : expressionTypeProvider.getExpressionsAt(elementAt)) {
                    TextRange r = element2.getTextRange();
                    if (exactRange && !r.equals((Object)range2) || !r.contains(range2)) continue;
                    if (!exactRange) {
                        exactRange = r.equals((Object)range2);
                    }
                    map3.put(element2, expressionTypeProvider);
                }
            }
        }
        LinkedHashMap<PsiElement, ExpressionTypeProvider> linkedHashMap = map3;
        if (linkedHashMap == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(16);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<ExpressionTypeProvider> getHandlers(Project project, Language ... languages) {
        DumbService dumbService = DumbService.getInstance((Project)project);
        Set set2 = (Set)JBIterable.of((Object[])languages).flatten(language2 -> dumbService.filterByDumbAwareness((Collection)LanguageExpressionTypes.INSTANCE.allForLanguage(language2))).addAllTo(new LinkedHashSet());
        if (set2 == null) {
            ShowExpressionTypeHandler.$$$reportNull$$$0(17);
        }
        return set2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintGetter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "displayHint";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpressions";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class DisplayedTypeInfo {
        private static volatile DisplayedTypeInfo ourCurrentInstance;
        @NotNull
        final PsiElement myElement;
        @NotNull
        final ExpressionTypeProvider<?> myProvider;
        @NotNull
        final Editor myEditor;

        DisplayedTypeInfo(@NotNull PsiElement element2, @NotNull ExpressionTypeProvider<?> provider2, @NotNull Editor editor2) {
            if (element2 == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(1);
            }
            if (editor2 == null) {
                DisplayedTypeInfo.$$$reportNull$$$0(2);
            }
            this.myElement = element2;
            this.myProvider = provider2;
            this.myEditor = editor2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayedTypeInfo info2 = (DisplayedTypeInfo)o;
            return Objects.equals(this.myElement, info2.myElement) && Objects.equals(this.myProvider, info2.myProvider) && Objects.equals(this.myEditor, info2.myEditor);
        }

        boolean isRepeating() {
            return this.equals(ourCurrentInstance);
        }

        void showHint(@NlsContexts.HintText String informationHint) {
            JComponent label2 = HintUtil.createInformationLabel(informationHint);
            DisplayedTypeInfo.setInstance(this);
            AccessibleContextUtil.setName((Component)label2, (String)CodeInsightBundle.message((String)"accessible.name.expression.type.hint", (Object[])new Object[0]));
            HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
            LightweightHint hint = new LightweightHint(label2);
            hint.addHintListener(e -> ApplicationManager.getApplication().invokeLater(() -> DisplayedTypeInfo.setInstance(null)));
            Point p = hintManager.getHintPosition(hint, this.myEditor, (short)1);
            int flags = 42;
            hintManager.showEditorHint(hint, this.myEditor, p, flags, 0, false);
        }

        private static void setInstance(DisplayedTypeInfo typeInfo) {
            ourCurrentInstance = typeInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/hint/ShowExpressionTypeHandler$DisplayedTypeInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

