/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    private static final ParameterInfoHandler[] EMPTY_HANDLERS = new ParameterInfoHandler[0];
    private final boolean myRequestFocus;

    public ShowParameterInfoHandler() {
        this(false);
    }

    public ShowParameterInfoHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(2);
        }
        ShowParameterInfoHandler.invoke(project, editor2, file2, -1, null, this.myRequestFocus);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void invoke(Project project, Editor editor2, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus) {
        ShowParameterInfoHandler.invoke(project, editor2, file2, lbraceOffset, highlightedElement, requestFocus, false, CodeInsightBundle.message((String)"parameter.info.progress.title", (Object[])new Object[0]));
    }

    @ApiStatus.Internal
    public static void invoke(Project project, Editor editor2, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus, boolean singleParameterHint, @Nullable @NlsContexts.ProgressTitle String progressTitle2) {
        int initialOffset = editor2.getCaretModel().getOffset();
        ParameterInfoTaskRunnerUtil.runTask(project, ReadAction.nonBlocking(() -> {
            int offset = editor2.getCaretModel().getOffset();
            int fileLength = file2.getTextLength();
            if (fileLength == 0) {
                return null;
            }
            int offsetForLangDetection = offset > 0 && offset == fileLength ? offset - 1 : offset;
            Language language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offsetForLangDetection);
            ShowParameterInfoContext context2 = new ShowParameterInfoContext(editor2, project, file2, offset, lbraceOffset, requestFocus, singleParameterHint);
            context2.setHighlightedElement(highlightedElement);
            context2.setRequestFocus(requestFocus);
            ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(project, language2, file2.getViewProvider().getBaseLanguage());
            return (Runnable)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                for (ParameterInfoHandler handler2 : handlers) {
                    PsiElement element2 = (PsiElement)handler2.findElementForParameterInfo((CreateParameterInfoContext)context2);
                    if (element2 == null) continue;
                    return () -> DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                        if (element2.isValid()) {
                            handler2.showParameterInfo((Object)element2, (CreateParameterInfoContext)context2);
                        }
                    });
                }
                return null;
            });
        }).withDocumentsCommitted(project).expireWhen(() -> editor2.getCaretModel().getOffset() != initialOffset).coalesceBy(new Object[]{ShowParameterInfoHandler.class, editor2}), continuation -> {
            if (continuation != null) {
                continuation.run();
            }
        }, progressTitle2, editor2);
    }

    public static ParameterInfoHandler @NotNull [] getHandlers(Project project, Language ... languages) {
        if (languages == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(3);
        }
        LinkedHashSet handlers = new LinkedHashSet();
        DumbService dumbService = DumbService.getInstance((Project)project);
        for (Language language2 : languages) {
            handlers.addAll(dumbService.filterByDumbAwareness((Collection)LanguageParameterInfo.INSTANCE.allForLanguage(language2)));
        }
        ParameterInfoHandler[] parameterInfoHandlerArray = handlers.isEmpty() ? EMPTY_HANDLERS : handlers.toArray(new ParameterInfoHandler[0]);
        if (parameterInfoHandlerArray == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return parameterInfoHandlerArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHandlers";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

