/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u0005H\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/hints/DisableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "lastOptionName", "", "getFamilyName", "getIntentionText", "getOptionHintAtOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "intellij.platform.lang.impl"})
public final class DisableCustomHintsOption
implements IntentionAction,
LowPriorityAction {
    @IntentionName
    private String lastOptionName = "";

    @NotNull
    public String getText() {
        return this.getIntentionText();
    }

    @IntentionName
    private final String getIntentionText() {
        String string = CodeInsightBundle.message((String)"inlay.hints.disable.option.shortening_rule", (Object[])new Object[]{0});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026tion.shortening_rule\", 0)");
        String optionPrefix = string;
        String string2 = CodeInsightBundle.message((String)"inlay.hints.disable.option.shortening_rule", (Object[])new Object[]{1});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CodeInsightBundle.messag\u2026tion.shortening_rule\", 1)");
        String resultPrefix = string2;
        CharSequence charSequence = optionPrefix;
        int n = 0;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            charSequence = resultPrefix;
            n = 0;
            if (!StringsKt.isBlank((CharSequence)charSequence) && StringsKt.startsWith$default((String)this.lastOptionName, (String)optionPrefix, (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append(resultPrefix);
                charSequence = this.lastOptionName;
                n = optionPrefix.length();
                boolean bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = ((String)charSequence2).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return stringBuilder.append(string3).toString();
            }
        }
        String string4 = CodeInsightBundle.message((String)"inlay.hints.disable.option", (Object[])new Object[]{this.lastOptionName});
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"CodeInsightBundle.messag\u2026.option\", lastOptionName)");
        return string4;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"inlay.hints.intention.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026s.intention.family.name\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        if (!PopupActionsKt.access$hasEditorParameterHintAtOffset(editor2, file2)) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor2, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        this.lastOptionName = option2.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getOptionHintAtOffset(Editor editor2, PsiFile file2) {
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        HintInfo hintInfo = PopupActionsKt.access$getHintInfoFromProvider(offset, file2, editor2);
        if (!(hintInfo instanceof HintInfo.OptionInfo)) {
            hintInfo = null;
        }
        return (HintInfo.OptionInfo)hintInfo;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        HintInfo.OptionInfo optionInfo = this.getOptionHintAtOffset(editor2, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        option2.disable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

