/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.VcsCodeAuthorInfo;
import com.intellij.codeInsight.hints.VcsCodeAuthorInlayHintsCollector;
import com.intellij.codeInsight.hints.VcsCodeAuthorInlayHintsCollectorKt;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.impl.UpToDateLineNumberProviderImpl;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\"\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010%\u001a\u00020\u000f*\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/codeInsight/hints/VcsCodeAuthorInlayHintsCollector;", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "editor", "Lcom/intellij/openapi/editor/Editor;", "authorAspect", "Lcom/intellij/openapi/vcs/annotate/LineAnnotationAspect;", "filter", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "", "getClickHandler", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/annotate/LineAnnotationAspect;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "buildPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "element", "info", "Lcom/intellij/codeInsight/hints/VcsCodeAuthorInfo;", "collect", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getCodeAuthorInfo", "project", "Lcom/intellij/openapi/project/Project;", "range", "Lcom/intellij/openapi/util/TextRange;", "getTextRangeWithoutLeadingCommentsAndWhitespaces", "invokeAnnotateAction", "event", "Ljava/awt/event/MouseEvent;", "contextComponent", "Ljavax/swing/JComponent;", "addContextMenu", "shiftTo", "offset", "", "withUserIcon", "intellij.platform.vcs.impl"})
public final class VcsCodeAuthorInlayHintsCollector
extends FactoryInlayHintsCollector {
    private final LineAnnotationAspect authorAspect;
    private final Function1<PsiElement, Boolean> filter;
    private final Function1<PsiElement, Function0<Unit>> getClickHandler;

    public boolean collect(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (element2 instanceof PsiFile) {
            return true;
        }
        if (!((Boolean)this.filter.invoke((Object)element2)).booleanValue()) {
            return true;
        }
        TextRange range2 = this.getTextRangeWithoutLeadingCommentsAndWhitespaces(element2);
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        VcsCodeAuthorInfo info2 = this.getCodeAuthorInfo(project, range2, editor2);
        InlayPresentation inlayPresentation = this.buildPresentation(element2, info2, editor2);
        Project project2 = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
        InlayPresentation presentation2 = this.shiftTo(this.addContextMenu(inlayPresentation, project2), range2.getStartOffset(), editor2);
        sink.addBlockElement(range2.getStartOffset(), false, true, 0, presentation2);
        return true;
    }

    private final TextRange getTextRangeWithoutLeadingCommentsAndWhitespaces(PsiElement element2) {
        PsiElement psiElement;
        Object v1;
        block2: {
            JBIterable jBIterable = SyntaxTraverser.psiApi().children((Object)element2);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"psiApi().children(element)");
            Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(!(it instanceof PsiComment) && !(it instanceof PsiWhiteSpace))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((psiElement = (PsiElement)v1) == null) {
            psiElement = element2;
        }
        PsiElement start2 = psiElement;
        TextRange textRange = TextRange.create((int)UtilsKt.getStartOffset((PsiElement)start2), (int)UtilsKt.getEndOffset((PsiElement)element2));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(start.s\u2026ffset, element.endOffset)");
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final VcsCodeAuthorInfo getCodeAuthorInfo(Project project, TextRange range2, Editor editor2) {
        Object object;
        void $this$groupingBy$iv;
        Map authorsFrequency;
        void $this$mapNotNullTo$iv$iv22;
        Iterable $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        int startLine = editor2.getDocument().getLineNumber(range2.getStartOffset());
        int endLine = editor2.getDocument().getLineNumber(range2.getEndOffset());
        UpToDateLineNumberProviderImpl provider2 = new UpToDateLineNumberProviderImpl(editor2.getDocument(), project);
        int n = startLine;
        Iterable iterable = (Iterable)new IntRange(n, endLine);
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Iterable<String> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n3 = provider2.getLineNumber((int)it);
            collection.add(n3);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            int it2 = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if (StringKt.nullize$default((String)this.authorAspect.getValue(it2), (boolean)false, (int)1, null) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add((String)it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy22 = false;
        Map $i$f$groupingBy22 = authorsFrequency = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>((Iterable)$this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element2) {
                void var2_2;
                String it = (String)element2;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $this$mapNotNullTo$iv$iv22 = false;
        destination$iv$iv = $i$f$groupingBy22.entrySet();
        boolean bl = false;
        iterator2 = destination$iv$iv.iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it3 = (Map.Entry)iterator2.next();
            boolean bl6 = false;
            it3 = ((Number)it3.getValue()).intValue();
            while (iterator2.hasNext()) {
                Object it4 = (Map.Entry)iterator2.next();
                $i$a$-maxOfOrNull-VcsCodeAuthorInlayHintsCollector$getCodeAuthorInfo$maxFrequency$1 = false;
                if (it3.compareTo(it4 = (Comparable)Integer.valueOf(((Number)it4.getValue()).intValue())) >= 0) continue;
                it3 = it4;
            }
            object = it3;
        }
        Integer n4 = (Integer)object;
        if (n4 == null) {
            return VcsCodeAuthorInfo.Companion.getNEW_CODE();
        }
        int maxFrequency = n4;
        Map $this$filterValues$iv = authorsFrequency;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl7 = false;
        for (Map.Entry entry$iv : map2.entrySet()) {
            int it5 = ((Number)entry$iv.getValue()).intValue();
            boolean bl8 = false;
            if (!(it5 == maxFrequency)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Object object2 = result$iv;
        Map map3 = object2;
        boolean bl9 = false;
        Iterable iterable2 = map3.entrySet();
        boolean bl10 = false;
        Iterator iterator3 = iterable2.iterator();
        if (!iterator3.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Map.Entry it3 = (Map.Entry)iterator3.next();
        boolean bl11 = false;
        Comparable comparable = (Comparable)((Object)((String)it3.getKey()));
        while (iterator3.hasNext()) {
            Map.Entry it6 = (Map.Entry)iterator3.next();
            $i$a$-minOf-VcsCodeAuthorInlayHintsCollector$getCodeAuthorInfo$2 = false;
            Comparable comparable2 = (Comparable)((Object)((String)it6.getKey()));
            if (comparable.compareTo(comparable2) <= 0) continue;
            comparable = comparable2;
        }
        object2 = comparable;
        boolean bl12 = provider2.isRangeChanged(startLine, endLine + 1);
        int n5 = authorsFrequency.size() - 1;
        String string = (String)object2;
        return new VcsCodeAuthorInfo(string, n5, bl12);
    }

    private final InlayPresentation buildPresentation(PsiElement element2, VcsCodeAuthorInfo info2, Editor editor2) {
        PresentationFactory presentationFactory = this.getFactory();
        boolean bl = false;
        boolean bl2 = false;
        PresentationFactory $this$run = presentationFactory;
        boolean bl3 = false;
        InlayPresentation text2 = $this$run.smallTextWithoutBackground(VcsCodeAuthorInlayHintsCollectorKt.access$getText(info2));
        InlayPresentation withIcon = info2.getMainAuthor() != null ? this.withUserIcon(text2) : text2;
        Function0 clickHandler = (Function0)this.getClickHandler.invoke((Object)element2);
        return $this$run.referenceOnHover(withIcon, new InlayPresentationFactory.ClickListener(clickHandler, this, info2, element2, editor2){
            final /* synthetic */ Function0 $clickHandler;
            final /* synthetic */ VcsCodeAuthorInlayHintsCollector this$0;
            final /* synthetic */ VcsCodeAuthorInfo $info$inlined;
            final /* synthetic */ PsiElement $element$inlined;
            final /* synthetic */ Editor $editor$inlined;
            {
                this.$clickHandler = function0;
                this.this$0 = vcsCodeAuthorInlayHintsCollector;
                this.$info$inlined = vcsCodeAuthorInfo;
                this.$element$inlined = psiElement;
                this.$editor$inlined = editor2;
            }

            public final void onClick(@NotNull MouseEvent event, @NotNull Point $noName_1) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                this.$clickHandler.invoke();
                JComponent jComponent = this.$editor$inlined.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.component");
                VcsCodeAuthorInlayHintsCollector.access$invokeAnnotateAction(this.this$0, event, jComponent);
            }
        });
    }

    private final void invokeAnnotateAction(MouseEvent event, JComponent contextComponent) {
        AnAction action2 = ActionManager.getInstance().getAction("Annotate");
        ActionUtil.invokeAction((AnAction)action2, (Component)contextComponent, (String)"EditorInlay", (InputEvent)event, null);
    }

    private final InlayPresentation withUserIcon(InlayPresentation $this$withUserIcon) {
        PresentationFactory presentationFactory = this.getFactory();
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[2];
        PresentationFactory presentationFactory2 = this.getFactory();
        Icon icon2 = AllIcons.Vcs.Author;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Vcs.Author");
        inlayPresentationArray[0] = presentationFactory2.smallScaledIcon(icon2);
        inlayPresentationArray[1] = $this$withUserIcon;
        return presentationFactory.seq(inlayPresentationArray);
    }

    private final InlayPresentation addContextMenu(InlayPresentation $this$addContextMenu, Project project) {
        return new MenuOnClickPresentation($this$addContextMenu, project, (Function0<? extends List<? extends AnAction>>)((Function0)addContextMenu.1.INSTANCE));
    }

    private final InlayPresentation shiftTo(InlayPresentation $this$shiftTo, int offset, Editor editor2) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        int column2 = offset - document2.getLineStartOffset(document2.getLineNumber(offset));
        return this.getFactory().seq(this.getFactory().textSpacePlaceholder(column2, true), $this$shiftTo);
    }

    public VcsCodeAuthorInlayHintsCollector(@NotNull Editor editor2, @NotNull LineAnnotationAspect authorAspect, @NotNull Function1<? super PsiElement, Boolean> filter, @NotNull Function1<? super PsiElement, ? extends Function0<Unit>> getClickHandler2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)authorAspect, (String)"authorAspect");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(getClickHandler2, (String)"getClickHandler");
        super(editor2);
        this.authorAspect = authorAspect;
        this.filter = filter;
        this.getClickHandler = getClickHandler2;
    }

    public static final /* synthetic */ void access$invokeAnnotateAction(VcsCodeAuthorInlayHintsCollector $this, MouseEvent event, JComponent contextComponent) {
        $this.invokeAnnotateAction(event, contextComponent);
    }
}

