/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation.listeners;

import com.intellij.codeInsight.hints.presentation.InputHandler;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThrowableRunnable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/hints/presentation/listeners/InlayEditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "activeContainer", "Lcom/intellij/codeInsight/hints/presentation/InputHandler;", "exitMouseInActiveContainer", "", "mouseMoved", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.platform.lang.impl"})
public final class InlayEditorMouseMotionListener
implements EditorMouseMotionListener {
    private InputHandler activeContainer;

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        EditorCustomElementRenderer container;
        Inlay inlay;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e.mouseEvent");
        MouseEvent event = mouseEvent;
        if (Intrinsics.areEqual((Object)e.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) ^ true) {
            this.exitMouseInActiveContainer();
            this.activeContainer = null;
            return;
        }
        Inlay inlay2 = inlay = e.getInlay();
        Object object = container = inlay2 != null ? inlay2.getRenderer() : null;
        if (Intrinsics.areEqual((Object)this.activeContainer, (Object)container) ^ true) {
            this.exitMouseInActiveContainer();
            if (container == null) {
                this.activeContainer = null;
            } else if (container instanceof InputHandler) {
                this.activeContainer = (InputHandler)container;
            }
        }
        if (!(container instanceof InputHandler)) {
            return;
        }
        Rectangle rectangle = inlay.getBounds();
        if (rectangle == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"inlay.bounds ?: return");
        Rectangle bounds2 = rectangle;
        Point inlayPoint = new Point(bounds2.x, bounds2.y);
        Point translated = new Point(event.getX() - inlayPoint.x, event.getY() - inlayPoint.y);
        SlowOperations.allowSlowOperations((ThrowableRunnable)new ThrowableRunnable(container, event, translated){
            final /* synthetic */ EditorCustomElementRenderer $container;
            final /* synthetic */ MouseEvent $event;
            final /* synthetic */ Point $translated;

            public final void run() {
                ((InputHandler)this.$container).mouseMoved(this.$event, this.$translated);
            }
            {
                this.$container = editorCustomElementRenderer;
                this.$event = mouseEvent;
                this.$translated = point;
            }
        });
    }

    private final void exitMouseInActiveContainer() {
        InputHandler container = this.activeContainer;
        if (container != null) {
            SlowOperations.allowSlowOperations((ThrowableRunnable)new ThrowableRunnable(container){
                final /* synthetic */ InputHandler $container;

                public final void run() {
                    this.$container.mouseExited();
                }
                {
                    this.$container = inputHandler;
                }
            });
        }
    }
}

