/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IntentionListStep
implements ListPopupStep<IntentionActionWithTextCaching>,
SpeedSearchFilter<IntentionActionWithTextCaching> {
    private static final Logger LOG = Logger.getInstance(IntentionListStep.class);
    private final CachedIntentions myCachedIntentions;
    @Nullable
    private final IntentionHintComponent.IntentionPopup myPopup;
    private Runnable myFinalRunnable;
    private final Project myProject;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;

    public IntentionListStep(@Nullable IntentionHintComponent.IntentionPopup popup2, @Nullable Editor editor2, @NotNull PsiFile file2, @NotNull Project project, CachedIntentions intentions) {
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(0);
        }
        if (project == null) {
            IntentionListStep.$$$reportNull$$$0(1);
        }
        this.myPopup = popup2;
        this.myProject = project;
        this.myFile = file2;
        this.myEditor = editor2;
        this.myCachedIntentions = intentions;
    }

    public String getTitle() {
        return null;
    }

    public boolean isSelectable(IntentionActionWithTextCaching action2) {
        return action2.isSelectable();
    }

    public PopupStep<?> onChosen(IntentionActionWithTextCaching action2, boolean finalChoice) {
        IntentionAction a = IntentionActionDelegate.unwrap((IntentionAction)action2.getAction());
        if (finalChoice && !(a instanceof AbstractEmptyIntentionAction)) {
            this.applyAction(action2);
            return FINAL_CHOICE;
        }
        if (this.hasSubstep(action2)) {
            IntentionListStep.closeIntentionPreviewPopup();
            return this.getSubStep(action2, action2.getToolName());
        }
        return FINAL_CHOICE;
    }

    public boolean isFinal(IntentionActionWithTextCaching value2) {
        IntentionAction a = IntentionActionDelegate.unwrap((IntentionAction)value2.getAction());
        return !(a instanceof AbstractEmptyIntentionAction) || !this.hasSubstep(value2);
    }

    private static void closeIntentionPreviewPopup() {
        ApplicationManager.getApplication().invokeLater(() -> StackingPopupDispatcher.getInstance().getPopupStream().filter(popup2 -> popup2.getUserData(IntentionPreviewPopupUpdateProcessor.IntentionPreviewPopupKey.class) != null).collect(Collectors.toList()).forEach(popup2 -> popup2.cancel()));
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    private void applyAction(@NotNull IntentionActionWithTextCaching cachedAction) {
        if (cachedAction == null) {
            IntentionListStep.$$$reportNull$$$0(2);
        }
        this.myFinalRunnable = () -> {
            PsiFile file2;
            HintManager.getInstance().hideAllHints();
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myEditor != null && (this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing() && !ApplicationManager.getApplication().isUnitTestMode())) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !DumbService.isDumbAware((Object)cachedAction)) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(CodeInsightBundle.message((String)"notification.0.is.not.available.during.indexing", (Object[])new Object[]{cachedAction.getText()}));
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            PsiFile psiFile = file2 = this.myEditor != null ? PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)this.myProject) : this.myFile;
            if (file2 == null) {
                return;
            }
            this.chooseActionAndInvoke(cachedAction, file2, this.myProject, this.myEditor);
        };
    }

    protected void chooseActionAndInvoke(@NotNull IntentionActionWithTextCaching cachedAction, @NotNull PsiFile file2, @NotNull Project project, @Nullable Editor editor2) {
        if (cachedAction == null) {
            IntentionListStep.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            IntentionListStep.$$$reportNull$$$0(4);
        }
        if (project == null) {
            IntentionListStep.$$$reportNull$$$0(5);
        }
        ShowIntentionActionsHandler.chooseActionAndInvoke(file2, editor2, cachedAction.getAction(), cachedAction.getText(), project);
    }

    @NotNull
    IntentionListStep getSubStep(@NotNull IntentionActionWithTextCaching action2, final @NlsContexts.PopupTitle String title2) {
        if (action2 == null) {
            IntentionListStep.$$$reportNull$$$0(6);
        }
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        for (IntentionAction optionIntention : action2.getOptionIntentions()) {
            intentions.intentionsToShow.add(new HighlightInfo.IntentionActionDescriptor(optionIntention, null, null, IntentionListStep.getIcon(optionIntention), null, null, null));
        }
        for (IntentionAction optionFix : action2.getOptionErrorFixes()) {
            intentions.errorFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, null, null, IntentionListStep.getIcon(optionFix), null, null, null));
        }
        for (IntentionAction optionFix : action2.getOptionInspectionFixes()) {
            intentions.inspectionFixesToShow.add(new HighlightInfo.IntentionActionDescriptor(optionFix, null, null, IntentionListStep.getIcon(optionFix), null, null, null));
        }
        return new IntentionListStep(this.myPopup, this.myEditor, this.myFile, this.myProject, CachedIntentions.create(this.myProject, this.myFile, this.myEditor, intentions)){

            @Override
            public String getTitle() {
                return title2;
            }

            @Override
            protected void chooseActionAndInvoke(@NotNull IntentionActionWithTextCaching cachedAction, @NotNull PsiFile file2, @NotNull Project project, @Nullable Editor editor2) {
                if (cachedAction == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                IntentionListStep.this.chooseActionAndInvoke(cachedAction, file2, project, editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "cachedAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/intention/impl/IntentionListStep$1";
                objectArray[2] = "chooseActionAndInvoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static Icon getIcon(IntentionAction optionIntention) {
        return optionIntention instanceof Iconable ? ((Iconable)optionIntention).getIcon(0) : null;
    }

    @TestOnly
    public Map<IntentionAction, List<IntentionAction>> getActionsWithSubActions() {
        LinkedHashMap<IntentionAction, List<IntentionAction>> result2 = new LinkedHashMap<IntentionAction, List<IntentionAction>>();
        for (IntentionActionWithTextCaching cached : this.getValues()) {
            IntentionAction action2 = cached.getAction();
            if (ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, action2) == null) continue;
            if (!cached.isShowSubmenu()) {
                result2.put(action2, Collections.emptyList());
                continue;
            }
            List<IntentionActionWithTextCaching> subActions = this.getSubStep(cached, cached.getToolName()).getValues();
            List options2 = subActions.stream().map(IntentionActionWithTextCaching::getAction).filter(option2 -> ShowIntentionActionsHandler.chooseFileForAction(this.myFile, this.myEditor, option2) != null).collect(Collectors.toList());
            result2.put(action2, options2);
        }
        return result2;
    }

    public boolean hasSubstep(IntentionActionWithTextCaching action2) {
        if (!action2.isShowSubmenu()) {
            return false;
        }
        return action2.getOptionIntentions().size() + action2.getOptionErrorFixes().size() > 0;
    }

    @NotNull
    public List<IntentionActionWithTextCaching> getValues() {
        List<IntentionActionWithTextCaching> list2 = this.myCachedIntentions.getAllActions();
        if (list2 == null) {
            IntentionListStep.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    public String getTextFor(IntentionActionWithTextCaching action2) {
        String text2 = action2.getText();
        if (LOG.isDebugEnabled() && text2.startsWith("<html>")) {
            LOG.info("IntentionAction.getText() returned HTML: action=" + action2.getAction().getClass() + " text=" + text2);
        }
        String string = text2;
        if (string == null) {
            IntentionListStep.$$$reportNull$$$0(8);
        }
        return string;
    }

    public Icon getIconFor(IntentionActionWithTextCaching value2) {
        if (!value2.isShowIcon()) {
            return null;
        }
        return this.myCachedIntentions.getIcon(value2);
    }

    public void canceled() {
        if (this.myPopup != null) {
            this.myPopup.cancelled(this);
        }
    }

    public int getDefaultOptionIndex() {
        return 0;
    }

    public ListSeparator getSeparatorAbove(IntentionActionWithTextCaching value2) {
        List<IntentionActionWithTextCaching> values2 = this.getValues();
        int index2 = values2.indexOf(value2);
        if (index2 <= 0) {
            return null;
        }
        IntentionActionWithTextCaching prev2 = values2.get(index2 - 1);
        if (this.myCachedIntentions.getGroup(value2) != this.myCachedIntentions.getGroup(prev2)) {
            return new ListSeparator();
        }
        return null;
    }

    public boolean isMnemonicsNavigationEnabled() {
        return false;
    }

    public MnemonicNavigationFilter<IntentionActionWithTextCaching> getMnemonicNavigationFilter() {
        return null;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return false;
    }

    public SpeedSearchFilter<IntentionActionWithTextCaching> getSpeedSearchFilter() {
        return this;
    }

    @Override
    public String getIndexedString(IntentionActionWithTextCaching value2) {
        return this.getTextFor(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/IntentionListStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "chooseActionAndInvoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubStep";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

