/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.TailType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiUtilCore;

public class EqTailType
extends TailType {
    public static final TailType INSTANCE = new EqTailType();

    protected boolean isSpaceAroundAssignmentOperators(Editor editor2, int tailOffset) {
        PsiFile psiFile = PsiEditorUtil.getPsiFile((Editor)editor2);
        Language language2 = PsiUtilCore.getLanguageAtOffset((PsiFile)psiFile, (int)tailOffset);
        CodeStyleSettingsFacade codeStyleFacade = CodeStyle.getFacade((PsiFile)psiFile).withLanguage(language2);
        return codeStyleFacade.isSpaceAroundAssignmentOperators();
    }

    public int processTail(Editor editor2, int tailOffset) {
        Document document = editor2.getDocument();
        int textLength = document.getTextLength();
        CharSequence chars = document.getCharsSequence();
        if (tailOffset < textLength - 1 && chars.charAt(tailOffset) == ' ' && chars.charAt(tailOffset + 1) == '=') {
            return EqTailType.moveCaret((Editor)editor2, (int)tailOffset, (int)2);
        }
        if (tailOffset < textLength && chars.charAt(tailOffset) == '=') {
            return EqTailType.moveCaret((Editor)editor2, (int)tailOffset, (int)1);
        }
        if (this.isSpaceAroundAssignmentOperators(editor2, tailOffset)) {
            document.insertString(tailOffset, (CharSequence)" =");
            tailOffset = EqTailType.moveCaret((Editor)editor2, (int)tailOffset, (int)2);
            tailOffset = EqTailType.insertChar((Editor)editor2, (int)tailOffset, (char)' ');
        } else {
            document.insertString(tailOffset, (CharSequence)"=");
            tailOffset = EqTailType.moveCaret((Editor)editor2, (int)tailOffset, (int)1);
        }
        return tailOffset;
    }
}

