/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupManagerListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.BitUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LookupManagerImpl
extends LookupManager {
    private static final Logger LOG = Logger.getInstance(LookupManagerImpl.class);
    private final Project myProject;
    private LookupImpl myActiveLookup;
    private Editor myActiveLookupEditor;
    private final PropertyChangeSupport myPropertyChangeSupport;
    public static final Key<Boolean> SUPPRESS_AUTOPOPUP_JAVADOC = Key.create((String)"LookupManagerImpl.suppressAutopopupJavadoc");

    public LookupManagerImpl(@NotNull Project project) {
        if (project == null) {
            LookupManagerImpl.$$$reportNull$$$0(0);
        }
        this.myActiveLookup = null;
        this.myActiveLookupEditor = null;
        this.myPropertyChangeSupport = new PropertyChangeSupport(this);
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorHintListener.TOPIC, (Object)new EditorHintListener(){

            @Override
            public void hintShown(Project project, final @NotNull LightweightHint hint, int flags) {
                LookupEx lookup2;
                if (hint == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == LookupManagerImpl.this.myProject && (lookup2 = LookupManagerImpl.this.getActiveLookup()) != null && BitUtil.isSet((int)flags, (int)4)) {
                    lookup2.addLookupListener(new LookupListener(){

                        public void currentItemChanged(@NotNull LookupEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            hint.hide();
                        }

                        public void itemSelected(@NotNull LookupEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            hint.hide();
                        }

                        public void lookupCanceled(@NotNull LookupEvent event) {
                            if (event == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            hint.hide();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "event";
                            objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupManagerImpl$1$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "currentItemChanged";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "itemSelected";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "lookupCanceled";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl$1", "hintShown"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }

            public void exitDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == LookupManagerImpl.this.myActiveLookupEditor) {
                    LookupManagerImpl.this.hideActiveLookup();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl$3", "editorReleased"));
            }
        }, (Disposable)this.myProject);
    }

    @Override
    @Nullable
    public LookupEx showLookup(@NotNull Editor editor2, LookupElement @NotNull [] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        if (editor2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            LookupManagerImpl.$$$reportNull$$$0(2);
        }
        if (arranger == null) {
            LookupManagerImpl.$$$reportNull$$$0(3);
        }
        if (items == null) {
            LookupManagerImpl.$$$reportNull$$$0(4);
        }
        for (LookupElement item : items) {
            assert (item != null);
        }
        LookupImpl lookup2 = this.createLookup(editor2, items, prefix, arranger);
        return lookup2.showLookup() ? lookup2 : null;
    }

    @Override
    @NotNull
    public LookupImpl createLookup(@NotNull Editor editor2, LookupElement @NotNull [] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        if (editor2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            LookupManagerImpl.$$$reportNull$$$0(6);
        }
        if (arranger == null) {
            LookupManagerImpl.$$$reportNull$$$0(7);
        }
        if (items == null) {
            LookupManagerImpl.$$$reportNull$$$0(8);
        }
        this.hideActiveLookup();
        final LookupImpl lookup2 = this.createLookup(editor2, arranger, this.myProject);
        Alarm alarm2 = new Alarm();
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActiveLookup = lookup2;
        this.myActiveLookupEditor = editor2;
        this.showDocOnItemChange(lookup2, alarm2);
        Disposer.register((Disposable)lookup2, (Disposable)new Disposable(){

            public void dispose() {
                LookupManagerImpl.this.myActiveLookup = null;
                LookupManagerImpl.this.myActiveLookupEditor = null;
                LookupManagerImpl.this.fireActiveLookupChanged(lookup2, null);
            }
        });
        if (items.length > 0) {
            CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
            for (LookupElement item : items) {
                this.myActiveLookup.addItem(item, matcher);
            }
            this.myActiveLookup.refreshUi(true, true);
        } else {
            alarm2.cancelAllRequests();
        }
        this.fireActiveLookupChanged(null, this.myActiveLookup);
        LookupImpl lookupImpl = lookup2;
        if (lookupImpl == null) {
            LookupManagerImpl.$$$reportNull$$$0(9);
        }
        return lookupImpl;
    }

    void fireActiveLookupChanged(LookupImpl oldLookup, LookupImpl newLookup) {
        this.myPropertyChangeSupport.firePropertyChange("activeLookup", oldLookup, newLookup);
        ((LookupManagerListener)this.myProject.getMessageBus().syncPublisher(LookupManagerListener.TOPIC)).activeLookupChanged(oldLookup, newLookup);
    }

    private void showDocOnItemChange(final @NotNull Lookup lookup2, final @NotNull Alarm alarm2) {
        if (lookup2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(10);
        }
        if (alarm2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(11);
        }
        if (QuickDocUtil.isDocumentationV2Enabled()) {
            return;
        }
        lookup2.addLookupListener(new LookupListener(){

            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                this.lookupClosed();
            }

            public void lookupCanceled(@NotNull LookupEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                this.lookupClosed();
            }

            public void currentItemChanged(@NotNull LookupEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(2);
                }
                alarm2.cancelAllRequests();
                CodeInsightSettings settings = CodeInsightSettings.getInstance();
                if (settings.AUTO_POPUP_JAVADOC_INFO && DocumentationManager.getInstance(LookupManagerImpl.this.myProject).getDocInfoHint() == null) {
                    alarm2.addRequest(() -> LookupManagerImpl.this.showJavadoc(lookup2), settings.JAVADOC_INFO_DELAY);
                }
            }

            private void lookupClosed() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                alarm2.cancelAllRequests();
                lookup2.removeLookupListener((LookupListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupManagerImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "itemSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lookupCanceled";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "currentItemChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void showJavadoc(Lookup lookup2) {
        if (this.myActiveLookup != lookup2) {
            return;
        }
        DocumentationManager docManager = DocumentationManager.getInstance(this.myProject);
        if (docManager.getDocInfoHint() != null) {
            return;
        }
        LookupElement currentItem = lookup2.getCurrentItem();
        CompletionProcess completion = CompletionService.getCompletionService().getCurrentCompletion();
        if (currentItem != null && currentItem.isValid() && LookupManagerImpl.isAutoPopupJavadocSupportedBy(currentItem) && completion != null) {
            try {
                boolean hideLookupWithDoc = completion.isAutopopupCompletion() || CodeInsightSettings.getInstance().JAVADOC_INFO_DELAY == 0;
                docManager.showJavaDocInfo(lookup2.getEditor(), lookup2.getPsiFile(), false, () -> {
                    if (hideLookupWithDoc && completion == CompletionService.getCompletionService().getCurrentCompletion()) {
                        this.hideActiveLookup();
                    }
                });
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
        }
    }

    public static boolean isAutoPopupJavadocSupportedBy(@NotNull LookupElement lookupElement) {
        if (lookupElement == null) {
            LookupManagerImpl.$$$reportNull$$$0(12);
        }
        return lookupElement.getUserData(SUPPRESS_AUTOPOPUP_JAVADOC) == null;
    }

    @NotNull
    protected LookupImpl createLookup(@NotNull Editor editor2, @NotNull LookupArranger arranger, Project project) {
        if (editor2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(13);
        }
        if (arranger == null) {
            LookupManagerImpl.$$$reportNull$$$0(14);
        }
        return new LookupImpl(project, editor2, arranger);
    }

    @Override
    public void hideActiveLookup() {
        LookupImpl lookup2 = this.myActiveLookup;
        if (lookup2 != null) {
            lookup2.checkValid();
            lookup2.hide();
            LOG.assertTrue(lookup2.isLookupDisposed(), (Object)"Should be disposed");
        }
    }

    @Override
    public LookupEx getActiveLookup() {
        if (this.myActiveLookup != null && this.myActiveLookup.isLookupDisposed()) {
            LookupImpl lookup2 = this.myActiveLookup;
            this.myActiveLookup = null;
            lookup2.checkValid();
        }
        return this.myActiveLookup;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(15);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener2);
    }

    @Override
    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(16);
        }
        if (disposable2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(17);
        }
        this.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)disposable2, (Disposable)new Disposable(){

            public void dispose() {
                LookupManagerImpl.this.removePropertyChangeListener(listener2);
            }
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            LookupManagerImpl.$$$reportNull$$$0(18);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener2);
    }

    @TestOnly
    public void forceSelection(char completion, int index2) {
        if (this.myActiveLookup == null) {
            throw new RuntimeException("There are no items in this lookup");
        }
        LookupElement lookupItem = this.myActiveLookup.getItems().get(index2);
        this.myActiveLookup.setCurrentItem(lookupItem);
        this.myActiveLookup.finishLookup(completion);
    }

    @TestOnly
    public void forceSelection(char completion, LookupElement item) {
        this.myActiveLookup.setCurrentItem(item);
        this.myActiveLookup.finishLookup(completion);
    }

    @TestOnly
    public void clearLookup() {
        if (this.myActiveLookup != null) {
            this.myActiveLookup.hide();
            this.myActiveLookup = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arranger";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/impl/LookupManagerImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/impl/LookupManagerImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showLookup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLookup";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDocOnItemChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAutoPopupJavadocSupportedBy";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

