/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor2, PsiFile file2) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(0);
        }
        int offset = editor2.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor2, ImplementationSearcher.getFlags(), offset);
        if (source == null && (offset = GotoImplementationHandler.tryGetNavigationSourceOffsetFromGutterIcon(editor2, "GotoImplementation")) >= 0) {
            source = TargetElementUtil.getInstance().findTargetElement(editor2, ImplementationSearcher.getFlags(), offset);
        }
        if (source == null) {
            return null;
        }
        return this.createDataForSource(editor2, offset, source);
    }

    @NotNull
    protected GotoTargetHandler.GotoData createDataForSource(@NotNull Editor editor2, int offset, PsiElement source) {
        PsiElement[] targets2;
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(1);
        }
        if ((targets2 = this.findTargets(editor2, offset, source)) == null) {
            GotoTargetHandler.GotoData data2 = new GotoTargetHandler.GotoData(source, PsiElement.EMPTY_ARRAY, Collections.emptyList());
            data2.isCanceled = true;
            GotoTargetHandler.GotoData gotoData = data2;
            if (gotoData == null) {
                GotoImplementationHandler.$$$reportNull$$$0(2);
            }
            return gotoData;
        }
        PsiReference reference2 = TargetElementUtil.findReference(editor2, offset);
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets2, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor2, offset, reference2){

            @Override
            public void onSuccess() {
                super.onSuccess();
                PsiElement oneElement = this.getTheOnlyOneElement();
                if (oneElement != null && GotoImplementationHandler.this.navigateToElement(oneElement)) {
                    this.myPopup.cancel();
                }
            }
        };
        GotoTargetHandler.GotoData gotoData2 = gotoData;
        if (gotoData2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(3);
        }
        return gotoData2;
    }

    protected PsiElement @Nullable [] findTargets(@NotNull Editor editor2, int offset, @NotNull PsiElement source) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(4);
        }
        if (source == null) {
            GotoImplementationHandler.$$$reportNull$$$0(5);
        }
        final PsiReference reference2 = TargetElementUtil.findReference(editor2, offset);
        final TargetElementUtil instance2 = TargetElementUtil.getInstance();
        return new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element2) {
                if (reference2 != null && !reference2.getElement().isValid()) {
                    return false;
                }
                return instance2.acceptImplementationForReference(reference2, element2);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element2) {
                return false;
            }
        }.searchImplementations(editor2, source, offset);
    }

    public static int tryGetNavigationSourceOffsetFromGutterIcon(@NotNull Editor editor2, String actionId) {
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(6);
        }
        int line = editor2.getCaretModel().getVisualPosition().line;
        List<GutterMark> renderers = ((EditorGutterComponentEx)editor2.getGutter()).getGutterRenderers(line);
        ArrayList<PsiElement> elementCandidates = new ArrayList<PsiElement>();
        for (GutterMark renderer2 : renderers) {
            if (!(renderer2 instanceof LineMarkerInfo.LineMarkerGutterIconRenderer)) continue;
            LineMarkerInfo.LineMarkerGutterIconRenderer lineMarkerRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)renderer2;
            AnAction clickAction = ((LineMarkerInfo.LineMarkerGutterIconRenderer)renderer2).getClickAction();
            if (!(clickAction instanceof NavigateAction) || !actionId.equals(((NavigateAction)clickAction).getOriginalActionId())) continue;
            elementCandidates.add(lineMarkerRenderer.getLineMarkerInfo().getElement());
        }
        if (elementCandidates.size() == 1) {
            return ((PsiElement)elementCandidates.iterator().next()).getTextRange().getStartOffset();
        }
        return -1;
    }

    @Override
    protected void chooseFromAmbiguousSources(Editor editor2, PsiFile file2, Consumer<? super GotoTargetHandler.GotoData> successCallback) {
        int offset = editor2.getCaretModel().getOffset();
        PsiElementProcessor navigateProcessor = element2 -> {
            GotoTargetHandler.GotoData data2 = this.createDataForSource(editor2, offset, element2);
            successCallback.consume((Object)data2);
            return true;
        };
        Project project = editor2.getProject();
        if (project == null) {
            return;
        }
        GotoDeclarationAction.chooseAmbiguousTarget(project, editor2, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), null);
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider2 : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider2.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, @Nullable String name2, int length, boolean finished2) {
        Object fullName;
        ItemPresentation presentation2;
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(7);
        }
        if ((presentation2 = ((NavigationItem)sourceElement).getPresentation()) == null) {
            fullName = name2;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (String)(containerText == null ? "" : containerText + ".") + presentation2.getPresentableText();
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{fullName == null ? "unnamed element" : StringUtil.escapeXmlEntities((String)fullName), length, finished2 ? "" : " so far"});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name2, int length) {
        if (sourceElement == null) {
            GotoImplementationHandler.$$$reportNull$$$0(9);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)name2), length});
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            GotoImplementationHandler.$$$reportNull$$$0(11);
        }
        if (editor2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(13);
        }
        String string = CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
        if (string == null) {
            GotoImplementationHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static Comparator<PsiElement> createImplementationComparator(@NotNull GotoTargetHandler.GotoData gotoData) {
        if (gotoData == null) {
            GotoImplementationHandler.$$$reportNull$$$0(15);
        }
        Comparator<PsiElement> projectContentComparator = GotoImplementationHandler.projectElementsFirst(gotoData.source.getProject());
        Comparator<PsiElement> presentationComparator = Comparator.comparing(element2 -> gotoData.getComparingObject(element2));
        Comparator positionComparator = PsiUtilCore::compareElementsByPosition;
        Comparator<PsiElement> result2 = projectContentComparator.thenComparing(presentationComparator).thenComparing(positionComparator);
        return GotoImplementationHandler.wrapIntoReadAction(result2);
    }

    @NotNull
    public static Comparator<PsiElement> projectElementsFirst(@NotNull Project project) {
        if (project == null) {
            GotoImplementationHandler.$$$reportNull$$$0(16);
        }
        FileIndexFacade index2 = FileIndexFacade.getInstance((Project)project);
        Comparator<PsiElement> comparator2 = Comparator.comparing(element2 -> index2.isInContent(element2.getContainingFile().getVirtualFile())).reversed();
        if (comparator2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(17);
        }
        return comparator2;
    }

    @NotNull
    private static <T> Comparator<T> wrapIntoReadAction(@NotNull Comparator<T> base) {
        if (base == null) {
            GotoImplementationHandler.$$$reportNull$$$0(18);
        }
        Comparator comparator2 = (e1, e2) -> (Integer)ReadAction.compute(() -> base.compare(e1, e2));
        if (comparator2 == null) {
            GotoImplementationHandler.$$$reportNull$$$0(19);
        }
        return comparator2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoData";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataForSource";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChooserTitle";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFoundMessage";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "projectElementsFirst";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapIntoReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceAndTargetElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDataForSource";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTargets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryGetNavigationSourceOffsetFromGutterIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChooserTitle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFindUsagesTitle";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNotFoundMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createImplementationComparator";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "projectElementsFirst";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoReadAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(@NotNull GotoTargetHandler.GotoData gotoData, Editor editor2, int offset, PsiReference reference2) {
            if (gotoData == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(0);
            }
            if (editor2 == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(1);
            }
            super(gotoData.source.getProject(), ImplementationSearcher.getSearchingForImplementations(), GotoImplementationHandler.createImplementationComparator(gotoData));
            this.myEditor = editor2;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference2;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                ImplementationsUpdaterTask.$$$reportNull$$$0(2);
            }
            super.run(indicator2);
            for (PsiElement element2 : this.myGotoData.targets) {
                if (this.updateComponent(element2)) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element2) {
                    indicator2.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element2)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element2) && !ImplementationsUpdaterTask.this.updateComponent(element2)) {
                        indicator2.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            String name2 = ElementDescriptionUtil.getElementDescription((PsiElement)this.myGotoData.source, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, name2, size, this.isFinished());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gotoData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/navigation/GotoImplementationHandler$ImplementationsUpdaterTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

