/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvokeTemplateAction
extends AnAction {
    private final TemplateImpl myTemplate;
    private final Editor myEditor;
    private final Project myProject;
    @Nullable
    private final Runnable myCallback;

    public InvokeTemplateAction(TemplateImpl template, Editor editor2, Project project, Set<Character> usedMnemonicsSet) {
        this(template, editor2, project, usedMnemonicsSet, null);
    }

    public InvokeTemplateAction(TemplateImpl template, Editor editor2, Project project, Set<Character> usedMnemonicsSet, @Nullable Runnable afterInvocationCallback) {
        super(InvokeTemplateAction.extractMnemonic(template.getKey(), usedMnemonicsSet) + (String)(StringUtil.isEmptyOrSpaces((String)template.getDescription()) ? "" : ". " + template.getDescription()));
        this.myTemplate = template;
        this.myProject = project;
        this.myEditor = editor2;
        this.myCallback = afterInvocationCallback;
    }

    @NlsActions.ActionText
    public static String extractMnemonic(@NlsActions.ActionText String caption, Set<? super Character> usedMnemonics) {
        if (StringUtil.isEmpty((String)caption)) {
            return "";
        }
        for (int i2 = 0; i2 < caption.length(); ++i2) {
            char c = caption.charAt(i2);
            if (!usedMnemonics.add(Character.valueOf(Character.toUpperCase(c)))) continue;
            return caption.substring(0, i2) + "\u001b" + caption.substring(i2);
        }
        return caption + " ";
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InvokeTemplateAction.$$$reportNull$$$0(0);
        }
        this.perform();
    }

    public void perform() {
        Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(Collections.singletonList(file2)).hasReadonlyFiles()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            this.myEditor.getCaretModel().runForEachCaret(__ -> {
                if (this.myEditor.getSelectionModel().hasSelection() && this.myTemplate.isToReformat()) {
                    int offset;
                    int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
                    int lineEnd = document.getLineEndOffset(document.getLineNumber(offset));
                    for (offset = this.myEditor.getSelectionModel().getSelectionStart(); offset < lineEnd && offset < selectionEnd && (document.getCharsSequence().charAt(offset) == ' ' || document.getCharsSequence().charAt(offset) == '\t'); ++offset) {
                    }
                    if (selectionEnd == document.getLineStartOffset(document.getLineNumber(selectionEnd))) {
                        --selectionEnd;
                    }
                    if (offset < lineEnd && offset < selectionEnd) {
                        this.myEditor.getSelectionModel().setSelection(offset, selectionEnd);
                    }
                }
                String selectionString = this.myEditor.getSelectionModel().getSelectedText();
                TemplateManager.getInstance(this.myProject).startTemplate(this.myEditor, selectionString, this.myTemplate);
            });
            if (this.myCallback != null) {
                this.myCallback.run();
            }
        }, CodeInsightBundle.message((String)"command.wrap.with.template", (Object[])new Object[0]), (Object)("Wrap with template " + this.myTemplate.getKey()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/InvokeTemplateAction", "actionPerformed"));
    }
}

