/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveTemplateTree
extends CheckboxTree
implements DataProvider,
CopyProvider,
PasteProvider,
DeleteProvider {
    private final TemplateListPanel myConfigurable;

    LiveTemplateTree(CheckboxTree.CheckboxTreeCellRenderer renderer2, CheckedTreeNode root2, TemplateListPanel configurable2) {
        super(renderer2, root2);
        this.myConfigurable = configurable2;
        if (!GraphicsEnvironment.isHeadless()) {
            this.setDragEnabled(true);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node2) {
        Object obj2 = node2.getUserObject();
        if (obj2 instanceof TemplateImpl) {
            ((TemplateImpl)obj2).setDeactivated(!node2.isChecked());
        }
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)o -> {
            Object object = ((DefaultMutableTreeNode)o.getLastPathComponent()).getUserObject();
            if (object instanceof TemplateGroup) {
                return ((TemplateGroup)object).getName();
            }
            if (object instanceof TemplateImpl) {
                TemplateImpl template = (TemplateImpl)object;
                return StringUtil.notNullize((String)template.getGroupName()) + " " + StringUtil.notNullize((String)template.getKey()) + " " + StringUtil.notNullize((String)template.getDescription()) + " " + template.getTemplateText();
            }
            return "";
        }), true).setComparator(new SubstringSpeedSearchComparator());
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LiveTemplateTree.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId) || PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(1);
        }
        Set<TemplateImpl> templates = this.myConfigurable.getSelectedTemplates().keySet();
        TemplateSettings templateSettings = TemplateSettings.getInstance();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(templates, template -> JDOMUtil.writeElement((Element)TemplateSettings.serializeTemplate(template, templateSettings.getDefaultTemplate((TemplateImpl)template), TemplateContext.getIdToType())), (String)System.lineSeparator())));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(2);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(3);
        }
        return this.isCopyEnabled(dataContext);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(4);
        }
        if (this.myConfigurable.getSingleContextGroup() == null) {
            return false;
        }
        String s = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        return s != null && s.trim().startsWith("<template ");
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(5);
        }
        return this.isPastePossible(dataContext);
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(6);
        }
        TemplateGroup group2 = this.myConfigurable.getSingleContextGroup();
        assert (group2 != null);
        String buffer = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        assert (buffer != null);
        try {
            for (Element templateElement2 : JDOMUtil.load((CharSequence)("<root>" + buffer + "</root>")).getChildren("template")) {
                TemplateImpl template = TemplateSettings.readTemplateFromElement(group2.getName(), templateElement2, this.getClass().getClassLoader());
                while (group2.containsTemplate(template.getKey(), template.getId())) {
                    template.setKey(template.getKey() + "1");
                    if (template.getId() == null) continue;
                    template.setId(template.getId() + "1");
                }
                this.myConfigurable.addTemplate(template);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(7);
        }
        this.myConfigurable.removeRows();
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            LiveTemplateTree.$$$reportNull$$$0(8);
        }
        return !this.myConfigurable.getSelectedTemplates().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SubstringSpeedSearchComparator
    extends SpeedSearchComparator {
        private SubstringSpeedSearchComparator() {
        }

        @Override
        public int matchingDegree(String pattern, String text2) {
            return this.matchingFragments(pattern, text2) != null ? 1 : 0;
        }

        @Override
        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text2) {
            int index2;
            if (pattern == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                SubstringSpeedSearchComparator.$$$reportNull$$$0(1);
            }
            return (index2 = StringUtil.indexOfIgnoreCase((String)text2, (String)pattern, (int)0)) >= 0 ? Collections.singleton(TextRange.from((int)index2, (int)pattern.length())) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateTree$SubstringSpeedSearchComparator";
            objectArray[2] = "matchingFragments";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

