/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TemplateExpressionLookupElement
extends LookupElementDecorator<LookupElement> {
    private final TemplateState myState;

    TemplateExpressionLookupElement(TemplateState state, LookupElement element2, int index2) {
        super(PrioritizedLookupElement.withPriority((LookupElement)element2, (double)(0x7FFFFFF5 - index2)));
        this.myState = state;
    }

    private static InsertionContext createInsertionContext(LookupElement item, PsiFile psiFile, List<? extends LookupElement> elements, Editor editor2, char completionChar) {
        OffsetMap offsetMap = new OffsetMap(editor2.getDocument());
        InsertionContext context2 = new InsertionContext(offsetMap, completionChar, elements.toArray(LookupElement.EMPTY_ARRAY), psiFile, editor2, InsertionContext.shouldAddCompletionChar((char)completionChar));
        context2.setTailOffset(editor2.getCaretModel().getOffset());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, context2.getTailOffset() - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, context2.getTailOffset());
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context2.getTailOffset());
        return context2;
    }

    void handleTemplateInsert(List<? extends LookupElement> elements, char completionChar) {
        InsertionContext context2 = TemplateExpressionLookupElement.createInsertionContext((LookupElement)this, this.myState.getPsiFile(), elements, this.myState.getEditor(), completionChar);
        WriteAction.run(() -> {
            this.doHandleInsert(context2);
            if (context2.shouldAddCompletionChar()) {
                CodeCompletionHandlerBase.addCompletionChar(context2, (LookupElement)this);
            }
        });
        Disposer.dispose((Disposable)context2.getOffsetMap());
        if (TemplateExpressionLookupElement.handleCompletionChar(context2) && !this.myState.isFinished()) {
            this.myState.calcResults(true);
            this.myState.considerNextTabOnLookupItemSelected(this.getDelegate());
        }
    }

    public void handleInsert(@NotNull InsertionContext context2) {
        if (context2 == null) {
            TemplateExpressionLookupElement.$$$reportNull$$$0(0);
        }
        this.doHandleInsert(context2);
        TemplateExpressionLookupElement.handleCompletionChar(context2);
    }

    private void doHandleInsert(InsertionContext context2) {
        LookupElement item = this.getDelegate();
        PsiDocumentManager.getInstance((Project)context2.getProject()).commitAllDocuments();
        super.handleInsert(context2);
        TextRange range2 = this.myState.getCurrentVariableRange();
        TemplateLookupSelectionHandler handler2 = (TemplateLookupSelectionHandler)item.getUserData(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM);
        if (handler2 != null && range2 != null) {
            handler2.itemSelected(item, context2.getFile(), context2.getDocument(), range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static boolean handleCompletionChar(InsertionContext context2) {
        if (context2.getCompletionChar() == '.') {
            AutoPopupController.getInstance(context2.getProject()).autoPopupMemberLookup(context2.getEditor(), null);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/impl/TemplateExpressionLookupElement", "handleInsert"));
    }
}

