/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotatorInspectionVisitor
extends PsiElementVisitor {
    private static final Logger LOG = Logger.getInstance(ExternalAnnotatorInspectionVisitor.class);
    private final ProblemsHolder myHolder;
    private final ExternalAnnotator myAnnotator;
    private final boolean myIsOnTheFly;

    public ExternalAnnotatorInspectionVisitor(ProblemsHolder holder, ExternalAnnotator annotator, boolean isOnTheFly) {
        this.myHolder = holder;
        this.myAnnotator = annotator;
        this.myIsOnTheFly = isOnTheFly;
    }

    public void visitFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(0);
        }
        ProblemDescriptor[] descriptors = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator(file2, this.myHolder.getManager(), this.myIsOnTheFly, this.myAnnotator);
        this.addDescriptors(descriptors);
    }

    public static <Init, Result> ProblemDescriptor @NotNull [] checkFileWithExternalAnnotator(@NotNull PsiFile file2, @NotNull InspectionManager manager2, boolean isOnTheFly, @NotNull ExternalAnnotator<Init, Result> annotator) {
        if (file2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(1);
        }
        if (manager2 == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (annotator == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (isOnTheFly) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(4);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Object info2 = ReadAction.compute(() -> annotator.collectInformation(file2));
        if (info2 != null) {
            Object annotationResult = annotator.doAnnotate(info2);
            if (annotationResult == null) {
                if (ProblemDescriptor.EMPTY_ARRAY == null) {
                    ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(5);
                }
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            ProblemDescriptor[] problemDescriptorArray = (ProblemDescriptor[])ReadAction.compute(() -> {
                AnnotationHolderImpl annotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2), true);
                annotationHolder.applyExternalAnnotatorWithContext(file2, annotator, annotationResult);
                annotationHolder.assertAllAnnotationsCreated();
                return ProblemDescriptorUtil.convertToProblemDescriptors((List<? extends Annotation>)((Object)annotationHolder), file2);
            });
            if (problemDescriptorArray == null) {
                ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(6);
            }
            return problemDescriptorArray;
        }
        if (ProblemDescriptor.EMPTY_ARRAY == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(7);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private void addDescriptors(ProblemDescriptor @NotNull [] descriptors) {
        if (descriptors == null) {
            ExternalAnnotatorInspectionVisitor.$$$reportNull$$$0(8);
        }
        for (ProblemDescriptor descriptor2 : descriptors) {
            LOG.assertTrue(descriptor2 != null, (Object)((Object)((Object)this)).getClass().getName());
            this.myHolder.registerProblem(descriptor2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileWithExternalAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFileWithExternalAnnotator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LocalQuickFixBackedByIntentionAction
    implements LocalQuickFix,
    Iconable {
        private final IntentionAction myAction;

        public LocalQuickFixBackedByIntentionAction(@NotNull IntentionAction action2) {
            if (action2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(0);
            }
            this.myAction = action2;
        }

        @NotNull
        public String getName() {
            String string = this.myAction.getText();
            if (string == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myAction.getFamilyName();
            if (string == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(3);
            }
            if (descriptor2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(4);
            }
            this.myAction.invoke(project, null, LocalQuickFixBackedByIntentionAction.getPsiFile(descriptor2));
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
            if (file2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(5);
            }
            return this.myAction.getElementToMakeWritable(file2);
        }

        @Nullable
        private static PsiFile getPsiFile(@NotNull ProblemDescriptor descriptor2) {
            PsiElement startElement;
            if (descriptor2 == null) {
                LocalQuickFixBackedByIntentionAction.$$$reportNull$$$0(6);
            }
            if ((startElement = descriptor2.getStartElement()) != null) {
                return startElement.getContainingFile();
            }
            PsiElement endElement = descriptor2.getEndElement();
            if (endElement != null) {
                return endElement.getContainingFile();
            }
            return null;
        }

        public Icon getIcon(@Iconable.IconFlags int flags) {
            if (this.myAction instanceof Iconable) {
                return ((Iconable)this.myAction).getIcon(flags);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalQuickFixBackedByIntentionAction action2 = (LocalQuickFixBackedByIntentionAction)o;
            return this.myAction.equals(action2.myAction);
        }

        public int hashCode() {
            return this.myAction.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ExternalAnnotatorInspectionVisitor$LocalQuickFixBackedByIntentionAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPsiFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

