/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnsureInstruction
extends Instruction {
    @Nullable
    private final UnsatisfiedConditionProblem myProblem;
    @NotNull
    private final RelationType myRelation;
    @NotNull
    private final DfType myCompareTo;
    @Nullable
    private final DfaControlTransferValue myTransferValue;
    private final boolean myMakeEphemeral;

    public EnsureInstruction(@Nullable UnsatisfiedConditionProblem problem, @NotNull RelationType relation, @NotNull DfType compareTo, @Nullable DfaControlTransferValue value2) {
        if (relation == null) {
            EnsureInstruction.$$$reportNull$$$0(0);
        }
        if (compareTo == null) {
            EnsureInstruction.$$$reportNull$$$0(1);
        }
        this(problem, relation, compareTo, value2, false);
    }

    public EnsureInstruction(@Nullable UnsatisfiedConditionProblem problem, @NotNull RelationType relation, @NotNull DfType compareTo, @Nullable DfaControlTransferValue value2, boolean makeEphemeral) {
        if (relation == null) {
            EnsureInstruction.$$$reportNull$$$0(2);
        }
        if (compareTo == null) {
            EnsureInstruction.$$$reportNull$$$0(3);
        }
        this.myProblem = problem;
        this.myRelation = relation;
        this.myCompareTo = compareTo;
        this.myTransferValue = value2;
        this.myMakeEphemeral = makeEphemeral;
    }

    @Override
    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory2) {
        if (factory2 == null) {
            EnsureInstruction.$$$reportNull$$$0(4);
        }
        if (this.myTransferValue == null) {
            EnsureInstruction ensureInstruction = this;
            if (ensureInstruction == null) {
                EnsureInstruction.$$$reportNull$$$0(5);
            }
            return ensureInstruction;
        }
        EnsureInstruction instruction = new EnsureInstruction(this.myProblem, this.myRelation, this.myCompareTo, this.myTransferValue.bindToFactory(factory2));
        instruction.setIndex(this.getIndex());
        EnsureInstruction ensureInstruction = instruction;
        if (ensureInstruction == null) {
            EnsureInstruction.$$$reportNull$$$0(6);
        }
        return ensureInstruction;
    }

    @Nullable
    public UnsatisfiedConditionProblem getProblem() {
        return this.myProblem;
    }

    @Nullable
    public DfaControlTransferValue getExceptionTransfer() {
        return this.myTransferValue;
    }

    @Override
    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            EnsureInstruction.$$$reportNull$$$0(7);
        }
        if (stateBefore == null) {
            EnsureInstruction.$$$reportNull$$$0(8);
        }
        DfaValue tosValue = stateBefore.isEmptyStack() ? interpreter.getFactory().getUnknown() : stateBefore.peek();
        DfaCondition cond = this.createCondition(tosValue);
        UnsatisfiedConditionProblem problem = this.getProblem();
        if (cond.equals(DfaCondition.getTrue())) {
            if (problem != null) {
                interpreter.getListener().onCondition(problem, tosValue, ThreeState.NO, stateBefore);
            }
            return this.nextStates(interpreter, stateBefore);
        }
        DfaMemoryState falseState = stateBefore.createCopy();
        boolean trueStatePossible = stateBefore.applyCondition(cond);
        boolean falseStatePossible = falseState.applyCondition(cond.negate());
        ArrayList<DfaInstructionState> result2 = new ArrayList<DfaInstructionState>();
        if (trueStatePossible) {
            result2.add(this.nextState(interpreter, stateBefore));
        }
        if (problem != null) {
            ThreeState failed = !trueStatePossible ? ThreeState.YES : (!falseStatePossible ? ThreeState.NO : ThreeState.UNSURE);
            interpreter.getListener().onCondition(problem, tosValue, failed, stateBefore);
        }
        if (falseStatePossible && this.myTransferValue != null) {
            List<DfaInstructionState> states = this.myTransferValue.dispatch(falseState, interpreter);
            if (this.myMakeEphemeral) {
                for (DfaInstructionState negState : states) {
                    negState.getMemoryState().markEphemeral();
                }
            }
            result2.addAll(states);
        }
        return result2.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    @Override
    public int @NotNull [] getSuccessorIndexes() {
        int[] nArray;
        if (this.myTransferValue == null) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.getIndex() + 1;
        } else {
            nArray = IntStreamEx.of((int[])this.myTransferValue.getPossibleTargetIndices()).append(new int[]{this.getIndex() + 1}).toArray();
        }
        if (nArray == null) {
            EnsureInstruction.$$$reportNull$$$0(9);
        }
        return nArray;
    }

    @NotNull
    public DfaCondition createCondition(@NotNull DfaValue tosValue) {
        if (tosValue == null) {
            EnsureInstruction.$$$reportNull$$$0(10);
        }
        DfaCondition dfaCondition = tosValue.cond(this.myRelation, this.myCompareTo);
        if (dfaCondition == null) {
            EnsureInstruction.$$$reportNull$$$0(11);
        }
        return dfaCondition;
    }

    public String toString() {
        return "ENSURE " + this.myRelation + " " + this.myCompareTo + (String)(this.myTransferValue == null ? "" : " " + this.myTransferValue.getTarget());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compareTo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/lang/ir/EnsureInstruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tosValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/lang/ir/EnsureInstruction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToFactory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessorIndexes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCondition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

