/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntConsumer;

class SortedIntSet
implements Comparable<SortedIntSet> {
    private int[] myData;
    private int mySize;

    SortedIntSet() {
        this.mySize = 0;
        this.myData = new int[10];
    }

    SortedIntSet(int[] values2) {
        this.myData = (int[])values2.clone();
        Arrays.sort(this.myData);
        this.mySize = this.myData.length;
    }

    public int size() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public void add(int val) {
        int pos = this.indexOf(val);
        if (pos >= 0) {
            return;
        }
        if (this.mySize == this.myData.length) {
            this.myData = Arrays.copyOf(this.myData, this.mySize * 3 / 2 + 1);
        }
        System.arraycopy(this.myData, -pos - 1, this.myData, -pos, this.mySize + pos + 1);
        this.myData[-pos - 1] = val;
        ++this.mySize;
    }

    public void add(int[] vals) {
        for (int val : vals) {
            this.add(val);
        }
    }

    public boolean contains(int val) {
        return this.indexOf(val) >= 0;
    }

    public void removeValue(int val) {
        int pos = this.indexOf(val);
        if (pos >= 0) {
            this.remove(pos);
        }
    }

    private int indexOf(int value2) {
        for (int i2 = 0; i2 < this.mySize; ++i2) {
            int datum = this.myData[i2];
            if (value2 == datum) {
                return i2;
            }
            if (value2 >= datum) continue;
            return -i2 - 1;
        }
        return -this.mySize - 1;
    }

    public void remove(int offset) {
        System.arraycopy(this.myData, offset + 1, this.myData, offset, this.mySize - offset - 1);
        --this.mySize;
    }

    public boolean containsAll(SortedIntSet that) {
        int thisSize;
        int thatSize = that.size();
        if (thatSize > (thisSize = this.size())) {
            return false;
        }
        int thisIndex = 0;
        for (int thatIndex = 0; thatIndex < thatSize; ++thatIndex) {
            int thatValue = that.myData[thatIndex];
            while (thisIndex < thisSize && this.myData[thisIndex] < thatValue) {
                ++thisIndex;
            }
            if (thisIndex == thisSize || this.myData[thisIndex] > thatValue) {
                return false;
            }
            ++thisIndex;
        }
        return true;
    }

    @Override
    public int compareTo(SortedIntSet t) {
        if (t == this) {
            return 0;
        }
        if (t.size() != this.size()) {
            return Integer.compare(this.size(), t.size());
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.myData[i2] == t.myData[i2]) continue;
            return Integer.compare(this.myData[i2], t.myData[i2]);
        }
        return 0;
    }

    public int get(int pos) {
        if (pos >= this.mySize) {
            throw new IllegalArgumentException();
        }
        return this.myData[pos];
    }

    public void forValues(IntConsumer consumer2) {
        for (int i2 = 0; i2 < this.mySize; ++i2) {
            consumer2.accept(this.myData[i2]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedIntSet set2 = (SortedIntSet)o;
        if (this.mySize != set2.mySize) {
            return false;
        }
        return Arrays.equals(this.myData, 0, this.mySize, set2.myData, 0, this.mySize);
    }

    public int hashCode() {
        int size = this.mySize;
        int result2 = Objects.hash(size);
        int[] arr = this.myData;
        for (int i2 = 0; i2 < size; ++i2) {
            int element2 = arr[i2];
            result2 = 31 * result2 + element2;
        }
        return result2;
    }

    protected int[] toNativeArray() {
        return Arrays.copyOf(this.myData, this.mySize);
    }
}

