/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class QuickFixWrapper
implements IntentionAction,
PriorityAction {
    private static final Logger LOG = Logger.getInstance(QuickFixWrapper.class);
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor2, int fixNumber) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(fixNumber >= 0, (Object)fixNumber);
        QuickFix[] fixes = descriptor2.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix2 = fixes[fixNumber];
        return fix2 instanceof IntentionAction ? (IntentionAction)fix2 : new QuickFixWrapper(descriptor2, (LocalQuickFix)fix2);
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor2, @NotNull LocalQuickFix fix2) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(1);
        }
        if (fix2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(2);
        }
        this.myDescriptor = descriptor2;
        this.myFix = fix2;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getFix().getName();
        if (string == null) {
            QuickFixWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        PsiElement psiElement;
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(5);
        }
        if ((psiElement = this.myDescriptor.getPsiElement()) == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        return containingFile == file2 || containingFile == null || containingFile.getViewProvider().getVirtualFile().equals(file2.getViewProvider().getVirtualFile());
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        PsiElement element2;
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(6);
        }
        PsiFile fileForUndo = (element2 = this.myDescriptor.getPsiElement()) == null ? null : element2.getContainingFile();
        LocalQuickFix fix2 = this.getFix();
        fix2.applyFix(project, (CommonProblemDescriptor)this.myDescriptor);
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        if (fileForUndo != null && !fileForUndo.equals(file2)) {
            UndoUtil.markPsiFileForUndo((PsiFile)fileForUndo);
        }
    }

    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(7);
        }
        return this.getFix().getElementToMakeWritable(file2);
    }

    @NotNull
    public LocalQuickFix getFix() {
        LocalQuickFix localQuickFix = this.myFix;
        if (localQuickFix == null) {
            QuickFixWrapper.$$$reportNull$$$0(8);
        }
        return localQuickFix;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myFix instanceof PriorityAction ? ((PriorityAction)this.myFix).getPriority() : PriorityAction.Priority.NORMAL;
        if (priority == null) {
            QuickFixWrapper.$$$reportNull$$$0(9);
        }
        return priority;
    }

    @TestOnly
    public ProblemHighlightType getHighlightType() {
        return this.myDescriptor.getHighlightType();
    }

    @Nullable
    public PsiFile getFile() {
        PsiElement element2 = this.myDescriptor.getPsiElement();
        return element2 != null ? element2.getContainingFile() : null;
    }

    public String toString() {
        return this.getText();
    }

    public boolean invokeForPreview(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            QuickFixWrapper.$$$reportNull$$$0(10);
        }
        return this.myFix.applyFixForPreview(project, this.myDescriptor.getDescriptorForPreview(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invokeForPreview";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

