/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.htmlInspections.XmlWrongClosingTagNameInspection;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlTagUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenameTagBeginOrEndIntentionAction
implements IntentionAction {
    private final boolean myStart;
    private final String myTargetName;
    private final String mySourceName;

    RenameTagBeginOrEndIntentionAction(@NotNull String targetName, @NotNull String sourceName, boolean start2) {
        if (targetName == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(0);
        }
        if (sourceName == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(1);
        }
        this.myTargetName = targetName;
        this.mySourceName = sourceName;
        this.myStart = start2;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file2) {
        if (project == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        int offset;
        PsiElement psiElement;
        if (project == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(5);
        }
        if ((psiElement = file2.findElementAt(offset = editor2.getCaretModel().getOffset())) == null) {
            return;
        }
        if (psiElement instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevLeaf((PsiElement)psiElement);
        }
        if (psiElement instanceof XmlToken) {
            Document document;
            IElementType tokenType = ((XmlToken)psiElement).getTokenType();
            if (tokenType != XmlTokenType.XML_NAME && tokenType == XmlTokenType.XML_TAG_END && (psiElement = psiElement.getPrevSibling()) == null) {
                return;
            }
            String text2 = psiElement.getText();
            PsiElement target2 = !this.myTargetName.equals(text2) ? psiElement : RenameTagBeginOrEndIntentionAction.findOtherSide(psiElement, this.myStart);
            if (target2 != null && (document = PsiDocumentManager.getInstance((Project)project).getDocument(file2)) != null) {
                TextRange textRange = target2.getTextRange();
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)this.myTargetName);
            }
        }
    }

    @Nullable
    public static PsiElement findOtherSide(PsiElement psiElement, boolean start2) {
        XmlToken target2 = null;
        PsiElement parent = psiElement.getParent();
        if (parent instanceof PsiErrorElement) {
            parent = parent.getParent();
        }
        if (parent instanceof XmlTag) {
            if (start2) {
                target2 = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)parent));
            } else {
                target2 = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)parent));
                if (target2 == null) {
                    PsiErrorElement errorElement = (PsiErrorElement)PsiTreeUtil.getChildOfType((PsiElement)parent, PsiErrorElement.class);
                    target2 = XmlWrongClosingTagNameInspection.findEndTagName(errorElement);
                }
            }
        }
        return target2;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    @IntentionName
    public String getName() {
        String string = this.myStart ? XmlAnalysisBundle.message((String)"xml.intention.rename.start.tag", (Object[])new Object[]{this.mySourceName, this.myTargetName}) : XmlAnalysisBundle.message((String)"xml.intention.rename.end.tag", (Object[])new Object[]{this.mySourceName, this.myTargetName});
        if (string == null) {
            RenameTagBeginOrEndIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceName";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/RenameTagBeginOrEndIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

