/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.naming;

import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;

public class NamingConventionBean {
    public String m_regex;
    public int m_minLength;
    public int m_maxLength;
    private final Set<String> myPredefinedNames = new HashSet<String>();
    protected Pattern m_regexPattern;

    public NamingConventionBean(@NonNls @RegExp String regex, int minLength, int maxLength, String ... predefinedNames2Ignore) {
        this.m_regex = regex;
        this.m_minLength = minLength;
        this.m_maxLength = maxLength;
        this.myPredefinedNames.addAll(Arrays.asList(predefinedNames2Ignore));
        this.initPattern();
    }

    public boolean isValid(String name2) {
        int length = name2.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if (this.myPredefinedNames.contains(name2)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name2);
        return matcher.matches();
    }

    public void initPattern() {
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((Object)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamingConventionBean bean = (NamingConventionBean)o;
        return this.m_minLength == bean.m_minLength && this.m_maxLength == bean.m_maxLength && Objects.equals(this.m_regex, bean.m_regex);
    }

    public int hashCode() {
        return Objects.hash(this.m_regex, this.m_minLength, this.m_maxLength);
    }
}

