/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.LevelAndCount;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionTreeNode
implements TreeNode {
    private static final Interner<LevelAndCount[]> LEVEL_AND_COUNT_INTERNER = new WeakInterner((HashingStrategy)new HashingStrategy<LevelAndCount[]>(){

        public int hashCode(LevelAndCount[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(LevelAndCount[] o1, LevelAndCount[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    protected final ProblemLevels myProblemLevels = new ProblemLevels();
    @Nullable
    volatile Children myChildren;
    final InspectionTreeNode myParent;

    protected InspectionTreeNode(InspectionTreeNode parent) {
        this.myParent = parent;
    }

    protected boolean doesNeedInternProblemLevels() {
        return false;
    }

    @Nullable
    public Icon getIcon(boolean expanded2) {
        return null;
    }

    LevelAndCount @NotNull [] getProblemLevels() {
        LevelAndCount[] levelAndCountArray = this.myProblemLevels.getValue();
        if (levelAndCountArray == null) {
            InspectionTreeNode.$$$reportNull$$$0(0);
        }
        return levelAndCountArray;
    }

    void dropProblemCountCaches() {
        for (InspectionTreeNode current2 = this; current2 != null && this.getParent() != null; current2 = current2.getParent()) {
            current2.myProblemLevels.drop();
        }
    }

    protected void visitProblemSeverities(@NotNull Object2IntMap<HighlightDisplayLevel> counter) {
        if (counter == null) {
            InspectionTreeNode.$$$reportNull$$$0(1);
        }
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            for (LevelAndCount levelAndCount : inspectionTreeNode.getProblemLevels()) {
                counter.mergeInt((Object)levelAndCount.getLevel(), levelAndCount.getCount(), Math::addExact);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean isExcluded() {
        List<? extends InspectionTreeNode> children2 = this.getChildren();
        for (InspectionTreeNode inspectionTreeNode : children2) {
            if (inspectionTreeNode.isExcluded()) continue;
            return false;
        }
        return !children2.isEmpty();
    }

    public boolean appearsBold() {
        return false;
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getTailText() {
        return null;
    }

    public void excludeElement() {
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            inspectionTreeNode.excludeElement();
        }
        this.dropProblemCountCaches();
    }

    public void amnestyElement() {
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            inspectionTreeNode.amnestyElement();
        }
        this.dropProblemCountCaches();
    }

    public RefEntity getContainingFileLocalEntity() {
        RefEntity current2 = null;
        for (InspectionTreeNode inspectionTreeNode : this.getChildren()) {
            RefEntity entity = inspectionTreeNode.getContainingFileLocalEntity();
            if (entity == null || current2 != null) {
                return null;
            }
            current2 = entity;
        }
        return current2;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    @Nls
    public abstract String getPresentableText();

    @NotNull
    public List<? extends InspectionTreeNode> getChildren() {
        Children children2 = this.myChildren;
        ImmutableList immutableList = children2 == null ? Collections.emptyList() : ContainerUtil.immutableList((Object[])children2.myChildren);
        if (immutableList == null) {
            InspectionTreeNode.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @Override
    public InspectionTreeNode getParent() {
        return this.myParent;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public InspectionTreeNode getChildAt(int idx) {
        return this.getChildren().get(idx);
    }

    @Override
    public int getIndex(TreeNode node2) {
        return Collections.binarySearch(this.getChildren(), (InspectionTreeNode)node2, InspectionResultsViewComparator.INSTANCE);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(this.getChildren());
    }

    public String toString() {
        return this.getPresentableText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/InspectionTreeNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemLevels";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/InspectionTreeNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitProblemSeverities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class ProblemLevels {
        private volatile LevelAndCount[] myLevels;

        ProblemLevels() {
        }

        private LevelAndCount @NotNull [] compute() {
            Object2IntOpenHashMap counter = new Object2IntOpenHashMap();
            InspectionTreeNode.this.visitProblemSeverities((Object2IntMap<HighlightDisplayLevel>)counter);
            LevelAndCount[] arr = new LevelAndCount[counter.size()];
            int[] i2 = new int[]{0};
            for (Object2IntMap.Entry entry2 : counter.object2IntEntrySet()) {
                int n = i2[0];
                i2[0] = n + 1;
                arr[n] = new LevelAndCount((HighlightDisplayLevel)entry2.getKey(), entry2.getIntValue());
            }
            Arrays.sort(arr, Comparator.comparing(levelAndCount -> levelAndCount.getLevel().getSeverity()).reversed());
            LevelAndCount[] levelAndCountArray = InspectionTreeNode.this.doesNeedInternProblemLevels() ? (LevelAndCount[])LEVEL_AND_COUNT_INTERNER.intern((Object)arr) : arr;
            if (levelAndCountArray == null) {
                ProblemLevels.$$$reportNull$$$0(0);
            }
            return levelAndCountArray;
        }

        public LevelAndCount @NotNull [] getValue() {
            LevelAndCount[] result2 = this.myLevels;
            if (result2 == null) {
                result2 = this.compute();
                this.myLevels = result2;
            }
            if (result2 == null) {
                ProblemLevels.$$$reportNull$$$0(1);
            }
            return result2;
        }

        public void drop() {
            this.myLevels = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/ui/InspectionTreeNode$ProblemLevels";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static class Children {
        private static final InspectionTreeNode[] EMPTY_ARRAY = new InspectionTreeNode[0];
        volatile InspectionTreeNode[] myChildren = EMPTY_ARRAY;
        final BidirectionalMap<Object, InspectionTreeNode> myUserObject2Node = new BidirectionalMap();

        Children() {
        }

        void clear() {
            this.myChildren = EMPTY_ARRAY;
            this.myUserObject2Node.clear();
        }
    }
}

