/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.services.OAuthCredentialsAcquirer;
import com.intellij.collaboration.auth.services.OAuthRequest;
import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.ide.BrowserUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00140\u0013H\u0002J\u001a\u0010\u0018\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00070\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "Lcom/intellij/collaboration/auth/services/OAuthService;", "()V", "currentRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "getCurrentRequest", "()Ljava/util/concurrent/atomic/AtomicReference;", "authorize", "Ljava/util/concurrent/CompletableFuture;", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "handleServerCallback", "", "path", "", "parameters", "", "", "startAuthorization", "", "getAuthorizationCode", "processCode", "code", "OAuthRequestWithResult", "intellij.platform.collaborationTools.auth"})
public abstract class OAuthServiceBase<T extends Credentials>
implements OAuthService<T> {
    @NotNull
    private final AtomicReference<OAuthRequestWithResult<T>> currentRequest = new AtomicReference();

    @NotNull
    protected final AtomicReference<OAuthRequestWithResult<T>> getCurrentRequest() {
        return this.currentRequest;
    }

    @Override
    @NotNull
    public CompletableFuture<T> authorize(@NotNull OAuthRequest<T> request2) {
        Intrinsics.checkNotNullParameter(request2, (String)"request");
        if (!this.currentRequest.compareAndSet(null, new OAuthRequestWithResult<T>(request2, new CompletableFuture()))) {
            OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
            Intrinsics.checkNotNull(oAuthRequestWithResult);
            return oAuthRequestWithResult.getResult();
        }
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        Intrinsics.checkNotNull(oAuthRequestWithResult);
        CompletableFuture<T> result2 = oAuthRequestWithResult.getResult();
        result2.whenComplete(new BiConsumer(this){
            final /* synthetic */ OAuthServiceBase this$0;

            public final void accept(T $noName_0, Throwable $noName_1) {
                this.this$0.getCurrentRequest().set(null);
            }
            {
                this.this$0 = oAuthServiceBase;
            }
        });
        this.startAuthorization(request2);
        return result2;
    }

    private final String getAuthorizationCode(Map<String, ? extends List<String>> $this$getAuthorizationCode) {
        List<String> list2 = $this$getAuthorizationCode.get("code");
        return list2 != null ? (String)CollectionsKt.firstOrNull(list2) : null;
    }

    @Override
    public boolean handleServerCallback(@NotNull String path2, @NotNull Map<String, ? extends List<String>> parameters2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        OAuthRequestWithResult<T> oAuthRequestWithResult = this.currentRequest.get();
        if (oAuthRequestWithResult == null) {
            return false;
        }
        OAuthRequestWithResult<T> request2 = oAuthRequestWithResult;
        if (Intrinsics.areEqual((Object)path2, (Object)request2.getRequest().getAuthorizationCodeUrl().getPath()) ^ true) {
            return false;
        }
        String string = this.getAuthorizationCode(parameters2);
        if (string == null) {
            return false;
        }
        String code = string;
        this.processCode(request2, code);
        CompletableFuture<T> result2 = request2.getResult();
        return result2.isDone() && !result2.isCancelled() && !result2.isCompletedExceptionally();
    }

    private final void startAuthorization(OAuthRequest<T> request2) {
        String string = request2.getAuthUrlWithParameters().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.authUrlWithParameters.toExternalForm()");
        String authUrl = string;
        BrowserUtil.browse((String)authUrl);
    }

    private final void processCode(OAuthRequestWithResult<T> $this$processCode, String code) {
        try {
            OAuthCredentialsAcquirer.AcquireCredentialsResult<T> acquireResult = $this$processCode.getRequest().getCredentialsAcquirer().acquireCredentials(code);
            if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Success) {
                $this$processCode.getResult().complete(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Success)acquireResult).getCredentials());
            } else if (acquireResult instanceof OAuthCredentialsAcquirer.AcquireCredentialsResult.Error) {
                $this$processCode.getResult().completeExceptionally(new RuntimeException(((OAuthCredentialsAcquirer.AcquireCredentialsResult.Error)acquireResult).getDescription()));
            }
        }
        catch (Exception e) {
            $this$processCode.getResult().completeExceptionally(e);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0003J/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthServiceBase$OAuthRequestWithResult;", "T", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "", "request", "Lcom/intellij/collaboration/auth/services/OAuthRequest;", "result", "Ljava/util/concurrent/CompletableFuture;", "(Lcom/intellij/collaboration/auth/services/OAuthRequest;Ljava/util/concurrent/CompletableFuture;)V", "getRequest", "()Lcom/intellij/collaboration/auth/services/OAuthRequest;", "getResult", "()Ljava/util/concurrent/CompletableFuture;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.collaborationTools.auth"})
    protected static final class OAuthRequestWithResult<T extends Credentials> {
        @NotNull
        private final OAuthRequest<T> request;
        @NotNull
        private final CompletableFuture<T> result;

        @NotNull
        public final OAuthRequest<T> getRequest() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> getResult() {
            return this.result;
        }

        public OAuthRequestWithResult(@NotNull OAuthRequest<T> request2, @NotNull CompletableFuture<T> result2) {
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.request = request2;
            this.result = result2;
        }

        @NotNull
        public final OAuthRequest<T> component1() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<T> component2() {
            return this.result;
        }

        @NotNull
        public final OAuthRequestWithResult<T> copy(@NotNull OAuthRequest<T> request2, @NotNull CompletableFuture<T> result2) {
            Intrinsics.checkNotNullParameter(request2, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            return new OAuthRequestWithResult<T>(request2, result2);
        }

        public static /* synthetic */ OAuthRequestWithResult copy$default(OAuthRequestWithResult oAuthRequestWithResult, OAuthRequest oAuthRequest, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                oAuthRequest = oAuthRequestWithResult.request;
            }
            if ((n & 2) != 0) {
                completableFuture = oAuthRequestWithResult.result;
            }
            return oAuthRequestWithResult.copy(oAuthRequest, completableFuture);
        }

        @NotNull
        public String toString() {
            return "OAuthRequestWithResult(request=" + this.request + ", result=" + this.result + ")";
        }

        public int hashCode() {
            OAuthRequest<T> oAuthRequest = this.request;
            CompletableFuture<T> completableFuture = this.result;
            return (oAuthRequest != null ? oAuthRequest.hashCode() : 0) * 31 + (completableFuture != null ? completableFuture.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OAuthRequestWithResult)) break block3;
                    OAuthRequestWithResult oAuthRequestWithResult = (OAuthRequestWithResult)object;
                    if (!Intrinsics.areEqual(this.request, oAuthRequestWithResult.request) || !Intrinsics.areEqual(this.result, oAuthRequestWithResult.result)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

