/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.TypeMarker;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/BinaryXmlWriter;", "", "out", "Ljava/io/DataOutputStream;", "(Ljava/io/DataOutputStream;)V", "strings", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "", "write", "", "element", "Lorg/jdom/Element;", "writeAttributes", "attributes", "", "Lorg/jdom/Attribute;", "writeElement", "writeString", "string", "writeUInt29", "v", "", "intellij.platform.projectModel.impl"})
public final class BinaryXmlWriter {
    private final Object2IntOpenHashMap<String> strings;
    private final DataOutputStream out;

    public final void write(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.writeElement(element2);
    }

    private final void writeString(String string) {
        block5: {
            block4: {
                if (string == null) break block4;
                CharSequence charSequence = string;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block5;
            }
            this.out.write(1);
            return;
        }
        int reference2 = this.strings.getInt((Object)string);
        if (reference2 != -1) {
            this.writeUInt29(reference2 << 1);
            return;
        }
        this.strings.put((Object)string, this.strings.size());
        this.out.write(3);
        IOUtil.writeUTF((DataOutput)this.out, (String)string);
    }

    private final void writeElement(Element element2) {
        this.writeString(element2.getName());
        this.writeAttributes(element2.hasAttributes() ? element2.getAttributes() : null);
        List content2 = element2.getContent();
        for (Content item : content2) {
            String text2;
            Content content3 = item;
            if (content3 instanceof Element) {
                this.out.writeByte(TypeMarker.ELEMENT.ordinal());
                this.writeElement((Element)item);
                continue;
            }
            if (content3 instanceof CDATA) {
                this.out.writeByte(TypeMarker.CDATA.ordinal());
                this.writeString(((CDATA)item).getText());
                continue;
            }
            if (!(content3 instanceof Text) || (text2 = ((Text)item).getText()) == null || Verifier.isAllXMLWhitespace((String)text2)) continue;
            this.out.writeByte(TypeMarker.TEXT.ordinal());
            this.writeString(text2);
        }
        this.out.writeByte(TypeMarker.ELEMENT_END.ordinal());
    }

    private final void writeAttributes(List<? extends Attribute> attributes2) {
        List<? extends Attribute> list2 = attributes2;
        int size = list2 != null ? list2.size() : 0;
        this.out.write(size);
        if (size == 0) {
            return;
        }
        if (size > 255) {
            throw (Throwable)new UnsupportedOperationException("attributes size > 255");
        }
        List<? extends Attribute> list3 = attributes2;
        Intrinsics.checkNotNull(list3);
        for (Attribute attribute : list3) {
            this.writeString(attribute.getName());
            this.writeString(attribute.getValue());
        }
    }

    private final void writeUInt29(int v) {
        if (v < 128) {
            this.out.write(v);
        } else if (v < 16384) {
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x200000) {
            this.out.write(v >> 14 & 0x7F | 0x80);
            this.out.write(v >> 7 & 0x7F | 0x80);
            this.out.write(v & 0x7F);
        } else if (v < 0x40000000) {
            this.out.write(v >> 22 & 0x7F | 0x80);
            this.out.write(v >> 15 & 0x7F | 0x80);
            this.out.write(v >> 8 & 0x7F | 0x80);
            this.out.write(v & 0xFF);
        } else {
            throw (Throwable)new IllegalArgumentException("Integer out of range: " + v);
        }
    }

    public BinaryXmlWriter(@NotNull DataOutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.strings = new Object2IntOpenHashMap();
        this.strings.defaultReturnValue(-1);
    }
}

