/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ChooseComponentsToExportDialog;
import com.intellij.configurationStore.ChooseComponentsToExportDialogKt;
import com.intellij.configurationStore.ComponentElementProperties;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.MultiStateElementsChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FieldPanel;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u001dH\u0014J\b\u0010%\u001a\u00020\u001bH\u0014J\b\u0010&\u001a\u00020\nH\u0014J\n\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\u001bH\u0002R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/configurationStore/ChooseComponentsToExportDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "fileToComponents", "", "Lcom/intellij/configurationStore/FileSpec;", "", "Lcom/intellij/configurationStore/ExportableItem;", "isShowFilePath", "", "title", "", "description", "(Ljava/util/Map;ZLjava/lang/String;Ljava/lang/String;)V", "chooser", "Lcom/intellij/ide/util/ElementsChooser;", "Lcom/intellij/configurationStore/ComponentElementProperties;", "exportFile", "Ljava/nio/file/Path;", "getExportFile$intellij_platform_configurationStore_impl", "()Ljava/nio/file/Path;", "exportableComponents", "", "getExportableComponents$intellij_platform_configurationStore_impl", "()Ljava/util/Set;", "pathPanel", "Lcom/intellij/ui/FieldPanel;", "browse", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createNorthPanel", "Ljavax/swing/JLabel;", "createSouthPanel", "doOKAction", "getDimensionServiceKey", "getPreferredFocusedComponent", "Ljavax/swing/JTextField;", "updateControls", "intellij.platform.configurationStore.impl"})
public final class ChooseComponentsToExportDialog
extends DialogWrapper {
    private final ElementsChooser<ComponentElementProperties> chooser;
    private final FieldPanel pathPanel;
    private final boolean isShowFilePath;
    private final String description;

    @NotNull
    public final Set<ExportableItem> getExportableComponents$intellij_platform_configurationStore_impl() {
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026rintSet<ExportableItem>()");
        Set components = set2;
        for (ComponentElementProperties elementProperties : this.chooser.getMarkedElements()) {
            components.addAll((Collection)elementProperties.getItems());
        }
        return components;
    }

    @NotNull
    public final Path getExportFile$intellij_platform_configurationStore_impl() {
        Path path2 = Paths.get(this.pathPanel.getText(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(pathPanel.text)");
        return path2;
    }

    private final void browse() {
        FileChooserDescriptor descriptor2;
        FileChooserDescriptor fileChooserDescriptor2 = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
        boolean bl = false;
        boolean bl2 = false;
        FileChooserDescriptor $this$apply = fileChooserDescriptor2;
        boolean bl3 = false;
        $this$apply.setTitle(ConfigurationStoreBundle.message("title.export.file.location", new Object[0]));
        $this$apply.setDescription(ConfigurationStoreBundle.message("prompt.choose.export.settings.file.path", new Object[0]));
        $this$apply.setHideIgnored(false);
        $this$apply.withFileFilter((Condition)browse.descriptor.1.1.INSTANCE);
        FileChooserDescriptor fileChooserDescriptor3 = descriptor2 = fileChooserDescriptor2;
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor3, (String)"descriptor");
        ChooseComponentsToExportDialogKt.chooseSettingsFile(fileChooserDescriptor3, this.pathPanel.getText(), this.getWindow(), (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public final void invoke(@NotNull VirtualFile file2) {
                String string;
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (file2.isDirectory()) {
                    string = file2.getPath() + "/settings.zip";
                } else {
                    String string2 = file2.getPath();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
                }
                String path2 = string;
                ChooseComponentsToExportDialog.access$getPathPanel$p(this.this$0).setText(FileUtil.toSystemDependentName((String)path2));
            }
            {
                this.this$0 = chooseComponentsToExportDialog;
                super(1);
            }
        }));
    }

    private final void updateControls() {
        CharSequence charSequence = this.pathPanel.getText();
        boolean bl = false;
        boolean bl2 = false;
        this.setOKActionEnabled(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)));
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction selectAll2 = new AbstractAction(this, ConfigurationStoreBundle.message("export.components.list.action.select.all", new Object[0])){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(true);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        AbstractAction selectNone2 = new AbstractAction(this, ConfigurationStoreBundle.message("export.components.list.action.select.none", new Object[0])){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).setAllElementsMarked(false);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        AbstractAction invert2 = new AbstractAction(this, ConfigurationStoreBundle.message("export.components.list.action.invert.selection", new Object[0])){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ChooseComponentsToExportDialog.access$getChooser$p(this.this$0).invertSelection();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        return new Action[]{selectAll2, selectNone2, invert2};
    }

    protected void doOKAction() {
        PropertiesComponent.getInstance().setValue("export.settings.path", this.pathPanel.getText(), ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        StringBuilder builder2 = new StringBuilder();
        if (this.chooser.hasUnmarkedElements()) {
            List<ComponentElementProperties> list2 = this.chooser.getElements(true);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"chooser.getElements(true)");
            List<ComponentElementProperties> marked = list2;
            for (ComponentElementProperties element2 : marked) {
                builder2.append(element2.getFileName());
                builder2.append("|");
            }
        }
        CharSequence charSequence = builder2;
        boolean bl = false;
        PropertiesComponent.getInstance().setValue("export.settings.marked", charSequence.length() == 0 ? null : builder2.toString());
        super.doOKAction();
    }

    @Nullable
    public JTextField getPreferredFocusedComponent() {
        return this.pathPanel.getTextField();
    }

    @NotNull
    protected JLabel createNorthPanel() {
        return new JLabel(this.description);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.chooser;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent buttons = super.createSouthPanel();
        if (!this.isShowFilePath) {
            JComponent jComponent = buttons;
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"buttons");
            return jComponent;
        }
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel2.add((Component)this.pathPanel);
        panel2.add(buttons);
        return panel2;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.actions.ChooseComponentsToExportDialog";
    }

    public ChooseComponentsToExportDialog(@NotNull Map<FileSpec, ? extends List<ExportableItem>> fileToComponents, boolean isShowFilePath, @NlsContexts.DialogTitle @NotNull String title2, @NlsContexts.Label @NotNull String description) {
        Intrinsics.checkNotNullParameter(fileToComponents, (String)"fileToComponents");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        super(false);
        this.isShowFilePath = isShowFilePath;
        this.description = description;
        this.pathPanel = new FieldPanel(ConfigurationStoreBundle.message("editbox.export.settings.to", new Object[0]), null, new ActionListener(this){
            final /* synthetic */ ChooseComponentsToExportDialog this$0;

            public final void actionPerformed(ActionEvent it) {
                ChooseComponentsToExportDialog.access$browse(this.this$0);
            }
            {
                this.this$0 = chooseComponentsToExportDialog;
            }
        }, null);
        LinkedHashMap componentToContainingListElement = new LinkedHashMap();
        for (List<ExportableItem> list2 : fileToComponents.values()) {
            for (ExportableItem item : list2) {
                if (ChooseComponentsToExportDialogKt.access$addToExistingListElement(item, componentToContainingListElement, fileToComponents)) continue;
                ComponentElementProperties componentElementProperties = new ComponentElementProperties();
                componentElementProperties.getItems().add(item);
                ((Map)componentToContainingListElement).put(item, componentElementProperties);
            }
        }
        this.chooser = new ElementsChooser(true);
        this.chooser.setColorUnmarkedElements(false);
        Set set2 = ChooseComponentsToExportDialogKt.access$getMarkedElementNames$p();
        for (ComponentElementProperties componentElementProperty : new LinkedHashSet(componentToContainingListElement.values())) {
            this.chooser.addElement(componentElementProperty, set2.isEmpty() || set2.contains(componentElementProperty.getFileName()), (MultiStateElementsChooser.ElementProperties)componentElementProperty);
        }
        this.chooser.sort(Comparator.comparing(1.INSTANCE));
        String string = PropertiesComponent.getInstance().getValue("export.settings.path", ChooseComponentsToExportDialogKt.access$getDEFAULT_PATH$p());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertiesComponent.getI\u2026ings.path\", DEFAULT_PATH)");
        String exportPath = string;
        this.pathPanel.setText(exportPath);
        this.pathPanel.setChangeListener(new Runnable(){

            @Override
            public final void run() {
                this.updateControls();
            }
        });
        this.updateControls();
        this.setTitle(title2);
        this.init();
    }

    public static final /* synthetic */ FieldPanel access$getPathPanel$p(ChooseComponentsToExportDialog $this) {
        return $this.pathPanel;
    }

    public static final /* synthetic */ ElementsChooser access$getChooser$p(ChooseComponentsToExportDialog $this) {
        return $this.chooser;
    }

    public static final /* synthetic */ void access$browse(ChooseComponentsToExportDialog $this) {
        $this.browse();
    }
}

