/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ModuleStateStorageManager;
import com.intellij.configurationStore.ModuleStoreBase;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.project.ProjectKt;
import com.intellij.util.messages.MessageBus;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0010\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0004J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u001c\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/configurationStore/ModuleStoreImpl;", "Lcom/intellij/configurationStore/ModuleStoreBase;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/ModuleStateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/ModuleStateStorageManager;", "getPathMacroManagerForDefaults", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "reloadStates", "", "componentNames", "", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
public class ModuleStoreImpl
extends ModuleStoreBase {
    private final PathMacroManager pathMacroManager;
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleStateStorageManager storageManager;

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ModuleStateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    @NotNull
    protected final PathMacroManager getPathMacroManagerForDefaults() {
        return this.pathMacroManager;
    }

    @Override
    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component2, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        List<Storage> result2 = super.getStorageSpecs(component2, stateSpec, operation);
        if (!ProjectKt.isDirectoryBased(this.getProject())) {
            return result2;
        }
        for (StreamProviderFactory provider2 : StreamProviderFactory.Companion.getEP_NAME().getExtensions((AreaInstance)this.getProject())) {
            Object object;
            Logger $this$runAndLogException$iv = ComponentStoreImplKt.getLOG();
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            boolean bl = false;
            try {
                object = Result.Companion;
                Logger $this$runCatching$iv = logger;
                boolean bl2 = false;
                boolean bl3 = false;
                List<Storage> list2 = provider2.customizeStorageSpecs(component2, this.getStorageManager(), stateSpec, result2, operation);
                if (list2 != null) {
                    List<Storage> list3 = list2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    List<Storage> it = list3;
                    boolean bl6 = false;
                    return it;
                }
                Object var12_12 = null;
                boolean bl7 = false;
                object = Result.constructor-impl(var12_12);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl8 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reloadStates(@NotNull Set<String> componentNames, @NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter(componentNames, (String)"componentNames");
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        Project project$iv = this.getProject();
        boolean $i$f$runBatchUpdate = false;
        Object object = project$iv.getMessageBus().syncPublisher(BatchUpdateListener.TOPIC);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.messageBus.syncP\u2026atchUpdateListener.TOPIC)");
        BatchUpdateListener publisher$iv = (BatchUpdateListener)object;
        publisher$iv.onBatchUpdateStarted();
        try {
            boolean bl = false;
            ComponentStoreImpl.reinitComponents$default(this, componentNames, null, null, 6, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            publisher$iv.onBatchUpdateFinished();
        }
    }

    public ModuleStoreImpl(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)module);
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"PathMacroManager.getInstance(module)");
        this.pathMacroManager = pathMacroManager;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        this.project = project;
        this.storageManager = new ModuleStateStorageManager(new TrackingPathMacroSubstitutorImpl(this.pathMacroManager), module);
    }
}

