/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.schemeManager.SchemeAddOrUpdateEvent;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicatorKt;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u0002H\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000b\u001a\u00020\u0007H\u00c6\u0003J\u001f\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J6\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00150\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/schemeManager/AddScheme;", "T", "Lcom/intellij/openapi/options/Scheme;", "M", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "Lcom/intellij/configurationStore/schemeManager/SchemeAddOrUpdateEvent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "", "execute", "", "schemaLoader", "Lkotlin/Lazy;", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "hashCode", "", "toString", "", "intellij.platform.configurationStore.impl"})
final class AddScheme<T extends Scheme, M extends T>
implements SchemeChangeEvent<T, M>,
SchemeAddOrUpdateEvent {
    @NotNull
    private final VirtualFile file;

    @Override
    public void execute(@NotNull Lazy<SchemeLoader<T, M>> schemaLoader, @NotNull SchemeManagerImpl<T, M> schemeManager2) {
        Intrinsics.checkNotNullParameter(schemaLoader, (String)"schemaLoader");
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        if (!this.getFile().isValid()) {
            return;
        }
        T t = SchemeChangeApplicatorKt.readSchemeFromFile(this.getFile(), (SchemeLoader)schemaLoader.getValue(), schemeManager2);
        if (t == null) {
            return;
        }
        T readScheme = t;
        String readSchemeKey = schemeManager2.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(readScheme);
        T t2 = schemeManager2.findSchemeByName(readSchemeKey);
        if (t2 == null) {
            return;
        }
        T existingScheme = t2;
        if ((Scheme)schemeManager2.getSchemeListManager$intellij_platform_configurationStore_impl().getReadOnlyExternalizableSchemes$intellij_platform_configurationStore_impl().get(schemeManager2.getProcessor$intellij_platform_configurationStore_impl().getSchemeKey(existingScheme)) != existingScheme) {
            ComponentStoreImplKt.getLOG().warn("Ignore incorrect VFS create scheme event: schema " + readSchemeKey + " is already exists");
            return;
        }
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public AddScheme(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.file = file2;
    }

    @NotNull
    public final VirtualFile component1() {
        return this.getFile();
    }

    @NotNull
    public final AddScheme<T, M> copy(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new AddScheme<T, M>(file2);
    }

    public static /* synthetic */ AddScheme copy$default(AddScheme addScheme, VirtualFile virtualFile2, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile2 = addScheme.getFile();
        }
        return addScheme.copy(virtualFile2);
    }

    @NotNull
    public String toString() {
        return "AddScheme(file=" + this.getFile() + ")";
    }

    public int hashCode() {
        VirtualFile virtualFile2 = this.getFile();
        return virtualFile2 != null ? virtualFile2.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AddScheme)) break block3;
                AddScheme addScheme = (AddScheme)object;
                if (!Intrinsics.areEqual((Object)this.getFile(), (Object)addScheme.getFile())) break block3;
            }
            return true;
        }
        return false;
    }
}

