/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeContentChangedHandler;
import com.intellij.configurationStore.schemeManager.ExternalInfo;
import com.intellij.configurationStore.schemeManager.RemoveAllSchemes;
import com.intellij.configurationStore.schemeManager.RemoveScheme;
import com.intellij.configurationStore.schemeManager.SchemeAddOrUpdateEvent;
import com.intellij.configurationStore.schemeManager.SchemeChangeApplicatorKt;
import com.intellij.configurationStore.schemeManager.SchemeChangeEvent;
import com.intellij.configurationStore.schemeManager.SchemeDataHolderImpl;
import com.intellij.configurationStore.schemeManager.SchemeLoader;
import com.intellij.configurationStore.schemeManager.SchemeLoaderKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.configurationStore.schemeManager.SchemeManagerUtilKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.util.StaxFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aO\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\b\u0010\u0005\u001a\u0004\u0018\u0001H\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a?\u0010\r\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u000bH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a=\u0010\u000f\u001a\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u000b2\u0006\u0010\u0010\u001a\u0002H\u0002H\u0000\u00a2\u0006\u0002\u0010\u0011\u001aS\u0010\u0012\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00142\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u000bH\u0000\u00a2\u0006\u0002\u0010\u0015\u001aH\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00180\u0017\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u0002H\u00022\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00180\u0017H\u0000\u00a8\u0006\u001a"}, d2={"callSchemeContentChangedIfSupported", "", "T", "Lcom/intellij/openapi/options/Scheme;", "M", "changedScheme", "fileName", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "schemeManager", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;", "(Lcom/intellij/openapi/options/Scheme;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Z", "findExternalizableSchemeByFileName", "(Ljava/lang/String;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Lcom/intellij/openapi/options/Scheme;", "getSchemeFileName", "scheme", "(Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;Lcom/intellij/openapi/options/Scheme;)Ljava/lang/String;", "readSchemeFromFile", "schemeLoader", "Lcom/intellij/configurationStore/schemeManager/SchemeLoader;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/configurationStore/schemeManager/SchemeLoader;Lcom/intellij/configurationStore/schemeManager/SchemeManagerImpl;)Lcom/intellij/openapi/options/Scheme;", "sortSchemeChangeEvents", "", "Lcom/intellij/configurationStore/schemeManager/SchemeChangeEvent;", "inputEvents", "intellij.platform.configurationStore.impl"})
public final class SchemeChangeApplicatorKt {
    private static final <T extends Scheme, M extends T> T findExternalizableSchemeByFileName(String fileName, SchemeManagerImpl<T, M> schemeManager2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = schemeManager2.getSchemes$intellij_platform_configurationStore_impl();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Scheme it = (Scheme)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)fileName, (Object)SchemeChangeApplicatorKt.getSchemeFileName(schemeManager2, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return (T)((Scheme)v0);
    }

    @NotNull
    public static final <T extends Scheme, M extends T> String getSchemeFileName(@NotNull SchemeManagerImpl<T, M> schemeManager2, @NotNull T scheme2) {
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        Intrinsics.checkNotNullParameter(scheme2, (String)"scheme");
        return schemeManager2.getFileName$intellij_platform_configurationStore_impl(scheme2) + schemeManager2.getSchemeExtension$intellij_platform_configurationStore_impl();
    }

    @Nullable
    public static final <T extends Scheme, M extends T> T readSchemeFromFile(@NotNull VirtualFile file2, @NotNull SchemeLoader<T, M> schemeLoader, @NotNull SchemeManagerImpl<T, M> schemeManager2) {
        M m;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(schemeLoader, (String)"schemeLoader");
        Intrinsics.checkNotNullParameter(schemeManager2, (String)"schemeManager");
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        String fileName = string;
        if (file2.isDirectory() || !schemeManager2.canRead(fileName)) {
            return null;
        }
        boolean $i$f$catchAndLog = false;
        try {
            boolean bl = false;
            m = schemeLoader.loadScheme(fileName, null, file2.contentsToByteArray());
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof ControlFlowException) {
                throw e$iv;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
            Logger logger = ComponentStoreImplKt.getLOG();
            boolean bl = false;
            String string2 = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            String string3 = string2;
            logger.error(stringBuilder.append(string3).toString(), e$iv);
            m = null;
        }
        return (T)m;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends Scheme, M extends T> Collection<SchemeChangeEvent<T, M>> sortSchemeChangeEvents(@NotNull Collection<? extends SchemeChangeEvent<T, M>> inputEvents) {
        Intrinsics.checkNotNullParameter(inputEvents, (String)"inputEvents");
        if (inputEvents.size() < 2) {
            return inputEvents;
        }
        boolean isThereSomeRemoveEvent = false;
        Set set2 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"CollectionFactory.create\u2026oryFootprintSet<String>()");
        Set existingAddOrUpdate = set2;
        Set set3 = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"CollectionFactory.create\u2026oryFootprintSet<String>()");
        Set removedFileNames = set3;
        ArrayList<SchemeChangeEvent<T, M>> result2 = new ArrayList<SchemeChangeEvent<T, M>>(inputEvents);
        int n = result2.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i2;
            SchemeChangeEvent<T, M> event = result2.get((int)i2);
            if (event instanceof RemoveAllSchemes) {
                void var8_10 = i2 - true;
                boolean bl2 = false;
                while (var8_10 >= 0) {
                    void j;
                    result2.remove((int)j);
                    --j;
                }
                break;
            }
            if (event instanceof SchemeAddOrUpdateEvent) {
                String fileName;
                Intrinsics.checkNotNullExpressionValue((Object)((SchemeAddOrUpdateEvent)((Object)event)).getFile().getName(), (String)"event.file.name");
                if (removedFileNames.contains(fileName)) {
                    result2.remove((int)i2);
                } else {
                    existingAddOrUpdate.add(fileName);
                }
            } else if (event instanceof RemoveScheme) {
                if (existingAddOrUpdate.contains(((RemoveScheme)event).getFileName())) {
                    result2.remove((int)i2);
                } else {
                    isThereSomeRemoveEvent = true;
                    removedFileNames.add(((RemoveScheme)event).getFileName());
                }
            }
            --i2;
        }
        sortSchemeChangeEvents.1 $fun$weight$1 = sortSchemeChangeEvents.1.INSTANCE;
        if (isThereSomeRemoveEvent) {
            CollectionsKt.sortWith((List)result2, (Comparator)sortSchemeChangeEvents.2.INSTANCE);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends Scheme, M extends T> boolean callSchemeContentChangedIfSupported(M changedScheme, String fileName, VirtualFile file2, SchemeManagerImpl<T, M> schemeManager2) {
        if (changedScheme == null || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof SchemeContentChangedHandler) || !(schemeManager2.getProcessor$intellij_platform_configurationStore_impl() instanceof LazySchemeProcessor)) {
            return false;
        }
        ExternalInfo externalInfo = (ExternalInfo)schemeManager2.getSchemeToInfo$intellij_platform_configurationStore_impl().get(changedScheme);
        if (externalInfo == null) {
            return false;
        }
        ExternalInfo externalInfo2 = externalInfo;
        boolean $i$f$catchAndLog = false;
        try {
            SchemeProcessor processor2;
            void parser;
            void bytes$iv;
            boolean bl = false;
            byte[] bytes = file2.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            byte[] byArray = bytes;
            boolean isOldSchemeNaming$iv = schemeManager2.isOldSchemeNaming$intellij_platform_configurationStore_impl();
            boolean $i$f$lazyPreloadScheme = false;
            void var11_12 = bytes$iv;
            boolean bl2 = false;
            InputStream inputStream2 = CharsetToolkit.inputStreamSkippingBOM((InputStream)new ByteArrayInputStream((byte[])var11_12));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"CharsetToolkit.inputStre\u2026gBOM(bytes.inputStream())");
            XMLStreamReader2 reader$iv = StaxFactory.createXmlStreamReader((InputStream)inputStream2);
            XMLStreamReader xMLStreamReader = (XMLStreamReader)reader$iv;
            String name2 = SchemeLoaderKt.access$preload(isOldSchemeNaming$iv, (XMLStreamReader)reader$iv);
            boolean bl3 = false;
            Function attributeProvider2 = new Function((XMLStreamReader)parser){
                final /* synthetic */ XMLStreamReader $parser;

                public final String apply(String it) {
                    return this.$parser.getAttributeValue(null, it);
                }
                {
                    this.$parser = xMLStreamReader;
                }
            };
            String string = name2;
            if (string == null) {
                LazySchemeProcessor lazySchemeProcessor = (LazySchemeProcessor)schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
                String string2 = FileUtilRt.getNameWithoutExtension((String)fileName);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtilRt.getNameWithoutExtension(fileName)");
                string = lazySchemeProcessor.getSchemeKey(attributeProvider2, string2);
            }
            if (string == null) {
                throw (Throwable)SchemeManagerUtilKt.nameIsMissed(bytes);
            }
            String schemeName = string;
            SchemeDataHolderImpl dataHolder = new SchemeDataHolderImpl(schemeManager2.getProcessor$intellij_platform_configurationStore_impl(), bytes, externalInfo2);
            SchemeProcessor schemeProcessor = processor2 = schemeManager2.getProcessor$intellij_platform_configurationStore_impl();
            if (schemeProcessor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeContentChangedHandler<M>");
            }
            ((SchemeContentChangedHandler)((Object)schemeProcessor)).schemeContentChanged(changedScheme, schemeName, dataHolder);
            return true;
        }
        catch (Throwable e$iv) {
            if (e$iv instanceof ControlFlowException) {
                throw e$iv;
            }
            StringBuilder stringBuilder = new StringBuilder().append("Cannot read scheme ");
            Logger logger = ComponentStoreImplKt.getLOG();
            boolean bl = false;
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            String string3 = string;
            logger.error(stringBuilder.append(string3).toString(), e$iv);
            return false;
        }
    }

    public static final /* synthetic */ Scheme access$findExternalizableSchemeByFileName(String fileName, SchemeManagerImpl schemeManager2) {
        return SchemeChangeApplicatorKt.findExternalizableSchemeByFileName(fileName, schemeManager2);
    }

    public static final /* synthetic */ boolean access$callSchemeContentChangedIfSupported(Scheme changedScheme, String fileName, VirtualFile file2, SchemeManagerImpl schemeManager2) {
        return SchemeChangeApplicatorKt.callSchemeContentChangedIfSupported(changedScheme, fileName, file2, schemeManager2);
    }
}

