/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.ElementColumnInfo;
import com.intellij.coverage.view.PercentageCoverageColumnInfo;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ui.ColumnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DirectoryCoverageViewExtension
extends CoverageViewExtension {
    protected final CoverageAnnotator myAnnotator;

    public DirectoryCoverageViewExtension(Project project, CoverageAnnotator annotator, CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean) {
        super(project, suitesBundle, stateBean);
        this.myAnnotator = annotator;
    }

    @Override
    public ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new ElementColumnInfo(), new PercentageCoverageColumnInfo(1, CoverageBundle.message("table.column.name.statistics", new Object[0]), this.mySuitesBundle, this.myStateBean)};
    }

    public String getSummaryForNode(@NotNull AbstractTreeNode node2) {
        String statInfo;
        if (node2 == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(0);
        }
        if ((statInfo = this.myAnnotator.getDirCoverageInformationString((PsiDirectory)node2.getValue(), this.mySuitesBundle, this.myCoverageDataManager)) == null) {
            return CoverageBundle.message("node.summary.no.coverage", node2.toString());
        }
        return CoverageBundle.message("node.summary.coverage.statistic", statInfo, node2.toString());
    }

    public String getSummaryForRootNode(@NotNull AbstractTreeNode childNode) {
        if (childNode == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(1);
        }
        Object value2 = childNode.getValue();
        return this.myAnnotator.getDirCoverageInformationString((PsiDirectory)value2, this.mySuitesBundle, this.myCoverageDataManager);
    }

    public String getPercentage(int columnIdx, @NotNull AbstractTreeNode node2) {
        Object value2;
        if (node2 == null) {
            DirectoryCoverageViewExtension.$$$reportNull$$$0(2);
        }
        if ((value2 = node2.getValue()) instanceof PsiFile) {
            return this.myAnnotator.getFileCoverageInformationString((PsiFile)value2, this.mySuitesBundle, this.myCoverageDataManager);
        }
        return value2 != null ? this.myAnnotator.getDirCoverageInformationString((PsiDirectory)value2, this.mySuitesBundle, this.myCoverageDataManager) : null;
    }

    @Override
    public PsiElement getParentElement(PsiElement element2) {
        PsiFile containingFile = element2.getContainingFile();
        if (containingFile != null) {
            return containingFile.getContainingDirectory();
        }
        return null;
    }

    @NotNull
    public AbstractTreeNode createRootNode() {
        VirtualFile baseDir = this.myProject.getBaseDir();
        return new CoverageListRootNode(this.myProject, (PsiNamedElement)PsiManager.getInstance((Project)this.myProject).findDirectory(baseDir), this.mySuitesBundle, this.myStateBean);
    }

    /*
     * WARNING - void declaration
     */
    public List<AbstractTreeNode<?>> getChildrenNodes(AbstractTreeNode node2) {
        ArrayList children2 = new ArrayList();
        if (node2 instanceof CoverageListNode) {
            void var8_10;
            PsiDirectory[] subdirectories;
            Object val = node2.getValue();
            if (val instanceof PsiFile || val == null) {
                return Collections.emptyList();
            }
            PsiDirectory psiDirectory = (PsiDirectory)val;
            PsiDirectory[] psiDirectoryArray = subdirectories = (PsiDirectory[])ReadAction.compute(() -> psiDirectory.getSubdirectories());
            int n = psiDirectoryArray.length;
            boolean bl = false;
            while (var8_10 < n) {
                PsiDirectory subdirectory = psiDirectoryArray[var8_10];
                children2.add(new CoverageListNode(this.myProject, (PsiNamedElement)subdirectory, this.mySuitesBundle, this.myStateBean));
                ++var8_10;
            }
            PsiFile[] psiFiles = (PsiFile[])ReadAction.compute(() -> psiDirectory.getFiles());
            for (PsiFile psiFile : psiFiles) {
                children2.add(new CoverageListNode(this.myProject, (PsiNamedElement)psiFile, this.mySuitesBundle, this.myStateBean));
            }
            for (AbstractTreeNode abstractTreeNode : children2) {
                abstractTreeNode.setParent(node2);
            }
        }
        return children2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/coverage/view/DirectoryCoverageViewExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSummaryForNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSummaryForRootNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPercentage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

