/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.awt.AWTEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
final class EventWatcherImpl
implements EventWatcher,
Disposable {
    private static final int PUBLISHER_DELAY = 1000;
    private static final Logger LOG = Logger.getInstance(EventWatcherImpl.class);
    private static final Pattern DESCRIPTION_BY_EVENT = Pattern.compile("(([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)\\[(?<description>\\w+(,runnable=(?<runnable>[^,]+))?[^]]*)].*");
    private final ConcurrentMap<String, RunnablesListener.WrapperDescription> myWrappers = new ConcurrentHashMap<String, RunnablesListener.WrapperDescription>();
    private final ConcurrentMap<String, RunnablesListener.InvocationsInfo> myDurationsByFqn = new ConcurrentHashMap<String, RunnablesListener.InvocationsInfo>();
    private final ConcurrentLinkedQueue<RunnablesListener.InvocationDescription> myRunnables = new ConcurrentLinkedQueue();
    private final ConcurrentMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>> myEventsByClass = new ConcurrentHashMap<Class<? extends AWTEvent>, ConcurrentLinkedQueue<RunnablesListener.InvocationDescription>>();
    private final Map<? super Runnable, Long> myCurrentCallablesOrRunnables = new Object2LongOpenHashMap();
    private final Map<? super AWTEvent, Long> myCurrentResults = new Object2LongOpenHashMap();
    @NotNull
    private final LogFileWriter myLogFileWriter = new LogFileWriter();
    @NotNull
    private final RegistryValue myThreshold;
    @NotNull
    private final ScheduledExecutorService myExecutor;
    @Nullable
    private ScheduledFuture<?> myFuture;

    EventWatcherImpl() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isDisposed() || application.isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        application.getMessageBus().connect((Disposable)this).subscribe(RunnablesListener.TOPIC, (Object)this.myLogFileWriter);
        this.myThreshold = ((RegistryManager)application.getService(RegistryManager.class)).get("ide.event.queue.dispatch.threshold");
        this.myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Events Logger", (int)1);
        this.myFuture = this.scheduleDumping();
    }

    /*
     * WARNING - void declaration
     */
    public void logTimeMillis(@NotNull String processId, long startedAt, @NotNull Class<? extends Runnable> clazz) {
        void runnableClass;
        if (processId == null) {
            EventWatcherImpl.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            EventWatcherImpl.$$$reportNull$$$0(1);
        }
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(processId, startedAt, System.currentTimeMillis());
        this.logTimeMillis(description, (Class<?>)runnableClass);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void runnableStarted(@NotNull Runnable runnable2, long l) {
        void startedAt;
        void runnable3;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (runnable3 == null) {
            EventWatcherImpl.$$$reportNull$$$0(2);
        }
        this.myCurrentCallablesOrRunnables.put((Runnable)runnable3, (long)startedAt);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void runnableFinished(@NotNull Runnable runnable2, long l) {
        void finishedAt;
        void runnable3;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (runnable3 == null) {
            EventWatcherImpl.$$$reportNull$$$0(3);
        }
        Class<?> runnableOrCallableClass = this.getCallableOrRunnableClass((Runnable)runnable3);
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(runnableOrCallableClass.getName(), Objects.requireNonNull(this.myCurrentCallablesOrRunnables.remove(runnable3)), (long)finishedAt);
        this.myRunnables.offer(description);
        this.myDurationsByFqn.compute(description.getProcessId(), (fqn, info2) -> RunnablesListener.InvocationsInfo.computeNext(fqn, description.getDuration(), info2));
        this.logTimeMillis(description, runnableOrCallableClass);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void edtEventStarted(@NotNull AWTEvent aWTEvent, long l) {
        void startedAt;
        void event;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (event == null) {
            EventWatcherImpl.$$$reportNull$$$0(4);
        }
        this.myCurrentResults.put((AWTEvent)event, (long)startedAt);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void edtEventFinished(@NotNull AWTEvent aWTEvent, long l) {
        void finishedAt;
        void event;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (event == null) {
            EventWatcherImpl.$$$reportNull$$$0(5);
        }
        RunnablesListener.InvocationDescription description = new RunnablesListener.InvocationDescription(EventWatcherImpl.toDescription(event.toString()), Objects.requireNonNull(this.myCurrentResults.remove(event)), (long)finishedAt);
        Class<?> eventClass = event.getClass();
        this.myEventsByClass.putIfAbsent(eventClass, new ConcurrentLinkedQueue());
        ((ConcurrentLinkedQueue)this.myEventsByClass.get(eventClass)).offer(description);
    }

    public void reset() {
        this.myWrappers.clear();
        this.myDurationsByFqn.clear();
        this.myRunnables.clear();
        this.myEventsByClass.clear();
        this.reschedule(this.scheduleDumping());
    }

    public void dispose() {
        this.myLogFileWriter.dump();
        this.reschedule(null);
        this.myExecutor.shutdownNow();
    }

    private void reschedule(@Nullable ScheduledFuture<?> future2) {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
        }
        this.myFuture = future2;
    }

    @NotNull
    private ScheduledFuture<?> scheduleDumping() {
        ScheduledFuture<?> scheduledFuture = this.myExecutor.scheduleWithFixedDelay(() -> {
            Application application = ApplicationManager.getApplication();
            if (application != null && !application.isDisposed()) {
                this.dumpDescriptions((RunnablesListener)application.getMessageBus().syncPublisher(RunnablesListener.TOPIC));
            } else {
                this.reschedule(null);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            EventWatcherImpl.$$$reportNull$$$0(6);
        }
        return scheduledFuture;
    }

    private void dumpDescriptions(@NotNull RunnablesListener publisher) {
        if (publisher == null) {
            EventWatcherImpl.$$$reportNull$$$0(7);
        }
        this.myEventsByClass.forEach((eventClass, events) -> publisher.eventsProcessed((Class<? extends AWTEvent>)eventClass, (Collection<RunnablesListener.InvocationDescription>)EventWatcherImpl.joinPolling(events)));
        publisher.runnablesProcessed(EventWatcherImpl.joinPolling(this.myRunnables), this.myDurationsByFqn.values(), this.myWrappers.values());
    }

    @NotNull
    private Class<?> getCallableOrRunnableClass(@NotNull Runnable runnable2) {
        Class<?> rootClass;
        Field targetField;
        if (runnable2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(8);
        }
        Object current2 = runnable2;
        while (current2 != null && (targetField = ReflectionUtil.findFieldInHierarchy(rootClass = current2.getClass(), field -> ReflectionUtil.isInstanceField((Field)field) && EventWatcherImpl.isCallableOrRunnable(field))) != null) {
            this.myWrappers.compute(rootClass.getName(), RunnablesListener.WrapperDescription::computeNext);
            current2 = ReflectionUtil.getFieldValue((Field)targetField, (Object)current2);
        }
        Class<?> clazz = (current2 != null ? current2 : runnable2).getClass();
        if (clazz == null) {
            EventWatcherImpl.$$$reportNull$$$0(9);
        }
        return clazz;
    }

    private static boolean isCallableOrRunnable(@NotNull Field field) {
        Class<?> fieldType;
        if (field == null) {
            EventWatcherImpl.$$$reportNull$$$0(10);
        }
        return ReflectionUtil.isAssignable(Runnable.class, fieldType = field.getType()) || ReflectionUtil.isAssignable(Callable.class, fieldType);
    }

    @NotNull
    private static <T> List<T> joinPolling(@NotNull Queue<? extends T> queue2) {
        if (queue2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(11);
        }
        ArrayList<T> builder2 = new ArrayList<T>();
        while (!queue2.isEmpty()) {
            builder2.add(queue2.poll());
        }
        List list2 = Collections.unmodifiableList(builder2);
        if (list2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    private void logTimeMillis(@NotNull RunnablesListener.InvocationDescription description, @NotNull Class<?> runnableClass) {
        int threshold;
        if (description == null) {
            EventWatcherImpl.$$$reportNull$$$0(13);
        }
        if (runnableClass == null) {
            EventWatcherImpl.$$$reportNull$$$0(14);
        }
        if ((threshold = this.myThreshold.asInteger()) < 0 || (long)threshold > description.getDuration()) {
            return;
        }
        LOG.info(description.toString());
        if (runnableClass != Runnable.class) {
            EventWatcherImpl.addPluginCost(runnableClass, description.getDuration());
        }
    }

    private static void addPluginCost(@NotNull Class<?> runnableClass, long duration) {
        ClassLoader loader;
        if (runnableClass == null) {
            EventWatcherImpl.$$$reportNull$$$0(15);
        }
        String pluginId = (loader = runnableClass.getClassLoader()) instanceof PluginAwareClassLoader ? ((PluginAwareClassLoader)loader).getPluginId().getIdString() : "com.intellij";
        StartUpMeasurer.addPluginCost((String)pluginId, (String)"invokeLater", (long)TimeUnit.MILLISECONDS.toNanos(duration));
    }

    @NotNull
    private static String toDescription(@NotNull String string) {
        Matcher matcher;
        if (string == null) {
            EventWatcherImpl.$$$reportNull$$$0(16);
        }
        MatchResult matchResult = (matcher = DESCRIPTION_BY_EVENT.matcher(string)).find() ? matcher.toMatchResult() : null;
        String string2 = matchResult instanceof Matcher ? ((Matcher)matchResult).group("description") : string;
        if (string2 == null) {
            EventWatcherImpl.$$$reportNull$$$0(17);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processId";
                break;
            }
            case 1: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableClass";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/EventWatcherImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publisher";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/EventWatcherImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleDumping";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableOrRunnableClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "joinPolling";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logTimeMillis";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runnableStarted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runnableFinished";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "edtEventStarted";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "edtEventFinished";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dumpDescriptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCallableOrRunnableClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCallableOrRunnable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "joinPolling";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPluginCost";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LogFileWriter
    implements RunnablesListener {
        private final File myLogDir = new File(new File(PathManager.getLogPath(), "edt-log"), new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(System.currentTimeMillis())));
        private final ArrayList<RunnablesListener.InvocationsInfo> myInfos = new ArrayList();
        private final ArrayList<RunnablesListener.WrapperDescription> myWrappers = new ArrayList();

        private LogFileWriter() {
        }

        @Override
        public void eventsProcessed(@NotNull Class<? extends AWTEvent> eventClass, @NotNull Collection<RunnablesListener.InvocationDescription> descriptions) {
            if (eventClass == null) {
                LogFileWriter.$$$reportNull$$$0(0);
            }
            if (descriptions == null) {
                LogFileWriter.$$$reportNull$$$0(1);
            }
            this.appendToFile(eventClass.getSimpleName(), descriptions);
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            if (invocations == null) {
                LogFileWriter.$$$reportNull$$$0(2);
            }
            if (infos == null) {
                LogFileWriter.$$$reportNull$$$0(3);
            }
            if (wrappers == null) {
                LogFileWriter.$$$reportNull$$$0(4);
            }
            this.appendToFile("Runnables", invocations);
            this.myInfos.addAll(infos);
            this.myWrappers.addAll(wrappers);
        }

        private void dump() {
            this.sortAndDumpToFile("Timings", this.myInfos);
            this.sortAndDumpToFile("Wrappers", this.myWrappers);
        }

        private <T> void appendToFile(@NotNull String fileName, @NotNull Collection<? extends T> entities2) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(5);
            }
            if (entities2 == null) {
                LogFileWriter.$$$reportNull$$$0(6);
            }
            this.writeToFile(fileName, entities2, true);
        }

        private <T> void writeToFile(@NotNull String fileName, @NotNull Collection<? extends T> entities2, boolean append) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(7);
            }
            if (entities2 == null) {
                LogFileWriter.$$$reportNull$$$0(8);
            }
            if (!this.myLogDir.isDirectory() && !this.myLogDir.mkdirs()) {
                LOG.debug(this.myLogDir.getAbsolutePath() + " cannot be created");
                return;
            }
            try {
                FileUtil.writeToFile((File)new File(this.myLogDir, fileName + ".log"), (String)StringUtil.join(entities2, Objects::toString, (String)"\n"), (boolean)append);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }

        private <T extends Comparable<? super T>> void sortAndDumpToFile(@NotNull String fileName, @NotNull List<? extends T> entities2) {
            if (fileName == null) {
                LogFileWriter.$$$reportNull$$$0(9);
            }
            if (entities2 == null) {
                LogFileWriter.$$$reportNull$$$0(10);
            }
            Collections.sort(entities2);
            this.writeToFile(fileName, entities2, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocations";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entities";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagnostic/EventWatcherImpl$LogFileWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "eventsProcessed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runnablesProcessed";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendToFile";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeToFile";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sortAndDumpToFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

