/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.ErrorReportConfigurable;
import com.intellij.diagnostic.ITNProxy;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.JetBrainsAccountDialogKt;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.error.UpdateAvailableException;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.util.Date;
import java.util.function.IntConsumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a>\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0002\u001a4\u0010\u0013\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0002\u001a<\u0010\u0017\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0002\u001a2\u0010\u0017\u001a\u00020\u001a2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00120\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"INTERVAL", "", "previousReport", "Lkotlin/Pair;", "", "onError", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorBean", "Lcom/intellij/diagnostic/ITNProxy$ErrorBean;", "parentComponent", "Ljava/awt/Component;", "callback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "onSuccess", "threadId", "eventData", "", "submit", "credentials", "Lcom/intellij/credentialStore/Credentials;", "", "intellij.platform.ide.impl"})
public final class ITNReporterKt {
    private static final long INTERVAL = 600000L;
    private static volatile Pair<Long, Integer> previousReport;

    private static final boolean submit(Project project, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer<? super SubmittedReportInfo> callback2) {
        Credentials credentials2 = ErrorReportConfigurable.Companion.getCredentials();
        if (CredentialAttributesKt.hasOnlyUserName((Credentials)credentials2) && (credentials2 = JetBrainsAccountDialogKt.askJBAccountCredentials$default(parentComponent, project, false, 4, null)) == null) {
            return false;
        }
        ITNReporterKt.submit(project, credentials2, errorBean, parentComponent, callback2);
        return true;
    }

    private static final void submit(Project project, Credentials credentials2, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer<? super SubmittedReportInfo> callback2) {
        Credentials credentials3 = credentials2;
        Credentials credentials4 = credentials2;
        ITNProxy.sendError(project, credentials3 != null ? credentials3.getUserName() : null, credentials4 != null ? credentials4.getPasswordAsString() : null, errorBean, new IntConsumer(project, errorBean, callback2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Consumer $callback;

            public final void accept(int threadId) {
                IdeaLoggingEvent ideaLoggingEvent = this.$errorBean.event;
                Intrinsics.checkNotNullExpressionValue((Object)ideaLoggingEvent, (String)"errorBean.event");
                ITNReporterKt.access$onSuccess(this.$project, threadId, ideaLoggingEvent.getData(), this.$callback);
            }
            {
                this.$project = project;
                this.$errorBean = errorBean;
                this.$callback = consumer2;
            }
        }, new java.util.function.Consumer(project, errorBean, parentComponent, callback2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Consumer $callback;

            public final void accept(Exception e) {
                Exception exception = e;
                Intrinsics.checkNotNullExpressionValue((Object)exception, (String)"e");
                ITNReporterKt.access$onError(this.$project, exception, this.$errorBean, this.$parentComponent, this.$callback);
            }
            {
                this.$project = project;
                this.$errorBean = errorBean;
                this.$parentComponent = component2;
                this.$callback = consumer2;
            }
        });
    }

    private static final void onSuccess(Project project, int threadId, Object eventData, Consumer<? super SubmittedReportInfo> callback2) {
        Pair pair;
        if (eventData instanceof AbstractMessage) {
            Date date = ((AbstractMessage)eventData).getDate();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"eventData.date");
            pair = TuplesKt.to((Object)date.getTime(), (Object)threadId);
        } else {
            pair = null;
        }
        previousReport = pair;
        String linkText = String.valueOf(threadId);
        SubmittedReportInfo reportInfo = new SubmittedReportInfo(ITNProxy.getBrowseUrl(threadId), linkText, SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
        callback2.consume((Object)reportInfo);
        ApplicationManager.getApplication().invokeLater(new Runnable(reportInfo, project){
            final /* synthetic */ SubmittedReportInfo $reportInfo;
            final /* synthetic */ Project $project;

            public final void run() {
                StringBuilder text2 = new StringBuilder();
                IdeErrorsDialog.appendSubmissionInformation(this.$reportInfo, text2);
                text2.append('.').append("<br/>").append(DiagnosticBundle.message("error.report.gratitude", new Object[0]));
                String string = XmlStringUtil.wrapInHtml((CharSequence)text2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"XmlStringUtil.wrapInHtml(text)");
                String content2 = string;
                String string2 = DiagnosticBundle.message("error.report.submitted", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DiagnosticBundle.message(\"error.report.submitted\")");
                String title2 = string2;
                NotificationGroupManager.getInstance().getNotificationGroup("Error Report").createNotification(title2, content2, NotificationType.INFORMATION).setListener(NotificationListener.URL_OPENING_LISTENER).setImportant(false).notify(this.$project);
            }
            {
                this.$reportInfo = submittedReportInfo;
                this.$project = project;
            }
        });
    }

    private static final void onError(Project project, Exception e, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer<? super SubmittedReportInfo> callback2) {
        Logger.getInstance(ITNReporter.class).info("reporting failed: " + e);
        ApplicationManager.getApplication().invokeLater(new Runnable(e, parentComponent, project, callback2, errorBean){
            final /* synthetic */ Exception $e;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Project $project;
            final /* synthetic */ Consumer $callback;
            final /* synthetic */ ITNProxy.ErrorBean $errorBean;

            public final void run() {
                if (this.$e instanceof UpdateAvailableException) {
                    String string = DiagnosticBundle.message("error.report.new.build.message", this.$e.getMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiagnosticBundle.message\u2026uild.message\", e.message)");
                    String message2 = string;
                    String string2 = DiagnosticBundle.message("error.report.new.build.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DiagnosticBundle.message\u2026.report.new.build.title\")");
                    String title2 = string2;
                    Icon icon2 = Messages.getWarningIcon();
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Messages.getWarningIcon()");
                    Icon icon3 = icon2;
                    if (this.$parentComponent.isShowing()) {
                        Messages.showMessageDialog((Component)this.$parentComponent, (String)message2, (String)title2, (Icon)icon3);
                    } else {
                        Messages.showMessageDialog((Project)this.$project, (String)message2, (String)title2, (Icon)icon3);
                    }
                    this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                } else if (this.$e instanceof NoSuchEAPUserException) {
                    Credentials credentials2 = JetBrainsAccountDialogKt.askJBAccountCredentials(this.$parentComponent, this.$project, true);
                    if (credentials2 != null) {
                        ITNReporterKt.access$submit(this.$project, credentials2, this.$errorBean, this.$parentComponent, this.$callback);
                    } else {
                        this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                    }
                } else {
                    String string = DiagnosticBundle.message("error.report.failed.message", this.$e.getMessage());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiagnosticBundle.message\u2026iled.message\", e.message)");
                    String message3 = string;
                    String string3 = DiagnosticBundle.message("error.report.failed.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DiagnosticBundle.message\u2026ror.report.failed.title\")");
                    String title3 = string3;
                    boolean result2 = MessageDialogBuilder.Companion.yesNo(title3, message3).ask(this.$project);
                    if (!result2 || !ITNReporterKt.access$submit(this.$project, this.$errorBean, this.$parentComponent, this.$callback)) {
                        this.$callback.consume((Object)new SubmittedReportInfo(SubmittedReportInfo.SubmissionStatus.FAILED));
                    }
                }
            }
            {
                this.$e = exception;
                this.$parentComponent = component2;
                this.$project = project;
                this.$callback = consumer2;
                this.$errorBean = errorBean;
            }
        });
    }

    public static final /* synthetic */ Pair access$getPreviousReport$p() {
        return previousReport;
    }

    public static final /* synthetic */ void access$setPreviousReport$p(Pair pair) {
        previousReport = pair;
    }

    public static final /* synthetic */ boolean access$submit(Project project, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer callback2) {
        return ITNReporterKt.submit(project, errorBean, parentComponent, (Consumer<? super SubmittedReportInfo>)callback2);
    }

    public static final /* synthetic */ void access$onSuccess(Project project, int threadId, Object eventData, Consumer callback2) {
        ITNReporterKt.onSuccess(project, threadId, eventData, (Consumer<? super SubmittedReportInfo>)callback2);
    }

    public static final /* synthetic */ void access$onError(Project project, Exception e, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer callback2) {
        ITNReporterKt.onError(project, e, errorBean, parentComponent, (Consumer<? super SubmittedReportInfo>)callback2);
    }

    public static final /* synthetic */ void access$submit(Project project, Credentials credentials2, ITNProxy.ErrorBean errorBean, Component parentComponent, Consumer callback2) {
        ITNReporterKt.submit(project, credentials2, errorBean, parentComponent, (Consumer<? super SubmittedReportInfo>)callback2);
    }
}

