/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.application.options.RegistryManager;
import com.intellij.diagnostic.ApdexData;
import com.intellij.diagnostic.IdePerformanceListener;
import com.intellij.diagnostic.IdeaFreezeReporter;
import com.intellij.diagnostic.JBRCrash;
import com.intellij.diagnostic.JitWatcher;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.diagnostic.SamplingTask;
import com.intellij.diagnostic.ThreadDump;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PerformanceWatcherImpl
extends PerformanceWatcher {
    private static final Logger LOG = Logger.getInstance(PerformanceWatcherImpl.class);
    private static final int TOLERABLE_LATENCY = 100;
    private static final String THREAD_DUMPS_PREFIX = "threadDumps-";
    private static final String DURATION_FILE_NAME = ".duration";
    private static final String PID_FILE_NAME = ".pid";
    private final File myLogDir = new File(PathManager.getLogPath());
    private volatile ApdexData mySwingApdex = ApdexData.EMPTY;
    private volatile ApdexData myGeneralApdex = ApdexData.EMPTY;
    private volatile long myLastSampling = System.nanoTime();
    private int myActiveEvents;
    private static final long ourIdeStart = System.currentTimeMillis();
    private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"EDT Performance Checker", (int)1);
    @Nullable
    private ScheduledFuture<?> myThread;
    @Nullable
    private FreezeCheckerTask myCurrentEDTEventChecker;
    private final JitWatcher myJitWatcher = new JitWatcher();
    @NotNull
    private final RegistryValue mySamplingInterval;
    @NotNull
    private final RegistryValue myMaxAttemptsCount;
    @NotNull
    private final RegistryValue myUnresponsiveInterval;
    @NotNull
    private final RegistryValue myMaxDumpDuration;

    private PerformanceWatcherImpl() {
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        RegistryManager registryManager = (RegistryManager)application.getService(RegistryManager.class);
        this.mySamplingInterval = registryManager.get("performance.watcher.sampling.interval.ms");
        this.myMaxAttemptsCount = registryManager.get("performance.watcher.unresponsive.max.attempts.before.log");
        this.myUnresponsiveInterval = registryManager.get("performance.watcher.unresponsive.interval.ms");
        this.myMaxDumpDuration = registryManager.get("performance.watcher.dump.duration.s");
        if (application.isHeadlessEnvironment()) {
            return;
        }
        RegistryValueListener cancelingListener = new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value2) {
                int samplingIntervalMs;
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                int n = samplingIntervalMs = PerformanceWatcherImpl.this.getUnresponsiveInterval() > 0 && PerformanceWatcherImpl.this.getMaxAttemptsCount() > 0 ? PerformanceWatcherImpl.this.getSamplingInterval() : 0;
                if (samplingIntervalMs <= 0) {
                    PerformanceWatcherImpl.this.cancelThread();
                    PerformanceWatcherImpl.this.myThread = null;
                } else if (PerformanceWatcherImpl.this.mySamplingInterval == value2) {
                    PerformanceWatcherImpl.this.cancelThread();
                    PerformanceWatcherImpl.this.myThread = PerformanceWatcherImpl.this.myExecutor.scheduleWithFixedDelay(() -> PerformanceWatcherImpl.this.samplePerformance(samplingIntervalMs), samplingIntervalMs, samplingIntervalMs, TimeUnit.MILLISECONDS);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diagnostic/PerformanceWatcherImpl$1", "afterValueChanged"));
            }
        };
        for (RegistryValue value2 : List.of(this.mySamplingInterval, this.myMaxAttemptsCount, this.myUnresponsiveInterval)) {
            value2.addListener(cancelingListener, (Disposable)this);
        }
        RegistryValue ourReasonableThreadPoolSize = registryManager.get("reasonable.application.thread.pool.size");
        AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
        service.setNewThreadListener((thread, runnable2) -> {
            if (service.getBackendPoolExecutorSize() > ourReasonableThreadPoolSize.asInteger() && ApplicationInfoImpl.getShadowInstance().isEAP()) {
                String message2;
                File file2 = this.doDumpThreads("newPooledThread/", true, message2 = "Too many pooled threads created (" + service.getBackendPoolExecutorSize() + " > " + ourReasonableThreadPoolSize + ")");
                LOG.info(message2 + (String)(file2 == null ? "" : "; thread dump is saved to '" + file2.getPath() + "'"));
            }
        });
        PerformanceWatcherImpl.reportCrashesIfAny();
        PerformanceWatcherImpl.cleanOldFiles(this.myLogDir, 0);
        cancelingListener.afterValueChanged(this.mySamplingInterval);
        ourInstance = this;
    }

    private static void reportCrashesIfAny() {
        Path systemDir = Path.of(PathManager.getSystemPath(), new String[0]);
        try {
            Path appInfoFile = systemDir.resolve(".appinfo");
            Path pidFile = systemDir.resolve(PID_FILE_NAME);
            if (SystemInfo.isJetBrainsJvm && Files.isRegularFile(appInfoFile, new LinkOption[0]) && Files.isRegularFile(pidFile, new LinkOption[0])) {
                String pid2 = Files.readString(pidFile);
                File[] crashFiles = new File(SystemProperties.getUserHome()).listFiles(file2 -> file2.getName().startsWith("java_error_in") && file2.getName().endsWith(pid2 + ".log") && file2.isFile());
                if (crashFiles != null) {
                    long appInfoFileLastModified = Files.getLastModifiedTime(appInfoFile, new LinkOption[0]).toMillis();
                    for (File file3 : crashFiles) {
                        if (file3.lastModified() <= appInfoFileLastModified) continue;
                        if (file3.length() > 0x500000L) {
                            LOG.info("Crash file " + file3 + " is too big to report");
                            break;
                        }
                        String content2 = FileUtil.loadFile((File)file3);
                        if (content2.contains("fuck_the_regulations")) break;
                        Attachment attachment = new Attachment("crash.txt", content2);
                        attachment.setIncluded(true);
                        String plugins2 = ((StreamEx)((StreamEx)StreamEx.of(PluginManagerCore.getLoadedPlugins()).filter(d -> d.isEnabled() && !d.isBundled())).map(PluginInfoDetectorKt::getPluginInfoByDescriptor).filter(PluginInfo::isSafeToReport)).map(i2 -> i2.getId() + " (" + i2.getVersion() + ")").joining((CharSequence)"\n", (CharSequence)"Extra plugins:\n", (CharSequence)"");
                        Attachment pluginsAttachment = new Attachment("plugins.txt", plugins2);
                        attachment.setIncluded(true);
                        Object[] attachments = new Attachment[]{attachment, pluginsAttachment};
                        File extraLog = PerformanceWatcherImpl.findExtraLogFile(pid2, appInfoFileLastModified);
                        if (extraLog != null) {
                            Attachment extraAttachment = new Attachment("jbr_err.txt", FileUtil.loadFile((File)extraLog));
                            extraAttachment.setIncluded(true);
                            attachments = (Attachment[])ArrayUtil.append((Object[])attachments, (Object)extraAttachment);
                        }
                        String message2 = StringUtil.substringBefore((String)content2, (String)"---------------  P R O C E S S  ---------------");
                        IdeaLoggingEvent event = LogMessage.createEvent(new JBRCrash(), message2, (Attachment[])attachments);
                        IdeaFreezeReporter.setAppInfo(event, Files.readString(appInfoFile));
                        IdeaFreezeReporter.report(event);
                        LifecycleUsageTriggerCollector.onCrashDetected();
                        break;
                    }
                }
            }
            IdeaFreezeReporter.saveAppInfo(appInfoFile, true);
            Files.createDirectories(pidFile.getParent(), new FileAttribute[0]);
            Files.writeString(pidFile, (CharSequence)OSProcessUtil.getApplicationPid(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Nullable
    private static File findExtraLogFile(String pid2, long lastModified) {
        if (!SystemInfo.isMac) {
            return null;
        }
        String logFileName = "jbr_err_pid" + pid2 + ".log";
        List<File> candidates = List.of(new File(SystemProperties.getUserHome(), logFileName), new File(logFileName));
        return (File)ContainerUtil.find(candidates, file2 -> file2.isFile() && file2.lastModified() > lastModified);
    }

    @Nullable
    private static IdePerformanceListener getPublisher() {
        Application application = ApplicationManager.getApplication();
        return application != null && !application.isDisposed() ? (IdePerformanceListener)application.getMessageBus().syncPublisher(IdePerformanceListener.TOPIC) : null;
    }

    @Override
    public void processUnfinishedFreeze(@NotNull BiConsumer<? super File, ? super Integer> consumer2) {
        File[] files2;
        if (consumer2 == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(0);
        }
        if ((files2 = this.myLogDir.listFiles()) != null) {
            Arrays.stream(files2).filter(file2 -> file2.getName().startsWith(THREAD_DUMPS_PREFIX)).filter(file2 -> Files.exists(file2.toPath().resolve(DURATION_FILE_NAME), new LinkOption[0])).findFirst().ifPresent(f -> {
                File marker = new File((File)f, DURATION_FILE_NAME);
                try {
                    String s = FileUtil.loadFile((File)marker);
                    PerformanceWatcherImpl.cleanup(f);
                    consumer2.accept((File)f, (Integer)Integer.parseInt(s));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    private static void cleanOldFiles(File dir, int level) {
        Object[] children2 = dir.listFiles((dir1, name2) -> level > 0 || name2.startsWith(THREAD_DUMPS_PREFIX));
        if (children2 == null) {
            return;
        }
        Arrays.sort(children2);
        for (int i2 = 0; i2 < children2.length; ++i2) {
            Object child2 = children2[i2];
            if (i2 < children2.length - 100 || PerformanceWatcherImpl.ageInDays((File)child2) > 10L) {
                FileUtil.delete((File)child2);
                continue;
            }
            if (level >= 3) continue;
            PerformanceWatcherImpl.cleanOldFiles((File)child2, level + 1);
        }
    }

    private static long ageInDays(File file2) {
        return TimeUnit.DAYS.convert(System.currentTimeMillis() - file2.lastModified(), TimeUnit.MILLISECONDS);
    }

    private void cancelThread() {
        if (this.myThread != null) {
            this.myThread.cancel(true);
        }
    }

    public void dispose() {
        this.cancelThread();
        this.myExecutor.shutdownNow();
    }

    private void samplePerformance(long samplingIntervalMs) {
        long current2 = System.nanoTime();
        this.myLastSampling = current2;
        for (long diffMs = TimeUnit.NANOSECONDS.toMillis(current2 - this.myLastSampling) - samplingIntervalMs; diffMs >= 0L; diffMs -= samplingIntervalMs) {
            this.myGeneralApdex = this.myGeneralApdex.withEvent(100L, diffMs);
        }
        this.myJitWatcher.checkJitState();
        SwingUtilities.invokeLater(() -> {
            long latencyMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - current2);
            this.mySwingApdex = this.mySwingApdex.withEvent(100L, latencyMs);
            IdePerformanceListener publisher = PerformanceWatcherImpl.getPublisher();
            if (publisher != null) {
                publisher.uiResponded(latencyMs);
            }
        });
    }

    private int getSamplingInterval() {
        return this.mySamplingInterval.asInteger();
    }

    private int getMaxAttemptsCount() {
        return this.myMaxAttemptsCount.asInteger();
    }

    @Override
    public int getDumpInterval() {
        return this.getSamplingInterval() * this.getMaxAttemptsCount();
    }

    @Override
    public int getUnresponsiveInterval() {
        return this.myUnresponsiveInterval.asInteger();
    }

    @Override
    public int getMaxDumpDuration() {
        return this.myMaxDumpDuration.asInteger() * 1000;
    }

    private static String buildName() {
        return ApplicationInfo.getInstance().getBuild().asString();
    }

    private static String formatTime(long timeMs) {
        return new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(timeMs));
    }

    private static void cleanup(File dir) {
        FileUtil.delete((File)new File(dir, DURATION_FILE_NAME));
    }

    @Override
    @ApiStatus.Internal
    public void edtEventStarted() {
        long start2 = System.nanoTime();
        ++this.myActiveEvents;
        if (this.myThread != null) {
            if (this.myCurrentEDTEventChecker != null) {
                this.myCurrentEDTEventChecker.stop();
            }
            this.myCurrentEDTEventChecker = new FreezeCheckerTask(start2);
        }
    }

    @Override
    @ApiStatus.Internal
    public void edtEventFinished() {
        --this.myActiveEvents;
        if (this.myThread != null) {
            Objects.requireNonNull(this.myCurrentEDTEventChecker).stop();
            this.myCurrentEDTEventChecker = this.myActiveEvents > 0 ? new FreezeCheckerTask(System.nanoTime()) : null;
        }
    }

    @Override
    @Nullable
    public File dumpThreads(@NotNull String pathPrefix, boolean appendMillisecondsToFileName) {
        if (pathPrefix == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(1);
        }
        return this.doDumpThreads(pathPrefix, appendMillisecondsToFileName, "");
    }

    @Nullable
    private File doDumpThreads(@NotNull String pathPrefix, boolean appendMillisecondsToFileName, @NotNull String contentsPrefix) {
        if (pathPrefix == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(2);
        }
        if (contentsPrefix == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(3);
        }
        return this.myThread == null ? null : this.dumpThreads(pathPrefix, appendMillisecondsToFileName, contentsPrefix + ThreadDumper.getThreadDumpInfo((ThreadInfo[])ThreadDumper.getThreadInfos()).getRawDump());
    }

    @Nullable
    private File dumpThreads(@NotNull String pathPrefix, boolean appendMillisecondsToFileName, @NotNull String rawDump) {
        if (pathPrefix == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(4);
        }
        if (rawDump == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(5);
        }
        if (!((String)pathPrefix).contains("/")) {
            pathPrefix = THREAD_DUMPS_PREFIX + (String)pathPrefix + "-" + PerformanceWatcherImpl.formatTime(ourIdeStart) + "-" + PerformanceWatcherImpl.buildName() + "/";
        } else if (!((String)pathPrefix).startsWith(THREAD_DUMPS_PREFIX)) {
            pathPrefix = THREAD_DUMPS_PREFIX + (String)pathPrefix;
        }
        long now = System.currentTimeMillis();
        Object suffix = appendMillisecondsToFileName ? "-" + now : "";
        File file2 = new File(this.myLogDir, (String)pathPrefix + "threadDump-" + PerformanceWatcherImpl.formatTime(now) + (String)suffix + ".txt");
        File dir = file2.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        String memoryUsage = this.getMemoryUsage();
        if (!memoryUsage.isEmpty()) {
            LOG.info(memoryUsage + " while dumping threads to " + file2);
        }
        try {
            FileUtil.writeToFile((File)file2, (String)rawDump);
        }
        catch (IOException e) {
            LOG.info("Failed to write the thread dump file: " + e.getMessage());
        }
        return file2;
    }

    @NotNull
    private String getMemoryUsage() {
        String jitProblem;
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long usedMemory = rt.totalMemory() - rt.freeMemory();
        long freeMemory = maxMemory - usedMemory;
        Object diagnosticInfo = "";
        if (freeMemory < maxMemory / 5L) {
            diagnosticInfo = "High memory usage (free " + freeMemory / 1024L / 1024L + " of " + maxMemory / 1024L / 1024L + " MB)";
        }
        if ((jitProblem = this.getJitProblem()) != null) {
            if (!((String)diagnosticInfo).isEmpty()) {
                diagnosticInfo = (String)diagnosticInfo + ", ";
            }
            diagnosticInfo = (String)diagnosticInfo + jitProblem;
        }
        String string = diagnosticInfo;
        if (string == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getJitProblem() {
        return this.myJitWatcher.getJitProblem();
    }

    @NotNull
    static List<StackTraceElement> getStacktraceCommonPart(@NotNull List<StackTraceElement> commonPart, StackTraceElement @NotNull [] stackTraceElements) {
        if (commonPart == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(7);
        }
        if (stackTraceElements == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(8);
        }
        for (int i2 = 0; i2 < commonPart.size() && i2 < stackTraceElements.length; ++i2) {
            StackTraceElement el2;
            StackTraceElement el1 = commonPart.get(commonPart.size() - i2 - 1);
            if (PerformanceWatcherImpl.compareStackTraceElements(el1, el2 = stackTraceElements[stackTraceElements.length - i2 - 1])) continue;
            List<StackTraceElement> list2 = commonPart.subList(commonPart.size() - i2, commonPart.size());
            if (list2 == null) {
                PerformanceWatcherImpl.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List<StackTraceElement> list3 = commonPart;
        if (list3 == null) {
            PerformanceWatcherImpl.$$$reportNull$$$0(10);
        }
        return list3;
    }

    static boolean compareStackTraceElements(StackTraceElement el1, StackTraceElement el2) {
        if (el1 == el2) {
            return true;
        }
        return el1.getClassName().equals(el2.getClassName()) && Objects.equals(el1.getMethodName(), el2.getMethodName()) && Objects.equals(el1.getFileName(), el2.getFileName());
    }

    @Override
    public void clearFreezeStacktraces() {
        if (this.myCurrentEDTEventChecker != null) {
            this.myCurrentEDTEventChecker.stopDumping();
        }
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return this.myExecutor;
    }

    @Override
    protected PerformanceWatcher.Snapshot newSnapshot() {
        return new SnapshotImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentsPrefix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDump";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcherImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonPart";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcherImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemoryUsage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStacktraceCommonPart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUnfinishedFreeze";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreads";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doDumpThreads";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStacktraceCommonPart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class FreezeCheckerTask {
        private final AtomicReference<CheckerState> myState = new AtomicReference<CheckerState>(CheckerState.CHECKING);
        @NotNull
        private final Future<?> myFuture;
        private final long myTaskStart;
        private String myFreezeFolder;
        private volatile SamplingTask myDumpTask;

        FreezeCheckerTask(long taskStart) {
            this.myFuture = PerformanceWatcherImpl.this.myExecutor.schedule(this::edtFrozen, (long)PerformanceWatcherImpl.this.getUnresponsiveInterval(), TimeUnit.MILLISECONDS);
            this.myTaskStart = taskStart;
        }

        /*
         * WARNING - void declaration
         */
        private long getDuration(long current2, @NotNull TimeUnit timeUnit) {
            void unit;
            if (timeUnit == null) {
                FreezeCheckerTask.$$$reportNull$$$0(0);
            }
            return unit.convert(current2 - this.myTaskStart, TimeUnit.NANOSECONDS);
        }

        void stop() {
            this.myFuture.cancel(false);
            if (this.myState.getAndSet(CheckerState.FINISHED) == CheckerState.FREEZE) {
                long taskStop = System.nanoTime();
                this.stopDumping();
                try {
                    PerformanceWatcherImpl.this.myExecutor.submit(() -> {
                        this.stopDumping();
                        long durationMs = this.getDuration(taskStop, TimeUnit.MILLISECONDS);
                        IdePerformanceListener publisher = PerformanceWatcherImpl.getPublisher();
                        if (publisher != null) {
                            publisher.uiFreezeFinished(durationMs, new File(PerformanceWatcherImpl.this.myLogDir, this.myFreezeFolder));
                        }
                        File reportDir = this.postProcessReportFolder(durationMs);
                        if (publisher != null) {
                            publisher.uiFreezeRecorded(durationMs, reportDir);
                        }
                    }).get();
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }

        private void edtFrozen() {
            this.myFreezeFolder = "threadDumps-freeze-" + PerformanceWatcherImpl.formatTime(System.currentTimeMillis()) + "-" + PerformanceWatcherImpl.buildName();
            if (this.myState.compareAndSet(CheckerState.CHECKING, CheckerState.FREEZE)) {
                File reportDir = new File(PerformanceWatcherImpl.this.myLogDir, this.myFreezeFolder);
                reportDir.mkdirs();
                final IdePerformanceListener publisher = PerformanceWatcherImpl.getPublisher();
                if (publisher == null) {
                    return;
                }
                publisher.uiFreezeStarted(reportDir);
                this.myDumpTask = new SamplingTask(PerformanceWatcherImpl.this.getDumpInterval(), PerformanceWatcherImpl.this.getMaxDumpDuration()){

                    @Override
                    protected void dumpedThreads(@NotNull ThreadDump threadDump) {
                        if (threadDump == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (FreezeCheckerTask.this.myState.get() == CheckerState.FINISHED) {
                            this.stop();
                        } else {
                            File file2 = PerformanceWatcherImpl.this.dumpThreads(FreezeCheckerTask.this.myFreezeFolder + "/", false, threadDump.getRawDump());
                            if (file2 != null) {
                                try {
                                    long duration = FreezeCheckerTask.this.getDuration(System.nanoTime(), TimeUnit.SECONDS);
                                    FileUtil.writeToFile((File)new File(file2.getParentFile(), PerformanceWatcherImpl.DURATION_FILE_NAME), (String)Long.toString(duration));
                                    publisher.dumpedThreads(file2, threadDump);
                                }
                                catch (IOException e) {
                                    LOG.info("Failed to write the duration file: " + e.getMessage());
                                }
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadDump", "com/intellij/diagnostic/PerformanceWatcherImpl$FreezeCheckerTask$1", "dumpedThreads"));
                    }
                };
            }
        }

        @Nullable
        private File postProcessReportFolder(long durationMs) {
            File dir = new File(PerformanceWatcherImpl.this.myLogDir, this.myFreezeFolder);
            File reportDir = null;
            if (dir.exists()) {
                PerformanceWatcherImpl.cleanup(dir);
                reportDir = new File(PerformanceWatcherImpl.this.myLogDir, dir.getName() + this.getFreezePlaceSuffix() + "-" + TimeUnit.MILLISECONDS.toSeconds(durationMs) + "sec");
                if (!dir.renameTo(reportDir)) {
                    LOG.warn("Unable to create freeze folder " + reportDir);
                    reportDir = dir;
                }
                String message2 = "UI was frozen for " + durationMs + "ms, details saved to " + reportDir;
                if (PluginManagerCore.isRunningFromSources()) {
                    LOG.info(message2);
                } else {
                    LOG.warn(message2);
                }
            }
            return reportDir;
        }

        void stopDumping() {
            SamplingTask task2 = this.myDumpTask;
            if (task2 != null) {
                task2.stop();
                this.myDumpTask = null;
            }
        }

        private String getFreezePlaceSuffix() {
            List<StackTraceElement> stacktraceCommonPart = null;
            SamplingTask task2 = this.myDumpTask;
            if (task2 == null) {
                return "";
            }
            for (Object[] objectArray : task2.getThreadInfos()) {
                Object[] edtStack;
                ThreadInfo edt = (ThreadInfo)ContainerUtil.find((Object[])objectArray, ThreadDumper::isEDT);
                if (edt == null || (edtStack = edt.getStackTrace()) == null) continue;
                if (stacktraceCommonPart == null) {
                    stacktraceCommonPart = ContainerUtil.newArrayList((Object[])edtStack);
                    continue;
                }
                stacktraceCommonPart = PerformanceWatcherImpl.getStacktraceCommonPart(stacktraceCommonPart, (StackTraceElement[])edtStack);
            }
            if (!ContainerUtil.isEmpty(stacktraceCommonPart)) {
                StackTraceElement element2 = (StackTraceElement)stacktraceCommonPart.get(0);
                return "-" + FileUtil.sanitizeFileName((String)StringUtil.getShortName((String)element2.getClassName())) + "." + FileUtil.sanitizeFileName((String)element2.getMethodName());
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/diagnostic/PerformanceWatcherImpl$FreezeCheckerTask", "getDuration"));
        }
    }

    private static enum CheckerState {
        CHECKING,
        FREEZE,
        FINISHED;

    }

    public final class SnapshotImpl
    implements PerformanceWatcher.Snapshot {
        private final ApdexData myStartGeneralSnapshot;
        private final ApdexData myStartSwingSnapshot;
        private final long myStartMillis;

        private SnapshotImpl() {
            this.myStartGeneralSnapshot = PerformanceWatcherImpl.this.myGeneralApdex;
            this.myStartSwingSnapshot = PerformanceWatcherImpl.this.mySwingApdex;
            this.myStartMillis = System.currentTimeMillis();
        }

        @Override
        public void logResponsivenessSinceCreation(@NonNls @NotNull String activityName) {
            if (activityName == null) {
                SnapshotImpl.$$$reportNull$$$0(0);
            }
            LOG.info(this.getLogResponsivenessSinceCreationMessage(activityName));
        }

        @Override
        @NotNull
        public String getLogResponsivenessSinceCreationMessage(@NonNls @NotNull String activityName) {
            if (activityName == null) {
                SnapshotImpl.$$$reportNull$$$0(1);
            }
            String string = activityName + " took " + (System.currentTimeMillis() - this.myStartMillis) + "ms; general responsiveness: " + PerformanceWatcherImpl.this.myGeneralApdex.summarizePerformanceSince(this.myStartGeneralSnapshot) + "; EDT responsiveness: " + PerformanceWatcherImpl.this.mySwingApdex.summarizePerformanceSince(this.myStartSwingSnapshot);
            if (string == null) {
                SnapshotImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcherImpl$SnapshotImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcherImpl$SnapshotImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogResponsivenessSinceCreationMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "logResponsivenessSinceCreation";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLogResponsivenessSinceCreationMessage";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

