/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.diagnostic.PluginStartupCostDialog;
import com.intellij.diagnostic.PluginStartupCostEntry;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0013\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/diagnostic/PluginStartupCostDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "pluginsToDisable", "", "", "getPluginsToDisable", "()Ljava/util/Set;", "table", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/diagnostic/PluginStartupCostEntry;", "getTable", "()Lcom/intellij/ui/table/TableView;", "setTable", "(Lcom/intellij/ui/table/TableView;)V", "tableModel", "Lcom/intellij/util/ui/ListTableModel;", "getTableModel", "()Lcom/intellij/util/ui/ListTableModel;", "setTableModel", "(Lcom/intellij/util/ui/ListTableModel;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createLeftSideActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doOKAction", "", "intellij.platform.ide.impl"})
final class PluginStartupCostDialog
extends DialogWrapper {
    @NotNull
    private final Set<String> pluginsToDisable;
    public ListTableModel<PluginStartupCostEntry> tableModel;
    public TableView<PluginStartupCostEntry> table;
    private final Project project;

    @NotNull
    public final Set<String> getPluginsToDisable() {
        return this.pluginsToDisable;
    }

    @NotNull
    public final ListTableModel<PluginStartupCostEntry> getTableModel() {
        ListTableModel<PluginStartupCostEntry> listTableModel = this.tableModel;
        if (listTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tableModel");
        }
        return listTableModel;
    }

    public final void setTableModel(@NotNull ListTableModel<PluginStartupCostEntry> listTableModel) {
        Intrinsics.checkNotNullParameter(listTableModel, (String)"<set-?>");
        this.tableModel = listTableModel;
    }

    @NotNull
    public final TableView<PluginStartupCostEntry> getTable() {
        TableView<PluginStartupCostEntry> tableView = this.table;
        if (tableView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return tableView;
    }

    public final void setTable(@NotNull TableView<PluginStartupCostEntry> tableView) {
        Intrinsics.checkNotNullParameter(tableView, (String)"<set-?>");
        this.table = tableView;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$apply;
        ColumnInfo[] columnInfoArray;
        void $this$mapNotNullTo$iv$iv22;
        Map<String, Object2LongMap<String>> pluginCostMap;
        Map<String, Object2LongMap<String>> $this$mapNotNull$iv = pluginCostMap = StartUpPerformanceService.Companion.getInstance().getPluginCostMap();
        boolean $i$f$mapNotNull = false;
        Map<String, Object2LongMap<String>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        TableView tableView = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = tableView.entrySet().iterator();
        while (iterator2.hasNext()) {
            PluginStartupCostEntry pluginStartupCostEntry;
            void pluginId;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry $dstr$pluginId$costMap = element$iv$iv;
            boolean bl3 = false;
            Map.Entry entry2 = $dstr$pluginId$costMap;
            boolean bl4 = false;
            String string = (String)entry2.getKey();
            entry2 = $dstr$pluginId$costMap;
            bl4 = false;
            Object2LongMap costMap = (Object2LongMap)entry2.getValue();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isInternal() && ApplicationInfoEx.getInstanceEx().isEssentialPlugin((String)pluginId)) {
                pluginStartupCostEntry = null;
            } else {
                Object object = PluginManagerCore.getPlugin(PluginId.getId((String)pluginId));
                if (object == null || (object = object.getName()) == null) {
                    pluginStartupCostEntry = null;
                } else {
                    LongIterator iterator3;
                    Object name2 = object;
                    long totalCost = 0L;
                    Intrinsics.checkNotNullExpressionValue((Object)((LongCollection)costMap.values()).iterator(), (String)"costMap.values.iterator()");
                    while (iterator3.hasNext()) {
                        totalCost += iterator3.nextLong();
                    }
                    ObjectSet objectSet = (ObjectSet)costMap.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"costMap.keys");
                    List ids = CollectionsKt.toMutableList((Collection)((Collection)objectSet));
                    CollectionsKt.sort((List)ids);
                    StringBuilder costDetails = new StringBuilder();
                    for (String id2 : ids) {
                        costDetails.append(id2).append(": ").append(TimeUnit.NANOSECONDS.toMillis(costMap.getLong((Object)id2)));
                        costDetails.append('\n');
                    }
                    String string2 = costDetails.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"costDetails.toString()");
                    pluginStartupCostEntry = new PluginStartupCostEntry((String)pluginId, (String)name2, totalCost, string2);
                }
            }
            if (pluginStartupCostEntry == null) continue;
            PluginStartupCostEntry pluginStartupCostEntry2 = pluginStartupCostEntry;
            boolean bl5 = false;
            boolean bl6 = false;
            PluginStartupCostEntry it$iv$iv = pluginStartupCostEntry2;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        boolean $this$mapNotNullTo$iv$iv22 = false;
        List tableData = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PluginStartupCostEntry it = (PluginStartupCostEntry)b;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getCost());
                it = (PluginStartupCostEntry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getCost();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        });
        ColumnInfo<PluginStartupCostEntry, String> pluginColumn2 = new ColumnInfo<PluginStartupCostEntry, String>(this, IdeBundle.message((String)"column.name.plugin", (Object[])new Object[0])){
            final /* synthetic */ PluginStartupCostDialog this$0;

            @NotNull
            public String valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getPluginName() + (this.this$0.getPluginsToDisable().contains(item.getPluginId()) ? " (will be disabled)" : "");
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        ColumnInfo<PluginStartupCostEntry, Integer> costColumn2 = new ColumnInfo<PluginStartupCostEntry, Integer>(IdeBundle.message((String)"column.name.startup.time.ms", (Object[])new Object[0])){

            @NotNull
            public Integer valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (int)TimeUnit.NANOSECONDS.toMillis(item.getCost());
            }
        };
        ColumnInfo<PluginStartupCostEntry, String> costDetailsColumn2 = new ColumnInfo<PluginStartupCostEntry, String>(IdeBundle.message((String)"column.name.cost.details", (Object[])new Object[0])){

            @NotNull
            public String valueOf(@NotNull PluginStartupCostEntry item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getCostDetails();
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isInternal()) {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[3];
            columnInfoArray2[0] = (ColumnInfo)pluginColumn2;
            columnInfoArray2[1] = (ColumnInfo)costColumn2;
            columnInfoArray = columnInfoArray2;
            columnInfoArray2[2] = (ColumnInfo)costDetailsColumn2;
        } else {
            ColumnInfo[] columnInfoArray3 = new ColumnInfo[2];
            columnInfoArray3[0] = (ColumnInfo)pluginColumn2;
            columnInfoArray = columnInfoArray3;
            columnInfoArray3[1] = (ColumnInfo)costColumn2;
        }
        ColumnInfo[] columns = columnInfoArray;
        this.tableModel = new ListTableModel(columns, tableData);
        ListTableModel<PluginStartupCostEntry> listTableModel = this.tableModel;
        if (listTableModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tableModel");
        }
        TableView tableView2 = new TableView(listTableModel);
        boolean bl8 = false;
        boolean bl9 = false;
        tableView = tableView2;
        PluginStartupCostDialog pluginStartupCostDialog = this;
        boolean bl10 = false;
        $this$apply.setShowColumns(true);
        Unit unit = Unit.INSTANCE;
        pluginStartupCostDialog.table = tableView2;
        TableView<PluginStartupCostEntry> tableView3 = this.table;
        if (tableView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"table");
        }
        return (JComponent)new JBScrollPane((Component)tableView3);
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        AbstractAction disableAction2 = new AbstractAction(this, IdeBundle.message((String)"button.disable.selected.plugins", (Object[])new Object[0])){
            final /* synthetic */ PluginStartupCostDialog this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                for (PluginStartupCostEntry costEntry : this.this$0.getTable().getSelectedObjects()) {
                    this.this$0.getPluginsToDisable().add(costEntry.getPluginId());
                }
                this.this$0.getTableModel().fireTableDataChanged();
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
        return new Action[]{disableAction2};
    }

    protected void doOKAction() {
        super.doOKAction();
        IdeErrorsDialog.confirmDisablePlugins(this.project, SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.pluginsToDisable), (Function1)doOKAction.1.INSTANCE), (Function1)doOKAction.2.INSTANCE)));
    }

    public PluginStartupCostDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        boolean bl = false;
        this.pluginsToDisable = new LinkedHashSet();
        this.setTitle(IdeBundle.message((String)"analyze.plugin.title", (Object[])new Object[0]));
        this.init();
    }
}

