/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.util.lang.ClassPath;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0003H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0004H\u0014J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 J \u0010!\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0014R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriter;", "Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "pluginCostMap", "", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "(Ljava/util/Map;Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;)V", "publicStatMetrics", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "getPublicStatMetrics", "()Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "beforeActivityWrite", "", "item", "ownOrTotalDuration", "", "fieldName", "getClassAndResourceLoadingStats", "writeAppInfo", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeExtraData", "writeProjectName", "projectName", "writeToLog", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "writeTotalDuration", "end", "timeOffset", "intellij.platform.diagnostic"})
public final class IdeIdeaFormatWriter
extends IdeaFormatWriter {
    @NotNull
    private final Object2IntOpenHashMap<String> publicStatMetrics;
    private final Map<String, Object2LongOpenHashMap<String>> pluginCostMap;

    @NotNull
    public final Object2IntOpenHashMap<String> getPublicStatMetrics() {
        return this.publicStatMetrics;
    }

    public final void writeToLog(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.getStringWriter().write("\n=== Stop: StartUp Measurement ===");
        log.info(this.getStringWriter().toString());
    }

    @Override
    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        boolean bl;
        block4: {
            ApplicationInfo appInfo;
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            ApplicationInfo applicationInfo = appInfo = ApplicationInfo.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"appInfo");
            writer.writeStringField("build", applicationInfo.getBuild().asStringWithoutProductCode());
            writer.writeStringField("buildDate", ZonedDateTime.ofInstant(appInfo.getBuildDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME));
            BuildNumber buildNumber = appInfo.getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"appInfo.build");
            writer.writeStringField("productCode", buildNumber.getProductCode());
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
            List<String> list2 = runtimeMXBean.getInputArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"ManagementFactory.getRun\u2026meMXBean().inputArguments");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)"-Xshare:auto") || Intrinsics.areEqual((Object)it, (Object)"-Xshare:on"))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            writer.writeBooleanField("cds", true);
        }
    }

    @Override
    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        String string = System.getProperty("idea.performanceReport.projectName");
        if (string == null) {
            string = IdeIdeaFormatWriterKt.access$safeHashValue(projectName);
        }
        writer.writeStringField("project", string);
    }

    @Override
    protected void writeExtraData(@NotNull JsonGenerator writer) {
        JsonGenerator $this$obj$iv;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Map<String, Long> stats = this.getClassAndResourceLoadingStats();
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "classLoading";
        boolean $i$f$obj = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl4 = false;
        long time = ((Number)MapsKt.getValue(stats, (Object)"classLoadingTime")).longValue();
        writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(time));
        long defineTime = ((Number)MapsKt.getValue(stats, (Object)"classDefineTime")).longValue();
        writer.writeNumberField("searchTime", TimeUnit.NANOSECONDS.toMillis(time - defineTime));
        writer.writeNumberField("defineTime", TimeUnit.NANOSECONDS.toMillis(defineTime));
        writer.writeNumberField("count", ((Number)MapsKt.getValue(stats, (Object)"classRequests")).longValue());
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "resourceLoading";
        $i$f$obj = false;
        string = fieldName$iv;
        bl = false;
        bl2 = false;
        it$iv = string;
        bl3 = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl5 = false;
        writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(((Number)MapsKt.getValue(stats, (Object)"resourceLoadingTime")).longValue()));
        writer.writeNumberField("count", ((Number)MapsKt.getValue(stats, (Object)"resourceRequests")).longValue());
        $this$obj$iv.writeEndObject();
        IdeIdeaFormatWriterKt.access$writeServiceStats(writer);
        IdeIdeaFormatWriterKt.access$writeIcons(writer);
    }

    private final Map<String, Long> getClassAndResourceLoadingStats() {
        ClassLoader classLoader = IdeIdeaFormatWriter.class.getClassLoader();
        Map map2 = MethodHandles.lookup().findVirtual(classLoader.getClass(), "getLoadingStats", MethodType.methodType(Map.class)).bindTo(classLoader).invokeExact();
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Long>");
        }
        Map stats = TypeIntrinsics.asMutableMap((Object)map2);
        Map map3 = ClassPath.getLoadingStats();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"ClassPath.getLoadingStats()");
        Map coreStats = map3;
        if (Intrinsics.areEqual((Object)((Long)coreStats.get("identity")), (Object)((Long)stats.get("identity"))) ^ true) {
            for (Map.Entry entry2 : coreStats.entrySet()) {
                long v1;
                Object k = entry2.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"entry.key");
                Long l = (Long)entry2.getValue();
                if (l != null && (v1 = ((Number)MapsKt.getValue((Map)stats, k)).longValue()) == l) continue;
                Object k2 = entry2.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"entry.key");
                Object v = entry2.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
                stats.put(k2, v1 + ((Number)v).longValue());
            }
        }
        return stats;
    }

    @Override
    protected long writeTotalDuration(@NotNull JsonGenerator writer, long end, long timeOffset) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        long totalDurationActual = super.writeTotalDuration(writer, end, timeOffset);
        this.publicStatMetrics.put((Object)"totalDuration", (int)totalDurationActual);
        return totalDurationActual;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        String string2 = item.getPluginId();
        if (string2 != null) {
            string = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            Object object = item.getCategory();
            if (object == null || (object = object.name()) == null) {
                object = "unknown";
            }
            StartUpMeasurer.doAddPluginCost((String)it, (String)object, (long)ownOrTotalDuration, this.pluginCostMap);
        }
        if (Intrinsics.areEqual((Object)fieldName, (Object)"items")) {
            String string3 = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.name");
            switch (string = string3) {
                case "splash initialization": {
                    ((Map)this.publicStatMetrics).put("splash", (int)TimeUnit.NANOSECONDS.toMillis(ownOrTotalDuration));
                    ((Map)this.publicStatMetrics).put("splashShown", (int)TimeUnit.NANOSECONDS.toMillis(item.getEnd() - StartUpMeasurer.getStartTime()));
                    break;
                }
                case "app initialization": 
                case "bootstrap": {
                    void itemName;
                    ((Map)this.publicStatMetrics).put(itemName, (int)TimeUnit.NANOSECONDS.toMillis(ownOrTotalDuration));
                    break;
                }
                case "project frame initialization": {
                    ((Map)this.publicStatMetrics).put("projectFrameVisible", (int)TimeUnit.NANOSECONDS.toMillis(item.getStart() - StartUpMeasurer.getStartTime()));
                    break;
                }
            }
        }
    }

    public IdeIdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities2, @NotNull Map<String, Object2LongOpenHashMap<String>> pluginCostMap, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkNotNullParameter(activities2, (String)"activities");
        Intrinsics.checkNotNullParameter(pluginCostMap, (String)"pluginCostMap");
        Intrinsics.checkNotNullParameter((Object)threadNameManager, (String)"threadNameManager");
        super(activities2, threadNameManager, "35");
        this.pluginCostMap = pluginCostMap;
        this.publicStatMetrics = new Object2IntOpenHashMap();
        this.publicStatMetrics.defaultReturnValue(-1);
    }
}

