/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginSet;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.ui.icons.IconLoadMeasurer;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"safeHashValue", "", "value", "writeIcons", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeServiceStats", "intellij.platform.diagnostic"})
public final class IdeIdeaFormatWriterKt {
    /*
     * WARNING - void declaration
     */
    private static final void writeIcons(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "icons";
        boolean $i$f$array = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl4 = false;
        for (IconLoadMeasurer.Counter stat : IconLoadMeasurer.getStats()) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv2 = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl5 = false;
            writer.writeStringField("name", stat.name);
            IconLoadMeasurer.Counter counter = stat;
            Intrinsics.checkNotNullExpressionValue((Object)counter, (String)"stat");
            writer.writeNumberField("count", counter.getCount());
            writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(stat.getTotalDuration()));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    private static final String safeHashValue(String value2) {
        Argon2BytesGenerator generator2 = new Argon2BytesGenerator();
        generator2.init(new Argon2Parameters.Builder(2).build());
        byte[] result2 = new byte[20];
        String string = value2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        generator2.generateBytes(byArray, result2, 0, result2.length);
        String string3 = Base64.getEncoder().withoutPadding().encodeToString(result2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().with\u2026().encodeToString(result)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final void writeServiceStats(JsonGenerator writer) {
        void $this$array$iv;
        JsonGenerator $this$obj$iv;
        Object plugin22;
        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"com/intellij/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriterKt$writeServiceStats$StatItem", "", "name", "", "(Ljava/lang/String;)V", "app", "", "getApp", "()I", "setApp", "(I)V", "module", "getModule", "setModule", "getName", "()Ljava/lang/String;", "project", "getProject", "setProject", "intellij.platform.diagnostic"})
        public final class StatItem {
            private int app;
            private int project;
            private int module;
            @NotNull
            private final String name;

            public final int getApp() {
                return this.app;
            }

            public final void setApp(int n) {
                this.app = n;
            }

            public final int getProject() {
                return this.project;
            }

            public final void setProject(int n) {
                this.project = n;
            }

            public final int getModule() {
                return this.module;
            }

            public final void setModule(int n) {
                this.module = n;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }

            public StatItem(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
            }
        }
        StatItem component2 = new StatItem("component");
        StatItem service = new StatItem("service");
        PluginSet pluginSet = PluginManagerCore.getPluginSet();
        Intrinsics.checkNotNullExpressionValue((Object)pluginSet, (String)"PluginManagerCore.getPluginSet()");
        PluginSet pluginSet2 = pluginSet;
        for (Object plugin22 : pluginSet2.getEnabledModules()) {
            StatItem statItem = service;
            statItem.setApp(statItem.getApp() + plugin22.appContainerDescriptor.getServices().size());
            StatItem statItem2 = service;
            statItem2.setProject(statItem2.getProject() + plugin22.projectContainerDescriptor.getServices().size());
            StatItem statItem3 = service;
            statItem3.setModule(statItem3.getModule() + plugin22.moduleContainerDescriptor.getServices().size());
            StatItem statItem4 = component2;
            List<ComponentConfig> list2 = plugin22.appContainerDescriptor.components;
            statItem4.setApp(statItem4.getApp() + (list2 != null ? list2.size() : 0));
            StatItem statItem5 = component2;
            List<ComponentConfig> list3 = plugin22.projectContainerDescriptor.components;
            statItem5.setProject(statItem5.getProject() + (list3 != null ? list3.size() : 0));
            StatItem statItem6 = component2;
            List<ComponentConfig> list4 = plugin22.moduleContainerDescriptor.components;
            statItem6.setModule(statItem6.getModule() + (list4 != null ? list4.size() : 0));
        }
        plugin22 = writer;
        String fieldName$iv = "stats";
        boolean $i$f$obj = false;
        String string = fieldName$iv;
        boolean bl = false;
        boolean bl2 = false;
        String it$iv = string;
        boolean bl3 = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl4 = false;
        writer.writeNumberField("plugin", pluginSet2.enabledPlugins.size());
        for (StatItem statItem : CollectionsKt.listOf((Object[])new StatItem[]{component2, service})) {
            void $this$obj$iv2;
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = statItem.getName();
            boolean $i$f$obj2 = false;
            if (fieldName$iv2 != null) {
                String string2;
                boolean bl5 = false;
                boolean bl6 = false;
                String it$iv2 = string2;
                $i$a$-let-JacksonUtil$obj$1$iv = false;
                $this$obj$iv2.writeFieldName(it$iv2);
            }
            $this$obj$iv2.writeStartObject();
            boolean bl7 = false;
            writer.writeNumberField("app", statItem.getApp());
            writer.writeNumberField("project", statItem.getProject());
            writer.writeNumberField("module", statItem.getModule());
            $this$obj$iv2.writeEndObject();
        }
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "plugins";
        boolean $i$f$array = false;
        string = fieldName$iv;
        bl = false;
        bl2 = false;
        it$iv = string;
        boolean bl8 = false;
        $this$array$iv.writeFieldName(it$iv);
        $this$array$iv.writeStartArray();
        boolean bl9 = false;
        for (IdeaPluginDescriptorImpl plugin3 : pluginSet2.enabledPlugins) {
            PluginAwareClassLoader classLoader;
            ClassLoader classLoader2 = plugin3.getPluginClassLoader();
            if (!(classLoader2 instanceof PluginAwareClassLoader)) {
                classLoader2 = null;
            }
            if ((PluginAwareClassLoader)classLoader2 == null) {
                continue;
            }
            JsonGenerator $this$obj$iv3 = writer;
            String fieldName$iv3 = null;
            boolean $i$f$obj3 = false;
            $this$obj$iv3.writeStartObject();
            boolean bl10 = false;
            writer.writeStringField("id", plugin3.getPluginId().getIdString());
            writer.writeNumberField("classCount", classLoader.getLoadedClassCount());
            writer.writeNumberField("classLoadingEdtTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getEdtTime()));
            writer.writeNumberField("classLoadingBackgroundTime", TimeUnit.NANOSECONDS.toMillis(classLoader.getBackgroundTime()));
            $this$obj$iv3.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    public static final /* synthetic */ String access$safeHashValue(String value2) {
        return IdeIdeaFormatWriterKt.safeHashValue(value2);
    }

    public static final /* synthetic */ void access$writeServiceStats(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeServiceStats(writer);
    }

    public static final /* synthetic */ void access$writeIcons(JsonGenerator writer) {
        IdeIdeaFormatWriterKt.writeIcons(writer);
    }
}

