/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.ExposingCharArrayWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.MyJsonPrettyPrinter;
import com.intellij.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.openapi.util.SystemInfo;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u00002\u00020\u0001B/\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0014J\u0006\u0010\u0016\u001a\u00020\u0017JF\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00142\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0004JL\u0010\u001f\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u001c2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0014J(\u0010*\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010-\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010.\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0004H\u0014J2\u0010/\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010 \u001a\u00020\u0014H\u0002J \u00100\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0014R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "version", "(Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;Ljava/lang/String;)V", "logPrefix", "stringWriter", "Lcom/intellij/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "getStringWriter", "()Lcom/intellij/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "beforeActivityWrite", "", "item", "ownOrTotalDuration", "", "fieldName", "toByteBuffer", "Ljava/nio/ByteBuffer;", "write", "timeOffset", "serviceActivities", "instantEvents", "", "end", "projectName", "writeActivities", "startTime", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "ownDurations", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "measureThreshold", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "writeAppInfo", "writeExtraData", "writeItemTimeInfo", "duration", "offset", "writeParallelActivities", "writeProjectName", "writeServiceEvents", "writeTotalDuration", "intellij.platform.diagnostic"})
public abstract class IdeaFormatWriter {
    private final String logPrefix;
    @NotNull
    private final ExposingCharArrayWriter stringWriter;
    private final Map<String, List<ActivityImpl>> activities;
    private final ThreadNameManager threadNameManager;
    private final String version;

    @NotNull
    protected final ExposingCharArrayWriter getStringWriter() {
        return this.stringWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(long timeOffset, @NotNull Map<String, ? extends List<ActivityImpl>> serviceActivities, @NotNull List<ActivityImpl> instantEvents, long end, @NotNull String projectName) {
        JsonGenerator writer;
        Intrinsics.checkNotNullParameter(serviceActivities, (String)"serviceActivities");
        Intrinsics.checkNotNullParameter(instantEvents, (String)"instantEvents");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        this.stringWriter.write(this.logPrefix);
        JsonGenerator jsonGenerator = writer = new JsonFactory().createGenerator((Writer)this.stringWriter);
        Intrinsics.checkNotNullExpressionValue((Object)jsonGenerator, (String)"writer");
        jsonGenerator.setPrettyPrinter((PrettyPrinter)new MyJsonPrettyPrinter());
        Closeable closeable = (Closeable)writer;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void $this$array$iv;
            JsonGenerator it = (JsonGenerator)closeable;
            boolean bl3 = false;
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl4 = false;
            writer.writeStringField("version", this.version);
            this.writeAppInfo(writer);
            writer.writeStringField("generated", ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStringField("os", SystemInfo.getOsNameAndVersion());
            writer.writeStringField("runtime", SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_VERSION + " " + SystemInfo.JAVA_RUNTIME_VERSION);
            this.writeProjectName(writer, projectName);
            this.writeExtraData(writer);
            this.writeParallelActivities(timeOffset, writer);
            JsonGenerator jsonGenerator2 = writer;
            String fieldName$iv2 = "traceEvents";
            boolean $i$f$array = false;
            String string = fieldName$iv2;
            boolean bl5 = false;
            boolean bl6 = false;
            String it$iv = string;
            boolean bl7 = false;
            $this$array$iv.writeFieldName(it$iv);
            $this$array$iv.writeStartArray();
            boolean bl8 = false;
            IdeaFormatWriterKt.access$writeInstantEvents(writer, instantEvents, timeOffset, this.threadNameManager);
            $this$array$iv.writeEndArray();
            this.writeServiceEvents(writer, serviceActivities, timeOffset);
            this.writeTotalDuration(writer, end, timeOffset);
            $this$obj$iv.writeEndObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    protected long writeTotalDuration(@NotNull JsonGenerator writer, long end, long timeOffset) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        long totalDurationActual = TimeUnit.NANOSECONDS.toMillis(end - timeOffset);
        writer.writeNumberField("totalDuration", totalDurationActual);
        return totalDurationActual;
    }

    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        writer.writeStringField("project", projectName);
    }

    protected void writeExtraData(@NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
    }

    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
    }

    private final void writeServiceEvents(JsonGenerator writer, Map<String, ? extends List<ActivityImpl>> serviceActivities, long startTime) {
        Object object = writeServiceEvents.comparator.1.INSTANCE;
        if (object != null) {
            Function2 function2 = object;
            object = new Comparator(function2){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function2;
                }

                public final /* synthetic */ int compare(Object p0, Object p1) {
                    Object object = this.function.invoke(p0, p1);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"invoke(...)");
                    return ((Number)object).intValue();
                }
            };
        }
        Comparator comparator2 = (Comparator)object;
        for (String name2 : CollectionsKt.sorted((Iterable)serviceActivities.keySet())) {
            List list2 = CollectionsKt.sortedWith((Iterable)((Iterable)MapsKt.getValue(serviceActivities, (Object)name2)), (Comparator)comparator2);
            Object2LongMap<ActivityImpl> ownDurations = ServiceReporterKt.computeOwnTime(list2, this.threadNameManager);
            this.writeActivities(list2, startTime, writer, name2, ownDurations, 0L, TimeUnit.MICROSECONDS);
        }
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        return this.stringWriter.toByteBuffer(this.logPrefix.length());
    }

    /*
     * WARNING - void declaration
     */
    private final void writeParallelActivities(long startTime, JsonGenerator writer) {
        Object object = this.activities;
        boolean bl = false;
        Iterator<Map.Entry<String, List<ActivityImpl>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            void name2;
            Map.Entry<String, List<ActivityImpl>> entry2;
            Map.Entry<String, List<ActivityImpl>> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            object = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            List<ActivityImpl> list2 = entry3.getValue();
            StartUpPerformanceReporter.Companion.sortItems$intellij_platform_diagnostic(list2);
            long measureThreshold = Intrinsics.areEqual((Object)name2, (Object)ActivityCategory.DEFAULT.getJsonName()) || Intrinsics.areEqual((Object)name2, (Object)ActivityCategory.REOPENING_EDITOR.getJsonName()) ? -1L : StartUpMeasurer.MEASURE_THRESHOLD;
            Object2LongOpenHashMap ownDurations = new Object2LongOpenHashMap();
            ownDurations.defaultReturnValue(-1L);
            this.writeActivities(list2, startTime, writer, IdeaFormatWriterKt.access$activityNameToJsonFieldName((String)name2), (Object2LongMap<ActivityImpl>)((Object2LongMap)ownDurations), measureThreshold, TimeUnit.MILLISECONDS);
        }
    }

    private final void writeActivities(List<ActivityImpl> activities2, long startTime, JsonGenerator writer, String fieldName, Object2LongMap<ActivityImpl> ownDurations, long measureThreshold, TimeUnit timeUnit) {
        if (activities2.isEmpty()) {
            return;
        }
        JsonGenerator $this$array$iv = writer;
        boolean $i$f$array = false;
        String string = fieldName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it$iv = string2;
            boolean bl3 = false;
            $this$array$iv.writeFieldName(it$iv);
        }
        $this$array$iv.writeStartArray();
        boolean bl = false;
        long skippedDuration = 0L;
        for (ActivityImpl item : activities2) {
            long ownDuration = ownDurations.getLong((Object)item);
            long ownOrTotalDuration = ownDuration == -1L ? item.getEnd() - item.getStart() : ownDuration;
            this.beforeActivityWrite(item, ownOrTotalDuration, fieldName);
            if (ownOrTotalDuration <= measureThreshold) {
                skippedDuration += ownOrTotalDuration;
                continue;
            }
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl4 = false;
            String string3 = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"item.name");
            writer.writeStringField("n", IdeaFormatWriterKt.access$compactName(string3));
            writer.writeNumberField("s", timeUnit.convert(item.getStart() - startTime, TimeUnit.NANOSECONDS));
            writer.writeNumberField("d", timeUnit.convert(item.getEnd() - item.getStart(), TimeUnit.NANOSECONDS));
            if (ownDuration != -1L) {
                writer.writeNumberField("od", timeUnit.convert(ownDuration, TimeUnit.NANOSECONDS));
            }
            writer.writeStringField("t", this.threadNameManager.getThreadName(item));
            if (item.getPluginId() != null) {
                writer.writeStringField("p", item.getPluginId());
            }
            $this$obj$iv.writeEndObject();
        }
        if (skippedDuration > 0L) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl5 = false;
            writer.writeStringField("n", "Other");
            writer.writeNumberField("d", timeUnit.convert(skippedDuration, TimeUnit.NANOSECONDS));
            writer.writeNumberField("s", timeUnit.convert(((ActivityImpl)CollectionsKt.last(activities2)).getStart() - startTime, TimeUnit.NANOSECONDS));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
    }

    protected void writeItemTimeInfo(@NotNull ActivityImpl item, long duration, long offset, @NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(duration));
        writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(item.getStart() - offset));
        writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(item.getEnd() - offset));
        writer.writeStringField("thread", this.threadNameManager.getThreadName(item));
        if (item.getPluginId() != null) {
            writer.writeStringField("p", item.getPluginId());
        }
    }

    public IdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities2, @NotNull ThreadNameManager threadNameManager, @NotNull String version2) {
        Intrinsics.checkNotNullParameter(activities2, (String)"activities");
        Intrinsics.checkNotNullParameter((Object)threadNameManager, (String)"threadNameManager");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        this.activities = activities2;
        this.threadNameManager = threadNameManager;
        this.version = version2;
        this.logPrefix = "=== Start: StartUp Measurement ===\n";
        this.stringWriter = new ExposingCharArrayWriter();
    }
}

