/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.lang.ClassPath;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"compareTime", "", "o1", "Lcom/intellij/diagnostic/ActivityImpl;", "o2", "computePluginCostMap", "", "", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "generateJarAccessLog", "", "outFile", "Ljava/nio/file/Path;", "intellij.platform.diagnostic"})
public final class StartUpPerformanceReporterKt {
    private static final Map<String, Object2LongOpenHashMap<String>> computePluginCostMap() {
        HashMap result2 = new HashMap(StartUpMeasurer.pluginCostMap);
        StartUpMeasurer.pluginCostMap.clear();
        Iterator<? extends IdeaPluginDescriptor> iterator2 = PluginManagerCore.getLoadedPlugins().iterator();
        while (iterator2.hasNext()) {
            PluginAwareClassLoader classLoader;
            String id2;
            IdeaPluginDescriptor plugin2;
            IdeaPluginDescriptor ideaPluginDescriptor = plugin2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)ideaPluginDescriptor, (String)"plugin");
            PluginId pluginId = ideaPluginDescriptor.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"plugin.pluginId");
            Intrinsics.checkNotNullExpressionValue((Object)pluginId.getIdString(), (String)"plugin.pluginId.idString");
            ClassLoader classLoader2 = ((IdeaPluginDescriptorImpl)plugin2).getPluginClassLoader();
            if (!(classLoader2 instanceof PluginAwareClassLoader)) {
                classLoader2 = null;
            }
            if ((PluginAwareClassLoader)classLoader2 == null) {
                continue;
            }
            Object2LongOpenHashMap costPerPhaseMap2 = (Object2LongOpenHashMap)result2.computeIfAbsent(id2, computePluginCostMap.costPerPhaseMap.1.INSTANCE);
            costPerPhaseMap2.put((Object)"classloading (EDT)", classLoader.getEdtTime());
            costPerPhaseMap2.put((Object)"classloading (background)", classLoader.getBackgroundTime());
        }
        return result2;
    }

    public static final int compareTime(@NotNull ActivityImpl o1, @NotNull ActivityImpl o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return o1.getStart() > o2.getStart() ? 1 : (o1.getStart() < o2.getStart() ? -1 : (o1.getEnd() > o2.getEnd() ? -1 : (o1.getEnd() < o2.getEnd() ? 1 : 0)));
    }

    private static final void generateJarAccessLog(Path outFile) {
        ClassLoader classLoader = StartUpPerformanceReporter.class.getClassLoader();
        Collection collection = MethodHandles.lookup().findStatic(classLoader.getClass(), "getLoadedClasses", MethodType.methodType(Collection.class)).invokeExact();
        if (collection == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Collection<kotlin.collections.Map.Entry<kotlin.String, java.nio.file.Path>>");
        }
        Collection itemsFromBootstrap = collection;
        Collection collection2 = ClassPath.getLoadedClasses();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ClassPath.getLoadedClasses()");
        Collection itemsFromCore = collection2;
        LinkedHashSet items = new LinkedHashSet(itemsFromBootstrap.size() + itemsFromCore.size());
        items.addAll(itemsFromBootstrap);
        items.addAll(itemsFromCore);
        Path homeDir = Path.of(PathManager.getHomePath(), new String[0]);
        StringBuilder builder2 = new StringBuilder();
        for (Map.Entry item : items) {
            Path source = (Path)item.getValue();
            if (!source.startsWith(homeDir)) continue;
            builder2.append((String)item.getKey()).append(':').append(homeDir.relativize(source));
            builder2.append('\n');
        }
        Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
        Files.writeString(outFile, (CharSequence)builder2, new OpenOption[0]);
    }

    public static final /* synthetic */ Map access$computePluginCostMap() {
        return StartUpPerformanceReporterKt.computePluginCostMap();
    }

    public static final /* synthetic */ void access$generateJarAccessLog(Path outFile) {
        StartUpPerformanceReporterKt.generateJarAccessLog(outFile);
    }
}

