/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInEditorWithMouseAction
extends AnAction
implements DumbAware {
    @NotNull
    private List<? extends Editor> myEditors = Collections.emptyList();

    public OpenInEditorWithMouseAction() {
        AnAction navigateAction = ActionManager.getInstance().getAction("GotoDeclaration");
        this.setShortcutSet((ShortcutSet)(navigateAction != null ? navigateAction.getShortcutSet() : new CustomShortcutSet(new Shortcut[]{new MouseShortcut(1, 128, 1)})));
    }

    public void install(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(0);
        }
        this.myEditors = editors2;
        for (Editor editor2 : editors2) {
            this.registerCustomShortcutSet(this.getShortcutSet(), (EditorGutterComponentEx)editor2.getGutter());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        InputEvent inputEvent;
        if (e == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(1);
        }
        if (!((inputEvent = e.getInputEvent()) instanceof MouseEvent)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getData(OpenInEditorAction.KEY) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Component component2 = inputEvent.getComponent();
        if (component2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Point point = ((MouseEvent)inputEvent).getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component2, point.x, point.y);
        if (!(componentAt instanceof EditorGutterComponentEx)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor2 = this.getEditor(componentAt);
        if (editor2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), (MouseEvent)inputEvent, componentAt);
        EditorMouseEventArea area = editor2.getMouseEventArea(convertedEvent);
        if (area != EditorMouseEventArea.LINE_NUMBERS_AREA) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(2);
        }
        MouseEvent inputEvent = (MouseEvent)e.getInputEvent();
        OpenInEditorAction openInEditorAction = (OpenInEditorAction)((Object)e.getRequiredData(OpenInEditorAction.KEY));
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Component component2 = inputEvent.getComponent();
        Point point = inputEvent.getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component2, point.x, point.y);
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), inputEvent, componentAt);
        Editor editor2 = this.getEditor(componentAt);
        assert (editor2 != null);
        int line = editor2.xyToLogicalPosition((Point)convertedEvent.getPoint()).line;
        Navigatable navigatable2 = this.getNavigatable(editor2, line);
        if (navigatable2 == null) {
            return;
        }
        openInEditorAction.openEditor(project, navigatable2);
    }

    @Nullable
    private Editor getEditor(@NotNull Component component2) {
        if (component2 == null) {
            OpenInEditorWithMouseAction.$$$reportNull$$$0(3);
        }
        for (Editor editor2 : this.myEditors) {
            if (editor2 == null || editor2.getGutter() != component2) continue;
            return editor2;
        }
        return null;
    }

    @Nullable
    protected abstract Navigatable getNavigatable(@NotNull Editor var1, int var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

