/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightingLevel;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.breadcrumbs.BreadcrumbsPlacement;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.AbstractToggleUseSoftWrapsAction;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetEditorSettingsAction
extends ActionGroup
implements DumbAware {
    @NotNull
    private final TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private final List<? extends Editor> myEditors;
    @Nullable
    private SyncScrollSupport.Support mySyncScrollSupport;
    private final AnAction @NotNull [] myActions;

    public SetEditorSettingsAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull List<? extends Editor> editors2) {
        if (settings == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(0);
        }
        if (editors2 == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(1);
        }
        super(DiffBundle.message((String)"editor.settings", (Object[])new Object[0]), null, AllIcons.General.GearPlain);
        this.setPopup(true);
        this.myTextSettings = settings;
        this.myEditors = editors2;
        for (Editor editor2 : this.myEditors) {
            ((EditorGutterComponentEx)editor2.getGutter()).setGutterPopupGroup(this);
        }
        this.myActions = new AnAction[]{new EditorSettingToggleAction("EditorToggleShowWhitespaces"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowWhitespaces();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowWhitespaces(state);
            }

            @Override
            public void apply(@NotNull Editor editor2, boolean value2) {
                if (editor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor2.getSettings().isWhitespacesShown() != value2) {
                    editor2.getSettings().setWhitespacesShown(value2);
                    editor2.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$1", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowLineNumbers"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowLineNumbers();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowLineNumbers(state);
            }

            @Override
            public void apply(@NotNull Editor editor2, boolean value2) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (editor2.getSettings().isLineNumbersShown() != value2) {
                    editor2.getSettings().setLineNumbersShown(value2);
                    editor2.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$2", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleShowIndentLines"){

            @Override
            public boolean isSelected() {
                return SetEditorSettingsAction.this.myTextSettings.isShowIndentLines();
            }

            @Override
            public void setSelected(boolean state) {
                SetEditorSettingsAction.this.myTextSettings.setShowIndentLines(state);
            }

            @Override
            public void apply(@NotNull Editor editor2, boolean value2) {
                if (editor2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (editor2.getSettings().isIndentGuidesShown() != value2) {
                    editor2.getSettings().setIndentGuidesShown(value2);
                    editor2.getComponent().repaint();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/actions/impl/SetEditorSettingsAction$3", "apply"));
            }
        }, new EditorSettingToggleAction("EditorToggleUseSoftWraps"){
            private boolean myForcedSoftWrap;

            @Override
            public boolean isSelected() {
                return this.myForcedSoftWrap || SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps();
            }

            @Override
            public void setSelected(boolean state) {
                this.myForcedSoftWrap = false;
                SetEditorSettingsAction.this.myTextSettings.setUseSoftWraps(state);
            }

            @Override
            public void apply(@NotNull Editor editor2, boolean value2) {
                if (editor2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (editor2.getSettings().isUseSoftWraps() == value2) {
                    return;
                }
                if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                    SetEditorSettingsAction.this.mySyncScrollSupport.enterDisableScrollSection();
                }
                try {
                    AbstractToggleUseSoftWrapsAction.toggleSoftWraps(editor2, null, value2);
                }
                finally {
                    if (SetEditorSettingsAction.this.mySyncScrollSupport != null) {
                        SetEditorSettingsAction.this.mySyncScrollSupport.exitDisableScrollSection();
                    }
                }
            }

            @Override
            public void applyDefaults(@NotNull List<? extends Editor> editors2) {
                if (editors2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!SetEditorSettingsAction.this.myTextSettings.isUseSoftWraps()) {
                    for (Editor editor2 : editors2) {
                        this.myForcedSoftWrap = this.myForcedSoftWrap || ((EditorImpl)editor2).getSoftWrapModel().shouldSoftWrapsBeForced();
                    }
                }
                super.applyDefaults(editors2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editors";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyDefaults";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new EditorHighlightingLayerGroup(), new EditorBreadcrumbsPlacementGroup()};
    }

    public void setSyncScrollSupport(@Nullable SyncScrollSupport.Support syncScrollSupport) {
        this.mySyncScrollSupport = syncScrollSupport;
    }

    public void applyDefaults() {
        for (AnAction action2 : this.myActions) {
            ((EditorSettingAction)action2).applyDefaults(this.myEditors);
        }
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction editorSettingsGroup = ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu.EditorSettings");
        ArrayList<Object> actions2 = new ArrayList<Object>();
        ContainerUtil.addAll(actions2, (Object[])this.myActions);
        actions2.add(editorSettingsGroup);
        actions2.add(Separator.getInstance());
        if (e != null && "DiffToolbar".equals(e.getPlace())) {
            AnAction[] anActionArray = actions2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                SetEditorSettingsAction.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }
        ActionGroup gutterGroup = (ActionGroup)ActionManager.getInstance().getAction("Diff.EditorGutterPopupMenu");
        ArrayList result2 = ContainerUtil.newArrayList((Object[])gutterGroup.getChildren(e));
        result2.add(Separator.getInstance());
        SetEditorSettingsAction.replaceOrAppend(result2, editorSettingsGroup, new DefaultActionGroup(actions2));
        AnAction[] anActionArray = result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            SetEditorSettingsAction.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    private static <T> void replaceOrAppend(List<T> list2, T from2, T to) {
        int index2 = list2.indexOf(from2);
        if (index2 == -1) {
            index2 = list2.size();
        }
        list2.remove(from2);
        list2.add(index2, to);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface EditorSettingAction {
        public void applyDefaults(@NotNull List<? extends Editor> var1);
    }

    private class EditorBreadcrumbsPlacementGroup
    extends ActionGroup
    implements EditorSettingAction,
    DumbAware {
        private final AnAction[] myOptions;

        EditorBreadcrumbsPlacementGroup() {
            ActionUtil.copyFrom((AnAction)this, (String)"EditorBreadcrumbsSettings");
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])BreadcrumbsPlacement.values(), option2 -> new OptionAction((BreadcrumbsPlacement)((Object)option2)), (Object[])AnAction.EMPTY_ARRAY);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                EditorBreadcrumbsPlacementGroup.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors2) {
            if (editors2 == null) {
                EditorBreadcrumbsPlacementGroup.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorBreadcrumbsPlacementGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorBreadcrumbsPlacementGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final BreadcrumbsPlacement myOption;

            OptionAction(BreadcrumbsPlacement option2) {
                if (option2 == null) {
                    OptionAction.$$$reportNull$$$0(0);
                }
                ActionUtil.copyFrom((AnAction)this, (String)option2.getActionId());
                this.myOption = option2;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(1);
                }
                return SetEditorSettingsAction.this.myTextSettings.getBreadcrumbsPlacement() == this.myOption;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(2);
                }
                SetEditorSettingsAction.this.myTextSettings.setBreadcrumbsPlacement(this.myOption);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorBreadcrumbsPlacementGroup$OptionAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class EditorHighlightingLayerGroup
    extends ActionGroup
    implements EditorSettingAction,
    DumbAware {
        private final AnAction[] myOptions;

        EditorHighlightingLayerGroup() {
            super(DiffBundle.message((String)"highlighting.level", (Object[])new Object[0]), true);
            this.myOptions = (AnAction[])ContainerUtil.map((Object[])HighlightingLevel.values(), level -> new OptionAction((HighlightingLevel)((Object)level)), (Object[])AnAction.EMPTY_ARRAY);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.myOptions == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors2) {
            if (editors2 == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(1);
            }
            this.apply(SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel());
        }

        private void apply(@NotNull HighlightingLevel layer) {
            if (layer == null) {
                EditorHighlightingLayerGroup.$$$reportNull$$$0(2);
            }
            for (Editor editor2 : SetEditorSettingsAction.this.myEditors) {
                ((EditorImpl)editor2).setHighlightingPredicate(layer.getCondition());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyDefaults";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class OptionAction
        extends ToggleAction
        implements DumbAware {
            @NotNull
            private final HighlightingLevel myLayer;

            OptionAction(HighlightingLevel layer) {
                if (layer == null) {
                    OptionAction.$$$reportNull$$$0(0);
                }
                super(layer.getText(), null, layer.getIcon());
                this.myLayer = layer;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(1);
                }
                return SetEditorSettingsAction.this.myTextSettings.getHighlightingLevel() == this.myLayer;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    OptionAction.$$$reportNull$$$0(2);
                }
                SetEditorSettingsAction.this.myTextSettings.setHighlightingLevel(this.myLayer);
                EditorHighlightingLayerGroup.this.apply(this.myLayer);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "layer";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorHighlightingLayerGroup$OptionAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private abstract class EditorSettingToggleAction
    extends ToggleAction
    implements DumbAware,
    EditorSettingAction {
        private EditorSettingToggleAction(String actionId) {
            if (actionId == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(0);
            }
            ActionUtil.copyFrom((AnAction)this, (String)actionId);
            this.getTemplatePresentation().setIcon(null);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(1);
            }
            return this.isSelected();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(2);
            }
            this.setSelected(state);
            for (Editor editor2 : SetEditorSettingsAction.this.myEditors) {
                this.apply(editor2, state);
            }
        }

        public abstract boolean isSelected();

        public abstract void setSelected(boolean var1);

        public abstract void apply(@NotNull Editor var1, boolean var2);

        @Override
        public void applyDefaults(@NotNull List<? extends Editor> editors2) {
            if (editors2 == null) {
                EditorSettingToggleAction.$$$reportNull$$$0(3);
            }
            for (Editor editor2 : editors2) {
                this.apply(editor2, this.isSelected());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/actions/impl/SetEditorSettingsAction$EditorSettingToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyDefaults";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

