/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffContextEx;
import com.intellij.diff.DiffExtension;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.actions.impl.NextChangeAction;
import com.intellij.diff.actions.impl.NextDifferenceAction;
import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.diff.actions.impl.PrevChangeAction;
import com.intellij.diff.actions.impl.PrevDifferenceAction;
import com.intellij.diff.impl.DiffRequestProcessorListener;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.impl.DiffViewerWrapper;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffRequestProcessor
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DiffRequestProcessor.class);
    private boolean myDisposed;
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffSettingsHolder.DiffSettings mySettings;
    @NotNull
    private final List<DiffTool> myAvailableTools;
    @NotNull
    private final List<DiffTool> myToolOrder;
    @Nullable
    private final DiffTool myForcedDiffTool;
    @NotNull
    private final DefaultActionGroup myToolbarGroup;
    @NotNull
    private final DefaultActionGroup myPopupActionGroup;
    @NotNull
    private final DefaultActionGroup myTouchbarActionGroup;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final MyPanel myMainPanel;
    @NotNull
    protected final Wrapper myContentPanel;
    @NotNull
    private final ActionToolbar myToolbar;
    @NotNull
    protected final Wrapper myToolbarWrapper;
    @NotNull
    private final Wrapper myToolbarStatusPanel;
    @NotNull
    private final MyProgressBar myProgressBar;
    @NotNull
    private final EventDispatcher<DiffRequestProcessorListener> myEventDispatcher;
    @NotNull
    private DiffRequest myActiveRequest;
    @NotNull
    private ViewerState myState;
    @Nullable
    private ApplyData myQueuedApplyRequest;
    private static final boolean SHOW_VIEWER_ACTIONS_IN_TOUCHBAR = Boolean.getBoolean("touchbar.diff.show.viewer.actions");
    @NotNull
    private IterationState myIterationState;

    public DiffRequestProcessor(@Nullable Project project) {
        this(project, (UserDataHolder)new UserDataHolderBase());
    }

    public DiffRequestProcessor(@Nullable Project project, @NonNls @NotNull String place) {
        if (place == null) {
            DiffRequestProcessor.$$$reportNull$$$0(0);
        }
        this(project, (UserDataHolder)DiffUtil.createUserDataHolder(DiffUserDataKeys.PLACE, place));
    }

    public DiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context2) {
        if (context2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(1);
        }
        this.myAvailableTools = new ArrayList<DiffTool>();
        this.myToolOrder = new ArrayList<DiffTool>();
        this.myEventDispatcher = EventDispatcher.create(DiffRequestProcessorListener.class);
        this.myIterationState = IterationState.NONE;
        this.myProject = project;
        this.myContext = new MyDiffContext(context2);
        this.myActiveRequest = new LoadingDiffRequest();
        this.mySettings = DiffSettingsHolder.DiffSettings.getSettings((String)this.myContext.getUserData(DiffUserDataKeys.PLACE));
        this.myForcedDiffTool = (DiffTool)this.myContext.getUserData(DiffUserDataKeysEx.FORCE_DIFF_TOOL);
        this.updateAvailableDiffTools();
        DiffTool.EP_NAME.addChangeListener(() -> {
            this.updateAvailableDiffTools();
            this.updateRequest(true);
        }, (Disposable)this);
        DiffToolSubstitutor.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        DiffIgnoredRangeProvider.EP_NAME.addChangeListener(() -> this.updateRequest(true), (Disposable)this);
        this.myToolbarGroup = new DefaultActionGroup();
        this.myPopupActionGroup = new DefaultActionGroup();
        this.myTouchbarActionGroup = new DefaultActionGroup();
        this.myMainPanel = new MyPanel();
        Touchbar.setActions((JComponent)((Object)this.myMainPanel), (ActionGroup)this.myTouchbarActionGroup);
        this.myContentPanel = new Wrapper();
        this.myToolbarStatusPanel = new Wrapper();
        this.myProgressBar = new MyProgressBar();
        this.myToolbar = ActionManager.getInstance().createActionToolbar("DiffToolbar", (ActionGroup)this.myToolbarGroup, true);
        this.myToolbar.setTargetComponent((JComponent)((Object)this.myMainPanel));
        this.myToolbarWrapper = new Wrapper(this.myToolbar.getComponent());
        this.myPanel = JBUI.Panels.simplePanel((Component)((Object)this.myMainPanel));
        BorderLayoutPanel statusPanel = JBUI.Panels.simplePanel((Component)this.myToolbarStatusPanel).addToLeft((Component)this.myProgressBar);
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel((Component)this.myToolbarWrapper).addToRight((Component)statusPanel);
        GuiUtils.installVisibilityReferent((JComponent)topPanel, (JComponent)this.myToolbar.getComponent());
        JBSplitter bottomContentSplitter = new JBSplitter(true, "DiffRequestProcessor.BottomComponentSplitter", 0.8f);
        bottomContentSplitter.setFirstComponent((JComponent)this.myContentPanel);
        this.myMainPanel.add((Component)topPanel, "North");
        this.myMainPanel.add((Component)bottomContentSplitter, "Center");
        this.myMainPanel.setFocusTraversalPolicyProvider(true);
        this.myMainPanel.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        JComponent bottomPanel2 = (JComponent)this.myContext.getUserData(DiffUserDataKeysEx.BOTTOM_PANEL);
        if (bottomPanel2 != null) {
            bottomContentSplitter.setSecondComponent(bottomPanel2);
        }
        if (bottomPanel2 instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)bottomPanel2));
        }
        this.myState = EmptyState.INSTANCE;
        this.myContentPanel.setContent((JComponent)DiffUtil.createMessagePanel(((LoadingDiffRequest)this.myActiveRequest).getMessage()));
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        if (toolbarComponents == null) {
            DiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return toolbarComponents.needTopToolbarBorder;
    }

    public void addListener(@NotNull DiffRequestProcessorListener listener2, @Nullable Disposable disposable2) {
        if (listener2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(3);
        }
        if (disposable2 != null) {
            this.myEventDispatcher.addListener((EventListener)listener2, disposable2);
        } else {
            this.myEventDispatcher.addListener((EventListener)listener2);
        }
    }

    @RequiresEdt
    protected void reloadRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateRequest(true);
    }

    @RequiresEdt
    public void updateRequest() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateRequest(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void updateRequest(boolean bl) {
        void force;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateRequest((boolean)force, null);
    }

    @RequiresEdt
    public abstract void updateRequest(boolean var1, @Nullable DiffUserDataKeysEx.ScrollToPolicy var2);

    @NotNull
    private FrameDiffTool getFittedTool(boolean applySubstitutor) {
        FrameDiffTool substitutor;
        ErrorDiffTool tool;
        if (this.myForcedDiffTool instanceof FrameDiffTool) {
            ErrorDiffTool errorDiffTool = this.myForcedDiffTool.canShow(this.myContext, this.myActiveRequest) ? (FrameDiffTool)this.myForcedDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                DiffRequestProcessor.$$$reportNull$$$0(4);
            }
            return errorDiffTool;
        }
        List<FrameDiffTool> tools = this.filterFittedTools(this.myToolOrder);
        ErrorDiffTool errorDiffTool = tool = tools.isEmpty() ? ErrorDiffTool.INSTANCE : tools.get(0);
        if (applySubstitutor && (substitutor = this.findToolSubstitutor((DiffTool)tool)) != null) {
            FrameDiffTool frameDiffTool = substitutor;
            if (frameDiffTool == null) {
                DiffRequestProcessor.$$$reportNull$$$0(5);
            }
            return frameDiffTool;
        }
        ErrorDiffTool errorDiffTool2 = tool;
        if (errorDiffTool2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(6);
        }
        return errorDiffTool2;
    }

    @NotNull
    private List<FrameDiffTool> getAvailableFittedTools() {
        return this.filterFittedTools(this.myAvailableTools);
    }

    @NotNull
    private List<FrameDiffTool> filterFittedTools(@NotNull List<? extends DiffTool> tools) {
        if (tools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<FrameDiffTool> result2 = new ArrayList<FrameDiffTool>();
        for (DiffTool diffTool : tools) {
            try {
                if (!(diffTool instanceof FrameDiffTool)) continue;
                if (diffTool.canShow(this.myContext, this.myActiveRequest)) {
                    result2.add((FrameDiffTool)diffTool);
                    continue;
                }
                FrameDiffTool substitutor = this.findToolSubstitutor(diffTool);
                if (substitutor == null) continue;
                result2.add((FrameDiffTool)diffTool);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        List<FrameDiffTool> list2 = DiffUtil.filterSuppressedTools(result2);
        if (list2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private FrameDiffTool findToolSubstitutor(@NotNull DiffTool tool) {
        DiffTool substitutor;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(9);
        }
        return (substitutor = DiffUtil.findToolSubstitutor(tool, this.myContext, this.myActiveRequest)) instanceof FrameDiffTool ? (FrameDiffTool)substitutor : null;
    }

    private void updateAvailableDiffTools() {
        this.myAvailableTools.clear();
        this.myToolOrder.clear();
        this.myAvailableTools.addAll(DiffManagerEx.getInstance().getDiffTools());
        this.myToolOrder.addAll(this.getToolOrderFromSettings(this.myAvailableTools));
    }

    private void moveToolOnTop(@NotNull DiffTool tool) {
        int index2;
        if (tool == null) {
            DiffRequestProcessor.$$$reportNull$$$0(10);
        }
        this.myToolOrder.remove(tool);
        FrameDiffTool toolToReplace = this.getFittedTool(false);
        for (index2 = 0; index2 < this.myToolOrder.size() && this.myToolOrder.get(index2) != toolToReplace; ++index2) {
        }
        this.myToolOrder.add(index2, tool);
        this.updateToolOrderSettings(this.myToolOrder);
    }

    @NotNull
    private ViewerState createState() {
        FrameDiffTool frameTool = this.getFittedTool(true);
        FrameDiffTool.DiffViewer viewer = frameTool.createComponent(this.myContext, this.myActiveRequest);
        for (DiffExtension extension2 : (DiffExtension[])DiffExtension.EP_NAME.getExtensions()) {
            try {
                extension2.onViewerCreated(viewer, this.myContext, this.myActiveRequest);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        DiffViewerWrapper wrapper2 = (DiffViewerWrapper)this.myActiveRequest.getUserData(DiffViewerWrapper.KEY);
        if (wrapper2 == null) {
            return new DefaultState(viewer, frameTool);
        }
        return new WrapperState(viewer, frameTool, wrapper2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void applyRequest(@NotNull DiffRequest diffRequest, boolean bl, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        void scrollToChangePolicy;
        void force;
        void request2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (request2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(11);
        }
        this.applyRequest((DiffRequest)request2, (boolean)force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy, false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void applyRequest(@NotNull DiffRequest diffRequest, boolean bl, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy, boolean bl2) {
        void sync2;
        void scrollToChangePolicy;
        boolean force;
        void request2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (request2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myIterationState = IterationState.NONE;
        force = force || this.myQueuedApplyRequest != null && this.myQueuedApplyRequest.force;
        this.myQueuedApplyRequest = new ApplyData((DiffRequest)request2, force, (DiffUserDataKeysEx.ScrollToPolicy)scrollToChangePolicy);
        Runnable task2 = () -> {
            if (this.myQueuedApplyRequest == null || this.myDisposed) {
                return;
            }
            this.doApplyRequest(this.myQueuedApplyRequest.request, this.myQueuedApplyRequest.force, this.myQueuedApplyRequest.scrollToChangePolicy);
            this.myQueuedApplyRequest = null;
        };
        if (sync2 != false) {
            task2.run();
        } else {
            IdeFocusManager.getInstance((Project)this.myProject).doWhenFocusSettlesDown(task2, ModalityState.current());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void doApplyRequest(@NotNull DiffRequest diffRequest, boolean bl, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        void scrollToChangePolicy;
        void force;
        void request2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (request2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(13);
        }
        if (force == false && request2 == this.myActiveRequest) {
            return;
        }
        request2.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, (Object)scrollToChangePolicy);
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> this.lambda$doApplyRequest$5((DiffRequest)request2));
        ((DiffRequestProcessorListener)this.myEventDispatcher.getMulticaster()).onViewerChanged();
    }

    protected void setWindowTitle(@NotNull @NlsContexts.DialogTitle String title2) {
        if (title2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(14);
        }
    }

    protected void onAfterNavigate() {
    }

    @RequiresEdt
    protected void onDispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @Nullable
    public <T> T getContextUserData(@NotNull Key<T> key) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(15);
        }
        return (T)this.myContext.getUserData(key);
    }

    public <T> void putContextUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            DiffRequestProcessor.$$$reportNull$$$0(16);
        }
        this.myContext.putUserData(key, value2);
    }

    @NotNull
    protected List<AnAction> getNavigationActions() {
        ArrayList actions2 = ContainerUtil.newArrayList((Object[])new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction(), new MyOpenInEditorAction(), Separator.getInstance(), new MyPrevChangeAction(), new MyNextChangeAction()});
        ContainerUtil.addIfNotNull((Collection)actions2, (Object)this.createGoToChangeAction());
        ArrayList arrayList = actions2;
        if (arrayList == null) {
            DiffRequestProcessor.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Nullable
    protected AnAction createGoToChangeAction() {
        return null;
    }

    protected boolean isWindowFocused() {
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        return window != null && window.isFocused();
    }

    private boolean isFocusedInWindow() {
        return DiffUtil.isFocusedComponentInWindow((Component)this.myContentPanel) || DiffUtil.isFocusedComponentInWindow(this.myToolbar.getComponent());
    }

    private void requestFocusInWindow() {
        DiffUtil.requestFocusInWindow(this.getPreferredFocusedComponent());
    }

    @NotNull
    protected List<DiffTool> getToolOrderFromSettings(@NotNull List<? extends DiffTool> availableTools) {
        if (availableTools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(18);
        }
        return DiffRequestProcessor.getToolOrderFromSettings(this.getSettings(), availableTools);
    }

    @NotNull
    protected static List<DiffTool> getToolOrderFromSettings(@NotNull DiffSettingsHolder.DiffSettings diffSettings, @NotNull List<? extends DiffTool> availableTools) {
        if (diffSettings == null) {
            DiffRequestProcessor.$$$reportNull$$$0(19);
        }
        if (availableTools == null) {
            DiffRequestProcessor.$$$reportNull$$$0(20);
        }
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        List<String> savedOrder = diffSettings.getDiffToolsOrder();
        for (String string : savedOrder) {
            DiffTool tool = (DiffTool)ContainerUtil.find(availableTools, t -> t.getClass().getCanonicalName().equals(clazz));
            if (tool == null) continue;
            result2.add(tool);
        }
        for (DiffTool diffTool : availableTools) {
            if (result2.contains(diffTool)) continue;
            result2.add(diffTool);
        }
        ArrayList<DiffTool> arrayList = result2;
        if (arrayList == null) {
            DiffRequestProcessor.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    protected void updateToolOrderSettings(@NotNull List<? extends DiffTool> toolOrder) {
        if (toolOrder == null) {
            DiffRequestProcessor.$$$reportNull$$$0(22);
        }
        ArrayList<String> savedOrder = new ArrayList<String>();
        for (DiffTool diffTool : toolOrder) {
            savedOrder.add(diffTool.getClass().getCanonicalName());
        }
        this.getSettings().setDiffToolsOrder(savedOrder);
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myDisposed = true;
            this.onDispose();
            this.myState.destroy();
            this.myToolbarStatusPanel.setContent(null);
            this.myContentPanel.setContent(null);
            this.myToolbarGroup.removeAll();
            this.myPopupActionGroup.removeAll();
            ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
            DiffRequestProcessor.onAssigned(this.myActiveRequest, false);
            this.myState = EmptyState.INSTANCE;
            this.myActiveRequest = NoDiffRequest.INSTANCE;
        });
    }

    protected void collectToolbarActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myToolbarGroup.removeAll();
        ArrayList<AnAction> navigationActions = new ArrayList<AnAction>(this.getNavigationActions());
        navigationActions.add((AnAction)new MyChangeDiffToolAction());
        DiffUtil.addActionBlock(this.myToolbarGroup, navigationActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, viewerActions);
        List requestContextActions = (List)this.myActiveRequest.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, requestContextActions);
        List contextActions = (List)this.myContext.getUserData(DiffUserDataKeys.CONTEXT_ACTIONS);
        DiffUtil.addActionBlock(this.myToolbarGroup, contextActions);
        DiffUtil.addActionBlock(this.myToolbarGroup, new AnAction[]{new ShowInExternalToolAction(), ActionManager.getInstance().getAction("ContextHelp")});
        if (SystemInfo.isMac) {
            this.myTouchbarActionGroup.removeAll();
            this.myTouchbarActionGroup.addAll(new AnAction[]{new MyPrevDifferenceAction(), new MyNextDifferenceAction(), new MyOpenInEditorAction(), Separator.getInstance(), new MyPrevChangeAction(), new MyNextChangeAction()});
            if (SHOW_VIEWER_ACTIONS_IN_TOUCHBAR && viewerActions != null) {
                this.myTouchbarActionGroup.addAll(viewerActions);
            }
        }
    }

    protected void collectPopupActions(@Nullable List<? extends AnAction> viewerActions) {
        this.myPopupActionGroup.removeAll();
        ArrayList<DiffToolToggleAction> selectToolActions = new ArrayList<DiffToolToggleAction>();
        for (DiffTool diffTool : this.getAvailableFittedTools()) {
            FrameDiffTool substitutor = this.findToolSubstitutor(diffTool);
            if (diffTool == this.myState.getActiveTool() || substitutor == this.myState.getActiveTool()) continue;
            selectToolActions.add(new DiffToolToggleAction(diffTool));
        }
        DiffUtil.addActionBlock(this.myPopupActionGroup, selectToolActions);
        DiffUtil.addActionBlock(this.myPopupActionGroup, viewerActions);
    }

    protected void buildToolbar(@Nullable List<? extends AnAction> viewerActions) {
        this.collectToolbarActions(viewerActions);
        ((ActionToolbarImpl)this.myToolbar).clearPresentationCache();
        this.myToolbar.updateActionsImmediately();
        TextDiffViewerUtil.recursiveRegisterShortcutSet((ActionGroup)this.myToolbarGroup, (JComponent)((Object)this.myMainPanel), null);
    }

    @NotNull
    public ActionToolbar getToolbar() {
        ActionToolbar actionToolbar = this.myToolbar;
        if (actionToolbar == null) {
            DiffRequestProcessor.$$$reportNull$$$0(23);
        }
        return actionToolbar;
    }

    protected void buildActionPopup(@Nullable List<? extends AnAction> viewerActions) {
        this.collectPopupActions(viewerActions);
        DiffUtil.registerAction((AnAction)new ShowActionGroupPopupAction(), (JComponent)((Object)this.myMainPanel));
    }

    private void setTitle(@Nullable @NlsContexts.DialogTitle String title2) {
        if (this.getContextUserData(DiffUserDataKeys.DO_NOT_CHANGE_WINDOW_TITLE) == Boolean.TRUE) {
            return;
        }
        if (title2 == null) {
            title2 = DiffBundle.message((String)"diff.files.dialog.title", (Object[])new Object[0]);
        }
        this.setWindowTitle(title2);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel2 = this.myPanel;
        if (jPanel2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(24);
        }
        return jPanel2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        JComponent component2 = this.myState.getPreferredFocusedComponent();
        JComponent fallback = this.myToolbar.getComponent();
        if (component2 == null || !component2.isFocusable()) {
            return fallback;
        }
        if (!component2.isShowing() && fallback.isShowing()) {
            return fallback;
        }
        return component2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public DiffRequest getActiveRequest() {
        return this.myActiveRequest;
    }

    @NotNull
    public DiffContext getContext() {
        DiffContext diffContext = this.myContext;
        if (diffContext == null) {
            DiffRequestProcessor.$$$reportNull$$$0(25);
        }
        return diffContext;
    }

    @Nullable
    public FrameDiffTool.DiffViewer getActiveViewer() {
        if (this.myState instanceof DefaultState) {
            return ((DefaultState)this.myState).myViewer;
        }
        if (this.myState instanceof WrapperState) {
            return ((WrapperState)this.myState).myViewer;
        }
        return null;
    }

    @NotNull
    protected DiffSettingsHolder.DiffSettings getSettings() {
        DiffSettingsHolder.DiffSettings diffSettings = this.mySettings;
        if (diffSettings == null) {
            DiffRequestProcessor.$$$reportNull$$$0(26);
        }
        return diffSettings;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @RequiresEdt
    protected boolean hasNextChange(boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return false;
    }

    @RequiresEdt
    protected boolean hasPrevChange(boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return false;
    }

    @RequiresEdt
    protected void goToNextChange(boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected void goToPrevChange(boolean bl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    @RequiresEdt
    protected boolean isNavigationEnabled() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return false;
    }

    private void notifyMessage(@NotNull AnActionEvent e, boolean next) {
        if (e == null) {
            DiffRequestProcessor.$$$reportNull$$$0(27);
        }
        if (!this.myContentPanel.isShowing()) {
            return;
        }
        Editor editor2 = (Editor)e.getData(DiffDataKeys.CURRENT_EDITOR);
        String message2 = DiffUtil.createNotificationText(next ? DiffBundle.message((String)"press.again.to.go.to.the.next.file", (Object[])new Object[0]) : DiffBundle.message((String)"press.again.to.go.to.the.previous.file", (Object[])new Object[0]), DiffBundle.message((String)"notification.you.can.disable.this.feature.in.0", (Object[])new Object[]{DiffUtil.getSettingsConfigurablePath()}));
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message2));
        Point point = new Point(this.myContentPanel.getWidth() / 2, next ? this.myContentPanel.getHeight() - JBUIScale.scale((int)40) : JBUIScale.scale((int)40));
        if (editor2 == null) {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            HintHint hintHint = DiffRequestProcessor.createNotifyHint((JComponent)this.myContentPanel, point, next);
            hint.show((JComponent)this.myContentPanel, point.x, point.y, owner instanceof JComponent ? (JComponent)owner : null, hintHint);
        } else {
            int x = SwingUtilities.convertPoint((Component)this.myContentPanel, (Point)point, (Component)editor2.getComponent()).x;
            JComponent header2 = editor2.getHeaderComponent();
            int shift = editor2.getScrollingModel().getVerticalScrollOffset() - (header2 != null ? header2.getHeight() : 0);
            LineRange changeRange = (LineRange)e.getData(DiffDataKeys.CURRENT_CHANGE_RANGE);
            LogicalPosition position = changeRange == null ? new LogicalPosition(editor2.getCaretModel().getLogicalPosition().line + (next ? 1 : 0), 0) : new LogicalPosition(next ? changeRange.end : changeRange.start, 0);
            int y = editor2.logicalPositionToXY((LogicalPosition)position).y - shift;
            Point editorPoint = new Point(x, y);
            HintHint hintHint = DiffRequestProcessor.createNotifyHint(editor2.getComponent(), editorPoint, !next);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, editorPoint, 42, 0, false, hintHint);
        }
    }

    @NotNull
    private static HintHint createNotifyHint(@NotNull JComponent component2, @NotNull Point point, boolean above) {
        if (component2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(28);
        }
        if (point == null) {
            DiffRequestProcessor.$$$reportNull$$$0(29);
        }
        HintHint hintHint = new HintHint(component2, point).setPreferredPosition(above ? Balloon.Position.above : Balloon.Position.below).setAwtTooltip(true).setFont(UIUtil.getLabelFont().deriveFont(1)).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true);
        if (hintHint == null) {
            DiffRequestProcessor.$$$reportNull$$$0(30);
        }
        return hintHint;
    }

    private static void onAssigned(@NotNull DiffRequest request2, boolean isAssigned) {
        if (request2 == null) {
            DiffRequestProcessor.$$$reportNull$$$0(31);
        }
        try {
            request2.onAssigned(isAssigned);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private /* synthetic */ void lambda$doApplyRequest$5(DiffRequest request2) {
        this.myState.destroy();
        this.myToolbarStatusPanel.setContent(null);
        this.myContentPanel.setContent(null);
        this.myToolbarWrapper.setBorder(null);
        this.myToolbarGroup.removeAll();
        this.myPopupActionGroup.removeAll();
        ActionUtil.clearActions((JComponent)((Object)this.myMainPanel));
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            DiffRequestProcessor.onAssigned(this.myActiveRequest, false);
            this.myActiveRequest = request2;
            DiffRequestProcessor.onAssigned(this.myActiveRequest, true);
            try {
                this.myState = this.createState();
                try {
                    this.myState.init();
                }
                catch (Throwable e) {
                    this.myState.destroy();
                    throw e;
                }
            }
            catch (Throwable e) {
                LOG.error(e);
                this.myState = new ErrorState(this, (MessageDiffRequest)new ErrorDiffRequest(DiffBundle.message((String)"error.cant.show.diff.message", (Object[])new Object[0])), (DiffTool)this.getFittedTool(true));
                this.myState.init();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarComponents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTools";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffSettings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolOrder";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFittedTool";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFittedTools";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationActions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOrderFromSettings";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotifyHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToolbarBottomBorder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterFittedTools";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveToolOnTop";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyRequest";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doApplyRequest";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setWindowTitle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContextUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putContextUserData";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getToolOrderFromSettings";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateToolOrderSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyMessage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createNotifyHint";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "onAssigned";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WrapperState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;
        @NotNull
        private final FrameDiffTool.DiffViewer myWrapperViewer;

        WrapperState(@NotNull FrameDiffTool.DiffViewer viewer, @NotNull FrameDiffTool tool, DiffViewerWrapper wrapper2) {
            if (viewer == null) {
                WrapperState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                WrapperState.$$$reportNull$$$0(1);
            }
            if (wrapper2 == null) {
                WrapperState.$$$reportNull$$$0(2);
            }
            this.myViewer = viewer;
            this.myTool = tool;
            this.myWrapperViewer = wrapper2.createComponent(DiffRequestProcessor.this.myContext, DiffRequestProcessor.this.myActiveRequest, this.myViewer);
        }

        @Override
        @RequiresEdt
        public void init() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            DiffRequestProcessor.this.myContentPanel.setContent(this.myWrapperViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents1 = this.myViewer.init();
            FrameDiffTool.ToolbarComponents toolbarComponents2 = this.myWrapperViewer.init();
            DiffRequestProcessor.this.buildToolbar(this.mergeActions(toolbarComponents1.toolbarActions, toolbarComponents2.toolbarActions));
            DiffRequestProcessor.this.buildActionPopup(this.mergeActions(toolbarComponents1.popupActions, toolbarComponents2.popupActions));
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents1.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents1)) {
                DiffRequestProcessor.this.myToolbarWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Nullable
        private List<AnAction> mergeActions(@Nullable List<AnAction> actions1, @Nullable List<AnAction> actions2) {
            if (actions1 == null && actions2 == null) {
                return null;
            }
            if (ContainerUtil.isEmpty(actions1)) {
                return actions2;
            }
            if (ContainerUtil.isEmpty(actions2)) {
                return actions1;
            }
            ArrayList<AnAction> result2 = new ArrayList<AnAction>(actions1);
            result2.add((AnAction)Separator.getInstance());
            for (AnAction action2 : actions2) {
                if (!(action2 instanceof Separator) && actions1.contains(action2)) continue;
                result2.add(action2);
            }
            return result2;
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
                Disposer.dispose((Disposable)this.myWrapperViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myWrapperViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                WrapperState.$$$reportNull$$$0(3);
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                WrapperState.$$$reportNull$$$0(4);
            }
            if (DiffDataKeys.WRAPPING_DIFF_VIEWER.is(dataId)) {
                return this.myWrapperViewer;
            }
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$WrapperState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DefaultState
    implements ViewerState {
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        @NotNull
        private final FrameDiffTool myTool;

        DefaultState(@NotNull FrameDiffTool.DiffViewer viewer, FrameDiffTool tool) {
            if (viewer == null) {
                DefaultState.$$$reportNull$$$0(0);
            }
            if (tool == null) {
                DefaultState.$$$reportNull$$$0(1);
            }
            this.myViewer = viewer;
            this.myTool = tool;
        }

        @Override
        @RequiresEdt
        public void init() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            DiffRequestProcessor.this.myContentPanel.setContent(this.myViewer.getComponent());
            DiffRequestProcessor.this.setTitle(DiffRequestProcessor.this.myActiveRequest.getTitle());
            FrameDiffTool.ToolbarComponents toolbarComponents = this.myViewer.init();
            DiffRequestProcessor.this.buildToolbar(toolbarComponents.toolbarActions);
            DiffRequestProcessor.this.buildActionPopup(toolbarComponents.popupActions);
            DiffRequestProcessor.this.myToolbarStatusPanel.setContent(toolbarComponents.statusPanel);
            if (DiffRequestProcessor.this.shouldAddToolbarBottomBorder(toolbarComponents)) {
                DiffRequestProcessor.this.myToolbarWrapper.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
            }
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myViewer.getPreferredFocusedComponent();
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            FrameDiffTool frameDiffTool = this.myTool;
            if (frameDiffTool == null) {
                DefaultState.$$$reportNull$$$0(2);
            }
            return frameDiffTool;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                DefaultState.$$$reportNull$$$0(3);
            }
            if (DiffDataKeys.DIFF_VIEWER.is(dataId)) {
                return this.myViewer;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DefaultState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ErrorState
    implements ViewerState {
        @Nullable
        private final DiffTool myDiffTool;
        @NotNull
        private final MessageDiffRequest myRequest;
        @NotNull
        private final FrameDiffTool.DiffViewer myViewer;
        final /* synthetic */ DiffRequestProcessor this$0;

        ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, MessageDiffRequest request2) {
            if (request2 == null) {
                ErrorState.$$$reportNull$$$0(0);
            }
            this(diffRequestProcessor, request2, null);
        }

        ErrorState(@NotNull DiffRequestProcessor diffRequestProcessor, @Nullable MessageDiffRequest request2, DiffTool diffTool) {
            if (request2 == null) {
                ErrorState.$$$reportNull$$$0(1);
            }
            this.this$0 = diffRequestProcessor;
            this.myDiffTool = diffTool;
            this.myRequest = request2;
            this.myViewer = ErrorDiffTool.INSTANCE.createComponent(diffRequestProcessor.myContext, (DiffRequest)this.myRequest);
        }

        @Override
        @RequiresEdt
        public void init() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.this$0.myContentPanel.setContent(this.myViewer.getComponent());
            FrameDiffTool.ToolbarComponents init2 = this.myViewer.init();
            this.this$0.buildToolbar(init2.toolbarActions);
        }

        @Override
        @RequiresEdt
        public void destroy() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            try {
                Disposer.dispose((Disposable)this.myViewer);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                ErrorState.$$$reportNull$$$0(2);
            }
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = this.myDiffTool != null ? this.myDiffTool : ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                ErrorState.$$$reportNull$$$0(3);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ErrorState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyState
    implements ViewerState {
        private static final EmptyState INSTANCE = new EmptyState();

        private EmptyState() {
        }

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return null;
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                EmptyState.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @NotNull
        public DiffTool getActiveTool() {
            ErrorDiffTool errorDiffTool = ErrorDiffTool.INSTANCE;
            if (errorDiffTool == null) {
                EmptyState.$$$reportNull$$$0(1);
            }
            return errorDiffTool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$EmptyState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$EmptyState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveTool";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ViewerState {
        @RequiresEdt
        public void init();

        @RequiresEdt
        public void destroy();

        @Nullable
        public JComponent getPreferredFocusedComponent();

        @Nullable
        public Object getData(@NotNull @NonNls String var1);

        @NotNull
        public DiffTool getActiveTool();
    }

    private static class ApplyData {
        @NotNull
        private final DiffRequest request;
        private final boolean force;
        @Nullable
        private final DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy;

        ApplyData(@NotNull DiffRequest request2, boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (request2 == null) {
                ApplyData.$$$reportNull$$$0(0);
            }
            this.request = request2;
            this.force = force;
            this.scrollToChangePolicy = scrollToChangePolicy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/impl/DiffRequestProcessor$ApplyData", "<init>"));
        }
    }

    private class MyDiffContext
    extends DiffContextEx {
        @NotNull
        private final UserDataHolder myInitialContext;
        @NotNull
        private final UserDataHolder myOwnContext;

        MyDiffContext(UserDataHolder initialContext) {
            if (initialContext == null) {
                MyDiffContext.$$$reportNull$$$0(0);
            }
            this.myOwnContext = new UserDataHolderBase();
            this.myInitialContext = initialContext;
        }

        @Override
        public void reopenDiffRequest() {
            DiffRequestProcessor.this.updateRequest(true);
        }

        @Override
        public void reloadDiffRequest() {
            DiffRequestProcessor.this.reloadRequest();
        }

        @Override
        public void showProgressBar(boolean enabled) {
            if (enabled) {
                DiffRequestProcessor.this.myProgressBar.startProgress();
            } else {
                DiffRequestProcessor.this.myProgressBar.stopProgress();
            }
        }

        @Override
        public void setWindowTitle(@NotNull String title2) {
            if (title2 == null) {
                MyDiffContext.$$$reportNull$$$0(1);
            }
            DiffRequestProcessor.this.setTitle(title2);
        }

        @Nullable
        public Project getProject() {
            return DiffRequestProcessor.this.getProject();
        }

        public boolean isFocusedInWindow() {
            return DiffRequestProcessor.this.isFocusedInWindow();
        }

        public boolean isWindowFocused() {
            return DiffRequestProcessor.this.isWindowFocused();
        }

        public void requestFocusInWindow() {
            DiffRequestProcessor.this.requestFocusInWindow();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            Object data2;
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(2);
            }
            if ((data2 = this.myOwnContext.getUserData(key)) != null) {
                return (T)data2;
            }
            return (T)this.myInitialContext.getUserData(key);
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            if (key == null) {
                MyDiffContext.$$$reportNull$$$0(3);
            }
            this.myOwnContext.putUserData(key, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyDiffContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setWindowTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            JComponent component2 = DiffRequestProcessor.this.getPreferredFocusedComponent();
            if (component2 == null) {
                return null;
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent(component2, this);
        }

        @Override
        @Nullable
        protected Project getProject() {
            return DiffRequestProcessor.this.myProject;
        }
    }

    private static class MyProgressBar
    extends JProgressBar {
        private int myProgressCount = 0;

        MyProgressBar() {
            this.setIndeterminate(true);
            this.setVisible(false);
        }

        public void startProgress() {
            ++this.myProgressCount;
            this.setVisible(true);
        }

        public void stopProgress() {
            --this.myProgressCount;
            LOG.assertTrue(this.myProgressCount >= 0);
            if (this.myProgressCount == 0) {
                this.setVisible(false);
            }
        }
    }

    private class MyPanel
    extends JBPanelWithEmptyText
    implements DataProvider {
        MyPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public Dimension getPreferredSize() {
            Dimension windowSize = DiffUtil.getDefaultDiffPanelSize();
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(windowSize.width, size.width), Math.max(windowSize.height, size.height));
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            Object data2;
            DataProvider contentProvider;
            if (dataId == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            if ((contentProvider = DataManagerImpl.getDataProviderEx(DiffRequestProcessor.this.myContentPanel.getTargetComponent())) != null && (data2 = contentProvider.getData(dataId)) != null) {
                return data2;
            }
            if (OpenInEditorAction.KEY.is(dataId)) {
                return new MyOpenInEditorAction();
            }
            if (DiffDataKeys.DIFF_REQUEST.is(dataId)) {
                return DiffRequestProcessor.this.myActiveRequest;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return DiffRequestProcessor.this.myProject;
            }
            if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
                if (DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID) != null) {
                    return DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.HELP_ID);
                }
                return "reference.dialogs.diff.file";
            }
            if (DiffDataKeys.DIFF_CONTEXT.is(dataId)) {
                return DiffRequestProcessor.this.myContext;
            }
            data2 = DiffRequestProcessor.this.myState.getData(dataId);
            if (data2 != null) {
                return data2;
            }
            DataProvider requestProvider = (DataProvider)DiffRequestProcessor.this.myActiveRequest.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (requestProvider != null && (data2 = requestProvider.getData(dataId)) != null) {
                return data2;
            }
            DataProvider contextProvider = (DataProvider)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.DATA_PROVIDER);
            if (contextProvider != null && (data2 = contextProvider.getData(dataId)) != null) {
                return data2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/diff/impl/DiffRequestProcessor$MyPanel", "getData"));
        }
    }

    protected class MyOpenInEditorAction
    extends OpenInEditorAction {
        @Override
        protected void onAfterEditorOpened() {
            DiffRequestProcessor.this.onAfterNavigate();
        }
    }

    protected class MyPrevChangeAction
    extends PrevChangeAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevChangeAction.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasPrevChange(true));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevChangeAction.$$$reportNull$$$0(1);
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasPrevChange(false)) {
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyPrevChangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyNextChangeAction
    extends NextChangeAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextChangeAction.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(DiffRequestProcessor.this.hasNextChange(true));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextChangeAction.$$$reportNull$$$0(1);
            }
            if (!DiffRequestProcessor.this.isNavigationEnabled() || !DiffRequestProcessor.this.hasNextChange(false)) {
                return;
            }
            DiffRequestProcessor.this.goToNextChange(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyNextChangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyPrevDifferenceAction
    extends PrevDifferenceAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoPrev()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange(true)) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyPrevDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE)) != null && iterable.canGoPrev()) {
                iterable.goPrev();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasPrevChange(false) && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.PREV) {
                DiffRequestProcessor.this.notifyMessage(e, false);
                DiffRequestProcessor.this.myIterationState = IterationState.PREV;
                return;
            }
            DiffRequestProcessor.this.goToPrevChange(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyPrevDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyNextDifferenceAction
    extends NextDifferenceAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(0);
            }
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            PrevNextDifferenceIterable iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE);
            if (iterable != null && iterable.canGoNext()) {
                e.getPresentation().setEnabled(true);
                return;
            }
            if (DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference() && DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange(true)) {
                e.getPresentation().setEnabled(true);
                return;
            }
            e.getPresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PrevNextDifferenceIterable iterable;
            if (e == null) {
                MyNextDifferenceAction.$$$reportNull$$$0(1);
            }
            if ((iterable = (PrevNextDifferenceIterable)e.getData(DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE)) != null && iterable.canGoNext()) {
                iterable.goNext();
                DiffRequestProcessor.this.myIterationState = IterationState.NONE;
                return;
            }
            if (!(DiffRequestProcessor.this.isNavigationEnabled() && DiffRequestProcessor.this.hasNextChange(false) && DiffRequestProcessor.this.getSettings().isGoToNextFileOnNextDifference())) {
                return;
            }
            if (DiffRequestProcessor.this.myIterationState != IterationState.NEXT) {
                DiffRequestProcessor.this.notifyMessage(e, true);
                DiffRequestProcessor.this.myIterationState = IterationState.NEXT;
                return;
            }
            DiffRequestProcessor.this.goToNextChange(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyNextDifferenceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum IterationState {
        NEXT,
        PREV,
        NONE;

    }

    private class ShowActionGroupPopupAction
    extends DumbAwareAction {
        ShowActionGroupPopupAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowSettingsPopup");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowActionGroupPopupAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(DiffRequestProcessor.this.myPopupActionGroup.getChildrenCount() > 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowActionGroupPopupAction.$$$reportNull$$$0(1);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DiffBundle.message((String)"diff.actions", (Object[])new Object[0]), (ActionGroup)DiffRequestProcessor.this.myPopupActionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
            popup2.showInCenterOf((Component)DiffRequestProcessor.this.myPanel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ShowActionGroupPopupAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class DiffToolToggleAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final DiffTool myDiffTool;

        private DiffToolToggleAction(DiffTool tool) {
            if (tool == null) {
                DiffToolToggleAction.$$$reportNull$$$0(0);
            }
            super(tool.getName());
            this.myDiffTool = tool;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffToolToggleAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(DiffRequestProcessor.this.myForcedDiffTool == null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffToolToggleAction.$$$reportNull$$$0(2);
            }
            if (DiffRequestProcessor.this.myState.getActiveTool() == this.myDiffTool) {
                return;
            }
            DiffUsageTriggerCollector.trigger(e.getProject(), "toggle.diff.tool", this.myDiffTool, (String)DiffRequestProcessor.this.myContext.getUserData(DiffUserDataKeys.PLACE));
            DiffRequestProcessor.this.moveToolOnTop(this.myDiffTool);
            DiffRequestProcessor.this.updateRequest(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$DiffToolToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangeDiffToolAction
    extends ComboBoxAction
    implements DumbAware {
        private MyChangeDiffToolAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyChangeDiffToolAction.$$$reportNull$$$0(0);
            }
            Presentation presentation2 = e.getPresentation();
            DiffTool activeTool = DiffRequestProcessor.this.myState.getActiveTool();
            presentation2.setText(activeTool.getName());
            if (DiffRequestProcessor.this.myForcedDiffTool != null) {
                presentation2.setEnabledAndVisible(false);
                return;
            }
            for (DiffTool diffTool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                if (diffTool == activeTool) continue;
                presentation2.setEnabledAndVisible(true);
                return;
            }
            presentation2.setEnabledAndVisible(false);
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
            DefaultActionGroup group2 = new DefaultActionGroup();
            for (DiffTool diffTool : DiffRequestProcessor.this.getAvailableFittedTools()) {
                group2.add((AnAction)new DiffToolToggleAction(diffTool));
            }
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                MyChangeDiffToolAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$MyChangeDiffToolAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ShowInExternalToolAction
    extends DumbAwareAction {
        ShowInExternalToolAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Diff.ShowInExternalTool");
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInExternalToolAction.$$$reportNull$$$0(0);
            }
            if (!ExternalDiffTool.isEnabled()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setEnabled(ExternalDiffTool.canShow(DiffRequestProcessor.this.myActiveRequest));
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInExternalToolAction.$$$reportNull$$$0(1);
            }
            try {
                ExternalDiffTool.showRequest(e.getProject(), DiffRequestProcessor.this.myActiveRequest);
            }
            catch (ProcessCanceledException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/diff/impl/DiffRequestProcessor$ShowInExternalToolAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

