/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.OnesideContentPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OnesideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final OnesideContentPanel myContentPanel;
    @NotNull
    private final Side mySide;
    @NotNull
    private final T myHolder;

    public OnesideDiffViewer(@NotNull DiffContext context2, @NotNull ContentDiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        if (context2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(1);
        }
        if (factory2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(2);
        }
        super(context2, request2);
        this.mySide = Side.fromRight((boolean)(this.myRequest.getContents().get(0) instanceof EmptyContent));
        this.myHolder = this.createEditorHolder(factory2);
        this.myContentPanel = OnesideContentPanel.createFromHolder(this.myHolder);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context2);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
        this.myContentPanel.setTitle(this.createTitle());
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.destroyEditorHolder();
        super.onDispose();
    }

    @NotNull
    protected T createEditorHolder(@NotNull EditorHolderFactory<T> factory2) {
        if (factory2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(3);
        }
        DiffContent content2 = (DiffContent)this.mySide.select(this.myRequest.getContents());
        T t = factory2.create(content2, this.myContext);
        if (t == null) {
            OnesideDiffViewer.$$$reportNull$$$0(4);
        }
        return t;
    }

    private void destroyEditorHolder() {
        Disposer.dispose(this.myHolder);
    }

    @Nullable
    protected JComponent createTitle() {
        List<JComponent> simpleTitles = DiffUtil.createSimpleTitles(this, this.myRequest);
        return (JComponent)this.mySide.select(simpleTitles);
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            OnesideDiffViewer.$$$reportNull$$$0(5);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public Side getSide() {
        Side side = this.mySide;
        if (side == null) {
            OnesideDiffViewer.$$$reportNull$$$0(6);
        }
        return side;
    }

    @NotNull
    protected DiffContent getContent() {
        DiffContent diffContent = (DiffContent)this.mySide.select(this.myRequest.getContents());
        if (diffContent == null) {
            OnesideDiffViewer.$$$reportNull$$$0(7);
        }
        return diffContent;
    }

    @NotNull
    protected T getEditorHolder() {
        T t = this.myHolder;
        if (t == null) {
            OnesideDiffViewer.$$$reportNull$$$0(8);
        }
        return t;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            OnesideDiffViewer.$$$reportNull$$$0(9);
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getContent();
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        return this.getContent().getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        if (context2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(10);
        }
        if (request2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(11);
        }
        if (factory2 == null) {
            OnesideDiffViewer.$$$reportNull$$$0(12);
        }
        if (!(request2 instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request2).getContents();
        if (contents.size() != 2) {
            return false;
        }
        DiffContent content1 = (DiffContent)contents.get(0);
        DiffContent content2 = (DiffContent)contents.get(1);
        if (content1 instanceof EmptyContent) {
            return factory2.canShowContent(content2, context2) && factory2.wantShowContent(content2, context2);
        }
        if (content2 instanceof EmptyContent) {
            return factory2.canShowContent(content1, context2) && factory2.wantShowContent(content1, context2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/OnesideDiffViewer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/OnesideDiffViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSide";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

