/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffLineMarkerRenderer$WhenMappings;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJH\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/diff/util/DiffLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "myHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "myDiffType", "Lcom/intellij/diff/util/TextDiffType;", "myEditorMode", "Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;", "myGutterMode", "myHideWithoutLineNumbers", "", "myEmptyRange", "myFirstLine", "myLastLine", "alignedSides", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;Lcom/intellij/diff/util/DiffDrawUtil$PaintMode;ZZZZZ)V", "drawMarker", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics2D;", "x1", "", "x2", "y1", "y2", "mode", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "paint", "Ljava/awt/Graphics;", "range", "Ljava/awt/Rectangle;", "intellij.platform.diff.impl"})
public final class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    private final RangeHighlighter myHighlighter;
    private final TextDiffType myDiffType;
    private final DiffDrawUtil.PaintMode myEditorMode;
    private final DiffDrawUtil.PaintMode myGutterMode;
    private final boolean myHideWithoutLineNumbers;
    private final boolean myEmptyRange;
    private final boolean myFirstLine;
    private final boolean myLastLine;
    private final boolean alignedSides;

    /*
     * Unable to fully structure code
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle range) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        (EditorEx)editor;
        (Graphics2D)g;
        v0 = ((EditorEx)editor).getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"editor.gutterComponentEx");
        gutter = v0;
        x1 = 0;
        x2 = x1 + gutter.getWidth();
        startLine = 0;
        endLine = 0;
        if (this.myEmptyRange) {
            startLine = this.myLastLine != false ? DiffUtil.getLineCount(((EditorEx)editor).getDocument()) : ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            endLine = startLine;
        } else {
            startLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            endLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getEndOffset()) + 1;
        }
        var11_9 = DiffDrawUtil.getGutterMarkerPaintRange(editor, startLine, endLine);
        var9_12 = var11_9.component1();
        y2 = var11_9.component2();
        if (!this.myHideWithoutLineNumbers) ** GOTO lbl-1000
        v1 = editor.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"editor.getSettings()");
        if (!v1.isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else lbl-1000:
        // 2 sources

        {
            annotationsOffset = gutter.getAnnotationsAreaOffset();
            annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                this.drawMarker(editor, (Graphics2D)g, x1, annotationsOffset, (int)y1, y2, this.alignedSides, this.myGutterMode);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (Intrinsics.areEqual((Object)this.myEditorMode, (Object)this.myGutterMode)) {
            this.drawMarker(editor, (Graphics2D)g, x1, x2, (int)y1, y2, this.alignedSides, this.myGutterMode);
        } else {
            xOutline = gutter.getWhitespaceSeparatorOffset();
            this.drawMarker(editor, (Graphics2D)g, xOutline, x2, (int)y1, y2, this.alignedSides, this.myEditorMode);
            this.drawMarker(editor, (Graphics2D)g, x1, xOutline, (int)y1, y2, this.alignedSides, this.myGutterMode);
        }
    }

    private final void drawMarker(Editor editor2, Graphics2D g, int x1, int x2, int y1, int y2, boolean alignedSides, DiffDrawUtil.PaintMode mode) {
        boolean isEmptyRange;
        Color color;
        if (x1 >= x2) {
            return;
        }
        boolean dottedLine = mode.border == DiffDrawUtil.BorderType.DOTTED;
        Color color2 = this.myDiffType.getColor(editor2);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"myDiffType.getColor(editor)");
        Color color3 = color2;
        switch (DiffLineMarkerRenderer$WhenMappings.$EnumSwitchMapping$0[mode.background.ordinal()]) {
            case 1: {
                color = null;
                break;
            }
            case 2: {
                color = color3;
                break;
            }
            case 3: {
                color = this.myDiffType.getIgnoredColor(editor2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Color backgroundColor = color;
        boolean bl = isEmptyRange = y2 - y1 <= 2;
        if (!isEmptyRange) {
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
            if (mode.border != DiffDrawUtil.BorderType.NONE && !alignedSides) {
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1, color3, false, dottedLine);
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y2 - 1, color3, false, dottedLine);
            }
        } else if (!alignedSides) {
            DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1 - 1, color3, true, dottedLine);
        }
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter myHighlighter, @NotNull TextDiffType myDiffType, @NotNull DiffDrawUtil.PaintMode myEditorMode, @NotNull DiffDrawUtil.PaintMode myGutterMode, boolean myHideWithoutLineNumbers, boolean myEmptyRange, boolean myFirstLine, boolean myLastLine, boolean alignedSides) {
        Intrinsics.checkNotNullParameter((Object)myHighlighter, (String)"myHighlighter");
        Intrinsics.checkNotNullParameter((Object)myDiffType, (String)"myDiffType");
        Intrinsics.checkNotNullParameter((Object)myEditorMode, (String)"myEditorMode");
        Intrinsics.checkNotNullParameter((Object)myGutterMode, (String)"myGutterMode");
        this.myHighlighter = myHighlighter;
        this.myDiffType = myDiffType;
        this.myEditorMode = myEditorMode;
        this.myGutterMode = myGutterMode;
        this.myHideWithoutLineNumbers = myHideWithoutLineNumbers;
        this.myEmptyRange = myEmptyRange;
        this.myFirstLine = myFirstLine;
        this.myLastLine = myLastLine;
        this.alignedSides = alignedSides;
    }
}

