/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.diff.DiffTool;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonMergeUtil;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.impl.DiffToolSubstitutor;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffEditorHighlighterUpdater;
import com.intellij.diff.util.DiffNotificationProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.SyncHeightComponent;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.LineNumberConverterAdapter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.MathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.PlatformDiffImplIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.IntUnaryOperator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    public static final Key<Boolean> TEMP_FILE_KEY = Key.create((String)"Diff.TempFile");
    @NotNull
    @NonNls
    public static final String DIFF_CONFIG = "diff.xml";
    public static final JBValue TITLE_GAP = new JBValue.Float(2.0f);
    public static final NotNullLazyValue<List<Image>> DIFF_FRAME_ICONS = NotNullLazyValue.createValue(() -> Arrays.asList(DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame32), DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame64), DiffUtil.iconToImage(PlatformDiffImplIcons.Diff_frame128)));

    private static Image iconToImage(@NotNull Icon icon2) {
        if (icon2 == null) {
            DiffUtil.$$$reportNull$$$0(0);
        }
        return ((IconLoader.CachedImageIcon)icon2).getRealIcon().getImage();
    }

    public static boolean isDiffEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(1);
        }
        return editor2.getEditorKind() == EditorKind.DIFF;
    }

    public static boolean isFileWithoutContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DiffUtil.$$$reportNull$$$0(2);
        }
        if (file2 instanceof VirtualFileWithoutContent) {
            return true;
        }
        return file2 instanceof DiffVirtualFile;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content2, @NotNull CharSequence text2) {
        EditorHighlighter highlighter;
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(4);
        }
        if ((highlighter = DiffUtil.createEditorHighlighter(project, content2)) == null) {
            return null;
        }
        highlighter.setText(text2);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text2) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(5);
        }
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text2);
        EditorHighlighter editorHighlighter = highlighter;
        if (editorHighlighter == null) {
            DiffUtil.$$$reportNull$$$0(6);
        }
        return editorHighlighter;
    }

    @Nullable
    public static EditorHighlighter createEditorHighlighter(@Nullable Project project, @NotNull DocumentContent content2) {
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(7);
        }
        FileType type = content2.getContentType();
        VirtualFile file2 = content2.getHighlightFile();
        Language language2 = (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language2 != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language2, (Project)project, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && file2.isValid() && (type == null || type == PlainTextFileType.INSTANCE || FileTypeRegistry.getInstance().isFileOfType(file2, type) || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project, file2);
        }
        if (type != null) {
            return highlighterFactory.createEditorHighlighter(project, type);
        }
        return null;
    }

    @NotNull
    public static EditorHighlighter createEmptyEditorHighlighter() {
        return new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
    }

    public static void setEditorHighlighter(@Nullable Project project, @NotNull EditorEx editor2, @NotNull DocumentContent content2) {
        EditorHighlighter highlighter;
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(9);
        }
        if ((highlighter = DiffUtil.createEditorHighlighter(project, content2)) != null) {
            editor2.setHighlighter(highlighter);
        }
        if (project != null) {
            new DiffEditorHighlighterUpdater(project, ((EditorImpl)editor2).getDisposable(), editor2, content2);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project, @NotNull EditorEx editor2, @Nullable DocumentContent content2) {
        Language language2;
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(10);
        }
        if (project != null && content2 != null && editor2.getVirtualFile() == null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(content2.getDocument());
            CommonCodeStyleSettings.IndentOptions indentOptions = psiFile != null ? CodeStyle.getSettings((PsiFile)psiFile).getIndentOptionsByFile(psiFile) : CodeStyle.getSettings((Project)project).getIndentOptions(content2.getContentType());
            editor2.getSettings().setTabSize(indentOptions.TAB_SIZE);
            editor2.getSettings().setUseTabCharacter(indentOptions.USE_TAB_CHARACTER);
        }
        Language language3 = language2 = content2 != null ? (Language)content2.getUserData(DiffUserDataKeys.LANGUAGE) : null;
        if (language2 != null) {
            editor2.getSettings().setLanguageSupplier(() -> language2);
        } else if (editor2.getProject() != null) {
            editor2.getSettings().setLanguageSupplier(() -> TextEditorImpl.getDocumentLanguage(editor2));
        }
        editor2.getSettings().setCaretRowShown(false);
        editor2.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(11);
        }
        editor2.getSettings().setFoldingOutlineShown(true);
        editor2.getSettings().setAutoCodeFoldingEnabled(false);
        editor2.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(12);
        }
        return DiffUtil.createEditor(document, project, isViewer, false);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project, boolean isViewer, boolean enableFolding) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(13);
        }
        EditorFactory factory2 = EditorFactory.getInstance();
        EditorKind kind = EditorKind.DIFF;
        EditorEx editor2 = (EditorEx)(isViewer ? factory2.createViewer(document, project, kind) : factory2.createEditor(document, project, kind));
        editor2.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor2.getMarkupModel())).setErrorStripeVisible(true);
        editor2.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor2);
        } else {
            editor2.getSettings().setFoldingOutlineShown(false);
            editor2.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor2.getComponent());
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            DiffUtil.$$$reportNull$$$0(14);
        }
        return editorEx;
    }

    public static void configureEditor(@NotNull EditorEx editor2, @NotNull DocumentContent content2, @Nullable Project project) {
        VirtualFile virtualFile2;
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(15);
        }
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(16);
        }
        if ((virtualFile2 = FileDocumentManager.getInstance().getFile(content2.getDocument())) != null) {
            editor2.setFile(virtualFile2);
        }
        DiffUtil.setEditorHighlighter(project, editor2, content2);
        DiffUtil.setEditorCodeStyle(project, editor2, content2);
    }

    public static boolean isMirrored(@NotNull Editor editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(17);
        }
        if (editor2 instanceof EditorEx) {
            return ((EditorEx)editor2).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project == null || project.isDefault()) {
            return false;
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        if (OutsidersPsiFileSupport.isOutsiderFile(file2)) {
            return false;
        }
        return file2.getUserData(TEMP_FILE_KEY) != Boolean.TRUE;
    }

    public static void installLineConvertor(@NotNull EditorEx editor2, @NotNull FoldingModelSupport foldingSupport) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(18);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(19);
        }
        assert (foldingSupport.getCount() == 1);
        IntUnaryOperator foldingLineConvertor = foldingSupport.getLineConvertor(0);
        editor2.getGutter().setLineNumberConverter((LineNumberConverter)new LineNumberConverterAdapter(foldingLineConvertor));
    }

    public static void installLineConvertor(@NotNull EditorEx editor2, @NotNull DocumentContent content2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(20);
        }
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(21);
        }
        IntUnaryOperator contentLineConvertor = DiffUtil.getContentLineConvertor(content2);
        editor2.getGutter().setLineNumberConverter((LineNumberConverter)(contentLineConvertor == null ? LineNumberConverter.DEFAULT : new LineNumberConverterAdapter(contentLineConvertor)));
    }

    public static void installLineConvertor(@NotNull EditorEx editor2, @Nullable DocumentContent content2, @NotNull FoldingModelSupport foldingSupport, int editorIndex) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(22);
        }
        if (foldingSupport == null) {
            DiffUtil.$$$reportNull$$$0(23);
        }
        IntUnaryOperator contentLineConvertor = content2 != null ? DiffUtil.getContentLineConvertor(content2) : null;
        IntUnaryOperator foldingLineConvertor = foldingSupport.getLineConvertor(editorIndex);
        IntUnaryOperator merged = DiffUtil.mergeLineConverters(contentLineConvertor, foldingLineConvertor);
        editor2.getGutter().setLineNumberConverter((LineNumberConverter)(merged == null ? LineNumberConverter.DEFAULT : new LineNumberConverterAdapter(merged)));
    }

    @Nullable
    public static IntUnaryOperator getContentLineConvertor(@NotNull DocumentContent content2) {
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(24);
        }
        return (IntUnaryOperator)content2.getUserData(DiffUserDataKeysEx.LINE_NUMBER_CONVERTOR);
    }

    @Nullable
    public static IntUnaryOperator mergeLineConverters(@Nullable IntUnaryOperator convertor1, @Nullable IntUnaryOperator convertor2) {
        if (convertor1 == null && convertor2 == null) {
            return null;
        }
        if (convertor1 == null) {
            return convertor2;
        }
        if (convertor2 == null) {
            return convertor1;
        }
        return value2 -> {
            int value22 = convertor2.applyAsInt(value2);
            return value22 >= 0 ? convertor1.applyAsInt(value22) : value22;
        };
    }

    public static void disableBlitting(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(25);
        }
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor2.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor2, int line) {
        if (editor2 == null) {
            return;
        }
        editor2.getSelectionModel().removeSelection();
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor2, int line, boolean animated) {
        DiffUtil.scrollEditor(editor2, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor2, int line, int column2, boolean animated) {
        if (editor2 == null) {
            return;
        }
        editor2.getSelectionModel().removeSelection();
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column2));
        DiffUtil.scrollToCaret(editor2, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor2, @NotNull Point point, boolean animated) {
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(26);
        }
        if (editor2 == null) {
            return;
        }
        if (!animated) {
            editor2.getScrollingModel().disableAnimation();
        }
        editor2.getScrollingModel().scrollHorizontally(point.x);
        editor2.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor2.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor2, boolean animated) {
        if (editor2 == null) {
            return;
        }
        if (!animated) {
            editor2.getScrollingModel().disableAnimation();
        }
        editor2.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor2.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor2) {
        if (editor2 == null) {
            return new Point(0, 0);
        }
        ScrollingModel model2 = editor2.getScrollingModel();
        return new Point(model2.getHorizontalScrollOffset(), model2.getVerticalScrollOffset());
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor2) {
        return editor2 != null ? editor2.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
    }

    public static void moveCaretToLineRangeIfNeeded(@NotNull Editor editor2, int startLine, int endLine) {
        int caretLine;
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(27);
        }
        if (!DiffUtil.isSelectedByLine(caretLine = editor2.getCaretModel().getLogicalPosition().line, startLine, endLine)) {
            editor2.getSelectionModel().removeSelection();
            editor2.getCaretModel().moveToLogicalPosition(new LogicalPosition(startLine, 0));
        }
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(28);
        }
        Icon icon2 = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
        if (icon2 == null) {
            DiffUtil.$$$reportNull$$$0(29);
        }
        return icon2;
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        if (sourceSide == null) {
            DiffUtil.$$$reportNull$$$0(30);
        }
        Icon icon2 = (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
        if (icon2 == null) {
            DiffUtil.$$$reportNull$$$0(31);
        }
        return icon2;
    }

    public static boolean isFromShortcut(@NotNull AnActionEvent e) {
        String place;
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(32);
        }
        return "keyboard shortcut".equals(place = e.getPlace()) || "mouse shortcut".equals(place);
    }

    public static void registerAction(@NotNull AnAction action2, @NotNull JComponent component2) {
        if (action2 == null) {
            DiffUtil.$$$reportNull$$$0(33);
        }
        if (component2 == null) {
            DiffUtil.$$$reportNull$$$0(34);
        }
        action2.registerCustomShortcutSet(action2.getShortcutSet(), component2);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull @Nls String message2) {
        if (message2 == null) {
            DiffUtil.$$$reportNull$$$0(35);
        }
        String text2 = StringUtil.replace((String)message2, (String)"\n", (String)"<br/>");
        JBLabel label2 = new JBLabel(text2){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        return DiffUtil.createMessagePanel((JComponent)label2);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull JComponent label2) {
        if (label2 == null) {
            DiffUtil.$$$reportNull$$$0(36);
        }
        JBColor commentFg = new JBColor(() -> {
            EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes commentAttributes = scheme2.getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
            if (commentAttributes.getForegroundColor() != null && commentAttributes.getBackgroundColor() == null) {
                return commentAttributes.getForegroundColor();
            }
            return scheme2.getDefaultForeground();
        });
        label2.setForeground((Color)commentFg);
        JPanel panel2 = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        panel2.setBorder(JBUI.Borders.empty((int)5));
        panel2.setBackground((Color)new JBColor(() -> EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()));
        panel2.add(label2);
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            DiffUtil.$$$reportNull$$$0(37);
        }
        return jPanel2;
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group2, AnAction ... actions2) {
        if (group2 == null) {
            DiffUtil.$$$reportNull$$$0(38);
        }
        DiffUtil.addActionBlock(group2, Arrays.asList(actions2));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group2, @Nullable List<? extends AnAction> actions2) {
        if (group2 == null) {
            DiffUtil.$$$reportNull$$$0(39);
        }
        if (actions2 == null || actions2.isEmpty()) {
            return;
        }
        group2.addSeparator();
        Object[] children2 = group2.getChildren(null);
        for (AnAction anAction2 : actions2) {
            if (!(anAction2 instanceof Separator) && ArrayUtil.contains((Object)anAction2, (Object[])children2)) continue;
            group2.add(anAction2);
        }
    }

    @Nls
    @NotNull
    public static String getSettingsConfigurablePath() {
        String string = SystemInfo.isMac ? DiffBundle.message((String)"label.diff.settings.path.macos", (Object[])new Object[0]) : DiffBundle.message((String)"label.diff.settings.path", (Object[])new Object[0]);
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @NotNull
    public static String createTooltipText(@NotNull @NlsContexts.Tooltip String text2, @Nullable @Nls String appendix) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(41);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(text2);
        if (appendix != null) {
            result2.br();
            result2.append((HtmlChunk)HtmlChunk.div((String)"margin-top:5px; font-size:small").addText(appendix));
        }
        String string = result2.wrapWithHtmlBody().toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String createNotificationText(@NotNull @Nls String text2, @Nullable @Nls String appendix) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(43);
        }
        HtmlBuilder result2 = new HtmlBuilder();
        result2.append(text2);
        if (appendix != null) {
            result2.br();
            result2.append((HtmlChunk)HtmlChunk.span((String)("color:#" + ColorUtil.toHex((Color)JBColor.gray) + "; font-size:small")).addText(appendix));
        }
        String string = result2.wrapWithHtmlBody().toString();
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    public static void showSuccessPopup(@NotNull @NlsContexts.PopupContent String message2, @NotNull RelativePoint point, @NotNull Disposable disposable2, final @Nullable Runnable hyperlinkHandler) {
        if (message2 == null) {
            DiffUtil.$$$reportNull$$$0(45);
        }
        if (point == null) {
            DiffUtil.$$$reportNull$$$0(46);
        }
        if (disposable2 == null) {
            DiffUtil.$$$reportNull$$$0(47);
        }
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon2 = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon2.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable2, (Disposable)balloon2);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<JComponent> createSimpleTitles(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull ContentDiffRequest request2) {
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(48);
        }
        List contents = request2.getContents();
        @Nls List titles = request2.getContentTitles();
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        List diffTitleCustomizers = (List)request2.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title2 = DiffUtil.createTitle((String)titles.get(i2), diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i2) : null);
            title2 = DiffUtil.createTitleWithNotifications(viewer, title2, (DiffContent)contents.get(i2));
            components.add(title2);
        }
        ArrayList<JComponent> arrayList = components;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static List<JComponent> createTextTitles(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull ContentDiffRequest request2, @NotNull List<? extends Editor> editors2) {
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(50);
        }
        if (editors2 == null) {
            DiffUtil.$$$reportNull$$$0(51);
        }
        List contents = request2.getContents();
        @Nls List titles = request2.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        List diffTitleCustomizers = (List)request2.getUserData(DiffUserDataKeysEx.EDITORS_TITLE_CUSTOMIZER);
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title2 = DiffUtil.createTitle((String)titles.get(i2), (DiffContent)contents.get(i2), equalCharsets, equalSeparators, editors2.get(i2), diffTitleCustomizers != null ? (DiffEditorTitleCustomizer)diffTitleCustomizers.get(i2) : null);
            title2 = DiffUtil.createTitleWithNotifications(viewer, title2, (DiffContent)contents.get(i2));
            result2.add(title2);
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @Nullable JComponent title2, @NotNull DiffContent content2) {
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(53);
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (title2 != null) {
            components.add(title2);
        }
        components.addAll(DiffUtil.createCustomNotifications(viewer, content2));
        if (content2 instanceof DocumentContent) {
            Document document = ((DocumentContent)content2).getDocument();
            if (FileDocumentManager.getInstance().isPartialPreviewOfALargeFile(document)) {
                components.add(DiffNotifications.createNotification(DiffBundle.message((String)"error.file.is.too.large.only.preview.is.loaded", (Object[])new Object[0])));
            }
        }
        if (components.isEmpty()) {
            return null;
        }
        return DiffUtil.createStackedComponents(components, TITLE_GAP);
    }

    @Nullable
    private static JComponent createTitle(@Nullable @NlsContexts.Label String title2, @NotNull DiffContent content2, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor2, @Nullable DiffEditorTitleCustomizer titleCustomizer2) {
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(54);
        }
        if (content2 instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content2;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator2 = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor2 == null || editor2.isViewer() || !DiffUtil.canMakeWritable(editor2.getDocument());
        return DiffUtil.createTitle(title2, separator2, charset, bom, isReadOnly, titleCustomizer2);
    }

    @NotNull
    public static JComponent createTitle(@Nullable @NlsContexts.Label String title2) {
        return DiffUtil.createTitle(title2, null, null, null, false, null);
    }

    @NotNull
    public static JComponent createTitle(@Nullable @NlsContexts.Label String title2, @Nullable DiffEditorTitleCustomizer titleCustomizer2) {
        return DiffUtil.createTitle(title2, null, null, null, false, titleCustomizer2);
    }

    @NotNull
    public static JComponent createTitle(@Nullable @NlsContexts.Label String title2, @Nullable LineSeparator separator2, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly, @Nullable DiffEditorTitleCustomizer titleCustomizer2) {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        BorderLayoutPanel labelWithIcon = new BorderLayoutPanel();
        JComponent titleLabel = titleCustomizer2 != null ? titleCustomizer2.getLabel() : new JBLabel(StringUtil.notNullize((String)title2)).setCopyable(true);
        labelWithIcon.addToCenter((Component)titleLabel);
        if (readOnly) {
            labelWithIcon.addToLeft((Component)new JBLabel(AllIcons.Ide.Readonly));
        }
        panel2.add((Component)labelWithIcon, "Center");
        if (charset != null || separator2 != null) {
            JPanel panel22 = new JPanel();
            panel22.setLayout(new BoxLayout(panel22, 0));
            if (charset != null) {
                panel22.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel22.add(DiffUtil.createCharsetPanel(charset, bom));
            }
            if (separator2 != null) {
                panel22.add(Box.createRigidArea((Dimension)JBUI.size((int)4, (int)0)));
                panel22.add(DiffUtil.createSeparatorPanel(separator2));
            }
            panel2.add((Component)panel22, "East");
        }
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            DiffUtil.$$$reportNull$$$0(55);
        }
        return jPanel2;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        if (charset == null) {
            DiffUtil.$$$reportNull$$$0(56);
        }
        String text2 = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text2 = DiffBundle.message((String)"diff.utf.charset.name.bom.suffix", (Object[])new Object[]{text2});
        }
        JLabel label2 = new JLabel(text2);
        if (charset.equals(StandardCharsets.UTF_8)) {
            label2.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(StandardCharsets.ISO_8859_1)) {
            label2.setForeground((Color)JBColor.RED);
        } else {
            label2.setForeground((Color)JBColor.BLACK);
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(57);
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator2) {
        if (separator2 == null) {
            DiffUtil.$$$reportNull$$$0(58);
        }
        JLabel label2 = new JLabel(separator2.toString());
        Object color = separator2 == LineSeparator.CRLF ? JBColor.RED : (separator2 == LineSeparator.LF ? JBColor.BLUE : (separator2 == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label2.setForeground((Color)color);
        JLabel jLabel = label2;
        if (jLabel == null) {
            DiffUtil.$$$reportNull$$$0(59);
        }
        return jLabel;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(60);
        }
        if (!ContainerUtil.exists(components, (Condition)Conditions.notNull())) {
            List<JComponent> list2 = components;
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(61);
            }
            return list2;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i2 = 0; i2 < components.size(); ++i2) {
            JComponent component2 = components.get(i2);
            result2.add(new SyncHeightComponent(components, component2));
        }
        ArrayList<JComponent> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<? extends JComponent> components, @NotNull JBValue vGap) {
        if (components == null) {
            DiffUtil.$$$reportNull$$$0(63);
        }
        if (vGap == null) {
            DiffUtil.$$$reportNull$$$0(64);
        }
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(vGap, -1));
        for (JComponent jComponent : components) {
            panel2.add(jComponent);
        }
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            DiffUtil.$$$reportNull$$$0(65);
        }
        return jPanel2;
    }

    @Nls
    @NotNull
    public static String getStatusText(int totalCount, int excludedCount, @NotNull ThreeState isContentsEqual) {
        if (isContentsEqual == null) {
            DiffUtil.$$$reportNull$$$0(66);
        }
        if (totalCount == 0 && isContentsEqual == ThreeState.NO) {
            String string = DiffBundle.message((String)"diff.all.differences.ignored.text", (Object[])new Object[0]);
            if (string == null) {
                DiffUtil.$$$reportNull$$$0(67);
            }
            return string;
        }
        Object message2 = DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{totalCount - excludedCount});
        if (excludedCount > 0) {
            message2 = (String)message2 + " " + DiffBundle.message((String)"diff.inactive.count.differences.status.text", (Object[])new Object[]{excludedCount});
        }
        String string = message2;
        if (string == null) {
            DiffUtil.$$$reportNull$$$0(68);
        }
        return string;
    }

    public static boolean isFocusedComponent(@Nullable Component component2) {
        return DiffUtil.isFocusedComponent(null, component2);
    }

    public static boolean isFocusedComponent(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Component ideFocusOwner = IdeFocusManager.getInstance((Project)project).getFocusOwner();
        if (ideFocusOwner != null && SwingUtilities.isDescendingFrom(ideFocusOwner, component2)) {
            return true;
        }
        Component jdkFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return jdkFocusOwner != null && SwingUtilities.isDescendingFrom(jdkFocusOwner, component2);
    }

    public static void requestFocus(@Nullable Project project, @Nullable Component component2) {
        if (component2 == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project).requestFocus(component2, true);
    }

    public static boolean isFocusedComponentInWindow(@Nullable Component component2) {
        if (component2 == null) {
            return false;
        }
        Window window = ComponentUtil.getWindow((Component)component2);
        if (window == null) {
            return false;
        }
        Component windowFocusOwner = window.getMostRecentFocusOwner();
        return windowFocusOwner != null && SwingUtilities.isDescendingFrom(windowFocusOwner, component2);
    }

    public static void requestFocusInWindow(@Nullable Component component2) {
        if (component2 != null) {
            component2.requestFocusInWindow();
        }
    }

    public static void runPreservingFocus(@NotNull FocusableContext context2, @NotNull Runnable task2) {
        if (context2 == null) {
            DiffUtil.$$$reportNull$$$0(69);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(70);
        }
        boolean hadFocus = context2.isFocusedInWindow();
        task2.run();
        if (hadFocus) {
            context2.requestFocusInWindow();
        }
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(71);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(72);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(73);
        }
        if (disposable2 == null) {
            DiffUtil.$$$reportNull$$$0(74);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            return new SimpleTextDiffProvider(settings, rediff, disposable2, diffComputer);
        }
        TwosideTextDiffProvider smartProvider = SmartTextDiffProvider.create(project, request2, settings, rediff, disposable2);
        if (smartProvider != null) {
            TwosideTextDiffProvider twosideTextDiffProvider = smartProvider;
            if (twosideTextDiffProvider == null) {
                DiffUtil.$$$reportNull$$$0(75);
            }
            return twosideTextDiffProvider;
        }
        return new SimpleTextDiffProvider(settings, rediff, disposable2);
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project, @NotNull ContentDiffRequest request2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        DiffUserDataKeysEx.DiffComputer diffComputer;
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(76);
        }
        if (settings == null) {
            DiffUtil.$$$reportNull$$$0(77);
        }
        if (rediff == null) {
            DiffUtil.$$$reportNull$$$0(78);
        }
        if (disposable2 == null) {
            DiffUtil.$$$reportNull$$$0(79);
        }
        if ((diffComputer = (DiffUserDataKeysEx.DiffComputer)request2.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER)) != null) {
            return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable2, diffComputer);
        }
        TwosideTextDiffProvider.NoIgnore smartProvider = SmartTextDiffProvider.createNoIgnore(project, request2, settings, rediff, disposable2);
        if (smartProvider != null) {
            TwosideTextDiffProvider.NoIgnore noIgnore = smartProvider;
            if (noIgnore == null) {
                DiffUtil.$$$reportNull$$$0(80);
            }
            return noIgnore;
        }
        return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable2);
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<? extends CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator2) {
        if (chunks == null) {
            DiffUtil.$$$reportNull$$$0(81);
        }
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(82);
        }
        if (indicator2 == null) {
            DiffUtil.$$$reportNull$$$0(83);
        }
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator2);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator2);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator2);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment2 -> new TextRange(fragment2.getStartOffset1(), fragment2.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment2 -> new TextRange(fragment2.getStartOffset2(), fragment2.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            DiffUtil.$$$reportNull$$$0(84);
        }
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonUtil.isEquals(chunk1, chunk2, comparisonPolicy);
    }

    public static <T> int @NotNull [] getSortedIndexes(@NotNull List<? extends T> values2, @NotNull Comparator<? super T> comparator2) {
        if (values2 == null) {
            DiffUtil.$$$reportNull$$$0(85);
        }
        if (comparator2 == null) {
            DiffUtil.$$$reportNull$$$0(86);
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>(values2.size());
        for (int i3 = 0; i3 < values2.size(); ++i3) {
            indexes.add(i3);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            Object val1 = values2.get((int)i1);
            Object val2 = values2.get((int)i2);
            return comparator2.compare((Object)val1, (Object)val2);
        });
        int[] nArray = ArrayUtil.toIntArray(indexes);
        if (nArray == null) {
            DiffUtil.$$$reportNull$$$0(87);
        }
        return nArray;
    }

    public static int @NotNull [] invertIndexes(int @NotNull [] indexes) {
        if (indexes == null) {
            DiffUtil.$$$reportNull$$$0(88);
        }
        int[] inverted = new int[indexes.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            inverted[indexes[i2]] = i2;
        }
        if (inverted == null) {
            DiffUtil.$$$reportNull$$$0(89);
        }
        return inverted;
    }

    public static boolean compareStreams(@NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream1, @NotNull ThrowableComputable<? extends InputStream, ? extends IOException> stream2) throws IOException {
        if (stream1 == null) {
            DiffUtil.$$$reportNull$$$0(90);
        }
        if (stream2 == null) {
            DiffUtil.$$$reportNull$$$0(91);
        }
        int i2 = 0;
        try (InputStream s1 = (InputStream)stream1.compute();
             InputStream s2 = (InputStream)stream2.compute();){
            if (s1 == null && s2 == null) {
                boolean bl = true;
                return bl;
            }
            if (s1 == null || s2 == null) {
                boolean bl = false;
                return bl;
            }
            while (true) {
                int b2;
                int b1;
                if ((b1 = s1.read()) != (b2 = s2.read())) {
                    boolean bl = false;
                    return bl;
                }
                if (b1 == -1) {
                    boolean bl = true;
                    return bl;
                }
                if (i2++ % 10000 != 0) continue;
                ProgressManager.checkCanceled();
            }
        }
    }

    @NotNull
    public static InputStream getFileInputStream(@NotNull VirtualFile file2) throws IOException {
        VirtualFileSystem fs;
        if (file2 == null) {
            DiffUtil.$$$reportNull$$$0(92);
        }
        if ((fs = file2.getFileSystem()) instanceof FileSystemInterface) {
            InputStream inputStream2 = ((FileSystemInterface)fs).getInputStream(file2);
            if (inputStream2 == null) {
                DiffUtil.$$$reportNull$$$0(93);
            }
            return inputStream2;
        }
        byte[] content2 = (byte[])ReadAction.compute(() -> file2.contentsToByteArray());
        return new ByteArrayInputStream(content2);
    }

    public static boolean isSomeRangeSelected(@NotNull Editor editor2, @NotNull Condition<? super BitSet> condition) {
        List carets;
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(94);
        }
        if (condition == null) {
            DiffUtil.$$$reportNull$$$0(95);
        }
        if ((carets = editor2.getCaretModel().getAllCarets()).size() != 1) {
            return true;
        }
        Caret caret = (Caret)carets.get(0);
        if (caret.hasSelection()) {
            return true;
        }
        return condition.value((Object)DiffUtil.getSelectedLines(editor2));
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(96);
        }
        Document document = editor2.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines2 = new BitSet(totalLines + 1);
        for (Caret caret : editor2.getCaretModel().getAllCarets()) {
            DiffUtil.appendSelectedLines(editor2, lines2, caret);
        }
        BitSet bitSet = lines2;
        if (bitSet == null) {
            DiffUtil.$$$reportNull$$$0(97);
        }
        return bitSet;
    }

    private static void appendSelectedLines(@NotNull Editor editor2, @NotNull BitSet lines2, @NotNull Caret caret) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(98);
        }
        if (lines2 == null) {
            DiffUtil.$$$reportNull$$$0(99);
        }
        if (caret == null) {
            DiffUtil.$$$reportNull$$$0(100);
        }
        Document document = editor2.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        if (caret.hasSelection()) {
            int line1 = editor2.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
            int line2 = editor2.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
            lines2.set(line1, line2 + 1);
            if (caret.getSelectionEnd() == document.getTextLength()) {
                lines2.set(totalLines);
            }
        } else {
            int offset = caret.getOffset();
            VisualPosition visualPosition = caret.getVisualPosition();
            Pair<LogicalPosition, LogicalPosition> pair = EditorUtil.calcSurroundingRange(editor2, visualPosition, visualPosition);
            lines2.set(((LogicalPosition)pair.first).line, Math.max(((LogicalPosition)pair.second).line, ((LogicalPosition)pair.first).line + 1));
            if (offset == document.getTextLength()) {
                lines2.set(totalLines);
            }
        }
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected2, int line1, int line2) {
        if (selected2 == null) {
            DiffUtil.$$$reportNull$$$0(101);
        }
        if (line1 == line2) {
            return selected2.get(line1);
        }
        int next = selected2.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(102);
        }
        TextRange range2 = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range2.getStartOffset();
        int offset2 = range2.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(103);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(104);
        }
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text2));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text2 + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(105);
        }
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(106);
        }
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text2);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(107);
        }
        if (newLines == null) {
            DiffUtil.$$$reportNull$$$0(108);
        }
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (document1 == null) {
            DiffUtil.$$$reportNull$$$0(109);
        }
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(110);
        }
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    public static String applyModification(final @NotNull CharSequence text2, final @NotNull LineOffsets lineOffsets, final @NotNull CharSequence otherText, final @NotNull LineOffsets otherLineOffsets, final @NotNull List<? extends Range> ranges) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(111);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(112);
        }
        if (otherText == null) {
            DiffUtil.$$$reportNull$$$0(113);
        }
        if (otherLineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(114);
        }
        if (ranges == null) {
            DiffUtil.$$$reportNull$$$0(115);
        }
        return new Object(){
            private final StringBuilder stringBuilder = new StringBuilder();
            private boolean isEmpty = true;

            @NotNull
            public String execute() {
                int lastLine = 0;
                for (Range range2 : ranges) {
                    CharSequence newChunkContent = DiffUtil.getLinesContent(otherText, otherLineOffsets, range2.start2, range2.end2);
                    this.appendOriginal(lastLine, range2.start1);
                    this.append(newChunkContent, range2.end2 - range2.start2);
                    lastLine = range2.end1;
                }
                this.appendOriginal(lastLine, lineOffsets.getLineCount());
                String string = this.stringBuilder.toString();
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private void appendOriginal(int start2, int end) {
                this.append(DiffUtil.getLinesContent(text2, lineOffsets, start2, end), end - start2);
            }

            private void append(CharSequence content2, int lineCount) {
                if (lineCount > 0 && !this.isEmpty) {
                    this.stringBuilder.append('\n');
                }
                this.stringBuilder.append(content2);
                this.isEmpty &= lineCount == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffUtil$3", "execute"));
            }
        }.execute();
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(116);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(117);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2, boolean includeNewLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(118);
        }
        CharSequence charSequence = DiffUtil.getLinesRange(document, line1, line2, includeNewLine).subSequence(document.getImmutableCharSequence());
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(119);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        if (sequence == null) {
            DiffUtil.$$$reportNull$$$0(120);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(121);
        }
        return DiffUtil.getLinesContent(sequence, lineOffsets, line1, line2, false);
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (sequence == null) {
            DiffUtil.$$$reportNull$$$0(122);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(123);
        }
        assert (sequence.length() == lineOffsets.getTextLength());
        CharSequence charSequence = DiffUtil.getLinesRange(lineOffsets, line1, line2, includeNewline).subSequence(sequence);
        if (charSequence == null) {
            DiffUtil.$$$reportNull$$$0(124);
        }
        return charSequence;
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(125);
        }
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(126);
        }
        return DiffUtil.getLinesRange(LineOffsetsUtil.create(document), line1, line2, includeNewline);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(127);
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getOffset(@NotNull Document document, int line, int column2) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(128);
        }
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start2 + column2, end);
    }

    public static int getLineCount(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(129);
        }
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(130);
        }
        return DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text2, @NonNls LineOffsets lineOffsets) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(131);
        }
        return DiffUtil.getLines(text2, lineOffsets, 0, lineOffsets.getLineCount());
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(132);
        }
        return DiffUtil.getLines(document.getCharsSequence(), LineOffsetsUtil.create(document), startLine, endLine);
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text2, @NonNls LineOffsets lineOffsets, int startLine, int endLine) {
        if (text2 == null) {
            DiffUtil.$$$reportNull$$$0(133);
        }
        if (startLine < 0 || startLine > endLine || endLine > lineOffsets.getLineCount()) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, lineOffsets.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = startLine; i2 < endLine; ++i2) {
            int start2 = lineOffsets.getLineStart(i2);
            int end = lineOffsets.getLineEnd(i2);
            result2.add(text2.subSequence(start2, end).toString());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            DiffUtil.$$$reportNull$$$0(134);
        }
        return arrayList;
    }

    public static int bound(int value2, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value2, lowerBound, upperBound);
        return MathUtil.clamp((int)value2, (int)lowerBound, (int)upperBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(135);
        }
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        return new LineRange(line1, line2);
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        if (e == null) {
            DiffUtil.$$$reportNull$$$0(136);
        }
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift) {
        return DiffUtil.updateRangeOnModification(start2, end, changeStart, changeEnd, shift, false);
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start2, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            return new UpdatedLineRange(start2, end, false);
        }
        if (start2 >= changeEnd) {
            return new UpdatedLineRange(start2 + shift, end + shift, false);
        }
        if (start2 <= changeStart && end >= changeEnd) {
            return new UpdatedLineRange(start2, end + shift, false);
        }
        int newChangeEnd = changeEnd + shift;
        if (start2 >= changeStart && end <= changeEnd) {
            return greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
        }
        if (start2 < changeStart) {
            return greedy ? new UpdatedLineRange(start2, newChangeEnd, true) : new UpdatedLineRange(start2, changeStart, true);
        }
        return greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment2) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(137);
        }
        boolean left = fragment2.getStartLine1() != fragment2.getEndLine1();
        boolean right = fragment2.getStartLine2() != fragment2.getEndLine2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment2) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(138);
        }
        boolean left = fragment2.getEndOffset1() != fragment2.getStartOffset1();
        boolean right = fragment2.getEndOffset2() != fragment2.getStartOffset2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            TextDiffType textDiffType = TextDiffType.MODIFIED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(139);
            }
            return textDiffType;
        }
        if (hasDeleted) {
            TextDiffType textDiffType = TextDiffType.DELETED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(140);
            }
            return textDiffType;
        }
        if (hasInserted) {
            TextDiffType textDiffType = TextDiffType.INSERTED;
            if (textDiffType == null) {
                DiffUtil.$$$reportNull$$$0(141);
            }
            return textDiffType;
        }
        LOG.error("Diff fragment should not be empty");
        TextDiffType textDiffType = TextDiffType.MODIFIED;
        if (textDiffType == null) {
            DiffUtil.$$$reportNull$$$0(142);
        }
        return textDiffType;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<? super ThreeSide> emptiness, @NotNull BiPredicate<? super ThreeSide, ? super ThreeSide> equality, @Nullable BiPredicate<? super ThreeSide, ? super ThreeSide> trueEquality, @NotNull BooleanGetter conflictResolver) {
        if (emptiness == null) {
            DiffUtil.$$$reportNull$$$0(143);
        }
        if (equality == null) {
            DiffUtil.$$$reportNull$$$0(144);
        }
        if (conflictResolver == null) {
            DiffUtil.$$$reportNull$$$0(145);
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, true, false);
            }
            boolean equalModifications = equality.test((ThreeSide)ThreeSide.LEFT, (ThreeSide)ThreeSide.RIGHT);
            if (equalModifications) {
                return new MergeConflictType(TextDiffType.INSERTED, true, true);
            }
            return new MergeConflictType(TextDiffType.CONFLICT, true, true, false);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(TextDiffType.DELETED, true, true);
        }
        boolean unchangedLeft = equality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT);
        boolean unchangedRight = equality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT);
        if (unchangedLeft && unchangedRight) {
            assert (trueEquality != null);
            boolean trueUnchangedLeft = trueEquality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT);
            boolean trueUnchangedRight = trueEquality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT);
            assert (!trueUnchangedLeft || !trueUnchangedRight);
            return new MergeConflictType(TextDiffType.MODIFIED, !trueUnchangedLeft, !trueUnchangedRight);
        }
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
        }
        boolean equalModifications = equality.test((ThreeSide)ThreeSide.LEFT, (ThreeSide)ThreeSide.RIGHT);
        if (equalModifications) {
            return new MergeConflictType(TextDiffType.MODIFIED, true, true);
        }
        boolean canBeResolved = !isLeftEmpty && !isRightEmpty && conflictResolver.get();
        return new MergeConflictType(TextDiffType.CONFLICT, true, true, canBeResolved);
    }

    @NotNull
    public static MergeConflictType getLineThreeWayDiffType(@NotNull MergeLineFragment fragment2, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(146);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(147);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(148);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(149);
        }
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment2, side)), (side1, side2) -> DiffUtil.compareLineMergeContents(fragment2, sequences, lineOffsets, policy, side1, side2), null, () -> DiffUtil.canResolveLineConflict(fragment2, sequences, lineOffsets));
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment2, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(150);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(151);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(152);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(153);
        }
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment2, side)), (side1, side2) -> DiffUtil.compareLineMergeContents(fragment2, sequences, lineOffsets, policy, side1, side2), (side1, side2) -> DiffUtil.compareLineMergeContents(fragment2, sequences, lineOffsets, ComparisonPolicy.DEFAULT, side1, side2), () -> DiffUtil.canResolveLineConflict(fragment2, sequences, lineOffsets));
    }

    private static boolean canResolveLineConflict(@NotNull MergeLineFragment fragment2, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets) {
        List contents;
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(154);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(155);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(156);
        }
        return ComparisonMergeUtil.tryResolveConflict((CharSequence)(contents = ThreeSide.map(side -> DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), fragment2.getStartLine(side), fragment2.getEndLine(side)))).get(0), (CharSequence)contents.get(1), (CharSequence)contents.get(2)) != null;
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment2, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(157);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(158);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(159);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(160);
        }
        if (side1 == null) {
            DiffUtil.$$$reportNull$$$0(161);
        }
        if (side2 == null) {
            DiffUtil.$$$reportNull$$$0(162);
        }
        int start1 = fragment2.getStartLine(side1);
        int end1 = fragment2.getEndLine(side1);
        int start2 = fragment2.getStartLine(side2);
        int end2 = fragment2.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = (CharSequence)side1.select(sequences);
        CharSequence sequence2 = (CharSequence)side2.select(sequences);
        LineOffsets offsets1 = (LineOffsets)side1.select(lineOffsets);
        LineOffsets offsets2 = (LineOffsets)side2.select(lineOffsets);
        for (int i2 = 0; i2 < end1 - start1; ++i2) {
            CharSequence content2;
            int line1 = start1 + i2;
            int line2 = start2 + i2;
            CharSequence content1 = DiffUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            if (ComparisonUtil.isEquals(content1, content2 = DiffUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1), policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment2, @NotNull ThreeSide side) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(163);
        }
        if (side == null) {
            DiffUtil.$$$reportNull$$$0(164);
        }
        return fragment2.getStartLine(side) == fragment2.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment2, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(165);
        }
        if (texts == null) {
            DiffUtil.$$$reportNull$$$0(166);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(167);
        }
        return DiffUtil.getMergeType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isWordMergeIntervalEmpty(fragment2, side)), (side1, side2) -> DiffUtil.compareWordMergeContents(fragment2, texts, policy, side1, side2), null, BooleanGetter.FALSE);
    }

    public static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment2, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(168);
        }
        if (texts == null) {
            DiffUtil.$$$reportNull$$$0(169);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(170);
        }
        if (side1 == null) {
            DiffUtil.$$$reportNull$$$0(171);
        }
        if (side2 == null) {
            DiffUtil.$$$reportNull$$$0(172);
        }
        int start1 = fragment2.getStartOffset(side1);
        int end1 = fragment2.getEndOffset(side1);
        int start2 = fragment2.getStartOffset(side2);
        int end2 = fragment2.getEndOffset(side2);
        CharSequence document1 = (CharSequence)side1.select(texts);
        CharSequence document2 = (CharSequence)side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEquals(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment2, @NotNull ThreeSide side) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(173);
        }
        if (side == null) {
            DiffUtil.$$$reportNull$$$0(174);
        }
        return fragment2.getStartOffset(side) == fragment2.getEndOffset(side);
    }

    @NotNull
    public static MergeConflictType getLineLeftToRightThreeSideDiffType(@NotNull MergeLineFragment fragment2, @NotNull List<? extends CharSequence> sequences, @NotNull List<? extends LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        if (fragment2 == null) {
            DiffUtil.$$$reportNull$$$0(175);
        }
        if (sequences == null) {
            DiffUtil.$$$reportNull$$$0(176);
        }
        if (lineOffsets == null) {
            DiffUtil.$$$reportNull$$$0(177);
        }
        if (policy == null) {
            DiffUtil.$$$reportNull$$$0(178);
        }
        return DiffUtil.getLeftToRightDiffType((Condition<? super ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment2, side)), (side1, side2) -> DiffUtil.compareLineMergeContents(fragment2, sequences, lineOffsets, policy, side1, side2));
    }

    @NotNull
    private static MergeConflictType getLeftToRightDiffType(@NotNull Condition<? super ThreeSide> emptiness, @NotNull BiPredicate<? super ThreeSide, ? super ThreeSide> equality) {
        if (emptiness == null) {
            DiffUtil.$$$reportNull$$$0(179);
        }
        if (equality == null) {
            DiffUtil.$$$reportNull$$$0(180);
        }
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(TextDiffType.DELETED, true, false);
            }
            return new MergeConflictType(TextDiffType.MODIFIED, true, true);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(TextDiffType.MODIFIED, true, true);
        }
        boolean unchangedLeft = equality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.LEFT);
        boolean unchangedRight = equality.test((ThreeSide)ThreeSide.BASE, (ThreeSide)ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? TextDiffType.INSERTED : TextDiffType.MODIFIED, true, false);
        }
        return new MergeConflictType(TextDiffType.MODIFIED, true, true);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @Nullable @NlsContexts.Command String string, @Nullable String string2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean bl, @NotNull Runnable runnable2) {
        void underBulkUpdate;
        void commandGroupId;
        void commandName2;
        Project project2;
        void task2;
        void confirmationPolicy;
        void document2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(181);
        }
        if (confirmationPolicy == null) {
            DiffUtil.$$$reportNull$$$0(182);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(183);
        }
        return DiffUtil.executeWriteCommand(project2, (Document)document2, (String)commandName2, (String)commandGroupId, (UndoConfirmationPolicy)confirmationPolicy, (boolean)underBulkUpdate, true, (Runnable)task2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean executeWriteCommand(@Nullable Project project, @NotNull Document document, @Nullable @NlsContexts.Command String string, @Nullable String string2, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, boolean bl, boolean bl2, @NotNull Runnable runnable2) {
        void shouldRecordCommandForActiveDocument;
        void commandGroupId;
        void commandName2;
        void underBulkUpdate;
        Project project2;
        void task2;
        void confirmationPolicy;
        void document2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(184);
        }
        if (confirmationPolicy == null) {
            DiffUtil.$$$reportNull$$$0(185);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(186);
        }
        if (!DiffUtil.makeWritable(project2, (Document)document2)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile((Document)document2);
            LOG.warn("Document is read-only" + (String)(file2 != null ? ": " + file2.getPresentableName() : ""));
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> DiffUtil.lambda$executeWriteCommand$24(project2, (boolean)underBulkUpdate, (Document)document2, (Runnable)task2, (String)commandName2, (String)commandGroupId, (UndoConfirmationPolicy)confirmationPolicy, (boolean)shouldRecordCommandForActiveDocument));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project, @Nullable @Nls String string, @NotNull Runnable runnable2) {
        void commandName2;
        void project2;
        void task2;
        Document document2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(187);
        }
        if (task2 == null) {
            DiffUtil.$$$reportNull$$$0(188);
        }
        return DiffUtil.executeWriteCommand((Project)project2, document2, (String)commandName2, null, UndoConfirmationPolicy.DEFAULT, false, (Runnable)task2);
    }

    public static boolean isEditable(@NotNull Editor editor2) {
        if (editor2 == null) {
            DiffUtil.$$$reportNull$$$0(189);
        }
        return !editor2.isViewer() && DiffUtil.canMakeWritable(editor2.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(190);
        }
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            if (file2.getUserData(TEMP_FILE_KEY) == Boolean.TRUE) {
                return false;
            }
            return !file2.isWritable();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean makeWritable(@Nullable Project project, @NotNull Document document) {
        Project project2;
        VirtualFile file2;
        void document2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (document2 == null) {
            DiffUtil.$$$reportNull$$$0(191);
        }
        if ((file2 = FileDocumentManager.getInstance().getFile((Document)document2)) == null) {
            return document2.isWritable();
        }
        if (!file2.isValid()) {
            return false;
        }
        return DiffUtil.makeWritable(project2, file2) && document2.isWritable();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static boolean makeWritable(@Nullable Project project, @NotNull VirtualFile virtualFile2) {
        Project project2;
        void file2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (file2 == null) {
            DiffUtil.$$$reportNull$$$0(192);
        }
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(Collections.singletonList(file2)).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project, @NotNull Document document) {
        UndoManager undoManager;
        if (document == null) {
            DiffUtil.$$$reportNull$$$0(193);
        }
        UndoManager undoManager2 = undoManager = project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files2) {
        if (files2 == null) {
            DiffUtil.$$$reportNull$$$0(194);
        }
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files2);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files2);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        return new Dimension(400, 200);
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return new Dimension(width, height);
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints2) {
        WindowWrapper.Mode mode;
        if (hints2 == null) {
            DiffUtil.$$$reportNull$$$0(195);
        }
        if ((mode = hints2.getMode()) == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        WindowWrapper.Mode mode2 = mode;
        if (mode2 == null) {
            DiffUtil.$$$reportNull$$$0(196);
        }
        return mode2;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component2 = window;
        while (component2 != null && (!(component2 instanceof Window) || (isClosed = DiffUtil.closeWindow(component2, modalOnly)))) {
            component2 = recursive ? component2.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window == null) {
            DiffUtil.$$$reportNull$$$0(197);
        }
        if (window instanceof IdeFrameImpl || modalOnly && DiffUtil.canBeHiddenBehind(window)) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    private static boolean canBeHiddenBehind(@NotNull Window window) {
        if (window == null) {
            DiffUtil.$$$reportNull$$$0(198);
        }
        if (!(window instanceof Frame)) {
            return false;
        }
        if (SystemInfo.isMac && window instanceof IdeFrame) {
            Project project = ((IdeFrame)window).getProject();
            IdeFrame projectFrame = WindowManager.getInstance().getIdeFrame(project);
            if (projectFrame != null) {
                return !projectFrame.isInFullScreen();
            }
        }
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(199);
        }
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key, value2);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key, UserDataHolder ... holders) {
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(200);
        }
        for (UserDataHolder holder : holders) {
            Boolean data2;
            if (holder == null || (data2 = (Boolean)holder.getUserData(key)) == null) continue;
            return data2;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key) {
        Object data2;
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(201);
        }
        if (first != null && (data2 = first.getUserData(key)) != null) {
            return (T)data2;
        }
        if (second != null && (data2 = second.getUserData(key)) != null) {
            return (T)data2;
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
    public static void addNotification(@Nullable JComponent component2, @NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(202);
        }
        if (component2 == null) {
            return;
        }
        DiffUtil.addNotification(viewer -> component2, holder);
    }

    public static void addNotification(@Nullable DiffNotificationProvider provider2, @NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(203);
        }
        if (provider2 == null) {
            return;
        }
        ArrayList<DiffNotificationProvider> newProviders = new ArrayList<DiffNotificationProvider>(DiffUtil.getNotificationProviders(holder));
        newProviders.add(provider2);
        holder.putUserData(DiffUserDataKeys.NOTIFICATION_PROVIDERS, newProviders);
    }

    @NotNull
    public static List<JComponent> createCustomNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull UserDataHolder context2, @NotNull UserDataHolder request2) {
        if (context2 == null) {
            DiffUtil.$$$reportNull$$$0(204);
        }
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(205);
        }
        List<DiffNotificationProvider> contextProviders = DiffUtil.getNotificationProviders(context2);
        List<DiffNotificationProvider> requestProviders = DiffUtil.getNotificationProviders(request2);
        return DiffUtil.createNotifications(viewer, ContainerUtil.concat(contextProviders, requestProviders));
    }

    @NotNull
    public static List<JComponent> createCustomNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull DiffContent content2) {
        if (content2 == null) {
            DiffUtil.$$$reportNull$$$0(206);
        }
        List<DiffNotificationProvider> providers = DiffUtil.getNotificationProviders((UserDataHolder)content2);
        return DiffUtil.createNotifications(viewer, providers);
    }

    @NotNull
    private static List<DiffNotificationProvider> getNotificationProviders(@NotNull UserDataHolder holder) {
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(207);
        }
        List providers = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATION_PROVIDERS)));
        List components = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        List list2 = ContainerUtil.concat((List)providers, (List)ContainerUtil.map((Collection)components, component2 -> viewer -> component2));
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(208);
        }
        return list2;
    }

    @NotNull
    private static List<JComponent> createNotifications(@Nullable FrameDiffTool.DiffViewer viewer, @NotNull List<DiffNotificationProvider> providers) {
        if (providers == null) {
            DiffUtil.$$$reportNull$$$0(209);
        }
        List list2 = ContainerUtil.mapNotNull(providers, it -> it.createNotification(viewer));
        if (list2 == null) {
            DiffUtil.$$$reportNull$$$0(210);
        }
        return list2;
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider2, @Nullable DataProvider fallbackProvider, @NotNull @NonNls String dataId) {
        Object data2;
        if (dataId == null) {
            DiffUtil.$$$reportNull$$$0(211);
        }
        if (provider2 != null && (data2 = provider2.getData(dataId)) != null) {
            return data2;
        }
        if (fallbackProvider != null && (data2 = fallbackProvider.getData(dataId)) != null) {
            return data2;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key, @Nullable T value2) {
        DataProvider dataProvider;
        if (holder == null) {
            DiffUtil.$$$reportNull$$$0(212);
        }
        if (key == null) {
            DiffUtil.$$$reportNull$$$0(213);
        }
        if (!((dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER)) instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key, value2);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context2) {
        DiffSettingsHolder.DiffSettings settings;
        if (context2 == null) {
            DiffUtil.$$$reportNull$$$0(214);
        }
        if ((settings = (DiffSettingsHolder.DiffSettings)context2.getUserData(DiffSettingsHolder.DiffSettings.KEY)) == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context2.getUserData(DiffUserDataKeys.PLACE));
            context2.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        DiffSettingsHolder.DiffSettings diffSettings = settings;
        if (diffSettings == null) {
            DiffUtil.$$$reportNull$$$0(215);
        }
        return diffSettings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map2, @NotNull Convertor<? super K, V> defaultValue) {
        if (map2 == null) {
            DiffUtil.$$$reportNull$$$0(216);
        }
        if (defaultValue == null) {
            DiffUtil.$$$reportNull$$$0(217);
        }
        TreeMap<K, V> result2 = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map2.entrySet()) {
            K key = it.getKey();
            V value2 = it.getValue();
            if (value2.equals(defaultValue.convert(key))) continue;
            result2.put(key, value2);
        }
        TreeMap<K, V> treeMap = result2;
        if (treeMap == null) {
            DiffUtil.$$$reportNull$$$0(218);
        }
        return treeMap;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools == null) {
            DiffUtil.$$$reportNull$$$0(219);
        }
        if (tools.size() < 2) {
            List list2 = tools;
            if (list2 == null) {
                DiffUtil.$$$reportNull$$$0(220);
            }
            return list2;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            List list3 = tools;
            if (list3 == null) {
                DiffUtil.$$$reportNull$$$0(221);
            }
            return list3;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        List list4 = filteredTools.isEmpty() ? tools : filteredTools;
        if (list4 == null) {
            DiffUtil.$$$reportNull$$$0(222);
        }
        return list4;
    }

    @Nullable
    public static DiffTool findToolSubstitutor(@NotNull DiffTool tool, @NotNull DiffContext context2, @NotNull DiffRequest request2) {
        if (tool == null) {
            DiffUtil.$$$reportNull$$$0(223);
        }
        if (context2 == null) {
            DiffUtil.$$$reportNull$$$0(224);
        }
        if (request2 == null) {
            DiffUtil.$$$reportNull$$$0(225);
        }
        for (DiffToolSubstitutor substitutor : (DiffToolSubstitutor[])DiffToolSubstitutor.EP_NAME.getExtensions()) {
            DiffTool replacement = substitutor.getReplacement(tool, context2, request2);
            if (replacement == null) continue;
            boolean canShow = replacement.canShow(context2, request2);
            if (!canShow) {
                LOG.error("DiffTool substitutor returns invalid tool");
                continue;
            }
            return replacement;
        }
        return null;
    }

    private static /* synthetic */ void lambda$executeWriteCommand$24(Project project, boolean underBulkUpdate, Document document, Runnable task2, String commandName2, String commandGroupId, UndoConfirmationPolicy confirmationPolicy, boolean shouldRecordCommandForActiveDocument) {
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (underBulkUpdate) {
                DocumentUtil.executeInBulk(document, task2);
            } else {
                task2.run();
            }
        }, commandName2, (Object)commandGroupId, confirmationPolicy, shouldRecordCommandForActiveDocument, document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 75: 
            case 80: 
            case 87: 
            case 89: 
            case 93: 
            case 97: 
            case 117: 
            case 119: 
            case 124: 
            case 134: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 196: 
            case 208: 
            case 210: 
            case 215: 
            case 218: 
            case 220: 
            case 221: 
            case 222: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 75: 
            case 80: 
            case 87: 
            case 89: 
            case 93: 
            case 97: 
            case 117: 
            case 119: 
            case 124: 
            case 134: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 196: 
            case 208: 
            case 210: 
            case 215: 
            case 218: 
            case 220: 
            case 221: 
            case 222: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 94: 
            case 96: 
            case 98: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 92: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 16: 
            case 21: 
            case 24: 
            case 53: 
            case 54: 
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 5: 
            case 41: 
            case 43: 
            case 104: 
            case 106: 
            case 111: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 75: 
            case 80: 
            case 87: 
            case 89: 
            case 93: 
            case 97: 
            case 117: 
            case 119: 
            case 124: 
            case 134: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 196: 
            case 208: 
            case 210: 
            case 215: 
            case 218: 
            case 220: 
            case 221: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 12: 
            case 13: 
            case 102: 
            case 103: 
            case 105: 
            case 107: 
            case 116: 
            case 118: 
            case 125: 
            case 126: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 181: 
            case 184: 
            case 187: 
            case 190: 
            case 191: 
            case 193: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingSupport";
                break;
            }
            case 26: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSide";
                break;
            }
            case 32: 
            case 135: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 35: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 47: 
            case 74: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 48: 
            case 50: 
            case 71: 
            case 76: 
            case 205: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vGap";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isContentsEqual";
                break;
            }
            case 69: 
            case 204: 
            case 214: 
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 70: 
            case 183: 
            case 186: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 73: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonPolicy";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream1";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream2";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLines";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document1";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document2";
                break;
            }
            case 112: 
            case 121: 
            case 123: 
            case 127: 
            case 148: 
            case 152: 
            case 156: 
            case 159: 
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherText";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherLineOffsets";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 137: 
            case 138: 
            case 146: 
            case 150: 
            case 154: 
            case 157: 
            case 163: 
            case 165: 
            case 168: 
            case 173: 
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 143: 
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptiness";
                break;
            }
            case 144: 
            case 180: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equality";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictResolver";
                break;
            }
            case 147: 
            case 151: 
            case 155: 
            case 158: 
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 149: 
            case 153: 
            case 160: 
            case 167: 
            case 170: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 161: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side1";
                break;
            }
            case 162: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side2";
                break;
            }
            case 164: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 166: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "texts";
                break;
            }
            case 182: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confirmationPolicy";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 197: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 199: 
            case 200: 
            case 201: 
            case 213: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 202: 
            case 203: 
            case 207: 
            case 212: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 209: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 211: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initEmptyEditorHighlighter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowDownIcon";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsConfigurablePath";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificationText";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleTitles";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextTitles";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetPanel";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparatorPanel";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createSyncHeightComponents";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackedComponents";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextDiffProvider";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIndexes";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "invertIndexes";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileInputStream";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLines";
                break;
            }
            case 117: 
            case 119: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesContent";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffType";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowMode";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationProviders";
                break;
            }
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotifications";
                break;
            }
            case 215: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffSettings";
                break;
            }
            case 218: {
                objectArray = objectArray2;
                objectArray2[1] = "trimDefaultValues";
                break;
            }
            case 220: 
            case 221: 
            case 222: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuppressedTools";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iconToImage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDiffEditor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileWithoutContent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initEditorHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initEmptyEditorHighlighter";
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 75: 
            case 80: 
            case 87: 
            case 89: 
            case 93: 
            case 97: 
            case 117: 
            case 119: 
            case 124: 
            case 134: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 196: 
            case 208: 
            case 210: 
            case 215: 
            case 218: 
            case 220: 
            case 221: 
            case 222: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHighlighter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEditorHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEditorCodeStyle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFoldingModelSupport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "configureEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMirrored";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "installLineConvertor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContentLineConvertor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "disableBlitting";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineRangeIfNeeded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getArrowIcon";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getArrowDownIcon";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isFromShortcut";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createMessagePanel";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addActionBlock";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationText";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "showSuccessPopup";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleTitles";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createTextTitles";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createTitleWithNotifications";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createTitle";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetPanel";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createSeparatorPanel";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createSyncHeightComponents";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createStackedComponents";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "runPreservingFocus";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createTextDiffProvider";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnoreTextDiffProvider";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "compareThreesideInner";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isChunksEquals";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getSortedIndexes";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "invertIndexes";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "compareStreams";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getFileInputStream";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isSomeRangeSelected";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedLines";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "appendSelectedLines";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedByLine";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "deleteLines";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "insertLines";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "replaceLines";
                break;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "applyModification";
                break;
            }
            case 116: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getLinesContent";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getLinesRange";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getLineCount";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLineRange";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "countLinesShift";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getLineDiffType";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getDiffType";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getMergeType";
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getLineThreeWayDiffType";
                break;
            }
            case 150: 
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "getLineMergeType";
                break;
            }
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "canResolveLineConflict";
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "compareLineMergeContents";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isLineMergeIntervalEmpty";
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getWordMergeType";
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "compareWordMergeContents";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "isWordMergeIntervalEmpty";
                break;
            }
            case 175: 
            case 176: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getLineLeftToRightThreeSideDiffType";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getLeftToRightDiffType";
                break;
            }
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteCommand";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "canMakeWritable";
                break;
            }
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "makeWritable";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "putNonundoableOperation";
                break;
            }
            case 194: {
                objectArray = objectArray;
                objectArray[2] = "markDirtyAndRefresh";
                break;
            }
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getWindowMode";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "closeWindow";
                break;
            }
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "canBeHiddenBehind";
                break;
            }
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "createUserDataHolder";
                break;
            }
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "isUserDataFlagSet";
                break;
            }
            case 201: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 202: 
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "addNotification";
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "createCustomNotifications";
                break;
            }
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationProviders";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "createNotifications";
                break;
            }
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 212: 
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "putDataKey";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "getDiffSettings";
                break;
            }
            case 216: 
            case 217: {
                objectArray = objectArray;
                objectArray[2] = "trimDefaultValues";
                break;
            }
            case 219: {
                objectArray = objectArray;
                objectArray[2] = "filterSuppressedTools";
                break;
            }
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "findToolSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 14: 
            case 29: 
            case 31: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 61: 
            case 62: 
            case 65: 
            case 67: 
            case 68: 
            case 75: 
            case 80: 
            case 87: 
            case 89: 
            case 93: 
            case 97: 
            case 117: 
            case 119: 
            case 124: 
            case 134: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 196: 
            case 208: 
            case 210: 
            case 215: 
            case 218: 
            case 220: 
            case 221: 
            case 222: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

