/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(Repository::getPresentableUrl);

    @NotNull
    public static List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            DvcsUtil.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.sorted(virtualFiles, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<? extends File> files2) {
        if (files2 == null) {
            DvcsUtil.$$$reportNull$$$0(2);
        }
        RefreshVFsSynchronously.refreshFiles(files2);
        List list2 = ContainerUtil.mapNotNull(files2, file2 -> VfsUtil.findFileByIoFile((File)file2, (boolean)false));
        if (list2 == null) {
            DvcsUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NlsSafe
    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            DvcsUtil.$$$reportNull$$$0(4);
        }
        String string = VcsImplUtil.getShortVcsRootName(repository.getProject(), repository.getRoot());
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    public static <T extends Repository> void disableActionIfAnyRepositoryIsFresh(@NotNull AnActionEvent e, @NotNull List<T> repositories, @NlsSafe String operationName) {
        boolean isFresh;
        if (e == null) {
            DvcsUtil.$$$reportNull$$$0(8);
        }
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(9);
        }
        if (isFresh = repositories.stream().anyMatch(Repository::isFresh)) {
            Presentation p = e.getPresentation();
            p.setEnabled(false);
            p.setDescription(DvcsBundle.messagePointer((String)"action.not.possible.in.fresh.repo.description", (Object[])new Object[]{operationName}));
        }
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        String joined;
        if (messages == null) {
            DvcsUtil.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmptyOrSpaces((String)(joined = StringUtil.join(messages, (String)"\n"))) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        FileEditor fileEditor;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(11);
        }
        return (fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor()) == null ? null : fileEditor.getFile();
    }

    @NlsSafe
    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            DvcsUtil.$$$reportNull$$$0(12);
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = VcsLogUtil.getShortHash(hash);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit2) {
        if (commit2 == null) {
            DvcsUtil.$$$reportNull$$$0(14);
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit2.getTimestamp()) + " ";
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(@NotNull Project project) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(16);
        }
        return DvcsUtil.workingTreeChangeStarted(project, null);
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project, @Nullable @Nls String activityName) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(17);
        }
        BackgroundTaskUtil.syncPublisher(BatchFileChangeListener.TOPIC).batchChangeStarted(project, activityName);
        return new AccessToken(){

            public void finish() {
                BackgroundTaskUtil.syncPublisher(BatchFileChangeListener.TOPIC).batchChangeCompleted(project);
            }
        };
    }

    public static void assertFileExists(File file2, @NonNls @Nls String message2) throws IllegalStateException {
        if (!file2.exists()) {
            throw new IllegalStateException(message2);
        }
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file2) throws RepoStateException {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(18);
        }
        return DvcsUtil.tryLoadFile(file2, null);
    }

    @NlsSafe
    @NotNull
    public static String tryLoadFile(@NotNull File file2, @Nullable String encoding) throws RepoStateException {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(19);
        }
        String string = DvcsUtil.tryOrThrow(() -> StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file2, (String)encoding)).trim(), file2);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable @NlsSafe String defaultValue) {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(21);
        }
        return DvcsUtil.tryLoadFileOrReturn(file2, defaultValue, null);
    }

    @NlsSafe
    @Nullable
    @Contract(value="_ , !null, _ -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable @NlsSafe String defaultValue, @Nullable @NonNls String encoding) {
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(22);
        }
        try {
            return DvcsUtil.tryLoadFile(file2, encoding);
        }
        catch (RepoStateException e) {
            LOG.warn((Throwable)e);
            return defaultValue;
        }
    }

    public static <T> T tryOrThrow(Callable<? extends T> actionToTry, Object details2) throws RepoStateException {
        IOException cause = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + details2, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + details2, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + details2, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            DvcsUtil.$$$reportNull$$$0(23);
        }
        if (subDirs == null) {
            DvcsUtil.$$$reportNull$$$0(24);
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)CommonProcessors.alwaysTrue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public static void addMappingIfSubRoot(@NotNull Project project, @NotNull @NonNls String string, @NotNull @NonNls String string2) {
        void vcsName;
        void newRepositoryPath;
        Project project2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (project2 == null) {
            DvcsUtil.$$$reportNull$$$0(25);
        }
        if (newRepositoryPath == null) {
            DvcsUtil.$$$reportNull$$$0(26);
        }
        if (vcsName == null) {
            DvcsUtil.$$$reportNull$$$0(27);
        }
        if (!project2.isDisposed() && project2.getBasePath() != null && FileUtil.isAncestor((String)project2.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager2 = ProjectLevelVcsManager.getInstance((Project)project2);
            manager2.setDirectoryMappings(VcsUtil.addMapping((List)manager2.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project, @NotNull RepositoryManager<T> manager2, @Nullable VirtualFile file2, @Nullable @NonNls String defaultRootPathValue) {
        Repository repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(28);
        }
        if (manager2 == null) {
            DvcsUtil.$$$reportNull$$$0(29);
        }
        if ((repository = manager2.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, file2))) != null) {
            return (T)repository;
        }
        return (T)manager2.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager2.getVcs(), defaultRootPathValue));
    }

    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project, @NotNull AbstractRepositoryManager<T> manager2, @Nullable @NonNls String defaultRootPathValue) {
        T repository;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(30);
        }
        if (manager2 == null) {
            DvcsUtil.$$$reportNull$$$0(31);
        }
        if ((repository = manager2.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project, DvcsUtil.getSelectedFile(project)))) != null) {
            return repository;
        }
        return manager2.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project, manager2.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project, @Nullable AbstractVcs vcs, @Nullable @NonNls String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(32);
        }
        if (project.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        if (vcs == null) {
            LOG.debug("Vcs not found.");
            return null;
        }
        String vcsName = vcs.getDisplayName();
        VirtualFile[] vcsRoots = vcsManager2.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && (recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        for (VirtualFile root2 : vcsRoots) {
            if (!root2.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root2, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + root2);
            return root2;
        }
        VirtualFile rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<? extends T> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(33);
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        validRepositories.sort(REPOSITORY_COMPARATOR);
        return validRepositories;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project, @NotNull VirtualFile file2) {
        ProjectLevelVcsManager vcsManager2;
        VirtualFile root2;
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            DvcsUtil.$$$reportNull$$$0(35);
        }
        if ((root2 = (vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project)).getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file2))) != null) {
            LOG.debug("Found root for zip/jar file: " + root2);
            return root2;
        }
        List entries2 = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file2);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry2 : entries2) {
            VirtualFile moduleRoot;
            if (!(entry2 instanceof LibraryOrderEntry) && !(entry2 instanceof JdkOrderEntry) || (moduleRoot = vcsManager2.getVcsRootFor(entry2.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.isEmpty()) {
            LOG.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOG.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            DvcsUtil.$$$reportNull$$$0(36);
        }
        VirtualFile root2 = null;
        if (file2 != null && (root2 = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(file2)) == null) {
            LOG.debug("Cannot get root by file. Trying with get by library: " + file2);
            root2 = DvcsUtil.getVcsRootForLibraryFile(project, file2);
        }
        return root2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    @RequiresBackgroundThread
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repositoryManager, @NotNull List<? extends VcsFullCommitDetails> list2) {
        void commits;
        RepositoryManager<R> repoManager;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (repoManager == null) {
            DvcsUtil.$$$reportNull$$$0(37);
        }
        if (commits == null) {
            DvcsUtil.$$$reportNull$$$0(38);
        }
        HashMap<Repository, List> groupedCommits = new HashMap<Repository, List>();
        for (VcsFullCommitDetails commit2 : commits) {
            Repository repository = repoManager.getRepositoryForRoot(commit2.getRoot());
            if (repository == null) {
                LOG.info("No repository found for commit " + commit2);
                continue;
            }
            List commitsInRoot = groupedCommits.computeIfAbsent(repository, __ -> new ArrayList());
            commitsInRoot.add(commit2);
        }
        HashMap<Repository, List> hashMap = groupedCommits;
        if (hashMap == null) {
            DvcsUtil.$$$reportNull$$$0(39);
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            DvcsUtil.$$$reportNull$$$0(40);
        }
        return (PushSupport)ContainerUtil.find((Object[])((PushSupport[])PushSupport.PUSH_SUPPORT_EP.getExtensions((AreaInstance)vcs.getProject())), support -> support.getVcs().equals((Object)vcs));
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(41);
        }
        return DvcsUtil.joinShortNames(repositories, -1);
    }

    @NlsSafe
    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            DvcsUtil.$$$reportNull$$$0(42);
        }
        return DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
    }

    @Nls
    @NotNull
    public static String joinWithAnd(@NotNull List<@Nls String> strings, int limit) {
        if (strings == null) {
            DvcsUtil.$$$reportNull$$$0(43);
        }
        String string = VcsUtil.joinWithAnd(strings, (int)limit);
        if (string == null) {
            DvcsUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 39: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 39: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 9: 
            case 33: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 11: 
            case 16: 
            case 17: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRepositoryPath";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoManager";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/DvcsUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "sortVirtualFilesByPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFilesWithRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRepositoryName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortHash";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadFile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "groupCommitsByRoots";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "joinWithAnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sortVirtualFilesByPresentation";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 39: 
            case 44: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFilesWithRefresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShortRepositoryName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShortNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disableActionIfAnyRepositoryIsFresh";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "joinMessagesOrNull";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDateString";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "workingTreeChangeStarted";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadFileOrReturn";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitVcsDirVfs";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addMappingIfSubRoot";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForFile";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "guessCurrentRepositoryQuick";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "guessRootForVcs";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sortRepositories";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootForLibraryFile";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "guessVcsRoot";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "groupCommitsByRoots";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPushSupport";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "joinShortNames";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "joinWithAnd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 20: 
            case 39: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

