/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.vcs.CompareWithLocalDialog;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCompareWithBranchAction<T extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = Objects.requireNonNull((VirtualFile)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).single());
        Repository repository = (Repository)Objects.requireNonNull(this.getRepositoryManager(project).getRepositoryForFileQuick(file2));
        assert (!repository.isFresh());
        String presentableRevisionName = (String)ObjectUtils.chooseNotNull((Object)repository.getCurrentBranchName(), (Object)DvcsUtil.getShortHash(Objects.requireNonNull(repository.getCurrentRevision())));
        List<String> branchNames = this.getBranchNamesExceptCurrent(repository);
        JBPopup popup2 = JBPopupFactory.getInstance().createPopupChooserBuilder(branchNames).setTitle(DvcsBundle.message((String)"popup.title.select.branch.to.compare", (Object[])new Object[0])).setItemChosenCallback(selected2 -> this.showDiffWithBranchUnderModalProgress(project, file2, presentableRevisionName, (String)selected2)).setAutoselectOnMouseMove(true).setNamerForFiltering(o -> o).createPopup();
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> popup2.showCenteredInCurrentWindow(project)));
    }

    @NotNull
    protected abstract List<String> getBranchNamesExceptCurrent(@NotNull T var1);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)JBIterable.from((Iterable)((Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES))).single();
        presentation2.setVisible(project != null);
        presentation2.setEnabled(project != null && file2 != null && this.isEnabled(this.getRepositoryManager(project).getRepositoryForFileQuick(file2)));
    }

    private boolean isEnabled(@Nullable T repository) {
        return repository != null && !repository.isFresh() && !this.noBranchesToCompare(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<T> getRepositoryManager(@NotNull Project var1);

    protected abstract boolean noBranchesToCompare(@NotNull T var1);

    @NotNull
    protected abstract Collection<Change> getDiffChanges(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3) throws VcsException;

    private void showDiffWithBranchUnderModalProgress(final @NotNull Project project, final @NotNull VirtualFile file2, @NotNull @NlsSafe String head, final @NotNull @NlsSafe String compare) {
        if (project == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        if (head == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        if (compare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        final String revNumTitle1 = VcsDiffUtil.getRevisionTitle(compare, false);
        final String revNumTitle2 = VcsDiffUtil.getRevisionTitle(head, true);
        if (file2.isDirectory()) {
            String dialogTitle = VcsBundle.message((String)"history.dialog.title.difference.between.versions.in", (Object[])new Object[]{revNumTitle1, revNumTitle2, filePath.getName()});
            CompareWithLocalDialog.showChanges(project, dialogTitle, CompareWithLocalDialog.LocalContent.AFTER, (ThrowableComputable<? extends Collection<Change>, ? extends VcsException>)((ThrowableComputable)() -> this.getDiffChanges(project, file2, compare)));
        } else {
            ChangeDiffRequestChain.Async requestChain = new ChangeDiffRequestChain.Async(){

                @NotNull
                protected ListSelection<ChangeDiffRequestProducer> loadRequestProducers() throws DiffRequestProducerException {
                    ListSelection listSelection;
                    try {
                        Collection<Change> changes = DvcsCompareWithBranchAction.this.getDiffChanges(project, file2, compare);
                        HashMap<Key<String>, String> changeContext = new HashMap<Key<String>, String>(2);
                        changeContext.put(DiffUserDataKeysEx.VCS_DIFF_LEFT_CONTENT_TITLE, revNumTitle1);
                        changeContext.put(DiffUserDataKeysEx.VCS_DIFF_RIGHT_CONTENT_TITLE, revNumTitle2);
                        listSelection = ListSelection.createAt(new ArrayList<Change>(changes), (int)0).map(change -> ChangeDiffRequestProducer.create(project, change, changeContext));
                    }
                    catch (VcsException e) {
                        throw new DiffRequestProducerException((Throwable)e);
                    }
                    if (listSelection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return listSelection;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$1", "loadRequestProducers"));
                }
            };
            DiffManager.getInstance().showDiff(project, (DiffRequestChain)requestChain, DiffDialogHints.DEFAULT);
        }
    }

    @NlsSafe
    protected static String fileDoesntExistInBranchError(@NotNull VirtualFile file2, @NotNull String branchToCompare) {
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        if (branchToCompare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        return DvcsBundle.message((String)"error.text.file.not.found.in.branch", (Object[])new Object[]{file2.isDirectory() ? 1 : 0, file2.getPresentableUrl(), branchToCompare});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compare";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiffWithBranchUnderModalProgress";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDoesntExistInBranchError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

