/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.dvcs.push.ui.VcsEditableComponent;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeHelper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PushLog
extends JPanel
implements DataProvider {
    @NonNls
    private static final String CONTEXT_MENU = "Vcs.Push.ContextMenu";
    @NonNls
    private static final String START_EDITING = "startEditing";
    @NonNls
    private static final String TREE_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Tree.Proportion";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "Vcs.Push.Splitter.Details.Proportion";
    private final SimpleChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private final JScrollPane myScrollPane;
    private final CommitDetailsPanel myDetailsPanel;
    private final MyShowDetailsAction myShowDetailsAction;
    private boolean myShouldRepaint;
    private boolean mySyncStrategy;
    @Nullable
    @Nls
    private String mySyncRenderedText;
    @NotNull
    private final Project myProject;
    private final boolean myAllowSyncStrategy;

    public PushLog(@NotNull Project project, final CheckedTreeNode root2, boolean allowSyncStrategy) {
        if (project == null) {
            PushLog.$$$reportNull$$$0(0);
        }
        this.myShouldRepaint = false;
        this.myProject = project;
        this.myAllowSyncStrategy = allowSyncStrategy;
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root2);
        treeModel.nodeStructureChanged((TreeNode)root2);
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root2){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }

            public boolean isPathEditable(TreePath path2) {
                return this.isEditable() && path2.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node2) {
                if (node2 instanceof EditableTreeNode) {
                    ((EditableTreeNode)node2).fireOnSelectionChange(node2.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path2 = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path2 == null) {
                    return "";
                }
                Object node2 = path2.getLastPathComponent();
                if (!(node2 instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node2 instanceof TooltipNode) {
                    String select2 = DvcsBundle.message((String)"push.select.all.commit.details", (Object[])new Object[0]);
                    return ((TooltipNode)node2).getTooltip() + "<p style='font-style:italic;color:gray;'>" + select2 + "</p>";
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node2 instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node2.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result2 = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root2);
                }
                PushLog.this.restoreSelection(node2);
                return result2;
            }

            public void cancelEditing() {
                DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root2);
                }
                PushLog.this.restoreSelection(lastSelectedPathComponent);
            }

            @Override
            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
                    Object pathComponent = path2.getLastPathComponent();
                    if (pathComponent instanceof RepositoryNode) {
                        return ((RepositoryNode)pathComponent).getRepositoryName();
                    }
                    return pathComponent.toString();
                }));
            }
        };
        this.myTree.setUI((TreeUI)((Object)new MyTreeUi()));
        this.myTree.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        this.myTree.setEditable(true);
        this.myTree.setShowsRootHandles(root2.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor(treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node2 instanceof EditableTreeNode) {
                    JComponent editedComponent = (JComponent)node2.getUserObject();
                    InputVerifier verifier = editedComponent.getInputVerifier();
                    if (verifier != null && !verifier.verify(editedComponent)) {
                        ((EditableTreeNode)((Object)node2)).fireOnCancel();
                    } else if (PushLog.this.mySyncStrategy) {
                        PushLog.this.resetEditSync();
                        ContainerUtil.process(PushLog.getChildNodesByType((DefaultMutableTreeNode)root2, RepositoryNode.class, false), node1 -> {
                            node1.fireOnChange();
                            return true;
                        });
                    } else {
                        ((EditableTreeNode)((Object)node2)).fireOnChange();
                    }
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node2 instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node2)).fireOnCancel();
                }
                PushLog.this.resetEditSync();
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)((Object)this.myTree), (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)((Object)this.myTree));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.updateChangesView();
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node2 instanceof RepositoryNode && PushLog.this.myTree.isEditing()) {
                    PushLog.this.myTree.getCellEditor().getTreeCellEditorComponent((JTree)((Object)PushLog.this.myTree), node2, true, false, false, PushLog.this.myTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)node2)));
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "");
        ExpandAllAction expandAllAction = new ExpandAllAction((JTree)((Object)this.myTree));
        expandAllAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExpandAll").getShortcutSet(), (JComponent)((Object)this.myTree));
        CollapseAllAction collapseAll2 = new CollapseAllAction((JTree)((Object)this.myTree));
        collapseAll2.registerCustomShortcutSet(ActionManager.getInstance().getAction("CollapseAll").getShortcutSet(), (JComponent)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"Vcs.Log.ContextMenu", (String)CONTEXT_MENU);
        this.myChangesBrowser = new SimpleChangesBrowser(project, false, false);
        this.myChangesBrowser.hideViewerBorder();
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.myTree));
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myChangesBrowser);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser);
        this.myChangesBrowser.addToolbarAction((AnAction)editSourceAction);
        this.setDefaultEmptyText();
        this.myDetailsPanel = new CommitDetailsPanel();
        JBScrollPane detailsScrollPane = new JBScrollPane((Component)this.myDetailsPanel, 20, 31);
        detailsScrollPane.setBorder((Border)JBUI.Borders.empty());
        detailsScrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        BorderLayoutPanel detailsContentPanel = new BorderLayoutPanel();
        detailsContentPanel.addToCenter((Component)detailsScrollPane);
        OnePixelSplitter detailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.67f);
        detailsSplitter.setFirstComponent((JComponent)this.myChangesBrowser);
        this.myShowDetailsAction = new MyShowDetailsAction(project, arg_0 -> PushLog.lambda$new$0((JBSplitter)detailsSplitter, detailsContentPanel, arg_0));
        this.myShowDetailsAction.setEnabled(false);
        this.myChangesBrowser.addToolbarSeparator();
        this.myChangesBrowser.addToolbarAction((AnAction)this.myShowDetailsAction);
        OnePixelSplitter splitter2 = new OnePixelSplitter(TREE_SPLITTER_PROPORTION, 0.5f);
        final JComponent syncStrategyPanel = this.myAllowSyncStrategy ? this.createStrategyPanel() : null;
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myTree)){

            public void layout() {
                super.layout();
                if (syncStrategyPanel != null) {
                    Rectangle bounds2 = this.getViewport().getBounds();
                    int height = bounds2.height - syncStrategyPanel.getPreferredSize().height;
                    this.getViewport().setBounds(bounds2.x, bounds2.y, bounds2.width, height);
                    syncStrategyPanel.setBounds(bounds2.x, bounds2.y + height, bounds2.width, syncStrategyPanel.getPreferredSize().height);
                }
            }
        };
        if (syncStrategyPanel != null) {
            this.myScrollPane.setViewport((JViewport)((Object)new MyTreeViewPort((Component)((Object)this.myTree), syncStrategyPanel.getPreferredSize().height)));
        }
        this.myScrollPane.getViewport().setScrollMode(0);
        this.myScrollPane.setOpaque(false);
        if (syncStrategyPanel != null) {
            this.myScrollPane.add(syncStrategyPanel);
        }
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        splitter2.setFirstComponent((JComponent)this.myScrollPane);
        splitter2.setSecondComponent((JComponent)detailsSplitter);
        this.setBorder(IdeBorderFactory.createBorder((int)8));
        this.setLayout(new BorderLayout());
        this.add((Component)splitter2);
        this.myTree.setRowHeight(0);
    }

    public void highlightNodeOrFirst(@Nullable RepositoryNode repositoryNode, boolean shouldScrollTo) {
        TreePath selectionPath = repositoryNode != null ? TreeUtil.getPathFromRoot((TreeNode)((Object)repositoryNode)) : TreeUtil.getFirstNodePath((JTree)((Object)this.myTree));
        this.myTree.setSelectionPath(selectionPath);
        if (shouldScrollTo) {
            this.myTree.scrollPathToVisible(selectionPath);
        }
    }

    private void restoreSelection(@Nullable DefaultMutableTreeNode node2) {
        if (node2 != null) {
            TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)node2);
        }
    }

    private JComponent createStrategyPanel() {
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(RenderingUtil.getBackground((JTree)((Object)this.myTree)));
        final LinkLabel linkLabel = new LinkLabel(DvcsBundle.message((String)"push.edit.all.targets", (Object[])new Object[0]), null);
        linkLabel.setBorder(JBUI.Borders.empty((int)2));
        linkLabel.setListener((LinkListener)new LinkListener<String>(){

            public void linkSelected(LinkLabel<String> aSource, String aLinkData) {
                if (linkLabel.isEnabled()) {
                    PushLog.this.startSyncEditing();
                }
            }
        }, null);
        this.myTree.addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean editMode = (Boolean)evt.getNewValue();
                linkLabel.setEnabled(editMode == false);
                linkLabel.setPaintUnderline(editMode == false);
                linkLabel.repaint();
            }
        });
        labelPanel.add((Component)linkLabel, "East");
        return labelPanel;
    }

    private void startSyncEditing() {
        this.mySyncStrategy = true;
        DefaultMutableTreeNode nodeToEdit = this.getFirstNodeToEdit();
        if (nodeToEdit != null) {
            this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)nodeToEdit));
        }
    }

    @NotNull
    private static List<Change> collectAllChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(1);
        }
        List<Change> list2 = CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
        if (list2 == null) {
            PushLog.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        if (selectedNodes == null) {
            PushLog.$$$reportNull$$$0(3);
        }
        List nodes = StreamEx.of(selectedNodes).select(RepositoryNode.class).toFlatList(node2 -> PushLog.getChildNodesByType((DefaultMutableTreeNode)((Object)node2), CommitNode.class, true));
        nodes.addAll(((StreamEx)StreamEx.of(selectedNodes).select(CommitNode.class).filter(node2 -> !nodes.contains(node2))).toList());
        List list2 = nodes;
        if (list2 == null) {
            PushLog.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<? extends CommitNode> commitNodes) {
        if (commitNodes == null) {
            PushLog.$$$reportNull$$$0(5);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (CommitNode commitNode : commitNodes) {
            changes.addAll(commitNode.getUserObject().getChanges());
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static <T> List<T> getChildNodesByType(@NotNull DefaultMutableTreeNode node2, Class<T> type, boolean reverseOrder) {
        if (node2 == null) {
            PushLog.$$$reportNull$$$0(7);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        if (node2.getChildCount() < 1) {
            ArrayList<DefaultMutableTreeNode> arrayList = nodes;
            if (arrayList == null) {
                PushLog.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node2.getFirstChild();
        while (childNode != null) {
            if (type.isInstance(childNode)) {
                DefaultMutableTreeNode nodeT = childNode;
                if (reverseOrder) {
                    nodes.add(0, nodeT);
                } else {
                    nodes.add(nodeT);
                }
            }
            childNode = (DefaultMutableTreeNode)node2.getChildAfter(childNode);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static List<Integer> getSortedRows(int @NotNull [] rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(10);
        }
        ArrayList<Integer> sorted = new ArrayList<Integer>();
        for (int row2 : rows) {
            sorted.add(row2);
        }
        sorted.sort(Collections.reverseOrder());
        ArrayList<Integer> arrayList = sorted;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void updateChangesView() {
        List<CommitNode> commitNodes = this.getSelectedCommitNodes();
        if (!commitNodes.isEmpty()) {
            this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message((String)"push.no.differences", (Object[])new Object[0]));
        } else {
            this.setDefaultEmptyText();
        }
        this.myChangesBrowser.setChangesToDisplay(PushLog.collectAllChanges(commitNodes));
        if (commitNodes.size() == 1 && this.getSelectedTreeNodes().stream().noneMatch(it -> it instanceof RepositoryNode)) {
            VcsFullCommitDetails commitDetails = commitNodes.get(0).getUserObject();
            CommitPresentationUtil.CommitPresentation presentation2 = CommitPresentationUtil.buildPresentation(this.myProject, (VcsCommitMetadata)commitDetails, new HashSet());
            this.myDetailsPanel.setCommit(presentation2);
            this.myShowDetailsAction.setEnabled(true);
        } else {
            this.myShowDetailsAction.setEnabled(false);
        }
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText(DvcsBundle.message((String)"push.no.commits.selected", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    public Object getData(@NotNull String id2) {
        if (id2 == null) {
            PushLog.$$$reportNull$$$0(12);
        }
        if (VcsDataKeys.CHANGES.is(id2)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return PushLog.collectAllChanges(commitNodes).toArray(new Change[0]);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(id2)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ContainerUtil.map2Array(commitNodes, VcsRevisionNumber.class, commitNode -> {
                Hash hash = (Hash)commitNode.getUserObject().getId();
                return new TextRevisionNumber(hash.asString(), hash.toShortString());
            });
        }
        return null;
    }

    @NotNull
    private List<CommitNode> getSelectedCommitNodes() {
        List<DefaultMutableTreeNode> selectedNodes = this.getSelectedTreeNodes();
        return selectedNodes.isEmpty() ? Collections.emptyList() : PushLog.collectSelectedCommitNodes(selectedNodes);
    }

    @NotNull
    private List<DefaultMutableTreeNode> getSelectedTreeNodes() {
        int[] rows = this.myTree.getSelectionRows();
        List<DefaultMutableTreeNode> list2 = rows != null && rows.length != 0 ? this.getNodesForRows(PushLog.getSortedRows(rows)) : ContainerUtil.emptyList();
        if (list2 == null) {
            PushLog.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        if (rows == null) {
            PushLog.$$$reportNull$$$0(14);
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
        for (Integer row2 : rows) {
            TreePath path2 = this.myTree.getPathForRow(row2);
            Object pathComponent = path2 == null ? null : path2.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        ArrayList<DefaultMutableTreeNode> arrayList = nodes;
        if (arrayList == null) {
            PushLog.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && this.myTree.isEditing() && e.getModifiers() == 0 && pressed) {
            this.myTree.stopEditing();
            return true;
        }
        if (this.myAllowSyncStrategy && e.getKeyCode() == 113 && e.getModifiers() == 8 && pressed) {
            this.startSyncEditing();
            return true;
        }
        if (CheckboxTreeHelper.isToggleEvent((KeyEvent)e, (JComponent)((Object)this.myTree)) && pressed) {
            this.toggleRepositoriesFromCommits();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private void toggleRepositoriesFromCommits() {
        LinkedHashSet checkedNodes = (LinkedHashSet)((StreamEx)StreamEx.of(this.getSelectedTreeNodes()).map(n -> n instanceof CommitNode ? n.getParent() : n).select(CheckedTreeNode.class).filter(CheckedTreeNode::isEnabled)).toCollection(LinkedHashSet::new);
        if (checkedNodes.isEmpty()) {
            return;
        }
        boolean newState2 = !((CheckedTreeNode)checkedNodes.iterator().next()).isChecked();
        checkedNodes.forEach(n -> this.myTree.setNodeState((CheckedTreeNode)n, newState2));
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNodeToEdit() {
        RepositoryNode selectedNode;
        if (this.myTree.getLastSelectedPathComponent() instanceof RepositoryNode && (selectedNode = (RepositoryNode)this.myTree.getLastSelectedPathComponent()).isEditableNow()) {
            return selectedNode;
        }
        List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
        RepositoryNode editableNode = (RepositoryNode)ContainerUtil.find(repositoryNodes, repositoryNode -> repositoryNode.isEditableNow());
        if (editableNode != null) {
            TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)((Object)editableNode));
        }
        return editableNode;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public CheckboxTree getTree() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            PushLog.$$$reportNull$$$0(16);
        }
        return checkboxTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node2) {
        if (node2 == null) {
            PushLog.$$$reportNull$$$0(17);
        }
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node2));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(18);
        }
        if (childrenNodes == null) {
            PushLog.$$$reportNull$$$0(19);
        }
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path2)) {
                this.updateChangesView();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        if (parentNode == null) {
            PushLog.$$$reportNull$$$0(20);
        }
        DefaultTreeModel model2 = (DefaultTreeModel)this.myTree.getModel();
        model2.nodeStructureChanged(parentNode);
        this.autoExpandChecked(parentNode);
        this.myShouldRepaint = false;
    }

    private void autoExpandChecked(@NotNull DefaultMutableTreeNode node2) {
        if (node2 == null) {
            PushLog.$$$reportNull$$$0(21);
        }
        if (node2.getChildCount() <= 0) {
            return;
        }
        if (node2 instanceof RepositoryNode) {
            this.expandIfChecked((RepositoryNode)((Object)node2));
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node2.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            this.expandIfChecked((RepositoryNode)((Object)childNode));
            childNode = (DefaultMutableTreeNode)node2.getChildAfter(childNode);
        }
    }

    private void expandIfChecked(@NotNull RepositoryNode node2) {
        if (node2 == null) {
            PushLog.$$$reportNull$$$0(22);
        }
        if (node2.isChecked()) {
            TreePath path2 = TreeUtil.getPathFromRoot((TreeNode)((Object)node2));
            this.myTree.expandPath(path2);
        }
    }

    private void setSyncText(@Nls String value2) {
        this.mySyncRenderedText = value2;
    }

    public void fireEditorUpdated(@NotNull @Nls String currentText) {
        if (currentText == null) {
            PushLog.$$$reportNull$$$0(23);
        }
        if (this.mySyncStrategy) {
            List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
            for (RepositoryNode node2 : repositoryNodes) {
                if (!node2.isEditableNow()) continue;
                node2.forceUpdateUiModelWithTypedText(currentText);
            }
            this.setSyncText(currentText);
            this.myTree.repaint();
        }
    }

    private void resetEditSync() {
        if (this.mySyncStrategy) {
            this.mySyncStrategy = false;
            this.mySyncRenderedText = null;
        }
    }

    private static /* synthetic */ void lambda$new$0(JBSplitter detailsSplitter, BorderLayoutPanel detailsContentPanel, Boolean state) {
        detailsSplitter.setSecondComponent((JComponent)(state != false ? detailsContentPanel : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitNodes";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenNodes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/PushLog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllChanges";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedCommitNodes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildNodesByType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedRows";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTreeNodes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesForRows";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectAllChanges";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedCommitNodes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildNodesByType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSortedRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodesForRows";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "selectIfNothingSelected";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refreshNode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "autoExpandChecked";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expandIfChecked";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fireEditorUpdated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyShowDetailsAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        private final PushSettings mySettings;
        @NotNull
        private final Consumer<Boolean> myOnUpdate;

        MyShowDetailsAction(@NotNull Project project, @NotNull Consumer<Boolean> onUpdate) {
            if (project == null) {
                MyShowDetailsAction.$$$reportNull$$$0(0);
            }
            if (onUpdate == null) {
                MyShowDetailsAction.$$$reportNull$$$0(1);
            }
            super(DvcsBundle.message((String)"push.show.details", (Object[])new Object[0]), AllIcons.Actions.PreviewDetailsVertically);
            this.mySettings = (PushSettings)project.getService(PushSettings.class);
            this.myOnUpdate = onUpdate;
        }

        private boolean getValue() {
            return this.mySettings.getShowDetailsInPushDialog();
        }

        public boolean isSelected(AnActionEvent e) {
            return this.getValue();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setShowDetailsInPushDialog(state);
            this.myOnUpdate.accept(state);
        }

        public void setEnabled(boolean enabled) {
            this.myOnUpdate.accept(enabled && this.getValue());
            super.setEnabled(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "onUpdate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/push/ui/PushLog$MyShowDetailsAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyTreeViewPort
    extends JBViewport {
        final int myHeightToReduce;

        MyTreeViewPort(@Nullable Component view, int heightToReduce) {
            this.setView(view);
            this.myHeightToReduce = heightToReduce;
        }

        public Dimension getExtentSize() {
            Dimension defaultSize = super.getExtentSize();
            return new Dimension(defaultSize.width, defaultSize.height - this.myHeightToReduce);
        }
    }

    private class MyTreeUi
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MyTreeUi.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                MyTreeUi.this.updateSizes();
            }
        };

        private MyTreeUi() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value2, int row2, int depth, boolean expanded2, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value2, row2, depth, expanded2, size);
                    dimensions.width = Math.max(PushLog.this.myScrollPane != null ? PushLog.this.myScrollPane.getViewport().getWidth() - this.getRowX(row2, depth) : PushLog.this.myTree.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean isSelected, boolean expanded2, boolean leaf, int row2) {
            RepositoryWithBranchPanel panel2;
            this.myValue = panel2 = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value2).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel2.getTreeCellEditorComponent(tree, value2, isSelected, expanded2, leaf, row2, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path2 = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row2 = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)PushLog.this.myTree), path2.getLastPathComponent(), false, false, true, row2, true);
                Object tag2 = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag2 instanceof VcsEditableComponent;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode2 = treePath.getLastPathComponent();
            return treeNode2 instanceof EditableTreeNode && ((EditableTreeNode)treeNode2).isEditableNow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
            if (!(value2 instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            ColoredTreeCellRenderer renderer2 = this.getTextRenderer();
            renderer2.setIpad((Insets)JBUI.emptyInsets());
            if (value2 instanceof RepositoryNode) {
                RepositoryNode valueNode = (RepositoryNode)value2;
                boolean isCheckboxVisible = valueNode.isCheckboxVisible();
                this.myCheckbox.setVisible(isCheckboxVisible);
                if (!isCheckboxVisible) {
                    renderer2.setIpad((Insets)JBUI.insets((int)0, (int)10));
                }
                if (valueNode.isChecked() && valueNode.isLoading()) {
                    this.myCheckbox.setState(ThreeStateCheckBox.State.DONT_CARE);
                } else {
                    this.myCheckbox.setSelected(valueNode.isChecked());
                }
            }
            Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
            if (value2 instanceof CustomRenderedTreeNode) {
                if (tree.isEditing() && PushLog.this.mySyncStrategy && value2 instanceof RepositoryNode) {
                    ((RepositoryNode)value2).render(renderer2, PushLog.this.mySyncRenderedText);
                } else {
                    ((CustomRenderedTreeNode)value2).render(renderer2);
                }
            } else {
                renderer2.append(userObject == null ? "" : userObject.toString());
            }
        }
    }
}

