/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class VcsRepositoryManager
implements Disposable {
    public static final ExtensionPointName<VcsRepositoryCreator> EP_NAME = new ExtensionPointName("com.intellij.vcsRepositoryCreator");
    private static final Logger LOG = Logger.getInstance(VcsRepositoryManager.class);
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = new Topic(VcsRepositoryMappingListener.class, Topic.BroadcastDirection.NONE);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories;
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories;
    private final Alarm myUpdateAlarm;
    private volatile boolean myDisposed;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(0);
        }
        VcsRepositoryManager vcsRepositoryManager = Objects.requireNonNull((VcsRepositoryManager)project.getService(VcsRepositoryManager.class));
        if (vcsRepositoryManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(1);
        }
        return vcsRepositoryManager;
    }

    public VcsRepositoryManager(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(2);
        }
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.myRepositories = new HashMap<VirtualFile, Repository>();
        this.myExternalRepositories = new HashMap<VirtualFile, Repository>();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::scheduleUpdate);
        EP_NAME.addChangeListener(() -> {
            this.disposeAllRepositories(false);
            this.scheduleUpdate();
            BackgroundTaskUtil.syncPublisher(this.myProject, VCS_REPOSITORY_MAPPING_UPDATED).mappingChanged();
        }, (Disposable)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.disposeAllRepositories(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllRepositories(boolean disposeExternal) {
        this.REPO_LOCK.writeLock().lock();
        try {
            for (Repository repo : this.myRepositories.values()) {
                Disposer.dispose((Disposable)repo);
            }
            this.myRepositories.clear();
            if (disposeExternal) {
                for (Repository repo : this.myExternalRepositories.values()) {
                    Disposer.dispose((Disposable)repo);
                }
                this.myExternalRepositories.clear();
            }
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    private void scheduleUpdate() {
        if (this.myUpdateAlarm.isDisposed()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> this.checkAndUpdateRepositoriesCollection(null), 0);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile virtualFile2) {
        void file2;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(3);
        }
        return this.getRepositoryForFile((VirtualFile)file2, false);
    }

    @Nullable
    public Repository getRepositoryForFileQuick(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(4);
        }
        return this.getRepositoryForFile(file2, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file2, boolean quick) {
        VcsRoot vcsRoot;
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(5);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(file2)) == null) {
            return this.getExternalRepositoryForFile(file2);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull FilePath file2, boolean quick) {
        VcsRoot vcsRoot;
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(6);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(file2)) == null) {
            return this.getExternalRepositoryForFile(file2);
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(7);
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry2 : repositories.entrySet()) {
            if (!entry2.getKey().isValid() || !VfsUtilCore.isAncestor((VirtualFile)entry2.getKey(), (VirtualFile)file2, (boolean)false)) continue;
            return entry2.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getExternalRepositoryForFile(@NotNull FilePath file2) {
        if (file2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
        for (Map.Entry<VirtualFile, Repository> entry2 : repositories.entrySet()) {
            if (!entry2.getKey().isValid() || !FileUtil.isAncestor((String)entry2.getKey().getPath(), (String)file2.getPath(), (boolean)false)) continue;
            return entry2.getValue();
        }
        return null;
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root2) {
        return this.getRepositoryForRoot(root2, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root2) {
        return this.getRepositoryForRoot(root2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root2, boolean updateIfNeeded) {
        if (root2 == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        if (updateIfNeeded && application.isDispatchThread() && !application.isUnitTestMode() && !application.isHeadlessEnvironment()) {
            updateIfNeeded = false;
            LOG.error("Do not call synchronous repository update in EDT");
        }
        this.REPO_LOCK.readLock().lock();
        try {
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root2);
            if (repo != null) {
                Repository repository = repo;
                return repository;
            }
            Repository externalRepo = this.myExternalRepositories.get(root2);
            if (externalRepo != null) {
                Repository repository = externalRepo;
                return repository;
            }
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && ArrayUtil.contains((Object)root2, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root2);
            this.REPO_LOCK.readLock().lock();
            try {
                Repository repository = this.myRepositories.get(root2);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return null;
    }

    public void addExternalRepository(@NotNull VirtualFile root2, @NotNull Repository repository) {
        if (root2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(10);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root2, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root2) {
        if (root2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(11);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root2);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(12);
        }
        this.REPO_LOCK.readLock().lock();
        try {
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
        ArrayList<Repository> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(13);
        }
        return arrayList2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> getExternalRepositories() {
        this.REPO_LOCK.readLock().lock();
        HashMap<VirtualFile, Repository> hashMap = new HashMap<VirtualFile, Repository>(this.myExternalRepositories);
        HashMap<VirtualFile, Repository> hashMap2 = hashMap;
        if (hashMap2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(14);
        }
        return hashMap2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        this.MODIFY_LOCK.lock();
        try {
            HashMap<VirtualFile, Repository> repositories;
            this.REPO_LOCK.readLock().lock();
            try {
                repositories = new HashMap<VirtualFile, Repository>(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            if (checkedRoot != null && repositories.containsKey(checkedRoot)) {
                return;
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.values());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    for (VirtualFile file2 : this.myRepositories.keySet()) {
                        Repository newRepo;
                        Repository oldRepo = this.myRepositories.get(file2);
                        if (oldRepo == (newRepo = (Repository)repositories.get(file2))) continue;
                        Disposer.dispose((Disposable)oldRepo);
                    }
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
        BackgroundTaskUtil.syncPublisher(this.myProject, VCS_REPOSITORY_MAPPING_UPDATED).mappingChanged();
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        if (knownRoots == null) {
            VcsRepositoryManager.$$$reportNull$$$0(15);
        }
        HashMap<VirtualFile, Repository> newRootsMap = new HashMap<VirtualFile, Repository>();
        for (VcsRoot root2 : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            VirtualFile rootPath = root2.getPath();
            if (knownRoots.contains(rootPath) || (repository = VcsRepositoryManager.tryCreateRepository(this.myProject, root2.getVcs(), rootPath, this)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        HashMap<VirtualFile, Repository> hashMap = newRootsMap;
        if (hashMap == null) {
            VcsRepositoryManager.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<Repository> repositories) {
        if (repositories == null) {
            VcsRepositoryManager.$$$reportNull$$$0(17);
        }
        ArrayList<VirtualFile> invalidRepos = new ArrayList<VirtualFile>();
        for (Repository repo : repositories) {
            VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(repo.getRoot());
            if (vcsRoot != null && repo.getRoot().equals(vcsRoot.getPath()) && repo.getVcs().equals((Object)vcsRoot.getVcs())) continue;
            invalidRepos.add(repo.getRoot());
        }
        ArrayList<VirtualFile> arrayList = invalidRepos;
        if (arrayList == null) {
            VcsRepositoryManager.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Nullable
    private static Repository tryCreateRepository(@NotNull Project project, @Nullable AbstractVcs vcs, @NotNull VirtualFile rootPath, @NotNull Disposable disposable2) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(19);
        }
        if (rootPath == null) {
            VcsRepositoryManager.$$$reportNull$$$0(20);
        }
        if (disposable2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(21);
        }
        if (vcs == null) {
            return null;
        }
        return (Repository)EP_NAME.computeSafeIfAny(creator -> {
            if (creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod())) {
                return creator.createRepositoryIfValid(project, rootPath, disposable2);
            }
            return null;
        });
    }

    @NotNull
    public String toString() {
        String string = "RepositoryManager{myRepositories: " + this.myRepositories + "}";
        if (string == null) {
            VcsRepositoryManager.$$$reportNull$$$0(22);
        }
        return string;
    }

    @TestOnly
    public void checkAndUpdateRepositories() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    @TestOnly
    public void waitForAsyncTaskCompletion() {
        try {
            this.myUpdateAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownRoots";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalRepositories";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findNewRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findInvalidRoots";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFileQuick";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExternalRepositoryForFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findNewRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findInvalidRoots";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateRepository";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyStartupActivity
    implements VcsStartupActivity {
        MyStartupActivity() {
        }

        @Override
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            VcsRepositoryManager.getInstance(project).checkAndUpdateRepositoriesCollection(null);
        }

        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/repo/VcsRepositoryManager$MyStartupActivity", "runActivity"));
        }
    }
}

