/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunOnTargetComboBox
extends ComboBox<Item> {
    public static final Logger LOGGER = Logger.getInstance(RunOnTargetComboBox.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private LanguageRuntimeType<?> myDefaultRuntimeType;
    private boolean hasSavedTargets;
    @NotNull
    private final MyRenderer myRenderer;

    public RunOnTargetComboBox(@NotNull Project project) {
        if (project == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(0);
        }
        this.hasSavedTargets = false;
        this.myRenderer = new MyRenderer(() -> this.hasSavedTargets);
        this.setModel(new MyModel());
        this.myProject = project;
        this.setRenderer((ListCellRenderer)((Object)this.myRenderer));
        this.addActionListener(e -> this.validateSelectedTarget());
    }

    public void initModel() {
        this.myRenderer.setProjectDefaultTarget(TargetEnvironmentsManager.getInstance((Project)this.myProject).getDefaultTarget());
        this.hasSavedTargets = false;
        MyModel model2 = (MyModel)this.getModel();
        model2.removeAllElements();
        model2.addElement(null);
        ArrayList types = new ArrayList();
        for (TargetEnvironmentType targetEnvironmentType : TargetEnvironmentType.getTargetTypesForRunConfigurations()) {
            if (!targetEnvironmentType.isSystemCompatible() || !targetEnvironmentType.providesNewWizard(this.myProject, this.myDefaultRuntimeType)) continue;
            types.add(new Type(targetEnvironmentType));
        }
        if (!types.isEmpty()) {
            model2.addElement(new Separator(ExecutionBundle.message((String)"run.on.targets.label.new.targets", (Object[])new Object[0])));
            for (Type type : types) {
                model2.addElement(type);
            }
        }
    }

    public void setDefaultLanguageRuntimeType(@Nullable LanguageRuntimeType<?> defaultLanguageRuntimeType) {
        this.myDefaultRuntimeType = defaultLanguageRuntimeType;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return this.myDefaultRuntimeType;
    }

    public void addTarget(@NotNull TargetEnvironmentConfiguration config2, int index2) {
        if (config2 == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(1);
        }
        if (!this.hasSavedTargets) {
            this.hasSavedTargets = true;
            ((MyModel)this.getModel()).insertElementAt(new Separator(ExecutionBundle.message((String)"run.on.targets.label.saved.targets", (Object[])new Object[0])), 1);
            ((MyModel)this.getModel()).insertElementAt(new LocalTarget(), 2);
        }
        ((MyModel)this.getModel()).insertElementAt(new SavedTarget(config2), index2);
    }

    @Nullable
    public String getSelectedTargetName() {
        return (String)ObjectUtils.doIfCast((Object)this.getSelectedItem(), Target.class, i2 -> i2.getTargetName());
    }

    public void addTargets(List<? extends TargetEnvironmentConfiguration> configs) {
        int index2 = 3;
        for (TargetEnvironmentConfiguration targetEnvironmentConfiguration : configs) {
            this.addTarget(targetEnvironmentConfiguration, index2);
            ++index2;
        }
    }

    public void selectTarget(String configName) {
        if (configName == null) {
            this.setSelectedItem(null);
            return;
        }
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Item at = (Item)this.getModel().getElementAt(i2);
            if (!(at instanceof Target) || !configName.equals(((Target)at).getTargetName())) continue;
            this.setSelectedItem(at);
        }
    }

    private void validateSelectedTarget() {
        Object selected2 = this.getSelectedItem();
        boolean hasErrors = false;
        if (selected2 instanceof SavedTarget) {
            SavedTarget target2 = (SavedTarget)selected2;
            target2.revalidateConfiguration();
            hasErrors = target2.hasErrors();
        }
        this.putClientProperty("JComponent.outline", hasErrors ? "error" : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    extends ColoredListCellRenderer<Item> {
        @Nullable
        private Item myProjectDefaultTargetItem;
        @NotNull
        private final Supplier<Boolean> myHasSavedTargetsSupplier;

        private MyRenderer(@NotNull Supplier<Boolean> hasSavedTargetsSupplier) {
            if (hasSavedTargetsSupplier == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            this.myHasSavedTargetsSupplier = hasSavedTargetsSupplier;
        }

        public void setProjectDefaultTarget(@Nullable TargetEnvironmentConfiguration projectDefaultTarget) {
            this.myProjectDefaultTargetItem = projectDefaultTarget != null ? new SavedTarget(projectDefaultTarget) : null;
        }

        public Component getListCellRendererComponent(JList<? extends Item> list2, Item value2, int index2, boolean selected2, boolean hasFocus) {
            if (value2 instanceof Separator) {
                SeparatorWithText separator2 = new SeparatorWithText();
                separator2.setCaption(value2.getDisplayName());
                return separator2;
            }
            return super.getListCellRendererComponent(list2, (Object)value2, index2, selected2, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list2, Item value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            if (value2 == null && !this.myHasSavedTargetsSupplier.get().booleanValue()) {
                this.append(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]));
                this.setIcon(AllIcons.Nodes.HomeFolder);
            } else if (value2 == null) {
                this.append(ExecutionBundle.message((String)"targets.details.project.default", (Object[])new Object[0])).append(" ");
                if (this.myProjectDefaultTargetItem == null) {
                    this.append(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(AllIcons.Nodes.HomeFolder);
                } else {
                    this.append(this.myProjectDefaultTargetItem.getDisplayName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.setIcon(this.myProjectDefaultTargetItem.icon);
                }
            } else {
                this.append(value2.getDisplayName());
                this.setIcon(value2.getIcon());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasSavedTargetsSupplier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$MyRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyModel
    extends DefaultComboBoxModel<Item> {
        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof Separator) {
                return;
            }
            if (anObject instanceof Type) {
                RunOnTargetComboBox.this.hidePopup();
                TargetEnvironmentWizard wizard = ((Type)anObject).createWizard(RunOnTargetComboBox.this.myProject, RunOnTargetComboBox.this.myDefaultRuntimeType);
                if (wizard != null && wizard.showAndGet()) {
                    TargetEnvironmentConfiguration newTarget = wizard.getSubject();
                    TargetEnvironmentsManager.getInstance((Project)RunOnTargetComboBox.this.myProject).addTarget(newTarget);
                    RunOnTargetComboBox.this.addTarget(newTarget, 2);
                    RunOnTargetComboBox.this.setSelectedIndex(2);
                }
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private static final class Type<T extends TargetEnvironmentConfiguration>
    extends Item {
        @NotNull
        private final TargetEnvironmentType<T> type;

        private Type(@NotNull TargetEnvironmentType<T> type) {
            if (type == null) {
                Type.$$$reportNull$$$0(0);
            }
            super(ExecutionBundle.message((String)"run.on.targets.label.new.target.of.type", (Object[])new Object[]{type.getDisplayName()}), type.getIcon());
            this.type = type;
        }

        @Nullable
        TargetEnvironmentWizard createWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> languageRuntime) {
            if (project == null) {
                Type.$$$reportNull$$$0(1);
            }
            return TargetEnvironmentWizard.createWizard(project, this.type, languageRuntime);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWizard";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class LocalTarget
    extends Target {
        private LocalTarget() {
            super(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]), AllIcons.Nodes.HomeFolder, "@@@LOCAL@@@");
        }
    }

    private static final class SavedTarget
    extends Target {
        private final TargetEnvironmentConfiguration myConfig;
        @Nullable
        private ValidationInfo myValidationInfo;

        private SavedTarget(TargetEnvironmentConfiguration config2) {
            super(config2.getDisplayName(), TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config2).getIcon());
            this.myConfig = config2;
            this.revalidateConfiguration();
        }

        public void revalidateConfiguration() {
            try {
                this.myConfig.validateConfiguration();
                this.myValidationInfo = null;
            }
            catch (RuntimeConfigurationException e) {
                this.myValidationInfo = new ValidationInfo(e.getLocalizedMessage());
            }
        }

        @Nullable
        public ValidationInfo getValidationInfo() {
            return this.myValidationInfo;
        }

        public boolean hasErrors() {
            return this.getValidationInfo() != null;
        }

        @Override
        public Icon getIcon() {
            Icon rawIcon = super.getIcon();
            return rawIcon != null && this.hasErrors() ? LayeredIcon.create(rawIcon, AllIcons.RunConfigurations.InvalidConfigurationLayer) : rawIcon;
        }
    }

    private static abstract class Target
    extends Item {
        @NotNull
        private final String myTargetName;

        private Target(@NlsContexts.Label @NotNull String displayName, Icon icon2) {
            if (displayName == null) {
                Target.$$$reportNull$$$0(0);
            }
            super(displayName, icon2);
            this.myTargetName = displayName;
        }

        protected Target(@NlsContexts.Label @NotNull String displayName, @NotNull Icon icon2, @NotNull String targetName) {
            if (displayName == null) {
                Target.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                Target.$$$reportNull$$$0(2);
            }
            if (targetName == null) {
                Target.$$$reportNull$$$0(3);
            }
            super(displayName, icon2);
            this.myTargetName = targetName;
        }

        @NotNull
        protected String getTargetName() {
            String string = this.myTargetName;
            if (string == null) {
                Target.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/RunOnTargetComboBox$Target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$Target";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Separator
    extends Item {
        private Separator(@NlsContexts.Label String displayName) {
            super(displayName, null);
        }
    }

    public static abstract class Item {
        private final @NlsContexts.Label String displayName;
        private final Icon icon;

        public Item(@NlsContexts.Label String displayName, Icon icon2) {
            this.displayName = displayName;
            this.icon = icon2;
        }

        @NlsContexts.Label
        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

