/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestStateStorage
implements Disposable {
    private static final File TEST_HISTORY_PATH = new File(PathManager.getSystemPath(), "testHistory");
    private static final int CURRENT_VERSION = 5;
    private final File myFile;
    private static final Logger LOG = Logger.getInstance(TestStateStorage.class);
    @Nullable
    private PersistentHashMap<String, Record> myMap;
    private volatile ScheduledFuture<?> myMapFlusher;

    public static File getTestHistoryRoot(@NotNull Project project) {
        if (project == null) {
            TestStateStorage.$$$reportNull$$$0(0);
        }
        return new File(TEST_HISTORY_PATH, project.getLocationHash());
    }

    public static TestStateStorage getInstance(@NotNull Project project) {
        if (project == null) {
            TestStateStorage.$$$reportNull$$$0(1);
        }
        return (TestStateStorage)project.getService(TestStateStorage.class);
    }

    public TestStateStorage(Project project) {
        String directoryPath = TestStateStorage.getTestHistoryRoot(project).getPath();
        this.myFile = new File(directoryPath + "/testStateMap");
        FileUtilRt.createParentDirs((File)this.myFile);
        try {
            this.myMap = this.initializeMap();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.myMapFlusher = FlushingDaemon.everyFiveSeconds(this::flushMap);
    }

    private PersistentHashMap<String, Record> initializeMap() throws IOException {
        return (PersistentHashMap)IOUtil.openCleanOrResetBroken(TestStateStorage.getComputable(this.myFile), (File)this.myFile);
    }

    private synchronized void flushMap() {
        if (this.myMapFlusher == null) {
            return;
        }
        if (this.myMap != null && this.myMap.isDirty()) {
            this.myMap.force();
        }
    }

    @NotNull
    private static ThrowableComputable<PersistentHashMap<String, Record>, IOException> getComputable(File file2) {
        ThrowableComputable throwableComputable = () -> new PersistentHashMap(file2.toPath(), (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<Record>(){

            public void save(@NotNull DataOutput out, Record value2) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                out.writeInt(value2.magnitude);
                out.writeLong(value2.date.getTime());
                out.writeLong(value2.configurationHash);
                out.writeInt(value2.failedLine);
                out.writeUTF(StringUtil.notNullize((String)value2.failedMethod));
                out.writeUTF(StringUtil.notNullize((String)value2.errorMessage));
                out.writeUTF(StringUtil.notNullize((String)value2.topStacktraceLine));
            }

            public Record read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new Record(in.readInt(), new Date(in.readLong()), in.readLong(), in.readInt(), in.readUTF(), in.readUTF(), in.readUTF());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/TestStateStorage$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 4096, 5);
        if (throwableComputable == null) {
            TestStateStorage.$$$reportNull$$$0(2);
        }
        return throwableComputable;
    }

    @NotNull
    public synchronized Collection<String> getKeys() {
        Collection<String> collection;
        try {
            collection = this.myMap == null ? Collections.emptyList() : this.myMap.getAllKeysWithExistingMapping();
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get keys");
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                TestStateStorage.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (collection == null) {
            TestStateStorage.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public synchronized Record getState(String testUrl) {
        try {
            return this.myMap == null ? null : (Record)this.myMap.get((Object)testUrl);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get state for " + testUrl);
            return null;
        }
    }

    public synchronized void removeState(String url) {
        if (this.myMap != null) {
            try {
                this.myMap.remove((Object)url);
            }
            catch (IOException e) {
                this.thingsWentWrongLetsReinitialize(e, "Can't remove state for " + url);
            }
        }
    }

    @Nullable
    public synchronized Map<String, Record> getRecentTests(int limit, Date since) {
        if (this.myMap == null) {
            return null;
        }
        HashMap<String, Record> result2 = new HashMap<String, Record>();
        try {
            for (String key : this.myMap.getAllKeysWithExistingMapping()) {
                Record record = (Record)this.myMap.get((Object)key);
                if (record == null || record.date.compareTo(since) <= 0) continue;
                result2.put(key, record);
                if (result2.size() < limit) continue;
                break;
            }
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't get recent tests");
        }
        return result2;
    }

    public synchronized void writeState(@NotNull String testUrl, Record record) {
        if (testUrl == null) {
            TestStateStorage.$$$reportNull$$$0(5);
        }
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.put((Object)testUrl, (Object)record);
        }
        catch (IOException e) {
            this.thingsWentWrongLetsReinitialize(e, "Can't write state for " + testUrl);
        }
    }

    public synchronized void dispose() {
        this.myMapFlusher.cancel(false);
        this.myMapFlusher = null;
        if (this.myMap == null) {
            return;
        }
        try {
            this.myMap.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myMap = null;
        }
    }

    private void thingsWentWrongLetsReinitialize(IOException e, String message2) {
        try {
            if (this.myMap != null) {
                try {
                    this.myMap.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                IOUtil.deleteAllFilesStartingWith((File)this.myFile);
            }
            this.myMap = this.initializeMap();
            LOG.warn(message2, (Throwable)e);
        }
        catch (IOException e1) {
            LOG.error("Cannot repair", (Throwable)e1);
            this.myMap = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/TestStateStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComputable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestHistoryRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Record {
        public final int magnitude;
        public final long configurationHash;
        public final Date date;
        public int failedLine;
        public String failedMethod;
        @NlsSafe
        public final String errorMessage;
        public final String topStacktraceLine;

        public Record(int magnitude, Date date, long configurationHash, int failLine, String method2, String errorMessage, String topStacktraceLine) {
            this.magnitude = magnitude;
            this.date = date;
            this.configurationHash = configurationHash;
            this.failedLine = failLine;
            this.failedMethod = method2;
            this.errorMessage = errorMessage;
            this.topStacktraceLine = topStacktraceLine;
        }
    }
}

