/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsComboBoxAction
extends ComboBoxAction
implements DumbAware {
    private static final String BUTTON_MODE = "ButtonMode";
    public static final Icon CHECKED_ICON = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(AllIcons.Actions.Checked, 16, 16));
    public static final Icon CHECKED_SELECTED_ICON = JBUIScale.scaleIcon((JBScalableIcon)new SizedIcon(AllIcons.Actions.Checked_selected, 16, 16));
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(0);
        }
        Presentation presentation2 = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            presentation2.setDescription(ExecutionBundle.messagePointer((String)"choose.run.configuration.action.description", (Object[])new Object[0]));
        }
        try {
            if (project == null || project.isDisposed() || !project.isOpen()) {
                RunConfigurationsComboBoxAction.updatePresentation(null, null, null, presentation2, e.getPlace());
                presentation2.setEnabled(false);
            } else {
                RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)project), this.getSelectedConfiguration(e), project, presentation2, e.getPlace());
                presentation2.setEnabled(true);
            }
        }
        catch (IndexNotReadyException e1) {
            presentation2.setEnabled(false);
        }
    }

    @Nullable
    protected RunnerAndConfigurationSettings getSelectedConfiguration(AnActionEvent e) {
        Project project = e.getProject();
        return project == null ? null : RunManager.getInstance((Project)project).getSelectedConfiguration();
    }

    protected static void updatePresentation(@Nullable ExecutionTarget target2, @Nullable RunnerAndConfigurationSettings settings, @Nullable Project project, @NotNull Presentation presentation2, String actionPlace) {
        if (presentation2 == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(1);
        }
        presentation2.putClientProperty(BUTTON_MODE, null);
        if (project != null && target2 != null && settings != null) {
            Object name2 = Executor.shortenNameIfNeeded((String)settings.getName());
            if (target2 != DefaultExecutionTarget.INSTANCE && !target2.isExternallyManaged()) {
                name2 = (String)name2 + " | " + target2.getDisplayName();
            } else if (!ExecutionTargetManager.canRun((RunConfiguration)settings.getConfiguration(), (ExecutionTarget)target2)) {
                name2 = (String)name2 + " | " + ExecutionBundle.message((String)"run.configurations.combo.action.nothing.to.run.on", (Object[])new Object[0]);
            }
            presentation2.setText((String)name2, false);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                RunConfigurationsComboBoxAction.setConfigurationIcon(presentation2, settings, project);
            }
        } else {
            presentation2.putClientProperty(BUTTON_MODE, (Object)Boolean.TRUE);
            presentation2.setText(ExecutionBundle.messagePointer((String)"action.presentation.RunConfigurationsComboBoxAction.text", (Object[])new Object[0]));
            presentation2.setDescription(ActionsBundle.actionDescription((String)"editRunConfigurations"));
            if ("TouchBarGeneral".equals(actionPlace)) {
                presentation2.setIcon(AllIcons.General.Add);
            } else {
                presentation2.setIcon(null);
            }
        }
    }

    protected static void setConfigurationIcon(Presentation presentation2, RunnerAndConfigurationSettings settings, Project project) {
        try {
            presentation2.setIcon(RunManagerEx.getInstanceEx(project).getConfigurationIcon(settings, true));
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Presentation presentation2;
        if (e == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(2);
        }
        if ("TouchBarGeneral".equals(e.getPlace()) && Boolean.TRUE.equals((presentation2 = e.getPresentation()).getClientProperty(BUTTON_MODE))) {
            Component component2;
            InputEvent inputEvent = e.getInputEvent();
            Component component3 = component2 = inputEvent != null ? inputEvent.getComponent() : null;
            if (component2 != null) {
                RunConfigurationsComboBoxAction.performWhenButton(component2, "TouchBarGeneral");
            }
            return;
        }
        super.actionPerformed(e);
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(4);
        }
        RunConfigurationsComboBoxButton button4 = new RunConfigurationsComboBoxButton(presentation2);
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JBEmptyBorder border = UIUtil.isUnderDefaultMacTheme() ? JBUI.Borders.empty((int)0, (int)2) : JBUI.Borders.empty((int)0, (int)5, (int)0, (int)4);
        panel2.setBorder((Border)border);
        panel2.add((Component)((Object)button4));
        NonOpaquePanel nonOpaquePanel = panel2;
        if (nonOpaquePanel == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(5);
        }
        return nonOpaquePanel;
    }

    private static void performWhenButton(@NotNull Component src, String place) {
        if (src == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(6);
        }
        ActionManager manager2 = ActionManager.getInstance();
        manager2.tryToExecute(manager2.getAction("editRunConfigurations"), (InputEvent)new MouseEvent(src, 501, System.currentTimeMillis(), 0, 0, 0, 0, false, 0), src, place, true);
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
        DefaultActionGroup allActionsGroup = new DefaultActionGroup();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)button4));
        if (project == null) {
            DefaultActionGroup defaultActionGroup = allActionsGroup;
            if (defaultActionGroup == null) {
                RunConfigurationsComboBoxAction.$$$reportNull$$$0(7);
            }
            return defaultActionGroup;
        }
        AnAction editRunConfigurationAction = this.getEditRunConfigurationAction();
        if (editRunConfigurationAction != null) {
            allActionsGroup.add(editRunConfigurationAction);
        }
        allActionsGroup.add((AnAction)new SaveTemporaryAction());
        allActionsGroup.addSeparator();
        RunnerAndConfigurationSettings selected2 = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selected2 != null) {
            ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project, (RunConfiguration)selected2.getConfiguration())) {
                allActionsGroup.add((AnAction)new SelectTargetAction(project, eachTarget, eachTarget.equals((Object)activeTarget)));
            }
            allActionsGroup.addSeparator();
        }
        for (Map<String, List<RunnerAndConfigurationSettings>> structure : RunManagerImpl.getInstanceImpl(project).getConfigurationsGroupedByTypeAndFolder(true).values()) {
            DefaultActionGroup actionGroup2 = new DefaultActionGroup();
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry2 : structure.entrySet()) {
                @NlsSafe String folderName = entry2.getKey();
                DefaultActionGroup group2 = folderName == null ? actionGroup2 : DefaultActionGroup.createPopupGroup(() -> folderName);
                group2.getTemplatePresentation().setIcon(AllIcons.Nodes.Folder);
                for (RunnerAndConfigurationSettings settings : entry2.getValue()) {
                    group2.add(this.createFinalAction(settings, project));
                }
                if (group2 == actionGroup2) continue;
                actionGroup2.add((AnAction)group2);
            }
            allActionsGroup.add((AnAction)actionGroup2);
            allActionsGroup.addSeparator();
        }
        DefaultActionGroup defaultActionGroup = allActionsGroup;
        if (defaultActionGroup == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @Nullable
    protected AnAction getEditRunConfigurationAction() {
        return ActionManager.getInstance().getAction("editRunConfigurations");
    }

    protected AnAction createFinalAction(@NotNull RunnerAndConfigurationSettings configuration2, @NotNull Project project) {
        if (configuration2 == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(9);
        }
        if (project == null) {
            RunConfigurationsComboBoxAction.$$$reportNull$$$0(10);
        }
        return new SelectConfigAction(configuration2, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performWhenButton";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFinalAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SelectConfigAction
    extends DumbAwareAction {
        private final RunnerAndConfigurationSettings myConfiguration;
        private final Project myProject;

        SelectConfigAction(RunnerAndConfigurationSettings configuration2, Project project) {
            this.myConfiguration = configuration2;
            this.myProject = project;
            String name2 = Executor.shortenNameIfNeeded((String)configuration2.getName());
            if (name2.isEmpty()) {
                name2 = " ";
            }
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(name2, false);
            presentation2.setDescription(ExecutionBundle.message((String)"select.0.1", (Object[])new Object[]{configuration2.getType().getConfigurationTypeDescription(), name2}));
            this.updateIcon(presentation2);
        }

        private void updateIcon(Presentation presentation2) {
            RunConfigurationsComboBoxAction.setConfigurationIcon(presentation2, this.myConfiguration, this.myProject);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(0);
            }
            RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(this.myConfiguration);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), this.myConfiguration, this.myProject, e.getPresentation(), e.getPlace());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectConfigAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            this.updateIcon(e.getPresentation());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectConfigAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SelectTargetAction
    extends AnAction {
        private final Project myProject;
        private final ExecutionTarget myTarget;

        SelectTargetAction(Project project, ExecutionTarget target2, boolean selected2) {
            this.myProject = project;
            this.myTarget = target2;
            String name2 = target2.getDisplayName();
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(name2, false);
            presentation2.setDescription(ExecutionBundle.message((String)"select.0", (Object[])new Object[]{name2}));
            presentation2.setIcon(selected2 ? CHECKED_ICON : EMPTY_ICON);
            presentation2.setSelectedIcon(selected2 ? CHECKED_SELECTED_ICON : EMPTY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SelectTargetAction.$$$reportNull$$$0(0);
            }
            ExecutionTargetManager.setActiveTarget((Project)this.myProject, (ExecutionTarget)this.myTarget);
            RunConfigurationsComboBoxAction.updatePresentation(ExecutionTargetManager.getActiveTarget((Project)this.myProject), RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), this.myProject, e.getPresentation(), e.getPlace());
        }

        public boolean isDumbAware() {
            RunnerAndConfigurationSettings configuration2 = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            return configuration2 == null || configuration2.getType().isDumbAware();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SelectTargetAction", "actionPerformed"));
        }
    }

    private static final class SaveTemporaryAction
    extends DumbAwareAction {
        SaveTemporaryAction() {
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setIcon(AllIcons.Actions.MenuSaveall);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            RunnerAndConfigurationSettings settings;
            Project project;
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(0);
            }
            if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) != null && (settings = SaveTemporaryAction.chooseTempSettings(project)) != null) {
                RunManager runManager = RunManager.getInstance((Project)project);
                runManager.makeStable(settings);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SaveTemporaryAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                SaveTemporaryAction.disable(presentation2);
                return;
            }
            RunnerAndConfigurationSettings settings = SaveTemporaryAction.chooseTempSettings(project);
            if (settings == null) {
                SaveTemporaryAction.disable(presentation2);
            } else {
                presentation2.setText(ExecutionBundle.messagePointer((String)"save.temporary.run.configuration.action.name", (Object[])new Object[]{Executor.shortenNameIfNeeded((String)settings.getName())}));
                presentation2.setDescription(presentation2.getText());
                presentation2.setEnabledAndVisible(true);
            }
        }

        private static void disable(Presentation presentation2) {
            presentation2.setEnabledAndVisible(false);
        }

        @Nullable
        private static RunnerAndConfigurationSettings chooseTempSettings(@NotNull Project project) {
            RunnerAndConfigurationSettings selectedConfiguration2;
            if (project == null) {
                SaveTemporaryAction.$$$reportNull$$$0(2);
            }
            if ((selectedConfiguration2 = RunManager.getInstance((Project)project).getSelectedConfiguration()) != null && selectedConfiguration2.isTemporary()) {
                return selectedConfiguration2;
            }
            return (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem((List)RunManager.getInstance((Project)project).getTempConfigurationsList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$SaveTemporaryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseTempSettings";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class RunConfigurationsComboBoxButton
    extends ComboBoxAction.ComboBoxButton {
        public RunConfigurationsComboBoxButton(Presentation presentation2) {
            if (presentation2 == null) {
                RunConfigurationsComboBoxButton.$$$reportNull$$$0(0);
            }
            super((ComboBoxAction)RunConfigurationsComboBoxAction.this, presentation2);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, JBUIScale.scale((int)75));
            return d;
        }

        protected void doShiftClick() {
            DataContext context2 = DataManager.getInstance().getDataContext((Component)((Object)this));
            Project project = (Project)CommonDataKeys.PROJECT.getData(context2);
            if (project != null && !ActionUtil.isDumbMode((Project)project)) {
                new EditConfigurationsDialog(project).show();
                return;
            }
            super.doShiftClick();
        }

        protected void fireActionPerformed(ActionEvent event) {
            if (Boolean.TRUE.equals(this.getPresentation().getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE))) {
                RunConfigurationsComboBoxAction.performWhenButton((Component)((Object)this), "unknown");
                return;
            }
            super.fireActionPerformed(event);
        }

        protected boolean isArrowVisible(@NotNull Presentation presentation2) {
            if (presentation2 == null) {
                RunConfigurationsComboBoxButton.$$$reportNull$$$0(1);
            }
            return !Boolean.TRUE.equals(presentation2.getClientProperty(RunConfigurationsComboBoxAction.BUTTON_MODE));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "presentation";
            objectArray2[1] = "com/intellij/execution/actions/RunConfigurationsComboBoxAction$RunConfigurationsComboBoxButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isArrowVisible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

