/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.ClearConsoleAction;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplexConsoleView<S extends ConsoleView, T extends ConsoleView>
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider {
    private static final String PRIMARY_CONSOLE_PANEL = "PRIMARY_CONSOLE_PANEL";
    private static final String SECONDARY_CONSOLE_PANEL = "SECONDARY_CONSOLE_PANEL";
    @NotNull
    private final S myPrimaryConsoleView;
    @NotNull
    private final T mySecondaryConsoleView;
    @Nullable
    private final String myStateStorageKey;
    private boolean myPrimary;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final SwitchDuplexConsoleViewAction mySwitchConsoleAction;
    private boolean myDisableSwitchConsoleActionOnProcessEnd;

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView) {
        if (primaryConsoleView == null) {
            DuplexConsoleView.$$$reportNull$$$0(0);
        }
        if (secondaryConsoleView == null) {
            DuplexConsoleView.$$$reportNull$$$0(1);
        }
        this(primaryConsoleView, secondaryConsoleView, null);
    }

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView, @Nullable String stateStorageKey) {
        if (primaryConsoleView == null) {
            DuplexConsoleView.$$$reportNull$$$0(2);
        }
        if (secondaryConsoleView == null) {
            DuplexConsoleView.$$$reportNull$$$0(3);
        }
        super(new CardLayout());
        this.myDisableSwitchConsoleActionOnProcessEnd = true;
        this.myPrimaryConsoleView = primaryConsoleView;
        this.mySecondaryConsoleView = secondaryConsoleView;
        this.myStateStorageKey = stateStorageKey;
        this.add((Component)this.myPrimaryConsoleView.getComponent(), PRIMARY_CONSOLE_PANEL);
        this.add((Component)this.mySecondaryConsoleView.getComponent(), SECONDARY_CONSOLE_PANEL);
        this.mySwitchConsoleAction = new SwitchDuplexConsoleViewAction();
        this.myPrimary = true;
        this.enableConsole(this.getStoredState());
        Disposer.register((Disposable)this, this.myPrimaryConsoleView);
        Disposer.register((Disposable)this, this.mySecondaryConsoleView);
    }

    public static <S extends ConsoleView, T extends ConsoleView> DuplexConsoleView<S, T> create(@NotNull S primary, @NotNull T secondary, @Nullable String stateStorageKey) {
        if (primary == null) {
            DuplexConsoleView.$$$reportNull$$$0(4);
        }
        if (secondary == null) {
            DuplexConsoleView.$$$reportNull$$$0(5);
        }
        return new DuplexConsoleView<S, T>(primary, secondary, stateStorageKey);
    }

    private void setStoredState(boolean primary) {
        if (this.myStateStorageKey != null) {
            PropertiesComponent.getInstance().setValue(this.myStateStorageKey, primary);
        }
    }

    private boolean getStoredState() {
        if (this.myStateStorageKey == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(this.myStateStorageKey);
    }

    public void enableConsole(boolean primary) {
        if (primary == this.myPrimary) {
            return;
        }
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, primary ? PRIMARY_CONSOLE_PANEL : SECONDARY_CONSOLE_PANEL);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getSubConsoleView(primary).getComponent(), true));
        this.myPrimary = primary;
    }

    public boolean isPrimaryConsoleEnabled() {
        return this.myPrimary;
    }

    @NotNull
    public S getPrimaryConsoleView() {
        S s = this.myPrimaryConsoleView;
        if (s == null) {
            DuplexConsoleView.$$$reportNull$$$0(6);
        }
        return s;
    }

    @NotNull
    public T getSecondaryConsoleView() {
        T t = this.mySecondaryConsoleView;
        if (t == null) {
            DuplexConsoleView.$$$reportNull$$$0(7);
        }
        return t;
    }

    public ConsoleView getSubConsoleView(boolean primary) {
        return primary ? this.getPrimaryConsoleView() : this.getSecondaryConsoleView();
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            DuplexConsoleView.$$$reportNull$$$0(8);
        }
        if (contentType == null) {
            DuplexConsoleView.$$$reportNull$$$0(9);
        }
        this.myPrimaryConsoleView.print(s, contentType);
        this.mySecondaryConsoleView.print(s, contentType);
    }

    public void clear() {
        this.myPrimaryConsoleView.clear();
        this.mySecondaryConsoleView.clear();
    }

    public void scrollTo(int offset) {
        this.myPrimaryConsoleView.scrollTo(offset);
        this.mySecondaryConsoleView.scrollTo(offset);
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(10);
        }
        this.myProcessHandler = processHandler2;
        this.myPrimaryConsoleView.attachToProcess(processHandler2);
        this.mySecondaryConsoleView.attachToProcess(processHandler2);
    }

    public void setOutputPaused(boolean value2) {
        this.myPrimaryConsoleView.setOutputPaused(value2);
        this.mySecondaryConsoleView.setOutputPaused(value2);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return this.myPrimaryConsoleView.hasDeferredOutput() && this.mySecondaryConsoleView.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(11);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            DuplexConsoleView.$$$reportNull$$$0(12);
        }
        this.myPrimaryConsoleView.setHelpId(helpId);
        this.mySecondaryConsoleView.setHelpId(helpId);
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            DuplexConsoleView.$$$reportNull$$$0(13);
        }
        this.myPrimaryConsoleView.addMessageFilter(filter);
        this.mySecondaryConsoleView.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            DuplexConsoleView.$$$reportNull$$$0(14);
        }
        this.myPrimaryConsoleView.printHyperlink(hyperlinkText, info2);
        this.mySecondaryConsoleView.printHyperlink(hyperlinkText, info2);
    }

    public int getContentSize() {
        return this.myPrimaryConsoleView.getContentSize();
    }

    public boolean canPause() {
        return false;
    }

    public AnAction @NotNull [] createConsoleActions() {
        ConsoleHistoryController controller;
        ArrayList<Object> actions2 = new ArrayList<Object>();
        actions2.addAll(this.mergeConsoleActions(Arrays.asList(this.myPrimaryConsoleView.createConsoleActions()), Arrays.asList(this.mySecondaryConsoleView.createConsoleActions())));
        actions2.add((Object)this.mySwitchConsoleAction);
        LanguageConsoleView langConsole = (LanguageConsoleView)ContainerUtil.findInstance(Arrays.asList(this.myPrimaryConsoleView, this.mySecondaryConsoleView), LanguageConsoleView.class);
        ConsoleHistoryController consoleHistoryController = controller = langConsole != null ? ConsoleHistoryController.getController(langConsole) : null;
        if (controller != null) {
            actions2.add(controller.getBrowseHistory());
        }
        AnAction[] anActionArray = actions2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            DuplexConsoleView.$$$reportNull$$$0(15);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
        this.myPrimaryConsoleView.allowHeavyFilters();
    }

    @NotNull
    public JComponent getComponent() {
        DuplexConsoleView duplexConsoleView = this;
        if (duplexConsoleView == null) {
            DuplexConsoleView.$$$reportNull$$$0(16);
        }
        return duplexConsoleView;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            DuplexConsoleView.$$$reportNull$$$0(18);
        }
        if (this.myPrimaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.myPrimaryConsoleView).addChangeListener(listener2, parent);
        }
        if (this.mySecondaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.mySecondaryConsoleView).addChangeListener(listener2, parent);
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        ConsoleView consoleView;
        if (dataId == null) {
            DuplexConsoleView.$$$reportNull$$$0(19);
        }
        if ((consoleView = this.getSubConsoleView(this.isPrimaryConsoleEnabled())) instanceof DataProvider) {
            return ((DataProvider)consoleView).getData(dataId);
        }
        return null;
    }

    @NotNull
    public Presentation getSwitchConsoleActionPresentation() {
        Presentation presentation2 = this.mySwitchConsoleAction.getTemplatePresentation();
        if (presentation2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(20);
        }
        return presentation2;
    }

    public void setDisableSwitchConsoleActionOnProcessEnd(boolean disableSwitchConsoleActionOnProcessEnd) {
        this.myDisableSwitchConsoleActionOnProcessEnd = disableSwitchConsoleActionOnProcessEnd;
    }

    @NotNull
    private List<AnAction> mergeConsoleActions(@NotNull List<? extends AnAction> actions1, @NotNull Collection<? extends AnAction> actions2) {
        if (actions1 == null) {
            DuplexConsoleView.$$$reportNull$$$0(21);
        }
        if (actions2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(22);
        }
        List list2 = ContainerUtil.map(actions1, action1 -> {
            AnAction action22 = (AnAction)ContainerUtil.find((Iterable)actions2, action2 -> action1.getClass() == action2.getClass() && StringUtil.equals((CharSequence)action1.getTemplatePresentation().getText(), (CharSequence)action2.getTemplatePresentation().getText()));
            if (action22 instanceof ToggleUseSoftWrapsToolbarAction) {
                return new MergedWrapTextAction((ToggleUseSoftWrapsToolbarAction)((Object)action1), (ToggleUseSoftWrapsToolbarAction)action22);
            }
            if (action22 instanceof ScrollToTheEndToolbarAction) {
                return new MergedToggleAction((ToggleAction)action1, (ToggleAction)action22);
            }
            if (action22 instanceof ClearConsoleAction) {
                return new MergedAction((AnAction)action1, action22);
            }
            return action1;
        });
        if (list2 == null) {
            DuplexConsoleView.$$$reportNull$$$0(23);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryConsoleView";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryConsoleView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primary";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondary";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/DuplexConsoleView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions1";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/DuplexConsoleView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryConsoleView";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryConsoleView";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchConsoleActionPresentation";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 23: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mergeConsoleActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MergedAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final AnAction myAction1;
        @NotNull
        private final AnAction myAction2;

        private MergedAction(@NotNull AnAction action1, @NotNull AnAction action2) {
            if (action1 == null) {
                MergedAction.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                MergedAction.$$$reportNull$$$0(1);
            }
            this.myAction1 = action1;
            this.myAction2 = action2;
            this.copyFrom(action1);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MergedAction.$$$reportNull$$$0(2);
            }
            this.myAction1.actionPerformed(e);
            this.myAction2.actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/DuplexConsoleView$MergedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergedToggleAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ToggleAction myAction1;
        @NotNull
        private final ToggleAction myAction2;

        private MergedToggleAction(@NotNull ToggleAction action1, @NotNull ToggleAction action2) {
            if (action1 == null) {
                MergedToggleAction.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                MergedToggleAction.$$$reportNull$$$0(1);
            }
            this.myAction1 = action1;
            this.myAction2 = action2;
            this.copyFrom((AnAction)action1);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MergedToggleAction.$$$reportNull$$$0(2);
            }
            return this.myAction1.isSelected(e);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MergedToggleAction.$$$reportNull$$$0(3);
            }
            this.myAction1.setSelected(e, state);
            this.myAction2.setSelected(e, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/DuplexConsoleView$MergedToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SwitchDuplexConsoleViewAction
    extends ToggleAction
    implements DumbAware {
        SwitchDuplexConsoleViewAction() {
            super(ExecutionBundle.messagePointer((String)"run.configuration.show.command.line.action.name", (Object[])new Object[0]), AllIcons.Debugger.Console);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            if (event == null) {
                SwitchDuplexConsoleViewAction.$$$reportNull$$$0(0);
            }
            return !DuplexConsoleView.this.isPrimaryConsoleEnabled();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                SwitchDuplexConsoleViewAction.$$$reportNull$$$0(1);
            }
            DuplexConsoleView.this.enableConsole(!flag);
            DuplexConsoleView.this.setStoredState(!flag);
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }

        public void update(@NotNull AnActionEvent event) {
            boolean isRunning;
            if (event == null) {
                SwitchDuplexConsoleViewAction.$$$reportNull$$$0(2);
            }
            super.update(event);
            if (!DuplexConsoleView.this.myDisableSwitchConsoleActionOnProcessEnd) {
                return;
            }
            Presentation presentation2 = event.getPresentation();
            boolean bl = isRunning = DuplexConsoleView.this.myProcessHandler != null && !DuplexConsoleView.this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation2.setEnabled(true);
            } else {
                DuplexConsoleView.this.enableConsole(true);
                Toggleable.setSelected((Presentation)presentation2, (boolean)false);
                presentation2.setEnabled(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/execution/console/DuplexConsoleView$SwitchDuplexConsoleViewAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MergedWrapTextAction
    extends MergedToggleAction {
        private MergedWrapTextAction(@NotNull ToggleUseSoftWrapsToolbarAction action1, ToggleUseSoftWrapsToolbarAction action2) {
            if (action1 == null) {
                MergedWrapTextAction.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                MergedWrapTextAction.$$$reportNull$$$0(1);
            }
            super(action1, action2);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MergedWrapTextAction.$$$reportNull$$$0(2);
            }
            super.setSelected(e, state);
            DuplexConsoleView.this.getComponent().revalidate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/console/DuplexConsoleView$MergedWrapTextAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

