/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.AsyncFilterRunner;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHyperlinkSupport {
    private static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    private static final Key<HyperlinkInfoTextAttributes> HYPERLINK = Key.create((String)"HYPERLINK");
    private static final Key<EditorHyperlinkSupport> EDITOR_HYPERLINK_SUPPORT_KEY = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_KEY");
    private final EditorEx myEditor;
    @NotNull
    private final Project myProject;
    private final AsyncFilterRunner myFilterRunner;

    public EditorHyperlinkSupport(@NotNull Editor editor2, @NotNull Project project) {
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(0);
        }
        if (project == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(1);
        }
        this.myEditor = (EditorEx)editor2;
        this.myProject = project;
        this.myFilterRunner = new AsyncFilterRunner(this, this.myEditor);
        editor2.addEditorMouseListener(new EditorMouseListener(){
            private MouseEvent myInitialMouseEvent;

            public void mousePressed(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myInitialMouseEvent = e.getMouseEvent();
            }

            public void mouseReleased(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                MouseEvent initialMouseEvent = this.myInitialMouseEvent;
                this.myInitialMouseEvent = null;
                MouseEvent mouseEvent = e.getMouseEvent();
                if (mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger()) {
                    if (!(initialMouseEvent == null || mouseEvent.getComponent() == initialMouseEvent.getComponent() && mouseEvent.getPoint().equals(initialMouseEvent.getPoint()))) {
                        return;
                    }
                    Runnable runnable2 = EditorHyperlinkSupport.this.getLinkNavigationRunnable(e.getLogicalPosition());
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        editor2.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    return;
                }
                HyperlinkInfo info2 = EditorHyperlinkSupport.this.getHyperlinkInfoByEvent(e);
                EditorHyperlinkSupport.this.myEditor.setCustomCursor(EditorHyperlinkSupport.class, info2 == null ? null : Cursor.getPredefinedCursor(12));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/EditorHyperlinkSupport$2", "mouseMoved"));
            }
        });
    }

    @NotNull
    public static EditorHyperlinkSupport get(@NotNull Editor editor2) {
        EditorHyperlinkSupport instance2;
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(2);
        }
        if ((instance2 = (EditorHyperlinkSupport)editor2.getUserData(EDITOR_HYPERLINK_SUPPORT_KEY)) == null) {
            Project project = editor2.getProject();
            assert (project != null);
            instance2 = new EditorHyperlinkSupport(editor2, project);
            editor2.putUserData(EDITOR_HYPERLINK_SUPPORT_KEY, (Object)instance2);
        }
        EditorHyperlinkSupport editorHyperlinkSupport = instance2;
        if (editorHyperlinkSupport == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(3);
        }
        return editorHyperlinkSupport;
    }

    public void clearHyperlinks() {
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            this.removeHyperlink(highlighter);
        }
    }

    public void waitForPendingFilters(long timeoutMs) {
        this.myFilterRunner.waitForPendingFilters(timeoutMs);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            HyperlinkInfo info2 = EditorHyperlinkSupport.getHyperlinkInfo(highlighter);
            if (info2 == null) continue;
            result2.put((Object)highlighter, (Object)info2);
        }
        return result2;
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(LogicalPosition logical) {
        if (EditorCoreUtil.inVirtualSpace((Editor)this.myEditor, (LogicalPosition)logical)) {
            return null;
        }
        int positionOffset = this.myEditor.logicalPositionToOffset(logical);
        RangeHighlighter range2 = this.findLinkRangeAt(positionOffset);
        if (range2 != null) {
            if (range2.getEndOffset() == positionOffset) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(range2);
            if (hyperlinkInfo != null) {
                return () -> {
                    if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                        Point point = this.myEditor.logicalPositionToXY(logical);
                        MouseEvent event = new MouseEvent(this.myEditor.getContentComponent(), 0, 0L, 0, point.x, point.y, 1, false);
                        ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint(event));
                    } else {
                        hyperlinkInfo.navigate(this.myProject);
                    }
                    EditorHyperlinkSupport.linkFollowed(this.myEditor, EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor), range2);
                };
            }
        }
        return null;
    }

    @Nullable
    public static HyperlinkInfo getHyperlinkInfo(@NotNull RangeHighlighter range2) {
        HyperlinkInfoTextAttributes attributes2;
        if (range2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(4);
        }
        return (attributes2 = (HyperlinkInfoTextAttributes)((Object)range2.getUserData(HYPERLINK))) != null ? attributes2.getHyperlinkInfo() : null;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        Iterator<RangeHighlighter> iterator2 = EditorHyperlinkSupport.getHyperlinks(offset, offset, this.myEditor).iterator();
        if (iterator2.hasNext()) {
            RangeHighlighter highlighter = iterator2.next();
            return highlighter;
        }
        return null;
    }

    @Nullable
    public HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range2 = this.findLinkRangeAt(offset);
        return range2 == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range2);
    }

    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        return EditorHyperlinkSupport.getHyperlinks(lineStart, lineEnd, this.myEditor);
    }

    private static List<RangeHighlighter> getHyperlinks(int startOffset, int endOffset, Editor editor2) {
        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new FilteringProcessor(rangeHighlighterEx -> rangeHighlighterEx.isValid() && EditorHyperlinkSupport.getHyperlinkInfo(rangeHighlighterEx) != null, (Processor)processor2));
        return new ArrayList<RangeHighlighter>(processor2.getResults());
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        if (hyperlink == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(5);
        }
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    public void createHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(6);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(7);
        }
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null);
    }

    @NotNull
    public RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(8);
        }
        return this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, null, 5900);
    }

    @NotNull
    private RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, int layer) {
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(9);
        }
        RangeHighlighterEx highlighter = this.myEditor.getMarkupModel().addRangeHighlighterAndChangeAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES, highlightStartOffset, highlightEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)ex -> {
            if (highlightAttributes != null) {
                ex.setTextAttributes(highlightAttributes);
            }
        }));
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, followedHyperlinkAttributes);
        RangeHighlighterEx rangeHighlighterEx = highlighter;
        if (rangeHighlighterEx == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(10);
        }
        return rangeHighlighterEx;
    }

    private static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
        if (highlighter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(11);
        }
        if (hyperlinkInfo == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(12);
        }
        highlighter.putUserData(HYPERLINK, (Object)new HyperlinkInfoTextAttributes(hyperlinkInfo, followedHyperlinkAttributes));
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorCoreUtil.inVirtualSpace((Editor)this.myEditor, (LogicalPosition)pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByEvent(@NotNull EditorMouseEvent event) {
        if (event == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(13);
        }
        return event.isOverText() ? this.getHyperlinkAt(event.getOffset()) : null;
    }

    public void highlightHyperlinks(@NotNull Filter customFilter, int line1, int endLine) {
        if (customFilter == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(14);
        }
        this.myFilterRunner.highlightHyperlinks(this.myProject, customFilter, Math.max(0, line1), endLine);
    }

    void highlightHyperlinks(@NotNull Filter.Result result2, int offsetDelta) {
        if (result2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(15);
        }
        int length = this.myEditor.getDocument().getTextLength();
        SmartList inlays = new SmartList();
        for (Filter.ResultItem resultItem : result2.getResultItems()) {
            int start2 = resultItem.getHighlightStartOffset() + offsetDelta;
            int end = resultItem.getHighlightEndOffset() + offsetDelta;
            if (start2 < 0 || end < start2 || end > length) continue;
            TextAttributes attributes2 = resultItem.getHighlightAttributes();
            if (resultItem instanceof InlayProvider) {
                inlays.add((InlayProvider)resultItem);
                continue;
            }
            if (resultItem.getHyperlinkInfo() != null) {
                this.createHyperlink(start2, end, attributes2, resultItem.getHyperlinkInfo(), resultItem.getFollowedHyperlinkAttributes(), resultItem.getHighlighterLayer());
                continue;
            }
            if (attributes2 == null) continue;
            this.addHighlighter(start2, end, attributes2, resultItem.getHighlighterLayer());
        }
        if (!inlays.isEmpty()) {
            this.myEditor.getInlayModel().execute(inlays.size() > 100, () -> this.lambda$highlightHyperlinks$3((List)inlays, offsetDelta));
        }
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        this.addHighlighter(highlightStartOffset, highlightEndOffset, highlightAttributes, 5800);
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, int highlighterLayer) {
        this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, highlighterLayer, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @NotNull
    private static TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighter range2) {
        HyperlinkInfoTextAttributes attrs;
        TextAttributes result2;
        if (range2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(16);
        }
        TextAttributes textAttributes = result2 = (attrs = (HyperlinkInfoTextAttributes)((Object)HYPERLINK.get((UserDataHolder)range2))) != null ? attrs.getFollowedHyperlinkAttributes() : null;
        if (result2 == null) {
            result2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        }
        TextAttributes textAttributes2 = result2;
        if (textAttributes2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(17);
        }
        return textAttributes2;
    }

    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(final @NotNull Editor editor2, int delta, final @NotNull Consumer<? super RangeHighlighter> action2) {
        RangeHighlighter range2;
        int i2;
        List<RangeHighlighter> ranges;
        if (editor2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(18);
        }
        if (action2 == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(19);
        }
        if ((ranges = EditorHyperlinkSupport.getHyperlinks(0, editor2.getDocument().getTextLength(), editor2)).isEmpty()) {
            return null;
        }
        for (i2 = 0; i2 < ranges.size() && (range2 = ranges.get(i2)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i2) {
        }
        int newIndex = i2 %= ranges.size();
        while (newIndex < ranges.size()) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = ranges.get(newIndex);
            HyperlinkInfo info2 = EditorHyperlinkSupport.getHyperlinkInfo(next);
            assert (info2 != null);
            if (info2.includeInOccurenceNavigation()) {
                boolean inCollapsedRegion;
                boolean bl = inCollapsedRegion = editor2.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) != null;
                if (!inCollapsedRegion) {
                    return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            action2.consume((Object)next);
                            EditorHyperlinkSupport.linkFollowed(editor2, ranges, next);
                        }
                    }, newIndex + 1, ranges.size());
                }
            }
            if (newIndex != i2) continue;
            break;
        }
        return null;
    }

    private static void linkFollowed(Editor editor2, Collection<? extends RangeHighlighter> ranges, RangeHighlighter link2) {
        MarkupModelEx markupModel = (MarkupModelEx)editor2.getMarkupModel();
        for (RangeHighlighter rangeHighlighter : ranges) {
            TextAttributes oldAttr = (TextAttributes)rangeHighlighter.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(rangeHighlighter, oldAttr);
                rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (rangeHighlighter != link2) continue;
            rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)rangeHighlighter.getTextAttributes(editor2.getColorsScheme()));
            markupModel.setRangeHighlighterAttributes(rangeHighlighter, EditorHyperlinkSupport.getFollowedHyperlinkAttributes(rangeHighlighter));
        }
        markupModel.addRangeHighlighter(CodeInsightColors.HYPERLINK_ATTRIBUTES, 0, 0, link2.getLayer(), HighlighterTargetArea.EXACT_RANGE).dispose();
    }

    @NotNull
    public static String getLineText(@NotNull Document document, int lineNumber, boolean includeEol) {
        if (document == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(20);
        }
        String string = EditorHyperlinkSupport.getLineSequence(document, lineNumber, includeEol).toString();
        if (string == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static CharSequence getLineSequence(@NotNull Document document, int lineNumber, boolean includeEol) {
        if (document == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(22);
        }
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        CharSequence charSequence = document.getImmutableCharSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset);
        if (charSequence == null) {
            EditorHyperlinkSupport.$$$reportNull$$$0(23);
        }
        return charSequence;
    }

    private /* synthetic */ void lambda$highlightHyperlinks$3(List inlays, int offsetDelta) {
        for (InlayProvider item : inlays) {
            this.myEditor.getInlayModel().addInlineElement(((Filter.ResultItem)item).getHighlightEndOffset() + offsetDelta, item.createInlayRenderer(this.myEditor));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlink";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHyperlink";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFollowedHyperlinkAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 21: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeHyperlink";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHyperlink";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "associateHyperlink";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHyperlinkInfoByEvent";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "highlightHyperlinks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFollowedHyperlinkAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNextOccurrence";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLineText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLineSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 17: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HyperlinkInfoTextAttributes
    extends TextAttributes {
        private final HyperlinkInfo myHyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;

        HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(0);
            }
            this.myHyperlinkInfo = hyperlinkInfo;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
        }

        @NotNull
        HyperlinkInfo getHyperlinkInfo() {
            HyperlinkInfo hyperlinkInfo = this.myHyperlinkInfo;
            if (hyperlinkInfo == null) {
                HyperlinkInfoTextAttributes.$$$reportNull$$$0(1);
            }
            return hyperlinkInfo;
        }

        @Nullable
        TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinkInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/EditorHyperlinkSupport$HyperlinkInfoTextAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHyperlinkInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

