/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.BaseRCSettingsConfigurable;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunConfigurationStorageUi;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunManagerImplKt;
import com.intellij.execution.impl.RunOnTargetPanel;
import com.intellij.execution.impl.ValidationResult;
import com.intellij.execution.impl.statistics.FusCollectSettingChangesRunConfiguration;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.ui.RunnerAndConfigurationSettingsEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ConfigurationQuickFix;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SingleConfigurationConfigurable<Config extends RunConfiguration>
extends BaseRCSettingsConfigurable {
    public static final DataKey<String> RUN_ON_TARGET_NAME_KEY = DataKey.create("RunOnTargetName");
    private static final Logger LOG = Logger.getInstance(SingleConfigurationConfigurable.class);
    private final PlainDocument myNameDocument;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Executor myExecutor;
    private MyValidatableComponent myComponent;
    private final @NlsContexts.ConfigurableName String myDisplayName;
    private final String myHelpTopic;
    private final boolean myBrokenConfiguration;
    private boolean myIsAllowRunningInParallel;
    private String myFolderName;
    private boolean myChangingNameFromCode;
    private final Alarm myValidationAlarm;
    private ValidationResult myLastValidationResult;
    private volatile boolean myValidationRequested;
    private final List<ValidationListener> myValidationListeners;
    private final RunOnTargetPanel myRunOnTargetPanel;

    private SingleConfigurationConfigurable(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(0);
        }
        super(ConfigurationSettingsEditorWrapper.createWrapper(settings), settings);
        this.myNameDocument = new PlainDocument();
        this.myIsAllowRunningInParallel = false;
        this.myValidationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.getEditor());
        this.myLastValidationResult = null;
        this.myValidationRequested = true;
        this.myValidationListeners = new SmartList();
        this.myProject = settings.getConfiguration().getProject();
        this.myExecutor = executor;
        Config configuration2 = this.getConfiguration();
        this.myDisplayName = ((RunnerAndConfigurationSettings)this.getSettings()).getName();
        this.myHelpTopic = configuration2.getType().getHelpTopic();
        this.myBrokenConfiguration = !configuration2.getType().isManaged();
        this.setFolderName(((RunnerAndConfigurationSettings)this.getSettings()).getFolderName());
        this.setNameText(configuration2.getName());
        this.myNameDocument.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                RunConfiguration runConfiguration;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.setModified(true);
                if (!SingleConfigurationConfigurable.this.myChangingNameFromCode && (runConfiguration = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration()) instanceof LocatableConfigurationBase) {
                    ((LocatableConfigurationBase)runConfiguration).setNameChangedByUser(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/SingleConfigurationConfigurable$1", "textChanged"));
            }
        });
        this.getEditor().addSettingsEditorListener((SettingsEditorListener)new SettingsEditorListener<RunnerAndConfigurationSettings>(){

            public void stateChanged(@NotNull SettingsEditor<RunnerAndConfigurationSettings> settingsEditor) {
                if (settingsEditor == null) {
                    2.$$$reportNull$$$0(0);
                }
                SingleConfigurationConfigurable.this.requestToUpdateWarning();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsEditor", "com/intellij/execution/impl/SingleConfigurationConfigurable$2", "stateChanged"));
            }
        });
        this.myRunOnTargetPanel = new RunOnTargetPanel(settings, (SettingsEditor<RunnerAndConfigurationSettings>)this.getEditor());
    }

    @NotNull
    public static <Config extends RunConfiguration> SingleConfigurationConfigurable<Config> editSettings(@NotNull RunnerAndConfigurationSettings settings, @Nullable Executor executor) {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(1);
        }
        SingleConfigurationConfigurable<Config> configurable2 = new SingleConfigurationConfigurable<Config>(settings, executor);
        configurable2.reset();
        SingleConfigurationConfigurable<Config> singleConfigurationConfigurable = configurable2;
        if (singleConfigurationConfigurable == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(2);
        }
        return singleConfigurationConfigurable;
    }

    @Override
    @NotNull
    protected RunnerAndConfigurationSettings getSnapshot() throws ConfigurationException {
        RunnerAndConfigurationSettings snapshot = super.getSnapshot();
        snapshot.setName(this.getNameText());
        snapshot.setFolderName(this.getFolderName());
        RunnerAndConfigurationSettings original = (RunnerAndConfigurationSettings)this.getSettings();
        snapshot.setTemporary(original.isTemporary());
        if (original.isStoredInDotIdeaFolder()) {
            snapshot.storeInDotIdeaFolder();
        } else if (original.isStoredInArbitraryFileInProject() && original.getPathIfStoredInArbitraryFileInProject() != null) {
            snapshot.storeInArbitraryFileInProject(original.getPathIfStoredInArbitraryFileInProject());
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = snapshot;
        if (runnerAndConfigurationSettings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(3);
        }
        return runnerAndConfigurationSettings;
    }

    @Override
    boolean isSpecificallyModified() {
        return this.myComponent != null && this.myComponent.myRCStorageUi != null && this.myComponent.myRCStorageUi.isModified() || this.myRunOnTargetPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)this.getSettings();
        RunConfiguration runConfiguration = settings.getConfiguration();
        if (runConfiguration instanceof FusCollectSettingChangesRunConfiguration) {
            RunConfiguration oldRunConfiguration = runConfiguration.clone();
            this.performApply(settings, runConfiguration);
            ((FusCollectSettingChangesRunConfiguration)runConfiguration).collectSettingChangesOnApply((FusCollectSettingChangesRunConfiguration)oldRunConfiguration);
        } else {
            this.performApply(settings, runConfiguration);
        }
    }

    private void performApply(@NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) throws ConfigurationException {
        if (settings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(4);
        }
        if (runConfiguration == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(5);
        }
        settings.setName(this.getNameText());
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        this.myRunOnTargetPanel.apply();
        settings.setFolderName(this.myFolderName);
        if (this.myComponent.myRCStorageUi != null) {
            this.myComponent.myRCStorageUi.apply(settings);
        }
        super.apply();
        RunManagerImpl.getInstanceImpl(this.myProject).addConfiguration(settings);
    }

    public void reset() {
        RunnerAndConfigurationSettings configuration2 = (RunnerAndConfigurationSettings)this.getSettings();
        this.setNameText(configuration2.getName());
        super.reset();
        if (this.myComponent == null) {
            this.myComponent = new MyValidatableComponent();
        }
        this.myComponent.doReset();
        this.myRunOnTargetPanel.reset();
    }

    void requestToUpdateWarning() {
        this.myValidationRequested = false;
        if (this.myComponent == null || this.isInplaceValidationSupported()) {
            return;
        }
        this.addValidationRequest();
    }

    private void addValidationRequest() {
        if (this.myComponent == null) {
            return;
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.myComponent.myWholePanel);
        if (modalityState == ModalityState.NON_MODAL) {
            return;
        }
        this.myValidationRequested = true;
        this.myValidationAlarm.cancelAllRequests();
        this.myValidationAlarm.addRequest(() -> {
            if (this.myComponent != null) {
                try {
                    RunnerAndConfigurationSettings snapshot = this.createSnapshot(false);
                    snapshot.setName(this.getNameText());
                    this.validateResultOnBackgroundThread(snapshot);
                }
                catch (ConfigurationException e) {
                    this.setValidationResult(this.createValidationResult(null, e));
                }
            }
        }, 100, modalityState);
    }

    void addValidationListener(ValidationListener listener2) {
        this.myValidationListeners.add(listener2);
    }

    private boolean isInplaceValidationSupported() {
        return this.getEditor() instanceof RunnerAndConfigurationSettingsEditor && ((RunnerAndConfigurationSettingsEditor)this.getEditor()).isInplaceValidationSupported();
    }

    @Override
    public JComponent createComponent() {
        this.myComponent.myNameText.setEnabled(!this.myBrokenConfiguration);
        JComponent result2 = this.myComponent.getWholePanel();
        DataManager.registerDataProvider((JComponent)result2, dataId -> {
            if (this.myComponent == null) {
                return null;
            }
            if (ConfigurationSettingsEditorWrapper.CONFIGURATION_EDITOR_KEY.is(dataId)) {
                return this.getEditor();
            }
            if (RUN_ON_TARGET_NAME_KEY.is(dataId)) {
                return TargetEnvironmentConfigurations.getEffectiveTargetName((String)this.myRunOnTargetPanel.getDefaultTargetName(), (Project)this.myProject);
            }
            return null;
        });
        Dimension size = result2.getPreferredSize();
        result2.setPreferredSize(new Dimension(Math.min(size.width, 800), Math.min(size.height, 600)));
        return result2;
    }

    JComponent getValidationComponent() {
        return this.myComponent.myValidationPanel;
    }

    public boolean isStoredInFile() {
        return this.myComponent != null && this.myComponent.myRCStorageUi != null && this.myComponent.myRCStorageUi.isStoredInFile();
    }

    private void validateResultOnBackgroundThread(RunnerAndConfigurationSettings snapshot) {
        this.getValidateAction(snapshot).expireWith((Disposable)this.getEditor()).coalesceBy(new Object[]{this.getEditor()}).finishOnUiThread(ModalityState.current(), this::setValidationResult).submit((java.util.concurrent.Executor)NonUrgentExecutor.getInstance());
    }

    private void setValidationResult(ValidationResult result2) {
        this.myLastValidationResult = result2;
        if (this.myComponent != null && !this.isInplaceValidationSupported()) {
            this.myComponent.updateValidationResultVisibility(result2);
        }
        for (ValidationListener listener2 : this.myValidationListeners) {
            listener2.validationCompleted(result2);
        }
    }

    public boolean isValid() {
        if (!this.myValidationRequested) {
            this.addValidationRequest();
        }
        return this.myLastValidationResult == null;
    }

    private NonBlockingReadAction<ValidationResult> getValidateAction(RunnerAndConfigurationSettings snapshot) {
        return ReadAction.nonBlocking(() -> {
            try {
                snapshot.checkSettings(this.myExecutor);
                for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
                    ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)snapshot.getConfiguration());
                    if (runner == null) continue;
                    SingleConfigurationConfigurable.checkConfiguration(runner, snapshot);
                }
            }
            catch (ConfigurationException e) {
                return this.createValidationResult(snapshot, e);
            }
            return null;
        });
    }

    private ValidationResult createValidationResult(RunnerAndConfigurationSettings snapshot, ConfigurationException e) {
        if (!e.shouldShowInDumbMode() && DumbService.isDumb((Project)this.myProject)) {
            return null;
        }
        return new ValidationResult(e.getLocalizedMessage(), e instanceof RuntimeConfigurationException ? e.getTitle() : ExecutionBundle.message((String)"invalid.data.dialog.title", (Object[])new Object[0]), this.getQuickFix(snapshot, e));
    }

    @Nullable
    private Runnable getQuickFix(RunnerAndConfigurationSettings snapshot, ConfigurationException exception) {
        ConfigurationQuickFix quickFix = exception.getConfigurationQuickFix();
        if (quickFix != null && snapshot != null) {
            return () -> {
                quickFix.applyFix(DataManager.getInstance().getDataContext((Component)this.myComponent.myWholePanel));
                this.getEditor().resetFrom((Object)snapshot);
            };
        }
        return quickFix == null ? null : () -> quickFix.applyFix(DataManager.getInstance().getDataContext((Component)this.myComponent.myWholePanel));
    }

    private static void checkConfiguration(@NotNull ProgramRunner<?> runner, @NotNull RunnerAndConfigurationSettings snapshot) throws RuntimeConfigurationException {
        if (runner == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(6);
        }
        if (snapshot == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(7);
        }
        RunnerSettings runnerSettings2 = snapshot.getRunnerSettings(runner);
        ConfigurationPerRunnerSettings configurationSettings = snapshot.getConfigurationSettings(runner);
        try {
            runner.checkConfiguration(runnerSettings2, configurationSettings);
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myComponent = null;
    }

    public String getNameText() {
        try {
            return this.myNameDocument.getText(0, this.myNameDocument.getLength());
        }
        catch (BadLocationException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public void addNameListener(DocumentListener listener2) {
        this.myNameDocument.addDocumentListener(listener2);
    }

    public void addSharedListener(ActionListener listener2) {
        if (this.myComponent.myRCStorageUi != null) {
            this.myComponent.myRCStorageUi.addStoreAsFileCheckBoxListener(listener2);
        }
    }

    public void setNameText(String name2) {
        this.myChangingNameFromCode = true;
        try {
            try {
                if (!this.myNameDocument.getText(0, this.myNameDocument.getLength()).equals(name2)) {
                    this.myNameDocument.replace(0, this.myNameDocument.getLength(), name2, null);
                }
            }
            catch (BadLocationException e) {
                LOG.error((Throwable)e);
            }
        }
        finally {
            this.myChangingNameFromCode = false;
        }
    }

    public JTextField getNameTextField() {
        return this.myComponent.myNameText;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public String getHelpTopic() {
        return this.myHelpTopic;
    }

    @NotNull
    public Config getConfiguration() {
        RunConfiguration runConfiguration = ((RunnerAndConfigurationSettings)this.getSettings()).getConfiguration();
        if (runConfiguration == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(8);
        }
        return (Config)runConfiguration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createSnapshot(boolean cloneBeforeRunTasks) throws ConfigurationException {
        RunnerAndConfigurationSettings snapshot = (RunnerAndConfigurationSettings)this.getEditor().getSnapshot();
        RunConfiguration runConfiguration = snapshot.getConfiguration();
        runConfiguration.setAllowRunningInParallel(this.myIsAllowRunningInParallel);
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myRunOnTargetPanel.getDefaultTargetName());
        }
        if (cloneBeforeRunTasks) {
            RunManagerImplKt.cloneBeforeRunTasks(runConfiguration);
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = snapshot;
        if (runnerAndConfigurationSettings == null) {
            SingleConfigurationConfigurable.$$$reportNull$$$0(9);
        }
        return runnerAndConfigurationSettings;
    }

    public String toString() {
        return this.myDisplayName;
    }

    public void setFolderName(@Nullable String folderName) {
        if (!Objects.equals(this.myFolderName, folderName)) {
            this.myFolderName = folderName;
            this.setModified(true);
        }
    }

    @Nullable
    public String getFolderName() {
        return this.myFolderName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/SingleConfigurationConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "editSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editSettings";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performApply";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface ValidationListener {
        public void validationCompleted(ValidationResult var1);
    }

    private class MyValidatableComponent {
        private JLabel myNameLabel;
        private JTextField myNameText;
        private JComponent myWholePanel;
        private JPanel myComponentPlace;
        private JBLabel myWarningLabel;
        private JButton myFixButton;
        private JSeparator mySeparator;
        private JBCheckBox myIsAllowRunningInParallelCheckBox;
        private JPanel myRCStoragePanel;
        @Nullable
        private final RunConfigurationStorageUi myRCStorageUi;
        private JPanel myValidationPanel;
        private JBScrollPane myJBScrollPane;
        private JPanel myRunOnPanel;
        private Runnable myQuickFix = null;
        private boolean myWindowResizedOnce = false;

        MyValidatableComponent() {
            this.$$$setupUI$$$();
            this.myNameLabel.setLabelFor(this.myNameText);
            this.myNameText.setDocument(SingleConfigurationConfigurable.this.myNameDocument);
            SingleConfigurationConfigurable.this.getEditor().addSettingsEditorListener(settingsEditor -> SingleConfigurationConfigurable.this.requestToUpdateWarning());
            this.myWarningLabel.setCopyable(true);
            this.myWarningLabel.setAllowAutoWrapping(true);
            this.myWarningLabel.setIcon(AllIcons.General.BalloonError);
            this.myComponentPlace.setLayout(new GridBagLayout());
            this.myComponentPlace.add((Component)this.getEditorComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            this.myComponentPlace.doLayout();
            this.myFixButton.setIcon(AllIcons.Actions.QuickfixBulb);
            SingleConfigurationConfigurable.this.requestToUpdateWarning();
            this.myFixButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MyValidatableComponent.this.myQuickFix == null) {
                        return;
                    }
                    MyValidatableComponent.this.myQuickFix.run();
                    SingleConfigurationConfigurable.this.requestToUpdateWarning();
                }
            });
            this.myIsAllowRunningInParallelCheckBox.addActionListener(e -> {
                SingleConfigurationConfigurable.this.setModified(true);
                SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = this.myIsAllowRunningInParallelCheckBox.isSelected();
            });
            RunConfigurationStorageUi runConfigurationStorageUi = this.myRCStorageUi = !SingleConfigurationConfigurable.this.myProject.isDefault() ? new RunConfigurationStorageUi(SingleConfigurationConfigurable.this.myProject, () -> SingleConfigurationConfigurable.this.setModified(true)) : null;
            if (this.myRCStorageUi != null) {
                this.myRCStoragePanel.add(this.myRCStorageUi.createComponent());
            }
            this.myRunOnPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            SingleConfigurationConfigurable.this.myRunOnTargetPanel.buildUi(this.myRunOnPanel, this.myNameLabel);
            this.updateValidationResultVisibility(null);
        }

        private void doReset() {
            RunConfiguration configuration2 = ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getConfiguration();
            boolean isManagedRunConfiguration = configuration2.getType().isManaged();
            if (this.myRCStorageUi != null) {
                this.myRCStorageUi.reset((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings());
            }
            SingleConfigurationConfigurable.this.myRunOnTargetPanel.reset();
            SingleConfigurationConfigurable.this.myIsAllowRunningInParallel = configuration2.isAllowRunningInParallel();
            this.myIsAllowRunningInParallelCheckBox.setEnabled(isManagedRunConfiguration);
            this.myIsAllowRunningInParallelCheckBox.setSelected(SingleConfigurationConfigurable.this.myIsAllowRunningInParallel);
            this.myIsAllowRunningInParallelCheckBox.setVisible(SingleConfigurationConfigurable.this.getEditor() instanceof ConfigurationSettingsEditorWrapper && ((RunnerAndConfigurationSettings)SingleConfigurationConfigurable.this.getSettings()).getFactory().getSingletonPolicy().isPolicyConfigurable());
        }

        public final JComponent getWholePanel() {
            return this.myWholePanel;
        }

        public JComponent getEditorComponent() {
            return SingleConfigurationConfigurable.this.getEditor().getComponent();
        }

        private void updateValidationResultVisibility(ValidationResult configurationException) {
            if (configurationException != null) {
                this.mySeparator.setVisible(true);
                this.myWarningLabel.setVisible(true);
                this.myWarningLabel.setText(this.generateWarningLabelText(configurationException));
                Runnable quickFix = configurationException.getQuickFix();
                if (quickFix == null) {
                    this.myFixButton.setVisible(false);
                } else {
                    this.myFixButton.setVisible(true);
                    this.myQuickFix = quickFix;
                }
                this.myValidationPanel.setVisible(true);
                Window window = UIUtil.getWindow((Component)this.myWholePanel);
                if (!this.myWindowResizedOnce && window != null && window.isShowing()) {
                    Dimension size = window.getSize();
                    window.setSize(size.width, size.height + this.myValidationPanel.getPreferredSize().height);
                    this.myWindowResizedOnce = true;
                }
            } else {
                this.mySeparator.setVisible(false);
                this.myWarningLabel.setVisible(false);
                this.myFixButton.setVisible(false);
                this.myValidationPanel.setVisible(false);
            }
        }

        @NlsContexts.Label
        private String generateWarningLabelText(ValidationResult configurationException) {
            return new HtmlBuilder().append(configurationException.getTitle()).append(": ").wrapWith("b").wrapWith("body").addRaw(configurationException.getMessage()).wrapWith("html").toString();
        }

        private void createUIComponents() {
            this.myComponentPlace = new NonOpaquePanel();
            this.myJBScrollPane = BaseRCSettingsConfigurable.wrapWithScrollPane(null);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JSeparator jSeparator;
            JButton jButton;
            JBLabel jBLabel;
            JPanel jPanel2;
            JPanel jPanel3;
            JPanel jPanel4;
            JBCheckBox jBCheckBox;
            JTextField jTextField;
            JLabel jLabel;
            this.createUIComponents();
            JPanel jPanel5 = new JPanel();
            this.myWholePanel = jPanel5;
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 5, 3, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myNameLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("edit.run.configuration.run.configuration.name.label"));
            jPanel6.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNameText = jTextField = new JTextField();
            jTextField.setColumns(15);
            jPanel6.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
            this.myIsAllowRunningInParallelCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("run.configuration.allow.running.parallel"));
            jPanel6.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel6.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(20, -1), null));
            this.myRCStoragePanel = jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(1, 0, 5));
            jPanel6.add((Component)jPanel4, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
            JBScrollPane jBScrollPane = this.myJBScrollPane;
            jBScrollPane.setHorizontalScrollBarPolicy(31);
            jPanel5.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            JPanel jPanel7 = this.myComponentPlace;
            jBScrollPane.setViewportView(jPanel7);
            this.myRunOnPanel = jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myValidationPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myWarningLabel = jBLabel = new JBLabel();
            jBLabel.setText("####################");
            jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, new Dimension(10, -1), new Dimension(10, -1), null));
            this.myFixButton = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/ExecutionBundle", MyValidatableComponent.class).getString("fix.run.configuration.problem.button"));
            jPanel2.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            this.mySeparator = jSeparator = new JSeparator();
            jPanel2.add((Component)jSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

